<?php
/* PluginFinder Service for GNUzilla.
 Copyright (C) 2005, 2006, 2007 Free Software Foundation, Inc.
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA.  */

/* This script is called by GNUzilla to retrieve information about the plugin
 needed to handle a specific MIME type.
 
 Returned data follows the RDF format.
 Resource Description Framework (RDF) is a family of specifications for a 
 metadata model that is often implemented as an application of XML.
 For further information about the RDF format take a look here: http://www.w3c.org/RDF.  
 */

/* Report a fatal error.  */
function bail ($errstr) {
    die("Error: " . $errstr);
}

/* These are passed in the GET string.  */
if (!array_key_exists('mimetype', $_GET))
    bail ("Invalid request.");

/* Get MIME-type to look for from the GET request.  */
$mimetype = $_GET['mimetype'];

/* Check if all the necessary information is specified.
 [appID] is the browser application IDentifier.
 [appVersion] is the browser version.
 [clientOs] is the operating system the browser is running on.
 [chromeLocale] is the chrome UI version.  Chrome is the user 
 interface parts of the application window.  For additional 
 information about chrome take a look here: 
 http://www.mozilla.org/xpfe/ConfigChromeSpec.html.  */
if (!array_key_exists('appID', $_GET) 
    || !array_key_exists('appVersion', $_GET)
    || !array_key_exists('clientOS', $_GET)    
    || !array_key_exists('chromeLocale', $_GET))
    bail ("Invalid request.");

/* Store GET information.  */
$reqTargetAppGuid = $_GET['appID'];
$reqTargetAppVersion = $_GET['appVersion'];
$clientOS = $_GET['clientOS'];
$chromeLocale = $_GET['chromeLocale'];

/* Check if the client is sending needed arguments.  */
if (empty($reqTargetAppVersion) || empty($reqTargetAppGuid)) {
    bail ("Invalid request.");
}

/* Now to spit out the RDF.  We hand-generate because the data is pretty simple.  */
$guid = $mimetype;

/* Control the MIME type the user is asking for and set the right values.
 Store some values to use after in the RDF data.  */
if ($mimetype == "application/x-mtx") {
  $name = "Plugger";
  $version = "5.1.3";
  $iconUrl = "";
  $XPILocation = "";
  $InstallerShowsUI = false;
  $manualInstallationURL = "http://fredrik.hubbe.net/plugger.html?free=1";
  $licenseURL = "http://fredrik.hubbe.net/plugger.html";
} else if ($mimetype == "application/x-shockwave-flash") {
  $name = "Gnash";
  $version = "0.8.1";
  $iconUrl = "";
  $XPILocation = "";
  $InstallerShowsUI = false;
  $manualInstallationURL = "ftp://ftp.gnu.org/gnu/gnash/0.8.1";
  $licenseURL = "http://www.gnu.org/licenses/gpl.txt";
} else {
  $name = "";
  $guid = "-1";
  $version = "";
  $iconUrl = "";
  $XPILocation = "";
  $InstallerShowsUI = "";
  $manualInstallationURL = "";
  $licenseURL = "";
}

/* Print the HTTP header data.  */
header("Content-type: text/xml");
header("Cache-Control: cache");
print "<?xml version=\"1.0\"?>\n";
print "<RDF:RDF xmlns:RDF=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:pfs=\"http://www.mozilla.org/2004/pfs-rdf#\">\n\n";

print "<RDF:Description about=\"urn:mozilla:plugin-results:{$mimetype}\">\n";

/* Output list of matching plugins.  */
print " <pfs:plugins><RDF:Seq>\n";
print "   <RDF:li resource=\"urn:mozilla:plugin:{$guid}\"/>\n";
print " </RDF:Seq></pfs:plugins>\n";
print "</RDF:Description>\n\n";

 
/* XML tags with _1 is the data the client was asking for.  Other
 plugins can be cached using an increasing value _2 ... _N. If the
 plugin the client was asking for cannot be found then start indexing 
 from position 2. <pfs:count> is the last used index.  */
print "<RDF:Description about=\"urn:mozilla:plugin:{$guid}\">\n";
print " <pfs:updates><RDF:Seq>\n";
print "   <RDF:li resource=\"urn:mozilla:plugin:{$guid}:{$version}\"/>\n";
print " </RDF:Seq></pfs:updates>\n";
print "</RDF:Description>\n\n";
print "<RDF:Description about=\"urn:mozilla:plugin:{$guid}:{$version}\">\n";

/* How may entries are in the list?  */
print " <pfs:count>1</pfs:count>\n";

/* Plugin name.  */
print " <pfs:name>{$name}</pfs:name>\n";

/* MIME type for the plugin.  */
print " <pfs:requestedMimetype>{$mimetype}</pfs:requestedMimetype>\n";

/* Globally Unique Identifier for the plugin.  */
print " <pfs:guid>{$guid}</pfs:guid>\n";

/* Version of the plugin.  */
print " <pfs:version>{$version}</pfs:version>\n";

/* Specify an icon for the plugin.  */
print " <pfs:IconUrl>{$iconUrl}</pfs:IconUrl>\n";

/* Location of the XPI plugin file; this is the file used by GNUzilla.
 to install it.  */
print " <pfs:XPILocation>{$XPILocation}</pfs:XPILocation>\n";

/* Specify if the installer shows a User Interface.  */
print " <pfs:InstallerShowsUI>{$InstallerShowsUI}</pfs:InstallerShowsUI>\n";

/* Specify here if the plugin has to be installed manually and a link to the 
 file to use.  */
print " <pfs:manualInstallationURL>{$manualInstallationURL}</pfs:manualInstallationURL>\n";

/* Specify a license for the plugin.  */
print " <pfs:licenseURL>{$licenseURL}</pfs:licenseURL>\n";
print "</RDF:Description>\n\n";

print "</RDF:RDF>\n";

?>
