#
# $Id: VLDB.pm,v 1.4 2003/09/02 19:13:27 wpm Exp $
#
# (c) 2003 Morgan Stanley and Co.
# See ..../src/LICENSE for terms of distribution.
#

package AFS::Object::VLDB;

use strict;

our @ISA = qw(AFS::Object);
our $VERSION = '1.0';

sub getVolumeNames {
    my $self = shift;
    return unless ref $self->{_names};
    return keys %{$self->{_names}};
}

sub getVLDBEntry {
    my $self = shift;
    my $name = shift;
    return unless ref $self->{_names};
    return $self->{_names}->{$name};
}

sub getVLDBEntries {
    my $self = shift;
    return unless ref $self->{_names};
    return values %{$self->{_names}};
}

sub _addVLDBEntry {
    my $self = shift;
    my $entry = shift;
    unless ( ref $entry && $entry->isa("AFS::Object::VLDBEntry") ) {
	$self->_Croak("Invalid argument: must be an AFS::Object::VLDBEntry object");
    }
    return $self->{_names}->{$entry->name()} = $entry;
}

1;
