

function remove_blank_paragraphs() {

    var d = oEditor.FCK.EditorDocument.body;  

    var paragraphs  = d.getElementsByTagName('p');
    var para_length = paragraphs.length;
    
    for(var i=0; i < para_length; i++) {
       var p = paragraphs[i];
       var children = p.childNodes;
       if(children) {
            strip_blanks(children);
       }
    }
 
}

function isBlankTextNode(str) {
  
      var l = str.length;
      for(var i=0; i < l; i++) {
            var c_num = str.charCodeAt(i);                  
            if(c_num != 160  && c_num != 32 && c_num != 10 && c_num != 12) {                     
               return false; 
            }       
      }
   return true;
}

function strip_blanks(children) {
       if(!children[0]) return;  
       var firstChild = children[0];
       var type =  firstChild.nodeType;
       if(type == 3) {
         if(firstChild.nodeValue) {
            if(!isBlankTextNode(firstChild.nodeValue)) {
                  return;
            }

         }

         firstChild.parentNode.removeChild(firstChild);
       }
       else if(type == 1) {

           var name = firstChild.nodeName.toUpperCase();
           if(name == "BR") {

               if(children.length == 1) {

                    firstChild.parentNode.removeChild(firstChild);
               }
               else  {

                   var secondChild = children[1];
                   if(secondChild.nodeType == 3) {
                       if(isBlankTextNode(secondChild.nodeValue)) {
                           var parent = secondChild.parentNode;
                           parent.removeChild(secondChild);
                           firstChild.parentNode.removeChild(firstChild);                            
                       }
                   }
               }
           }
       }
    return true;
}

var ourParaCycles;

var MAXPCycles = 5;
var RemainingParagraphs = 0;

function removeParagraphs() {
      ourParaCycles=0;
 
     var d = oEditor.FCK.EditorDocument.body;
     var paragraphs  = d.getElementsByTagName('p');
     var numParStart = paragraphs.length;


    _removeParagraphs(ourParaCycles);
     remove_blank_paragraphs();
     paragraph_cleanup();
     RemainingParagraphs = 0
     var d = oEditor.FCK.EditorDocument.body;
     xtra_blanks (d);
     count_blanks(d);

     var p_done  = numParStart - RemainingParagraphs;
     innerHTML('blanks_left', RemainingParagraphs);
     innerHTML('blanks_done', p_done);
    
}


function count_blanks(n) {
   
   if(n.nodeType == 3 && isBlankTextNode(n.data)) {         
           RemainingParagraphs++;       
   }
   else {
       var kids = n.childNodes;
       for(var i=0; i< kids.length; i++) count_blanks(kids[i]);
   }
    
}


function xtra_blanks(n) {
   
   if(n.nodeType == 3 && isBlankTextNode(n.data)) {         

          var p = n.parentNode;
          var len = p.childNodes.length;
          p.removeChild(n);
          if(len == 1) {
             p.parentNode.removeChild(p);
          }
          
   }
   else {
       var kids = n.childNodes;
       for(var i=0; i< kids.length; i++) xtra_blanks(kids[i]);
   }
    
    
    
}

function paragraph_cleanup() {

    var d = oEditor.FCK.EditorDocument.body;
    var paragraphs  = d.getElementsByTagName('p');

    for(var i=0; i < paragraphs.length; i++) {
          var p = paragraphs[i];
          var c = paragraphs[i].childNodes;        
          if(c) {
              var c_len = c.length; 
              for(j = 0; j < c.length; j++) {               
                  node = c[j];

                  if(node.nodeType == 3) {                   
                        if(isBlankTextNode(node.nodeValue)) { 
                           if(c_len == 1) {
                             var parent = p.parentNode;
                             parent.removeChild(p);
                           }
                           else {
                             var parent = node.parentNode;
                             parent.removeChild(node);
                           }
                        }
                  }
                else if(node.nodeType == 1) {
                   if(node.nodeName.match(/INDENT|REDACT/i)) {
                           if(c_len == 1) {
                             var parent = p.parentNode;
                             parent.removeChild(p);
                           }
                           else {
                             var parent = node.parentNode;
                             parent.removeChild(node);
                           }
                   }
                }
              }
          }
    }

}


var ourHL_Paras = new Array();   // list of highlit paras
var whichParasToDelete = new Array();
var ourRemovedParas = new Array();

/**
   list of para nodes which have had temporary space inserted 
   needed for Gecko browsers which don't implement colors on nodes without
   at least a space character, whereas IE accepts a line-feed
*/
var xA0Substitution = new Array();  

function openAskParaDelete() {
    cancelParaDelete(false);

    ourHL_Paras = new Array();
    whichParasToDelete = new Array();
    ourRemovedParas = new Array();
    xA0Substitution = new Array();
    trimSavedColors = new Array();
    highlight_Paragraphs(); 
    removeZeroLenParas();
    if(ourHL_Paras.length) {
              setNodeColors(ourHL_Paras[0][0],hiLITE.next_item, hiLITE.next_item);  
    }
    view_component('ask_paraWin');
 
}

function removeZeroLenParas() {

  var temp = new Array();
  for(var i = 0; i < ourHL_Paras.length; i++) {

      if(typeof ourHL_Paras[i][1] == "string") {
         var p = ourHL_Paras[i][0].parentNode;
         p.removeChild(ourHL_Paras[i][0]);
      }
      else {
           temp.push(ourHL_Paras[i]);
      }    
  }


 if(temp.length)  {
      ourHL_Paras = temp;
 }

}

function next_paraDelete(skip) {
    if(ourHL_Paras.length == 0) return;
    var node = ourHL_Paras.shift();
    checkViewPort(node[0]);

   ourRemovedParas.push(node);
    if(!skip) {
          whichParasToDelete.push(node[0]);   
          trimSavedColors.push(node[1]);      
          setNodeColors(node[0],'white', hiLITE.delete_item);          
    }
    else {
         var colors =  getSavedStyleColors(node[1], 'black', 'white');
          setNodeColors(node[0], colors['color'], colors['background']);
    }
 
    if(ourHL_Paras.length) {
          var node = ourHL_Paras[0]; 
          checkViewPort(node[0]);
          setNodeColors(node[0],'white', hiLITE.next_item);  
    }
}


function confirmParaDelete() {

   for(var i=0; i <  ourHL_Paras.length; i++) {    
        var colors =  getSavedStyleColors(ourHL_Paras[i][1], 'black', 'white');
        setNodeColors(ourHL_Paras[i][0], colors['color'],  colors['background']);
   }

    for(var i=0; i <  xA0Substitution.length; i++) {      
           if(xA0Substitution[i][1]) {
              xA0Substitution[i][0] = xA0Substitution[i][1]; 
           }
    }

   for(var i=0; i < whichParasToDelete.length; i++) {
       if(!complexParaDeletion(whichParasToDelete[i], trimSavedColors[i])) {
           var parent = whichParasToDelete[i].parentNode;  
           if(parent) parent.removeChild(whichParasToDelete[i]);  
       }
   }

    hide_el('ask_spacesWin');
    reload_panel();
}


function complexParaDeletion(para, colors) {
    var deletion = false;

    kids = para.childNodes;
    if(kids.length <= 1) return false;

    for(var i=0; i < kids.length; i++) {
         if(kids[i].nodeType == 3 && isBlankTextNode(kids[i].nodeValue)) {
            deletion = true;  
            var parent = kids[i].parentNode;
            parent.removeChild(kids[i]);
         }
    }

    var fg = 'black';
    var bg = 'white';
    if(colors &&  typeof colors  == 'object') {   
        fg = colors['color'] ? colors['color'] : 'black';   
        bg = colors['background'] ? colors['background'] : 'white';   
    }

    setNodeColors(para, fg, bg); 
    kids = para.childNodes;
    if(kids.length == 0) para.parentNode.removeChild(para);
    
    return deletion;  
}

function cancelParaDelete(do_reload){

   for(var i=0; i <  ourHL_Paras.length; i++) {    
       var colors =  getSavedStyleColors(ourHL_Paras[i][1], 'black', 'white');
       setNodeColors(ourHL_Paras[i][0], colors['color'],  colors['background']);        
   }

   for(var i=0; i <  ourRemovedParas.length; i++) {      
       var colors =  getSavedStyleColors(ourRemovedParas[i][1], 'black', 'white');
       setNodeColors(ourRemovedParas[i][0], colors['color'],  colors['background']);
   }
 
    for(var i=0; i <  xA0Substitution.length; i++) {      
           if(xA0Substitution[i][1]) {
              xA0Substitution[i][0] = xA0Substitution[i][1]; 
           }
    }

    if(!do_reload) return;
    hide_el('ask_paraWin');
    reload_panel();
}

function toggleParaHighlight() {
  var dom = document.getElementById('para_ask');
  if(dom.checked)
        highlight_Paragraphs();
  else cancelParaDelete(false);

}

function highlight_Paragraphs() {
    var d = oEditor.FCK.EditorDocument.body;   
   
    var paragraphs  = d.getElementsByTagName('p');
    var para_length = paragraphs.length;

    for(var i=0; i < paragraphs.length; i++) {

    var children = paragraphs[i].childNodes;
    if(!children.length) {     
       ourHL_Paras.push([paragraphs[i], "str"]);
       setNodeColors(paragraphs[i],hiLITE.current_item, hiLITE.current_item);               
    }
     else {
       markParaChildren(children);
     }
    }

    if(ourHL_Paras.length) {
        var node = ourHL_Paras[0]; 
        checkViewPort(node[0]);     
    }

} 


function markParaChildren(children) {


  for(var i=0; i < children.length; i++) {
        var c = children[i];          

        if(c.nodeType == 3 && isBlankTextNode(c.nodeValue)) { 
           var attr = getColorAttributes(c.parentNode);
           if(!c.data.match(/\xa0/)) {   // data can equal line-feed: \xa0
                  xA0Substitution.push([c, c.data]);
                  c.data = "\xa0"; 
           }
           if(children.length > 1) {           
              ourHL_Paras.push([c.parentNode, attr]); 

              setNodeColors(c.parentNode,'white', hiLITE.current_item);  
              return;
           }
           else {
             ourHL_Paras.push([c.parentNode, "str"]); 
             setNodeColors(c.parentNode,'white', hiLITE.current_item);   
             return;
           }
        }
  }

  return true;
}


function _removeParagraphs(cycle) {

    var d = oEditor.FCK.EditorDocument.body;
   
    var count = 0;
    var paragraphs  = d.getElementsByTagName('p');
    var para_length = paragraphs.length;
    for(var i=0; i < paragraphs.length; i++) {
            
            if(paragraphs[i].childNodes.length) {               
             
               if(!paragraphChildren(paragraphs[i].childNodes)) {
                       if(confirm('Exit'))
                        return;

               }
            }
           if(!paragraphs[i].childNodes.length) {
               var p_parent = paragraphs[i].parentNode;
               p_parent.removeChild(paragraphs[i]);
          }
       count++;
     }
    cycle++;
    ourParaCycles = cycle;
    
    if(count != para_length && cycle < MAXPCycles) {
       _removeParagraphs(cycle);
    }

 
  
}



function paragraphChildren(children) {
 
  for(var i=0; i < children.length; i++) {
            var c = children[i];              
            if(c.nodeType == 3 && c.nodeValue.match(/^\n*[\xA0\x20]+\n*$/)) {                                     
                   c.parentNode.removeChild(c);  
            }
  }

  return true;
}



function innerHTML(node, data) {
 
  if(typeof node == "string") {
      node = document.getElementById(node);
  }
 if(!node) return;
  node.innerHTML = data;
}



