#!/usr/bin/perl

package eBay::API::XML::DataType::StoreCustomListingHeaderType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. StoreCustomListingHeaderType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::StoreCustomListingHeaderType

=head1 DESCRIPTION

Configuration of a Store custom listing header.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::StoreCustomListingHeaderType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::StoreCustomListingHeaderLinkType;
use eBay::API::XML::DataType::Enum::StoreCustomListingHeaderDisplayCodeType;


my @gaProperties = ( [ 'AddToFavoriteStores', 'xs:boolean', '', '', '' ]
	, [ 'DisplayType', 'ns:StoreCustomListingHeaderDisplayCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::StoreCustomListingHeaderDisplayCodeType', '' ]
	, [ 'LinkToInclude', 'ns:StoreCustomListingHeaderLinkType', '1'
	     ,'eBay::API::XML::DataType::StoreCustomListingHeaderLinkType', '1' ]
	, [ 'Logo', 'xs:boolean', '', '', '' ]
	, [ 'SearchBox', 'xs:boolean', '', '', '' ]
	, [ 'SignUpForStoreNewsletter', 'xs:boolean', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAddToFavoriteStores()

Specifies whether the custom header has a link to Add to
Favorite Stores.

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'xs:boolean'

=cut

sub setAddToFavoriteStores {
  my $self = shift;
  $self->{'AddToFavoriteStores'} = shift
}

=head2 isAddToFavoriteStores()

  Calls: GetStore
  Returned: Conditionally

#    Returns: 'xs:boolean'

=cut

sub isAddToFavoriteStores {
  my $self = shift;
  return $self->{'AddToFavoriteStores'};
}


=head2 setDisplayType()

Display type for the custom listing header.

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'ns:StoreCustomListingHeaderDisplayCodeType'

=cut

sub setDisplayType {
  my $self = shift;
  $self->{'DisplayType'} = shift
}

=head2 getDisplayType()

  Calls: GetStore
  Returned: Conditionally

#    Returns: 'ns:StoreCustomListingHeaderDisplayCodeType'

=cut

sub getDisplayType {
  my $self = shift;
  return $self->{'DisplayType'};
}


=head2 setLinkToInclude()

Link to include in the custom header.

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: reference to an array  
                      of 'ns:StoreCustomListingHeaderLinkType'

=cut

sub setLinkToInclude {
  my $self = shift;
  $self->{'LinkToInclude'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getLinkToInclude()

  Calls: GetStore
  Returned: Conditionally

#    Returns: reference to an array  
                      of 'ns:StoreCustomListingHeaderLinkType'

=cut

sub getLinkToInclude {
  my $self = shift;
  return $self->_getDataTypeArray('LinkToInclude');
}


=head2 setLogo()

Specifies whether the custom header has a logo.

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'xs:boolean'

=cut

sub setLogo {
  my $self = shift;
  $self->{'Logo'} = shift
}

=head2 isLogo()

  Calls: GetStore
  Returned: Conditionally

#    Returns: 'xs:boolean'

=cut

sub isLogo {
  my $self = shift;
  return $self->{'Logo'};
}


=head2 setSearchBox()

Specifies whether the custom header has a search box.

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'xs:boolean'

=cut

sub setSearchBox {
  my $self = shift;
  $self->{'SearchBox'} = shift
}

=head2 isSearchBox()

  Calls: GetStore
  Returned: Conditionally

#    Returns: 'xs:boolean'

=cut

sub isSearchBox {
  my $self = shift;
  return $self->{'SearchBox'};
}


=head2 setSignUpForStoreNewsletter()

Specifies whether the custom header has a link to Sign up for Store
Newsletter.

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'xs:boolean'

=cut

sub setSignUpForStoreNewsletter {
  my $self = shift;
  $self->{'SignUpForStoreNewsletter'} = shift
}

=head2 isSignUpForStoreNewsletter()

  Calls: GetStore
  Returned: Conditionally

#    Returns: 'xs:boolean'

=cut

sub isSignUpForStoreNewsletter {
  my $self = shift;
  return $self->{'SignUpForStoreNewsletter'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
