#!/usr/bin/perl

package eBay::API::XML::Call::GetWantItNowSearchResults::GetWantItNowSearchResultsResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetWantItNowSearchResultsResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetWantItNowSearchResults::GetWantItNowSearchResultsResponseType

=head1 DESCRIPTION

Response contains the Want It Now posts that have the specified keyword(s) in the
title and (optionally) the description.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetWantItNowSearchResults::GetWantItNowSearchResultsResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");

use eBay::API::XML::DataType::PaginationResultType;
use eBay::API::XML::DataType::WantItNowPostArrayType;


my @gaProperties = ( [ 'HasMoreItems', 'xs:boolean', '', '', '' ]
	, [ 'ItemsPerPage', 'xs:int', '', '', '' ]
	, [ 'PageNumber', 'xs:int', '', '', '' ]
	, [ 'PaginationResult', 'ns:PaginationResultType', ''
	     ,'eBay::API::XML::DataType::PaginationResultType', '1' ]
	, [ 'WantItNowPostArray', 'ns:WantItNowPostArrayType', ''
	     ,'eBay::API::XML::DataType::WantItNowPostArrayType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setHasMoreItems()

Indicates whether there are additional Want It Now posts that meet the
search criteria.

#    Argument: 'xs:boolean'

=cut

sub setHasMoreItems {
  my $self = shift;
  $self->{'HasMoreItems'} = shift
}

=head2 isHasMoreItems()

  Returned: Always
#    Returns: 'xs:boolean'

=cut

sub isHasMoreItems {
  my $self = shift;
  return $self->{'HasMoreItems'};
}


=head2 setItemsPerPage()

Indicates the maximum number of Want It Now posts that can be returned in
a WantItNowPostArray for a request. This value can be specified in the
request by  EntriesPerPage in Pagination in the request.

#    Argument: 'xs:int'

=cut

sub setItemsPerPage {
  my $self = shift;
  $self->{'ItemsPerPage'} = shift
}

=head2 getItemsPerPage()

  Returned: Always
#    Returns: 'xs:int'

=cut

sub getItemsPerPage {
  my $self = shift;
  return $self->{'ItemsPerPage'};
}


=head2 setPageNumber()

Indicates the page of data returned by the current call.

#    Argument: 'xs:int'

=cut

sub setPageNumber {
  my $self = shift;
  $self->{'PageNumber'} = shift
}

=head2 getPageNumber()

  Returned: Always
#    Returns: 'xs:int'

=cut

sub getPageNumber {
  my $self = shift;
  return $self->{'PageNumber'};
}


=head2 setPaginationResult()

Indicates the results of the pagination, including the total number of
pages of data there are to be returned and the total number of posts there
are to be returned.

#    Argument: 'ns:PaginationResultType'

=cut

sub setPaginationResult {
  my $self = shift;
  $self->{'PaginationResult'} = shift
}

=head2 getPaginationResult()

  Returned: Always
#    Returns: 'ns:PaginationResultType'

=cut

sub getPaginationResult {
  my $self = shift;
  return $self->_getDataTypeInstance( 'PaginationResult'
		,'eBay::API::XML::DataType::PaginationResultType');
}


=head2 setWantItNowPostArray()

Contains the returned Want It Now posts, if any. The data for each post is
returned in a WantItNowPostType object.

#    Argument: 'ns:WantItNowPostArrayType'

=cut

sub setWantItNowPostArray {
  my $self = shift;
  $self->{'WantItNowPostArray'} = shift
}

=head2 getWantItNowPostArray()

  Returned: Always
#    Returns: 'ns:WantItNowPostArrayType'

=cut

sub getWantItNowPostArray {
  my $self = shift;
  return $self->_getDataTypeInstance( 'WantItNowPostArray'
		,'eBay::API::XML::DataType::WantItNowPostArrayType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
