// CharacterTracer.java
// Copyright (c) 2010 William Whitney
// All rights reserved.
// This software is released under the BSD license.
// Please see the accompanying LICENSE.txt for details.
package at.ac.tuwien.dbai.pdfwrap.ocr;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.LookupOp;
import java.awt.image.ShortLookupTable;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

import javax.imageio.ImageIO;

import net.sourceforge.javaocr.scanner.DocumentScanner;
import net.sourceforge.javaocr.scanner.DocumentScannerListener;
import net.sourceforge.javaocr.scanner.DocumentScannerListenerAdaptor;
import net.sourceforge.javaocr.scanner.PixelImage;
import at.ac.tuwien.dbai.pdfwrap.model.document.CompositeSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.GenericSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.TextFragment;
import at.ac.tuwien.dbai.pdfwrap.util.ExtraUtils;
import at.ac.tuwien.dbai.pdfwrap.utils.SegmentUtils;

/**
 * Saves all the characters in an image to an output directory individually.
 * @author William Whitney
 */
public class SegmentExtractor extends DocumentScannerListenerAdaptor
{

    private DocumentScanner documentScanner = new DocumentScanner();
    private BufferedImage bfImage;
    private Graphics2D bfImageGraphics;
    // TODO! 
    private List<TextFragment> charList;

    
    public static BufferedImage preprocessImage(BufferedImage pageImage, int scaleFactor)
    {
		System.out.println("image:width: " + pageImage.getWidth());
		System.out.println("img.getColorModel: " + pageImage.getColorModel());
		
		// http://webcache.googleusercontent.com/search?q=cache:53mskGkhmFUJ:forums.sun.com/thread.jspa%3FthreadID%3D5394747+InvertedCMYKColorSpace&cd=6&hl=de&ct=clnk&client=ubuntu
		if (pageImage.getColorModel().toString().indexOf("InvertedCMYKColorSpace") >= 0) // -1 if not present
		{
			// invert colours
			System.out.println("filtering");
			short[] invert = new short[256];
			for(int i = 0; i < invert.length; i++) {
			    invert[i] = (short) (255-i);
			}
			LookupOp op = new LookupOp(new ShortLookupTable(0,invert),null);
			op.filter(pageImage, pageImage);
		}
		
		// take care of PDFBox colour spaces
		int multiplier = 1;
		/* //
		if (pageImage.getColorModel().toString().indexOf("org.apache.pdfbox.pdmodel.graphics.color") >= 0) // -1 if not present
		{
			if (pageImage.getColorModel().toString().indexOf("#pixelBits = 32") >= 0)
				multiplier = 4;
			
			if (pageImage.getColorModel().toString().indexOf("#pixelBits = 24") >= 0)
				multiplier = 3;
			
			if (pageImage.getColorModel().toString().indexOf("#pixelBits = 16") >= 0)
				multiplier = 2;
			
		}
		
		System.out.println("multiplier: " + multiplier);
		*/ //
//			Utils.convertToBinary(pageImage); DOES NOT WORK!
		
		// binarize image
		BufferedImage newImage =
			new BufferedImage(pageImage.getWidth() / scaleFactor, pageImage.getHeight() / scaleFactor,
	        BufferedImage.TYPE_BYTE_GRAY);
		for (int y = 0; y < newImage.getHeight(); y ++)
        {
        	for (int x = 0; x < newImage.getWidth(); x ++)
        	{
        		newImage.setRGB(x, y, Color.WHITE.getRGB());
        	}
        }
        	
		BufferedImage tempImage =
			new BufferedImage(pageImage.getWidth(),pageImage.getHeight(),
	        BufferedImage.TYPE_BYTE_GRAY);
        // Get the graphics context for the black-and-white image.
//	        Graphics2D g2d = newImage.createGraphics();
		Graphics2D g2d = tempImage.createGraphics();
        // Render the input image on it.
        g2d.drawImage(pageImage,0,0,null);
//	        WritableRaster rast = newImage.getRaster();
//	        int[] black = new int[1];
//	        black[0] = 0;
//	        int[] white = new int[1];
//	        white[0] = 255;
        for (int y = 0; y < pageImage.getHeight(); y ++)
        {
        	for (int x = 0; x < pageImage.getWidth(); x ++)
        	{
        		int srcPixel = tempImage.getRGB(x / multiplier, y / multiplier);
        		// grey image => r=g=b
        		Color c = new Color(srcPixel);
        		if (c.getBlue() < 224) // never less than 127...
        		{
//	        			System.out.println("black pixel " + c.getBlue());
//	        			rast.setPixel(x, y, black);
        			int scaledX = x / scaleFactor;
        			int scaledY = y / scaleFactor;
        			if (scaledX >= 0 && scaledX < newImage.getWidth() && // otherwise rounding errors occur
        				scaledY >= 0 && scaledY < newImage.getHeight())
        				newImage.setRGB(x / scaleFactor, y / scaleFactor, Color.BLACK.getRGB());
        		}
        		// do not set white; image should start out white
//        		else
//	        			rast.setPixel(x, y, white);
//        			newImage.setRGB(x, y, Color.WHITE.getRGB());
        	}
        }
        
	    pageImage = newImage;
	    // test code to see what our intermediary processing does
	    try
	    {
		    File currentDir = new File(".");
			File outFile = new File(currentDir.getCanonicalPath()
					+ File.separator + "processedImg.tif");
			ImageIO.write(pageImage, "tif", outFile);
			System.out.println("outFile: " + outFile.getCanonicalPath());
	    }
	    catch (Exception e)
	    {
	    	e.printStackTrace();
	    }
		return pageImage;
    }
    
    //public void slice(File inputImage, File outputDir, int std_width, int std_height)
    //public void slice(InputStream is) throws IOException//byte[] inputImage)//, int std_width, int std_height)
    public void slice(Image img) //throws IOException
    {
    	// 14.08.10 Exception only readable when performing IO
        //try
        //{
        	charList = new ArrayList<TextFragment>();
//            this.std_width = std_width;
//            this.std_height = std_height;
//            this.inputImage = inputImage;
            //Image img = ImageIO.read(is);
            PixelImage pixelImage = new PixelImage(img);
            pixelImage.toGrayScale(true);
//            pixelImage.filter();
            
            // segmentation step added 14.11.10
//            pixelImage = convolve(pixelImage, pixelImage.width / 150, pixelImage.width / 1000);
            pixelImage = convolve(pixelImage, 4, 0);
            removeShortRows(pixelImage, 12, 3);
            
            BufferedImage newImage =
				new BufferedImage(pixelImage.width, pixelImage.height,
		        BufferedImage.TYPE_BYTE_GRAY);
            
            int[] pixels = pixelImage.pixels;
            for (int y = 0; y < pixelImage.height; y ++)
            {
            	for (int x = 0; x < pixelImage.width; x ++)
            	{
            		int idx = (y * pixelImage.width + x);
            		if (pixels[idx] < 128) // black
            		{
            			newImage.setRGB(x, y, Color.BLACK.getRGB());
            		}
            		else
            		{
            			newImage.setRGB(x, y, Color.WHITE.getRGB());
            		}
            	}
            }		
            
			try
		    {
			    File currentDir = new File(".");
				File outFile = new File(currentDir.getCanonicalPath()
						+ File.separator + "processedImg2.tif");
				ImageIO.write(newImage, "tif", outFile);
				System.out.println("outFile: " + outFile.getCanonicalPath());
		    }
		    catch (Exception e)
		    {
		    	e.printStackTrace();
		    }			
            
		    List<TextFragment> pageItems = findConnectedComponents(pixelImage);
		    
		    // grow pageItems vertically to account for previous shrinking
		    Iterator iter = pageItems.iterator();
		    while(iter.hasNext())
		    {
		    	GenericSegment gs = (GenericSegment)iter.next();
		    	gs.setY1(gs.getY1() - 1);
		    	gs.setY2(gs.getY2() + 1);
		    }
		    
		    // remove all items where at least one dimension > 100 
		    // (borders enclosing text, graphics, etc.)
		    List<GenericSegment> itemsToRemove = new ArrayList<GenericSegment>();
		    iter = pageItems.iterator();
		    while(iter.hasNext())
		    {
		    	GenericSegment gs = (GenericSegment)iter.next();
		    	// 15.12.10 connected component finding doesn't work 100% (bug somewhere?)
		    	// so limits raised to 200px and at least 5 intersecting items
		    	if (gs.getWidth() > 200 || gs.getHeight() > 200)
		    	{
		    		// check whether item is fully intersected (within) by at least another...
		    		
//		    		boolean intersects = false;
		    		int intersects = 0;
		    		Iterator iter2 = pageItems.iterator();
		    		while(iter2.hasNext() && intersects < 5)//!intersects)
		    		{
		    			GenericSegment gs2 = (GenericSegment)iter2.next();
		    			// gs2 is "inside" of gs1
		    			if (gs2.getX1() > gs.getX1() && gs2.getX2() < gs.getX2() &&
		    				gs2.getY1() > gs.getY1() && gs2.getY2() < gs.getY2())
		    				intersects ++;//= true;
		    		}
		    		if (intersects >= 5)//(intersects)
		    			itemsToRemove.add(gs);
		    	}
		    	
		    	// remove vertical lines of boxes (remain after filtering)
		    	if (gs.getWidth() < 30 && gs.getHeight() > 50)
		    	{
		    		itemsToRemove.add(gs);
		    	}
		    }
		    System.out.println("removing items: " + itemsToRemove);
		    pageItems.removeAll(itemsToRemove);
		    
		    // merge intersecting items -- DON'T
		    ExtraUtils.mergeIntersectingBlockAreas(pageItems);
		    
            charList.addAll(pageItems);
            System.out.println("charList.size: " + charList.size());
            
//            System.out.println("white threshold: " + documentScanner.getWhiteThreshold());
//            documentScanner.scan(pixelImage, this, 0, 0, pixelImage.width, pixelImage.height);
        //}
        //catch (IOException ex)
        //{
        //    Logger.getLogger(SegmentExtractor.class.getName()).log(Level.SEVERE, null, ex);
        //    throw ex;
        //}
    }
    
    // adapted from SegmentList to work with non-compound segments (areas only)
    
    
    /*
    public BufferedImage getTracedImage(File inputImage)
    {
        try
        {
            bfImage = ImageIO.read(inputImage);
            bfImageGraphics = bfImage.createGraphics();

            Image img = ImageIO.read(inputImage);
            PixelImage pixelImage = new PixelImage(img);
            pixelImage.toGrayScale(true);
            pixelImage.filter();
            documentScanner.scan(pixelImage, this, 0, 0, pixelImage.width, pixelImage.height);
        }
        catch (IOException ex)
        {
            LOG.log(Level.SEVERE, null, ex);
        }
        bfImageGraphics.dispose();

        return bfImage;
    }
     */
    
    @Override
    public void processChar(PixelImage pixelImage, int x1, int x2, int y1, int y2, int rowY1, int rowY2)
    {	
//    	TextFragment newChar = new TextFragment(x1, y1, x2, y2);//, "X", null, -1.0f);
    	TextFragment newChar = new TextFragment(x1, y1, rowY1, rowY2);
    	newChar.setText("X");
    	//newChar.setSegFontSize(rowY2 - rowY1);//(-1.0f);
    	// TODO: this is a fudge, but seems to work for now...
    	newChar.setFontSize(10.0f);
    	charList.add(newChar);
    	
//    	TextLine newLine = new TextLine();
//    	newLine.getItems().add(newChar);
//    	newLine.setSegText(newChar.getSegText());
//    	newLine.setBoundingBox(newChar.getBoundingBox());
//    	charList.add(newLine);
    	
//    	System.out.println("adding newChar: " + newChar);
    }

    @Override
    public void processSpace(PixelImage pixelImage, int x1, int x2, int y1, int y2)
    {
    	TextFragment newChar = new TextFragment(x1, y1, x2, y2);//, "X", null, -1.0f);
    	newChar.setText(" ");
    	//newChar.setSegFontSize(y2 - y1);//(-1.0f);
    	// TODO: this is a fudge, but seems to work for now...
    	newChar.setFontSize(10.0f);
    	charList.add(newChar);
    	
//    	System.out.println("adding newChar: " + newChar);
    }
    
    public void beginRow(PixelImage pixelImage, int y1, int y2)
    {
//    	System.out.println("beginRow with y1=" + y1 + " y2=" + y2);
    }
    
    public void endRow(PixelImage pixelImage, int y1, int y2)
    {
//    	System.out.println("endRow with y1=" + y1 + " y2=" + y2);
    }
    
    private static final Logger LOG = Logger.getLogger(SegmentExtractor.class.getName());

	public List<TextFragment> getCharList() {
		return charList;
	}

	public void setCharList(List<TextFragment> charList) {
		this.charList = charList;
	}
	
	public void removeShortRowsOld(PixelImage pixelImage, int minRowWidth)
	{
		int[] pixels = pixelImage.pixels;
		
		for (int y = 0; y < pixelImage.height; y ++)
        {
			int blackPixels = 0;
        	for (int x = 0; x < pixelImage.width; x ++)
        	{
        		int idx = (y * pixelImage.width + x);
        		
        		if (pixels[idx] < 128)
        			blackPixels ++;
        		else
        		{	
        			if (blackPixels < minRowWidth)
        			{
        				// set all prev. pixels to white
        				for (int z = 0; z < blackPixels; z ++)
        				{
        					pixels[idx-z-1] = 255;
        				}
        			}
        			blackPixels = 0;
        		}
        	}
        }
	}
	
	public void removeShortRows(PixelImage pixelImage, int minRowWidth, int maxRowHeight)
	{
		int[] imgPixels = pixelImage.pixels;
		int[] shortRowPixels = new int[imgPixels.length];

		// set shortRowPixels to white
		for (int n = 0; n < shortRowPixels.length; n ++)
		{
			shortRowPixels[n] = 255;
		}
		
		// go horizontally through image
		for (int y = 0; y < pixelImage.height; y ++)
        {
			int blackPixels = 0;
        	for (int x = 0; x < pixelImage.width; x ++)
        	{
        		int idx = (y * pixelImage.width + x);
        		
        		if (imgPixels[idx] < 128)
        			blackPixels ++;
        		else
        		{	
        			if (blackPixels < minRowWidth)
        			{
        				// set all prev. pixels to white
        				for (int z = 0; z < blackPixels; z ++)
        				{
//        					imgPixels[idx-z-1] = 255;
        					shortRowPixels[idx-z-1] = 0;
        				}
        			}
        			blackPixels = 0;
        		}
        	}
        }
		
		
		// go vertically through image
		for (int x = 0; x < pixelImage.width; x ++)
        {
			int blackPixels = 0;
        	for (int y = 0; y < pixelImage.height; y ++)
        	{
        		int idx = (y * pixelImage.width + x);
        		
        		if (shortRowPixels[idx] < 128)
        			blackPixels ++;
        		else
        		{	
        			if (blackPixels > maxRowHeight)
        			{
        				// set all prev. pixels to white
        				for (int z = 0; z < blackPixels; z ++)
        				{
//        					imgPixels[idx-z-1] = 255;
        					shortRowPixels[(y-z-1) * pixelImage.width + x] = 255;
        				}
        			}
        			blackPixels = 0;
        		}
        	}
        }
		
		
		// go horizontally through image again
		for (int n = 0; n < shortRowPixels.length; n ++)
		{
			if (shortRowPixels[n] < 128)
    			imgPixels[n] = 255;
		}
	}
	
	// kernel widths are plus-minus pixels
	public final PixelImage convolve(PixelImage pixelImage, int kernelWidth, int kernelHeight)
	{
		int[] pixels = pixelImage.pixels;
		int[] newpixels = new int[pixels.length];
        
		// initialize newpixels with white
		for (int p = 0; p < newpixels.length; p ++)
		{
			newpixels[p] = 255;
		}
	
			
		System.out.println("height: " + pixelImage.height + " width: " + pixelImage.width);
		System.out.println("pixels: " + pixelImage.pixels.length);
		
        for (int y = 1; y < pixelImage.height - 1; y ++)
        {
        	for (int x = 0; x < pixelImage.width; x ++)
        	{
        		int idx = (y * pixelImage.width + x);
        		
        		int idxAbove = ((y + 1) * pixelImage.width + x);
//        		int idxAbove2 = ((y + 2) * pixelImage.width + x);
        		int idxBelow = ((y - 1) * pixelImage.width + x);
//        		int idxBelow2 = ((y - 2) * pixelImage.width + x);
        		
//        		System.out.println("idx: " + idx);
        		if (pixels[idx] < 128 && pixels[idxAbove] < 128 && pixels[idxBelow] < 128)// &&
//        			pixels[idxAbove2] < 128 && pixels[idxBelow2] < 128) // black
        		{
//        			System.out.println("x: " + x + " y: " + y);
	        		for (int h = 0; h <= kernelHeight; h ++)
	        		{
	        			for (int w = 0; w <= kernelWidth; w ++)
	        			{
//	        				System.out.println("h: " + h + " w: " + w);
	        				int x2, y2;
	        				x2 = x + w; y2 = y + h;
	        				if (x2 > 0 && x2 < pixelImage.width
	        					&& y2 > 0 && y2 < pixelImage.height)
	        				{
	        					int idx2 = (y2 * pixelImage.width + x2);
	        					newpixels[idx2] = 0;
//	        					System.out.println("x2: " + x2 + " y2: " + y2 + " idx2: " + idx2);
	        				}
	        				
	        				x2 = x - w; y2 = y + h;
	        				if (x2 > 0 && x2 < pixelImage.width
	        					&& y2 > 0 && y2 < pixelImage.height)
	        				{
	        					int idx2 = (y2 * pixelImage.width + x2);
	        					newpixels[idx2] = 0;
//	        					System.out.println("x2: " + x2 + " y2: " + y2 + " idx2: " + idx2);
	        				}
	        				
	        				x2 = x + w; y2 = y - h;
	        				if (x2 > 0 && x2 < pixelImage.width
	        					&& y2 > 0 && y2 < pixelImage.height)
	        				{
	        					int idx2 = (y2 * pixelImage.width + x2);
	        					newpixels[idx2] = 0;
//	        					System.out.println("x2: " + x2 + " y2: " + y2 + " idx2: " + idx2);
	        				}
	        				
	        				x2 = x - w; y2 = y - h;
	        				if (x2 > 0 && x2 < pixelImage.width
	        					&& y2 > 0 && y2 < pixelImage.height)
	        				{
	        					int idx2 = (y2 * pixelImage.width + x2);
	        					newpixels[idx2] = 0;
//	        					System.out.println("x2: " + x2 + " y2: " + y2 + " idx2: " + idx2);
	        				}
	        			}
	        		}
        		}
        	}
        }
//        pixelImage.pixels = newpixels;
        PixelImage retVal = new PixelImage(newpixels, pixelImage.width, pixelImage.height);
        return retVal;
	}
	
	public final List<TextFragment> findConnectedComponents(PixelImage pixelImage)
	{
		int[] pixels = pixelImage.pixels;
		PixelImage labelImage = 
			new PixelImage(new int[pixels.length], pixelImage.width, pixelImage.height);
		int[] labels = labelImage.pixels;
		
//		ArrayList equivFrom = new ArrayList();
//		ArrayList equivTo = new ArrayList();
		int[] equiv = new int[pixels.length];
		
		System.out.println("entering first pass");
		
		// first pass of algorithm
		int lastGivenLabel = 0;
		
		for (int y = 0; y < pixelImage.height; y ++)
        {
        	for (int x = 0; x < pixelImage.width; x ++)
        	{
        		int idx = (y * pixelImage.width + x);

        		
        		if (pixels[idx] < 128) // black
        		{
        			boolean hasNeighbour = false;
            		int smallestNeighbour = Integer.MAX_VALUE;
        			int x2, y2;
        			
    				x2 = x - 1; y2 = y; //WEST
    				if (x2 > 0 && x2 < pixelImage.width
    					&& y2 > 0 && y2 < pixelImage.height)
    				{
    					int idx2 = (y2 * pixelImage.width + x2);
    					if (pixels[idx2] < 128)
    					{
    						hasNeighbour = true;
    						if (labels[idx2] < smallestNeighbour)
    							smallestNeighbour = labels[idx2];
    					}
    				}
    				
    				x2 = x - 1; y2 = y - 1; //NORTH-WEST
    				if (x2 > 0 && x2 < pixelImage.width
    					&& y2 > 0 && y2 < pixelImage.height)
    				{
    					int idx2 = (y2 * pixelImage.width + x2);
    					if (pixels[idx2] < 128)
    					{
    						hasNeighbour = true;
    						if (labels[idx2] < smallestNeighbour)
    							smallestNeighbour = labels[idx2];
    					}
    				}
    				
    				x2 = x; y2 = y - 1; //NORTH
    				if (x2 > 0 && x2 < pixelImage.width
    					&& y2 > 0 && y2 < pixelImage.height)
    				{
    					int idx2 = (y2 * pixelImage.width + x2);
    					if (pixels[idx2] < 128)
    					{
    						hasNeighbour = true;
    						if (labels[idx2] < smallestNeighbour)
    							smallestNeighbour = labels[idx2];
    					}
    				}
    				
    				x2 = x + 1; y2 = y - 1; //NORTH-EAST
    				if (x2 > 0 && x2 < pixelImage.width
    					&& y2 > 0 && y2 < pixelImage.height)
    				{
    					int idx2 = (y2 * pixelImage.width + x2);
    					if (pixels[idx2] < 128)
    					{
    						hasNeighbour = true;
    						if (labels[idx2] < smallestNeighbour)
    							smallestNeighbour = labels[idx2];
    					}
    				}
    				
    				if (hasNeighbour)
    				{
    					labels[idx] = smallestNeighbour;
    					
    					// now go through the other neighbours again, which are different,
    					// and enter equivalence classes
    					
    					x2 = x - 1; y2 = y; //WEST
        				if (x2 > 0 && x2 < pixelImage.width
        					&& y2 > 0 && y2 < pixelImage.height)
        				{
        					int idx2 = (y2 * pixelImage.width + x2);
        					if (pixels[idx2] < 128)
        					{
        						if (labels[idx2] != smallestNeighbour) // should always be >
        						{
        							// add equiv. classes for both
//        							equivFrom.add(new Integer(labels[idx2]));
//        							equivTo.add(new Integer(smallestNeighbour));
        							equiv[labels[idx2]] = smallestNeighbour;
        						}
        					}
        				}
        				
        				x2 = x - 1; y2 = y - 1; //NORTH-WEST
        				if (x2 > 0 && x2 < pixelImage.width
        					&& y2 > 0 && y2 < pixelImage.height)
        				{
        					int idx2 = (y2 * pixelImage.width + x2);
        					if (pixels[idx2] < 128)
        					{
        						hasNeighbour = true;
        						if (labels[idx2] != smallestNeighbour)
        						{
        							// add equiv. classes for both
//        							equivFrom.add(new Integer(labels[idx2]));
//        							equivTo.add(new Integer(smallestNeighbour));
        							equiv[labels[idx2]] = smallestNeighbour;
        						}
        					}
        				}
        				
        				x2 = x; y2 = y - 1; //NORTH
        				if (x2 > 0 && x2 < pixelImage.width
        					&& y2 > 0 && y2 < pixelImage.height)
        				{
        					int idx2 = (y2 * pixelImage.width + x2);
        					if (pixels[idx2] < 128)
        					{
        						hasNeighbour = true;
        						if (labels[idx2] != smallestNeighbour)
        						{
        							// add equiv. classes for both
//        							equivFrom.add(new Integer(labels[idx2]));
//        							equivTo.add(new Integer(smallestNeighbour));
        							equiv[labels[idx2]] = smallestNeighbour;
        						}
        					}
        				}
        				
        				x2 = x + 1; y2 = y - 1; //NORTH-EAST
        				if (x2 > 0 && x2 < pixelImage.width
        					&& y2 > 0 && y2 < pixelImage.height)
        				{
        					int idx2 = (y2 * pixelImage.width + x2);
        					if (pixels[idx2] < 128)
        					{
        						hasNeighbour = true;
        						if (labels[idx2] != smallestNeighbour)
        						{
        							// add equiv. classes for both
//        							equivFrom.add(new Integer(labels[idx2]));
//        							equivTo.add(new Integer(smallestNeighbour));
        							equiv[labels[idx2]] = smallestNeighbour;
        						}
        					}
        				}
    				}
    				else
    				{
//    					System.out.println("new label!");
    					// give lastGivenLabel + 1
    					labels[idx] = lastGivenLabel + 1;
    					lastGivenLabel ++;
    				}
        		}
        	}
        }	
		
		System.out.println("no labels: " + lastGivenLabel);
//		System.out.println("equivFrom.size: " + equivFrom.size());
		
		// second pass of algorithm
		System.out.println("entering second pass");
		
		boolean loop = true;
		while(loop)
		{
			loop = false;
			for (int y = 0; y < labelImage.height; y ++)
	        {
	//			System.out.println("y=" + y);
	        	for (int x = 0; x < labelImage.width; x ++)
	        	{
	        		int idx = (y * labelImage.width + x);
	
	        		if (pixels[idx] < 128) // black
	        		{
	        			// labels[idx] assigned
	        			
	        			// now, we reduce labels[idx] if an equivalence relation exists
	        			/*
	        			for (int n = 0; n < equivFrom.size(); n ++)
	        			{
	        				int eFrom = (Integer)equivFrom.get(n);
	        				int eTo = (Integer)equivTo.get(n);
	        				
	//        				System.out.println("eFrom: " + eFrom + " eTo: " + eTo);
	        				
	        				// TEST: eFrom should not be repeated!
	        				
	        				if (labels[idx] == eFrom)
	        					labels[idx] = eTo;
	        			}
	        			*/
	        			
	        			if (equiv[labels[idx]] > 0) // unassigned = 0 with int arrays
	        			{
	//        				System.out.println("replacing label " + labels[idx] + " with " + equiv[labels[idx]]);
	        				labels[idx] = equiv[labels[idx]];
	        				// to allow for transitive equivalence a -> b -> c -> d -> ... etc...
	        				// loop until no more labels are changed
	        				loop = true;
	        			}
	        		}
	        	}
	        }
		}
		
		// third pass: return GenericSegments with bBox of pixel coordinates corresponding
		// to the connected components
		System.out.println("entering third pass");
		
		List<TextFragment> retVal = new ArrayList<TextFragment>();
		
		for (int lbl = 1; lbl <= lastGivenLabel; lbl ++)
		{
			CompositeSegment cts = new CompositeSegment();
			boolean first = true;
			for (int y = 0; y < labelImage.height; y ++)
	        {
	        	for (int x = 0; x < labelImage.width; x ++)
	        	{
	        		int idx = (y * labelImage.width + x);

	        		if (labels[idx] == lbl) // black
	        		{
	        			GenericSegment pixelSeg = new GenericSegment(x, x, y, y); // size 0
	        			if (first)
	        			{
	        				first = false;
	        				cts.setBoundingBox(pixelSeg.getBoundingBox());
	        			}
	        			else
	        			{
	//	        			cts.getItems().add(pixelSeg);
		        			cts.growBoundingBox(pixelSeg);
	        			}
	        		}
	        	}
	        }
//			System.out.println("added segment: " + cts);
//			cts.findBoundingBox();
//			retVal.add(cts);
			TextFragment newChar = new TextFragment(cts.getX1(), cts.getX2(), cts.getY1(), cts.getY2());
	    	newChar.setText("X");
	    	//newChar.setSegFontSize(rowY2 - rowY1);//(-1.0f);
	    	// TODO: this is a fudge, but seems to work for now...
	    	newChar.setFontSize(10.0f);
			retVal.add(newChar);
		}
		
		System.out.println("lastGivenLabel: " + lastGivenLabel);
		
		return retVal;
	}
	
	// NOT IN USE
	public final void segment(
            PixelImage pixelImage,
            DocumentScannerListener listener,
            int blockX1,
            int blockY1,
            int blockX2,
            int blockY2)
    {

        int[] pixels = pixelImage.pixels;
        int w = pixelImage.width;
        int h = pixelImage.height;

        if (blockX1 < 0)
        {
            blockX1 = 0;
        }
        else if (blockX1 >= w)
        {
            blockX1 = w - 1;
        }
        if (blockY1 < 0)
        {
            blockY1 = 0;
        }
        else if (blockY1 >= h)
        {
            blockY1 = h - 1;
        }
        if ((blockX2 <= 0) || (blockX2 >= w))
        {
            blockX2 = w - 1;
        }
        if ((blockY2 <= 0) || (blockY2 >= h))
        {
            blockY2 = h - 1;
        }

        blockX2++;
        blockY2++;

        boolean whiteLine = true;
        listener.beginDocument(pixelImage);
        // First build list of rows of text.
        ArrayList<Integer> al = new ArrayList<Integer>();
        int y1 = 0;
        for (int y = blockY1; y < blockY2; y++)
        {
            boolean isWhiteSpace = true;
            for (int x = blockX1, idx = (y * w) + blockX1; x < blockX2;
                    x++, idx++)
            {
//            	System.out.println("pixels[idx]: " + pixels[idx]);
            	if (false)
                if (pixels[idx] < 128)
                {
                    isWhiteSpace = false;
                    break;
                }
            }
            if (isWhiteSpace)
            {
                if (!whiteLine)
                {
                    whiteLine = true;
                    al.add(new Integer(y1));
                    al.add(new Integer(y));
                }
            }
            else
            {
                if (whiteLine)
                {
                    whiteLine = false;
                    y1 = y;
                }
            }
        }
        if (!whiteLine)
        {
            al.add(new Integer(y1));
            al.add(new Integer(blockY2));
        }
        
        System.out.println("al.size before merging: " + al.size());

        System.out.println("al.size after merging: " + al.size());
        
        // Process the rows.
        for (int i = 0; (i + 1) < al.size(); i += 2)
        {
            int bY1 = (al.get(i)).intValue();
            int bY2 = (al.get(i + 1)).intValue();

//            processRow(pixelImage,
//                    listener,
//                    pixels, w, h, blockX1, bY1, blockX2, bY2);
        }
    }
}
