# Parallel::Tiny

Provides a simple, no frills fork manager.

## Installation

Install from CPAN:

```shell
cpan -i Parallel::Tiny
```

## Source Build

```shell
cpan -i Dist::Zilla Dist::Zilla::Plugin::VersionFromModule Dist::Zilla::Plugin::AutoPrereqs Dist::Zilla::PluginBundle::Basic
cpan -i Test::Spec Sys::Prctl
dzil test
dzil install
```

## Usage

### Synopsis:

Provided an object that provides a `run` method, you can create a `Parallel::Tiny` fork manager that will run that method several times:

```perl
my $obj = My::Handler->new();

my $forker = Parallel::Tiny->new(
    handler      => $obj,
    subname      => 'start', # My::Handler must implement start()
    workers      => 4,
    worker_total => 'infinite',
);

$forker->run();
```

In the above example we will execute the `run` method for a `My::Handler` object 4 workers at a time, infinitely (or until the application or the fork manager is stopped).

