package Spp::Cursor;

use Exporter;
our @ISA    = qw(Exporter);
our @EXPORT = qw(cursor go get_char pre_char cache recover);

use 5.012;

sub cursor {
   my ($str, $ns) = @_;
   $str = $str . chr(0);
   return {
      str    => $str,
      ns     => $ns,
      len    => length($str),
      off    => 0,
      line   => 1,      # record line number of souce code
      debug  => 0,      # 1 open debug mode
      depth  => 0,      # match_rule trace depth
   };
}

sub go {
   my $cursor = shift;
   $cursor->{off} += 1;
   return 1;
}

sub get_char {
   my $cursor = shift;
   return substr($cursor->{str}, $cursor->{off}, 1);
}

sub pre_char {
   my $cursor = shift;
   return substr($cursor->{str}, $cursor->{off} - 1, 1);
}

sub cache {
   my $cursor = shift;
   my $line = $cursor->{line};
   my $off = $cursor->{off};
   return [$line, $off];
}

sub recover {
   my ($cursor, $cache) = @_;
   my ($line, $off) = @{$cache};
   $cursor->{line} = $line;
   $cursor->{off} = $off;
   return 1;
}

1;
