package Mylisp;

use 5.012;
no warnings "experimental";

use Exporter;
our @ISA = qw(Exporter);
our @EXPORT =
  qw(mylisp_repl get_mylisp_parser mylisp_to_ast);

our $VERSION = '2.01';
use Spp::Builtin;
use Spp::Tools;
use Spp;
use Mylisp::Grammar;
use Mylisp::OptAst;
use Mylisp::Lint;
use Mylisp::LintAst;
use Mylisp::ToPerl;
use Mylisp::ToMylisp;
use Mylisp::ToGo;

sub mylisp_repl {
  my $parser = get_mylisp_parser();
  say 'This is Mylisp REPL, type enter to exit.';
  while (1) {
    print '>> ';
    my $line = <STDIN>;
    exit() if ord($line) == 10;
    my ($match, $ok) = match_text($parser, $line);
    if ($ok) {
      say '.. ', see_ast($match);
      my $ast = opt_mylisp_ast($match);
      say '.. ', see_ast($ast);
      my $lint = new_lint($line);
      say 'golang -> ', ast_to_go($ast);
      say 'perl ->   ', ast_to_perl_repl($ast);
      say 'mylisp->  ', ast_to_mylisp($ast);
    }
    else { say $match }
  }
}

sub get_mylisp_parser {
  my $grammar = get_mylisp_grammar();
  return grammar_to_ast($grammar);
}

sub mylisp_to_ast {
  my $code   = shift;
  my $parser = get_mylisp_parser();
  my ($match, $ok) = match_text($parser, $code);
  if   ($ok) { return opt_mylisp_ast($match) }
  else       { error($match) }
}
1;
