package Net::FileMaker::Error::JA::XSLT;

use strict;
use warnings;

=encoding utf8

=head1 NAME

Net::FileMaker::Error::JA::XML - FileMaker Server XSLTインタフェーイスの日本語エラー文字列

=head1 INFO

このモジュールがサポートするエラーコードがFileMaker XML/XSLTのドキュメンテーションから抜き出され、FileMaker Server 10に有効でありそうです。

=head1 SEE ALSO

L<Net::FileMaker::Error>

=cut

my $error_codes = {

	'-1'	=> "原因不明のエラー",
	0		=> "エラーなし",
	10000	=> "無効なヘッダ名",
	10001	=> "無効な HTTP ステータスコード",
	10100	=> "原因不明のセッションエラー",,
	10101	=> "要求されたセッション名はすでに使用されています",
	10102	=> "セッションにアクセスできませんでした。存在しない可能性があります",
	10103	=> "セッションがタイムアウトしました",
	10104	=> "指定されたセッションオブジェクトは存在しません",
	10200	=> "原因不明のメッセージングエラー",
	10201	=> "メッセージの書式設定エラー",
	10202	=> "メッセージの SMTP フィールドのエラー",
	10203	=> "メッセージの「To」フィールドのエラー",
	10204	=> "メッセージの「From」フィールドのエラー",
	10205	=> "メッセージの「CC」フィールドのエラー",
	10206	=> "メッセージの「BCC」フィールドのエラー",
	10207	=> "メッセージの「Subject」フィールドのエラー",
	10208	=> "メッセージの「Reply-To」フィールドのエラー",
	10209	=> "メッセージの本文のエラー",
	10210	=> "再帰メールエラー - 電子メール用の XSLT スタイルシート内で send_email() を呼び出そうとしました",
	10211	=> "SMTP 認証エラー - ログインに失敗したか、間違ったタイプの認証が指定されています",
	10212	=> "無効な関数の使用法 - 電子メール用の XSLT スタイルシート内で set_header()、set_status_code()、ま たは set_cookie() を呼び出そうとしました",
	10213	=> "SMTP サーバーが無効であるか動作していません",
	10300	=> "原因不明の書式設定エラー",
	10301	=> "無効な日付または時刻書式",
	10302	=> "無効な日付書式",
	10303	=> "無効な時刻書式",
	10304	=> "無効な曜日書式",
	10305	=> "不適切な形式の日付または時刻文字列",
	10306	=> "不適切な形式の日付文字列",
	10307	=> "不適切な形式の時刻文字列",
	10308	=> "不適切な形式の曜日文字列",
	10309	=> "サポートされていないテキストエンコード",
	10310	=> "無効な URL エンコード",
	10311	=> "正規表現パターンのエラー"

};

sub new
{
	my $class = shift;
	$class = ref($class) || $class;

	my $self = { };
	return bless $self, $class;
}

sub get_string
{
	my ($self, $error_code) = @_;
	return $error_codes->{$error_code};
}

1; # End of Net::FileMaker::Error::JA::XSLT