use strict;
use warnings;
use Test::More;
use AsyncLogWatcher;
use AnyEvent;
use File::Temp qw/ tempfile /;

# Create a temp log file
my ($fh, $log_file) = tempfile();
print $fh "line1\nline2\nline3\n";
close($fh);

# Create a temp pattern file
my ($pfh, $patterns_file) = tempfile();
print $pfh "line1\nline3\n";
close($pfh);

my $cv = AnyEvent->condvar;

my @matched_lines;
my $watcher = AsyncLogWatcher->new({
    log_file => $log_file,
    patterns_file => $patterns_file,
    on_match => sub {
        my ($line) = @_;
        push @matched_lines, $line;
        $cv->send if @matched_lines == 2;
    },
});

my $guard = $watcher->watch;

my $timer = AnyEvent->timer(
    after => 5,
    cb => sub {
        fail("Timeout: Callback was not called enough times");
        $cv->send;
    },
);

$cv->recv;  # Wait for callbacks or timeout

is_deeply(
    \@matched_lines,
    ["line1\n", "line3\n"],
    "Correct lines were matched"
);

done_testing();

