#
#  Test of \p{ .. }, \P{ .. }, etc.
#
#  This script uses ShiftJIS::String.pm
#
use ShiftJIS::String qw(mkrange);
use ShiftJIS::Regexp qw(re match);

my $n  = 0;
my @NG;

my %char = (
 n => [ "\n" ],
 r => [ "\r", "\t", "\f" ],
 s => [ ' '  ],
 S => [ '@' ],
 b => [ "\x7F" ],
 c => [ mkrange("\x00-\x08\x0b\x0e-\x1F") ],
 p => [ mkrange('!-/:-@[-^`{-~') ],
 q => [ '_' ],
 d => [ mkrange("0-9") ],
 u => [ mkrange("A-Z") ],
 l => [ mkrange("a-z") ],
 D => [ mkrange('O-X') ],
 U => [ mkrange('`-y') ],
 L => [ mkrange('-') ],
 G => [ mkrange('--') ],
 C => [ mkrange('@-`p-') ],
 H => [ mkrange('-JKTU') ],
 K => [ mkrange('@-[RS')   ],
 h => [ mkrange('-') ],
 k => [ mkrange('-') ],
 J => [ mkrange('-r') ],
 Z => [ mkrange('-') ],
 Y => [ mkrange('V-Z') ],
 P => [ mkrange('A-IL-Q\---΁--') ],
 B => [ mkrange('-') ],
 X => [ mkrange("\x81\xAD-\x81\xB7\x81\xC0-\x81\xC7\x81\xCF-\x81\xD9"
	.	"\x81\xE9-\x81\xEF\x81\xF8-\x81\xFB\x82\x40-\x82\x4E"
	.	"\x82\x59-\x82\x5F\x82\x7A-\x82\x80\x82\x9B-\x82\x9E"
	.	"\x82\xF2-\x82\xFC\x83\x97-\x83\x9E\x83\xB7-\x83\xBE"
	.	"\x83\xD7-\x83\xFC\x84\x61-\x84\x6F\x84\x92-\x84\x9E"
	.	"\x84\xBF-\x86\xFC\x88\x40-\x88\x9E\x98\x73-\x98\x9E"
	.	"\xEA\xA5-\xEC\xFC") ],
);

sub sp { grep /\w/, split '', shift }

my @cls =		   sp q(nrsSbc-pqdulDUL-GCHKhk-JZYPBX);
my %res = (
 '\j'			=>[sp q(111111-11111111-111111-111111)],
 '[\0-\x{fcfc}]'	=>[sp q(111111-11111111-111111-111111)],
 '.'			=>[sp q(011111-11111111-111111-111111)],
 '\J'			=>[sp q(011111-11111111-111111-111111)],
 '[^\n]'		=>[sp q(011111-11111111-111111-111111)],
 '\d'			=>[sp q(000000-00100000-000000-000000)],
 '[\d]'			=>[sp q(000000-00100000-000000-000000)],
 '\D'			=>[sp q(111111-11011111-111111-111111)],
 '[\D]'			=>[sp q(111111-11011111-111111-111111)],
 '\w'			=>[sp q(000000-01111000-000000-000000)],
 '[\w]'			=>[sp q(000000-01111000-000000-000000)],
 '\W'			=>[sp q(111111-10000111-111111-111111)],
 '[\W]'			=>[sp q(111111-10000111-111111-111111)],
 '\s'			=>[sp q(111000-00000000-000000-000000)],
 '[\s]'			=>[sp q(111000-00000000-000000-000000)],
 '\S'			=>[sp q(000111-11111111-111111-111111)],
 '[\S]'			=>[sp q(000111-11111111-111111-111111)],

 '\p{IsDigit}'		=>[sp q(000000-00100100-000000-000000)],
 '[[:digit:]]'		=>[sp q(000000-00100100-000000-000000)],
 '[^[:^digit:]]'	=>[sp q(000000-00100100-000000-000000)],
 '[0-9O-X]'		=>[sp q(000000-00100100-000000-000000)],
 '\P{IsDigit}'		=>[sp q(111111-11011011-111111-111111)],
 '[[:^digit:]]'		=>[sp q(111111-11011011-111111-111111)],
 '[^[:digit:]]'		=>[sp q(111111-11011011-111111-111111)],
 '[^0-9O-X]'		=>[sp q(111111-11011011-111111-111111)],
 '\p{IsUpper}'		=>[sp q(000000-00010010-000000-000000)],
 '[[:upper:]]'		=>[sp q(000000-00010010-000000-000000)],
 '[^[:^upper:]]'	=>[sp q(000000-00010010-000000-000000)],
 '[A-Z`-y]'		=>[sp q(000000-00010010-000000-000000)],
 '\P{IsUpper}'		=>[sp q(111111-11101101-111111-111111)],
 '[[:^upper:]]'		=>[sp q(111111-11101101-111111-111111)],
 '[^[:upper:]]'		=>[sp q(111111-11101101-111111-111111)],
 '[^A-Z`-y]'		=>[sp q(111111-11101101-111111-111111)],
 '\p{IsLower}'		=>[sp q(000000-00001001-000000-000000)],
 '[[:lower:]]'		=>[sp q(000000-00001001-000000-000000)],
 '[^[:^lower:]]'	=>[sp q(000000-00001001-000000-000000)],
 '[a-z-]'		=>[sp q(000000-00001001-000000-000000)],
 '\P{IsLower}'		=>[sp q(111111-11110110-111111-111111)],
 '[[:^lower:]]'		=>[sp q(111111-11110110-111111-111111)],
 '[^[:lower:]]'		=>[sp q(111111-11110110-111111-111111)],
 '[^a-z-]'		=>[sp q(111111-11110110-111111-111111)],
 '(?i)[A-Z`-y]'	=>[sp q(000000-00011010-000000-000000)],
 '(?i)[^A-Z`-y]'	=>[sp q(111111-11100101-111111-111111)],
 '(?i)[a-z-]'	=>[sp q(000000-00011001-000000-000000)],
 '(?i)[^a-z-]'	=>[sp q(111111-11100110-111111-111111)],
 '\p{IsAlpha}'		=>[sp q(000000-00011011-000000-000000)],
 '[[:alpha:]]'		=>[sp q(000000-00011011-000000-000000)],
 '[^[:^alpha:]]'	=>[sp q(000000-00011011-000000-000000)],
 '\P{IsAlpha}'		=>[sp q(111111-11100100-111111-111111)],
 '[[:^alpha:]]'		=>[sp q(111111-11100100-111111-111111)],
 '[^[:alpha:]]'		=>[sp q(111111-11100100-111111-111111)],
 '\p{IsAlnum}'		=>[sp q(000000-00111111-000000-000000)],
 '[[:alnum:]]'		=>[sp q(000000-00111111-000000-000000)],
 '[^[:^alnum:]]'	=>[sp q(000000-00111111-000000-000000)],
 '\P{IsAlnum}'		=>[sp q(111111-11000000-111111-111111)],
 '[[:^alnum:]]'		=>[sp q(111111-11000000-111111-111111)],
 '[^[:alnum:]]'		=>[sp q(111111-11000000-111111-111111)],
 '\p{IsWord}'		=>[sp q(000000-01111111-111101-111000)],
 '[[:word:]]'		=>[sp q(000000-01111111-111101-111000)],
 '[^[:^word:]]'		=>[sp q(000000-01111111-111101-111000)],
 '\P{IsWord}'		=>[sp q(111111-10000000-000010-000111)],
 '[[:^word:]]' 		=>[sp q(111111-10000000-000010-000111)],
 '[^[:word:]]'		=>[sp q(111111-10000000-000010-000111)],
 '\p{IsPunct}'		=>[sp q(000000-11000000-000010-000110)],
 '[[:punct:]]'		=>[sp q(000000-11000000-000010-000110)],
 '[^[:^punct:]]'	=>[sp q(000000-11000000-000010-000110)],
 '\P{IsPunct}'		=>[sp q(111111-00111111-111101-111001)],
 '[[:^punct:]]'		=>[sp q(111111-00111111-111101-111001)],
 '[^[:punct:]]'		=>[sp q(111111-00111111-111101-111001)],
 '\p{IsSpace}'		=>[sp q(111100-00000000-000000-000000)],
 '[[:space:]]'		=>[sp q(111100-00000000-000000-000000)],
 '[^[:^space:]]'	=>[sp q(111100-00000000-000000-000000)],
 '[\s\x{8140}]'		=>[sp q(111100-00000000-000000-000000)],
 '\P{IsSpace}'		=>[sp q(000011-11111111-111111-111111)],
 '[[:^space:]]'		=>[sp q(000011-11111111-111111-111111)],
 '[^[:space:]]'		=>[sp q(000011-11111111-111111-111111)],
 '[^\s\x{8140}]'	=>[sp q(000011-11111111-111111-111111)],
 '\p{IsGraph}'		=>[sp q(000000-11111111-111111-111111)],
 '[[:graph:]]'		=>[sp q(000000-11111111-111111-111111)],
 '[^[:^graph:]]'	=>[sp q(000000-11111111-111111-111111)],
 '\P{IsGraph}'		=>[sp q(111111-00000000-000000-000000)],
 '[[:^graph:]]'		=>[sp q(111111-00000000-000000-000000)],
 '[^[:graph:]]'		=>[sp q(111111-00000000-000000-000000)],
 '\p{IsPrint}'		=>[sp q(111100-11111111-111111-111111)],
 '[[:print:]]'		=>[sp q(111100-11111111-111111-111111)],
 '[^[:^print:]]'	=>[sp q(111100-11111111-111111-111111)],
 '\P{IsPrint}'		=>[sp q(000011-00000000-000000-000000)],
 '[[:^print:]]'		=>[sp q(000011-00000000-000000-000000)],
 '[^[:print:]]'		=>[sp q(000011-00000000-000000-000000)],
 '\p{IsCntrl}'		=>[sp q(110001-00000000-000000-000000)],
 '[[:cntrl:]]'		=>[sp q(110001-00000000-000000-000000)],
 '[^[:^cntrl:]]'	=>[sp q(110001-00000000-000000-000000)],
 '\P{IsCntrl}'		=>[sp q(001110-11111111-111111-111111)],
 '[[:^cntrl:]]'		=>[sp q(001110-11111111-111111-111111)],
 '[^[:cntrl:]]'		=>[sp q(001110-11111111-111111-111111)],
 '\p{IsAscii}'		=>[sp q(111011-11111000-000000-000000)],
 '[[:ascii:]]'		=>[sp q(111011-11111000-000000-000000)],
 '[^[:^ascii:]]'	=>[sp q(111011-11111000-000000-000000)],
 '[\0-\c?]'		=>[sp q(111011-11111000-000000-000000)],
 '\P{IsAscii}'		=>[sp q(000100-00000111-111111-111111)],
 '[[:^ascii:]]'		=>[sp q(000100-00000111-111111-111111)],
 '[^[:ascii:]]'		=>[sp q(000100-00000111-111111-111111)],
 '[^\0-\c?]'		=>[sp q(000100-00000111-111111-111111)],
 '\p{IsHankaku}'	=>[sp q(000000-00000000-000011-000000)],
 '[[:hankaku:]]'	=>[sp q(000000-00000000-000011-000000)],
 '[^[:^hankaku:]]'	=>[sp q(000000-00000000-000011-000000)],
 '[\xA1-\xDF]'		=>[sp q(000000-00000000-000011-000000)],
 '\P{IsHankaku}'	=>[sp q(111111-11111111-111100-111111)],
 '[[:^hankaku:]]'	=>[sp q(111111-11111111-111100-111111)],
 '[^[:hankaku:]]'	=>[sp q(111111-11111111-111100-111111)],
 '[^\xa1-\xdf]'		=>[sp q(111111-11111111-111100-111111)],
 '\p{IsZenkaku}'	=>[sp q(000100-00000111-111100-111111)],
 '[[:zenkaku:]]'	=>[sp q(000100-00000111-111100-111111)],
 '[^[:^zenkaku:]]'	=>[sp q(000100-00000111-111100-111111)],
 '\P{IsZenkaku}'	=>[sp q(111011-11111000-000011-000000)],
 '[[:^zenkaku:]]'	=>[sp q(111011-11111000-000011-000000)],
 '[^[:zenkaku:]]'	=>[sp q(111011-11111000-000011-000000)],
 '\p{IsX0201}'		=>[sp q(111011-11111000-000011-000000)],
 '[[:x0201:]]'		=>[sp q(111011-11111000-000011-000000)],
 '[^[:^x0201:]]'	=>[sp q(111011-11111000-000011-000000)],
 '\P{IsX0201}'		=>[sp q(000100-00000111-111100-111111)],
 '[[:^x0201:]]'		=>[sp q(000100-00000111-111100-111111)],
 '[^[:x0201:]]'		=>[sp q(000100-00000111-111100-111111)],
 '[[:x0201:][:x0208:]]' =>[sp q(111111-11111111-111111-111110)],
 '[^[:x0201:][:x0208:]]'=>[sp q(000000-00000000-000000-000001)],
 '[\x20-\x7F\xA1-\xDF]' =>[sp q(001010-11111000-000011-000000)],
 '[^\x20-\x7F\xA1-\xDF]'=>[sp q(110101-00000111-111100-111111)],

 '\p{IsX0208}'		=>[sp q(000100-00000111-111100-111110)],
 '[[:x0208:]]'		=>[sp q(000100-00000111-111100-111110)],
 '[^[:^x0208:]]'	=>[sp q(000100-00000111-111100-111110)],
 '\P{IsX0208}'		=>[sp q(111011-11111000-000011-000001)],
 '[[:^x0208:]]'		=>[sp q(111011-11111000-000011-000001)],
 '[^[:x0208:]]'		=>[sp q(111011-11111000-000011-000001)],

 '\p{InLatin}'		=>[sp q(000000-00011000-000000-000000)],
 '[[:latin:]]'		=>[sp q(000000-00011000-000000-000000)],
 '[^[:^latin:]]'	=>[sp q(000000-00011000-000000-000000)],
 '[A-Za-z]'		=>[sp q(000000-00011000-000000-000000)],
 '\P{InLatin}'		=>[sp q(111111-11100111-111111-111111)],
 '[[:^latin:]]'		=>[sp q(111111-11100111-111111-111111)],
 '[^[:latin:]]'		=>[sp q(111111-11100111-111111-111111)],
 '[^A-Za-z]'		=>[sp q(111111-11100111-111111-111111)],
 '\p{InFullLatin}'	=>[sp q(000000-00000011-000000-000000)],
 '[[:fulllatin:]]'	=>[sp q(000000-00000011-000000-000000)],
 '[^[:^fulllatin:]]'	=>[sp q(000000-00000011-000000-000000)],
 '[`-y-]'		=>[sp q(000000-00000011-000000-000000)],
 '\P{InFullLatin}'	=>[sp q(111111-11111100-111111-111111)],
 '[[:^fulllatin:]]'	=>[sp q(111111-11111100-111111-111111)],
 '[^[:fulllatin:]]'	=>[sp q(111111-11111100-111111-111111)],
 '[^`-y-]'	=>[sp q(111111-11111100-111111-111111)],
 '\p{InGreek}'		=>[sp q(000000-00000000-100000-000000)],
 '[[:greek:]]'		=>[sp q(000000-00000000-100000-000000)],
 '[^[:^greek:]]'	=>[sp q(000000-00000000-100000-000000)],
 '[--]'		=>[sp q(000000-00000000-100000-000000)],
 '\P{InGreek}'		=>[sp q(111111-11111111-011111-111111)],
 '[[:^greek:]]'		=>[sp q(111111-11111111-011111-111111)],
 '[^[:greek:]]'		=>[sp q(111111-11111111-011111-111111)],
 '[^--]'	=>[sp q(111111-11111111-011111-111111)],
 '\p{InCyrillic}'	=>[sp q(000000-00000000-010000-000000)],
 '[[:cyrillic:]]'	=>[sp q(000000-00000000-010000-000000)],
 '[^[:^cyrillic:]]'	=>[sp q(000000-00000000-010000-000000)],
 '[@-`p-]'		=>[sp q(000000-00000000-010000-000000)],
 '\P{InCyrillic}'	=>[sp q(111111-11111111-101111-111111)],
 '[[:^cyrillic:]]'	=>[sp q(111111-11111111-101111-111111)],
 '[^[:cyrillic:]]'	=>[sp q(111111-11111111-101111-111111)],
 '[^@-`p-]'	=>[sp q(111111-11111111-101111-111111)],
 '\p{InHalfKana}'	=>[sp q(000000-00000000-000001-000000)],
 '[[:halfkana:]]'	=>[sp q(000000-00000000-000001-000000)],
 '[^[:^halfkana:]]'	=>[sp q(000000-00000000-000001-000000)],
 '[\xA6-\xDF]'		=>[sp q(000000-00000000-000001-000000)],
 '\P{InHalfKana}'	=>[sp q(111111-11111111-111110-111111)],
 '[[:^halfkana:]]'	=>[sp q(111111-11111111-111110-111111)],
 '[^[:halfkana:]]'	=>[sp q(111111-11111111-111110-111111)],
 '[^\xA6-\xDF]'		=>[sp q(111111-11111111-111110-111111)],
 '\p{InHiragana}'	=>[sp q(000000-00000000-001000-000000)],
 '[[:hiragana:]]'	=>[sp q(000000-00000000-001000-000000)],
 '[^[:^hiragana:]]'	=>[sp q(000000-00000000-001000-000000)],
 '[-JKTU]'	=>[sp q(000000-00000000-001000-000000)],
 '\P{InHiragana}'	=>[sp q(111111-11111111-110111-111111)],
 '[[:^hiragana:]]'	=>[sp q(111111-11111111-110111-111111)],
 '[^[:hiragana:]]'	=>[sp q(111111-11111111-110111-111111)],
 '[^-JKTU]'	=>[sp q(111111-11111111-110111-111111)],
 '\p{InKatakana}'	=>[sp q(000000-00000000-000100-000000)],
 '[[:katakana:]]'	=>[sp q(000000-00000000-000100-000000)],
 '[^[:^katakana:]]'	=>[sp q(000000-00000000-000100-000000)],
 '[@-[RS]'	=>[sp q(000000-00000000-000100-000000)],
 '\P{InKatakana}'	=>[sp q(111111-11111111-111011-111111)],
 '[[:^katakana:]]'	=>[sp q(111111-11111111-111011-111111)],
 '[^[:katakana:]]'	=>[sp q(111111-11111111-111011-111111)],
 '[^@-[RS]'	=>[sp q(111111-11111111-111011-111111)],
 '\p{InFullKana}'	=>[sp q(000000-00000000-001100-000000)],
 '[[:fullkana:]]'	=>[sp q(000000-00000000-001100-000000)],
 '[^[:^fullkana:]]'	=>[sp q(000000-00000000-001100-000000)],
 '\P{InFullKana}'	=>[sp q(111111-11111111-110011-111111)],
 '[[:^fullkana:]]'	=>[sp q(111111-11111111-110011-111111)],
 '[^[:fullkana:]]'	=>[sp q(111111-11111111-110011-111111)],
 '\p{InKana}'		=>[sp q(000000-00000000-001101-000000)],
 '[[:kana:]]'		=>[sp q(000000-00000000-001101-000000)],
 '[^[:^kana:]]'		=>[sp q(000000-00000000-001101-000000)],
 '\P{InKana}'		=>[sp q(111111-11111111-110010-111111)],
 '[[:^kana:]]'		=>[sp q(111111-11111111-110010-111111)],
 '[^[:kana:]]'		=>[sp q(111111-11111111-110010-111111)],
 '\p{InKanji1}'		=>[sp q(000000-00000000-000000-100000)],
 '[[:kanji1:]]'		=>[sp q(000000-00000000-000000-100000)],
 '[^[:^kanji1:]]'	=>[sp q(000000-00000000-000000-100000)],
 '[-r]'		=>[sp q(000000-00000000-000000-100000)],
 '\P{InKanji1}'		=>[sp q(111111-11111111-111111-011111)],
 '[[:^kanji1:]]'	=>[sp q(111111-11111111-111111-011111)],
 '[^[:kanji1:]]'	=>[sp q(111111-11111111-111111-011111)],
 '[^-r]'		=>[sp q(111111-11111111-111111-011111)],
 '\p{InKanji2}'		=>[sp q(000000-00000000-000000-010000)],
 '[[:kanji2:]]'		=>[sp q(000000-00000000-000000-010000)],
 '[^[:^kanji2:]]'	=>[sp q(000000-00000000-000000-010000)],
 '[-]'		=>[sp q(000000-00000000-000000-010000)],
 '\P{InKanji2}'		=>[sp q(111111-11111111-111111-101111)],
 '[[:^kanji2:]]'	=>[sp q(111111-11111111-111111-101111)],
 '[^[:kanji2:]]'	=>[sp q(111111-11111111-111111-101111)],
 '[^-]'		=>[sp q(111111-11111111-111111-101111)],
 '\p{InKanji}'		=>[sp q(000000-00000000-000000-111000)],
 '[[:kanji:]]'		=>[sp q(000000-00000000-000000-111000)],
 '[^[:^kanji:]]'	=>[sp q(000000-00000000-000000-111000)],
 '\P{InKanji}'		=>[sp q(111111-11111111-111111-000111)],
 '[[:^kanji:]]'		=>[sp q(111111-11111111-111111-000111)],
 '[^[:kanji:]]'		=>[sp q(111111-11111111-111111-000111)],
 '[V-Z]'		=>[sp q(000000-00000000-000000-001000)],
 '[^V-Z]'		=>[sp q(111111-11111111-111111-110111)],
 '\p{InBoxDrawing}'	=>[sp q(000000-00000000-000000-000010)],
 '[[:boxdrawing:]]'	=>[sp q(000000-00000000-000000-000010)],
 '[^[:^boxdrawing:]]'	=>[sp q(000000-00000000-000000-000010)],
 '\P{InBoxDrawing}'	=>[sp q(111111-11111111-111111-111101)],
 '[[:^boxdrawing:]]'	=>[sp q(111111-11111111-111111-111101)],
 '[^[:boxdrawing:]]'	=>[sp q(111111-11111111-111111-111101)],
);

#open RE, ">regexp.txt";
my($mod,$OK,$r,$cl);
for $r (sort keys %res){
  print "$r\n";
  my $re = "^$r\$";
  $mod = $re =~ s/\(\?i\)// ? 'io' : 'o';
# printf RE "%s\n    %s\n", $r, $re;  next;
  for $cl (0..$#cls){
    my $match = grep(match($_, $re, $mod), @{ $char{ $cls[ $cl ] } });
    my $a = $match == @{ $char{ $cls[ $cl ] } } ? 1 : $match == 0 ? 0 : -1;

    my $msg = $a == $res{ $r }[$cl] ? "ok" : "not ok";
    ++$n;
    print "$msg $n\n";
    push @NG, $n.$r." ".$cls[ $cl ]."\n" if $msg ne 'ok';
  }
}
print ! @NG
	? "All tests successful.\n"
	: "Failed ".scalar(@NG).", tests.\n", @NG;
__END__
