use utf8;

package SemanticWeb::Schema::MediaReviewItem;

# ABSTRACT: Represents an item or group of closely related items treated as a unit for the sake of evaluation in a [[MediaReview]]

use v5.14;
use Moo;

extends qw/ SemanticWeb::Schema::CreativeWork /;


use MooX::JSON_LD 'MediaReviewItem';
use Ref::Util qw/ is_plain_hashref /;
# RECOMMEND PREREQ: Ref::Util::XS

use namespace::autoclean;

our $VERSION = 'v21.0.0';


has media_item_appearance => (
    is        => 'rw',
    predicate => '_has_media_item_appearance',
    json_ld   => 'mediaItemAppearance',
);





1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SemanticWeb::Schema::MediaReviewItem - Represents an item or group of closely related items treated as a unit for the sake of evaluation in a [[MediaReview]]

=head1 VERSION

version v21.0.0

=head1 DESCRIPTION

Represents an item or group of closely related items treated as a unit for the sake of evaluation in a L<SemanticWeb::Schema::MediaReview>. Authorship etc. apply to the items rather than to the curation/grouping or reviewing party.

=head1 ATTRIBUTES

=head2 C<media_item_appearance>

C<mediaItemAppearance>

In the context of a L<SemanticWeb::Schema::MediaReview>, indicates specific media item(s) that are grouped using a L<SemanticWeb::Schema::MediaReviewItem>.

A media_item_appearance should be one of the following types:

=over

=item C<InstanceOf['SemanticWeb::Schema::MediaObject']>

=back

=head2 C<_has_media_item_appearance>

A predicate for the L</media_item_appearance> attribute.

=head1 SEE ALSO

L<SemanticWeb::Schema::CreativeWork>

=head1 SOURCE

The development version is on github at L<https://github.com/robrwo/SemanticWeb-Schema>
and may be cloned from L<git://github.com/robrwo/SemanticWeb-Schema.git>

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/robrwo/SemanticWeb-Schema/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

Robert Rothenberg <rrwo@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018-2022 by Robert Rothenberg.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
