use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile being created.
WriteMakefile(
	'NAME' => 'Net::Info',
	'DISTNAME' => 'Net-Info',
	'VERSION_FROM' => 'lib/Net/Info.pm',
	($] >= 5.005 
		?	
			(
				ABSTRACT	=> 'Parse Network configuration files',
				AUTHOR		=> 'WENWU YAN <careline@126.com>',
				META_MERGE     => {
					resources  => {
						repository => 'http://github.com/ggmo/Net::Info',
					},
				},
			) 
		: ()
	),
	'dist'   => {COMPRESS=>'gzip', SUFFIX=>'gz'},
	'PREREQ_PM' => {
		 'Scalar::Util' => 1.07,
	},
);

package MY;

sub postamble {
    <<"END_OF_POSTAMBLE";

pm_to_blib: README

README: lib/Net/Info.pod
\tpod2text lib/Net/Info.pod >README

END_OF_POSTAMBLE
}
