package Bencher::Scenario::TreeObject::Startup;

our $DATE = '2016-03-30'; # DATE
our $VERSION = '0.02'; # VERSION

use Bencher::ScenarioUtil::TreeObject;

my $classes = \%Bencher::ScenarioUtil::TreeObject::classes;

our $scenario = {
    summary => 'Benchmark startup of various tree classes',
    module_startup => 1,
    participants => [
        map {
            #my $spec = $classes->{$_};
            +{ module=>$_ };
        } keys %$classes,
    ],
};

1;
# ABSTRACT: Benchmark startup of various tree classes

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::TreeObject::Startup - Benchmark startup of various tree classes

=head1 VERSION

This document describes version 0.02 of Bencher::Scenario::TreeObject::Startup (from Perl distribution Bencher-Scenarios-TreeObject), released on 2016-03-30.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m TreeObject::Startup

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Tree::Object::Hash> 0.06

L<Tree::Object::Hash::ChildrenAsList> 0.06

L<Tree::Object::Array> 0.06

L<Tree::ObjectXS::Array> 0.02

L<Tree::Object::Array::Glob> 0.06

L<Tree::ObjectXS::Hash> 0.02

=head1 BENCHMARK PARTICIPANTS

=over

=item * Tree::Object::Hash (perl_code)

L<Tree::Object::Hash>



=item * Tree::Object::Hash::ChildrenAsList (perl_code)

L<Tree::Object::Hash::ChildrenAsList>



=item * Tree::Object::Array (perl_code)

L<Tree::Object::Array>



=item * Tree::ObjectXS::Array (perl_code)

L<Tree::ObjectXS::Array>



=item * Tree::Object::Array::Glob (perl_code)

L<Tree::Object::Array::Glob>



=item * Tree::ObjectXS::Hash (perl_code)

L<Tree::ObjectXS::Hash>



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m TreeObject::Startup >>):

 +------------------------------------+-----------+------------------------+------------+---------+---------+
 | participant                        | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +------------------------------------+-----------+------------------------+------------+---------+---------+
 | Tree::ObjectXS::Hash               | 4e+01     | 18                     | 1          | 0.00044 | 20      |
 | Tree::ObjectXS::Array              | 36        | 14                     | 1          | 0.00016 | 20      |
 | Tree::Object::Hash                 | 32        | 10                     | 1.2        | 0.00016 | 20      |
 | Tree::Object::Array::Glob          | 31        | 9                      | 1.2        | 3.2e-05 | 20      |
 | Tree::Object::Array                | 31        | 9                      | 1.2        | 6.9e-05 | 20      |
 | Tree::Object::Hash::ChildrenAsList | 31        | 9                      | 1.2        | 5.8e-05 | 20      |
 | perl -e1 (baseline)                | 22        | 0                      | 1.7        | 5.9e-05 | 20      |
 +------------------------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-TreeObject>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-TreeObject>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-TreeObject>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
