package Bencher::Scenario::PERLANCARTreeExamples;

our $DATE = '2016-04-12'; # DATE
our $VERSION = '0.02'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark PERLANCAR::Tree::Examples',
    modules => {
        'PERLANCAR::Tree::Examples' => {version=>1.0.4},
    },
    description => <<'_',

Created just for testing, while adding feature in `Bencher` to return result
size.

_
    participants => [
        {
            fcall_template => 'PERLANCAR::Tree::Examples::gen_sample_data(size => <size>, backend => <backend>)',
        },
    ],
    datasets => [
        {name => 'dataset', args=>{'size@'=>['tiny1', 'medium1'], 'backend@'=>['hash', 'array']}},
    ],
    include_result_size => 1,
};

1;
# ABSTRACT: Benchmark PERLANCAR::Tree::Examples

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::PERLANCARTreeExamples - Benchmark PERLANCAR::Tree::Examples

=head1 VERSION

This document describes version 0.02 of Bencher::Scenario::PERLANCARTreeExamples (from Perl distribution Bencher-Scenario-PERLANCARTreeExamples), released on 2016-04-12.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m PERLANCARTreeExamples

To run module startup overhead benchmark:

 % bencher --module-startup -m PERLANCARTreeExamples

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<PERLANCAR::Tree::Examples> 1.000.004

=head1 BENCHMARK PARTICIPANTS

=over

=item * PERLANCAR::Tree::Examples::gen_sample_data (perl_code)

Function call template:

 PERLANCAR::Tree::Examples::gen_sample_data(size => <size>, backend => <backend>)



=back

=head1 BENCHMARK DATASETS

=over

=item * dataset

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m PERLANCARTreeExamples >>):

 +-------------+----------+-----------+-----------+------------+------------------+---------+---------+
 | arg_backend | arg_size | rate (/s) | time (ms) | vs_slowest | result_size (MB) | errors  | samples |
 +-------------+----------+-----------+-----------+------------+------------------+---------+---------+
 | hash        | medium1  | 13        | 75        | 1          | 8.2              | 0.00013 | 21      |
 | array       | medium1  | 14        | 71        | 1.1        | 3.7              | 9.1e-05 | 20      |
 | hash        | tiny1    | 6.2e+04   | 0.016     | 4.6e+03    | 0.0013           | 6e-08   | 20      |
 | array       | tiny1    | 6.5e+04   | 0.015     | 4.9e+03    | 0.00052          | 2.7e-08 | 20      |
 +-------------+----------+-----------+-----------+------------+------------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m PERLANCARTreeExamples --module-startup >>):

 +---------------------------+-----------+------------------------+------------+---------+---------+
 | participant               | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +---------------------------+-----------+------------------------+------------+---------+---------+
 | PERLANCAR::Tree::Examples | 19        | 9.9                    | 1          | 9.3e-05 | 20      |
 | perl -e1 (baseline)       | 9.1       | 0                      | 2.1        | 7.7e-05 | 21      |
 +---------------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Created just for testing, while adding feature in C<Bencher> to return result
size.


Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-PERLANCARTreeExamples>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-PERLANCARTreeExamples>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-PERLANCARTreeExamples>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
