#!/usr/bin/perl
use strict;
use warnings;
use SMS::Send::Adapter::Node::Red;

my $service = SMS::Send::Adapter::Node::Red->new(content => join('', <>));
$service->cgi_response;

__END__

=head1 NAME

perl-SMS-Send-Adapter-Node-Red.cgi - SMS::Send Adapter to Node-RED JSON HTTP request CGI Script

=head1 DESCRIPTION

A CGI application to control SMS::Send with a web service.

=head1 API

The script is called over HTTP with a JSON Object payload.

  POST http://localhost/cgi-bin/perl-webserice-node-red-sms-send.cgi

  {
   "driver"  : "VoIP::MS",
   "to"      : "7035551212",
   "text"    : "Text Message",
   "options" : { "this" : "or", "that" : "and" }
  }

Return is a JSON Object.

  200 OK

  {
   "sent"  : true,
   "input" : {...},
  }

=head1 Node-Red Integration

Use four nodes: inject, function, http request, and debug.

=over

=item * In the function node

=over

=item * Set the "payload" to a JSON Object with the keys "driver", "to" and "text" and any extra "options" needed for the SMS::Send object.

  my_text     = msg.payload;
  msg.payload = {
                 "driver"  : "VoIP::MS",
                 "text"    : my_text,
                 "to"      : "7035936405",
                 "options" : {"key" : "value"},
                };
  return msg;

=back

=item * In the http request node

=over

=item * Set the "Method" to POST

=item * Set the "URL" to https://127.0.0.1/cgi-bin/perl-webserice-node-red-sms-send.cgi

=item * Set the "Return" to a parsed JSON Object

=back

=item * In the debug node

=over

=item * Set the "Output" to msg.payload.sent which returns boolean true or false

=back

=back

=head2 Node Red Example

  [{"id":"3313f548.d53dba","type":"inject","z":"bbbcee28.8891c","name":"Inject","topic":"","payload":"My SMS Text","payloadType":"str","repeat":"","crontab":"","once":false,"onceDelay":0.1,"x":90,"y":1540,"wires":[["5cb3e4eb.f6d34c"]]},{"id":"3a6aed54.d74342","type":"debug","z":"bbbcee28.8891c","name":"","active":true,"tosidebar":true,"console":false,"tostatus":false,"complete":"payload.sent","targetType":"msg","x":710,"y":1540,"wires":[]},{"id":"a9dfd541.a3b3f8","type":"http request","z":"bbbcee28.8891c","name":"SMS::Send","method":"POST","ret":"obj","paytoqs":false,"url":"https://127.0.0.1/cgi-bin/perl-SMS-Send-Adapter-Node-Red.cgi","tls":"","persist":false,"proxy":"","authType":"","x":490,"y":1540,"wires":[["3a6aed54.d74342","aec87ffa.ec17f"]]},{"id":"aec87ffa.ec17f","type":"debug","z":"bbbcee28.8891c","name":"","active":true,"tosidebar":true,"console":false,"tostatus":false,"complete":"statusCode","targetType":"msg","x":700,"y":1500,"wires":[]},{"id":"707cfb7e.11b714","type":"debug","z":"bbbcee28.8891c","name":"","active":true,"tosidebar":true,"console":false,"tostatus":false,"complete":"payload","targetType":"msg","x":490,"y":1500,"wires":[]},{"id":"5cb3e4eb.f6d34c","type":"function","z":"bbbcee28.8891c","name":"payload formatter","func":"my_text     = msg.payload;\nmsg.payload = {\n               \"driver\"  : \"VoIP::MS\",\n               \"text\"    : my_text,\n               \"to\"      : \"7035936405\",\n               \"options\" : {\"key\" : \"value\"},\n              };\nreturn msg;","outputs":1,"noerr":0,"x":270,"y":1540,"wires":[["707cfb7e.11b714","a9dfd541.a3b3f8"]]}]

=head2 BUILD

  rpmbuild -ta WebService-Node-Red-SMS-Send-*.tar.gz

=head1 INSTALLATION

I recommend installation with the provided RPM package perl-Power-Outlet-application-cgi which installs to /var/www/cgi-bin

  sudo yum install perl-Power-Outlet-application-cgi

=cut
