#!/usr/bin/perl
#
# Create MANIFEST file for packaging your module. Usage
#
#	./package_manifest.pl   /work/Dancer2-Plugin-WebService-3.007
#	./package_manifest.pl	# or from inside the module's directory
#
# George Bouras
# george.mpouras@yandex.com
# Athens Greece, 20 Apr 2017


(my $dir = exists $ARGV[0] ? -d $ARGV[0] ? $ARGV[0] : die "Sorry the directory \"$ARGV[0]\" does not exist\n" : '.') =~s/\/*$//;

open  FILE, '>', "$dir/MANIFEST" or die "Could not create file \"$dir/MANIFEST\" because $!\n";
print FILE "# This file was automatically generated by $0 @ARGV\n";

use File::Find;
File::Find::find({ wanted=>\&Catalog, no_chdir=>1, bydepth=>0, follow=>0}, $dir);

close FILE;

sub Catalog {
return unless -f $File::Find::name;
s/^$dir\/?//;
print STDOUT "$_\n";
print FILE "$_\n"
}