/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin;

import net.sourceforge.plantuml.skin.ArrowHead;
import net.sourceforge.plantuml.skin.ArrowPart;

public class ArrowDressing {
    private final ArrowHead head;
    private final ArrowPart part;

    public String name() {
        return this.toString();
    }

    public String toString() {
        return this.head.name();
    }

    private ArrowDressing(ArrowHead arrowHead, ArrowPart arrowPart) {
        if (arrowHead == null || arrowPart == null) {
            throw new IllegalArgumentException();
        }
        this.head = arrowHead;
        this.part = arrowPart;
    }

    public static ArrowDressing create() {
        return new ArrowDressing(ArrowHead.NONE, ArrowPart.FULL);
    }

    public ArrowDressing withHead(ArrowHead arrowHead) {
        return new ArrowDressing(arrowHead, this.part);
    }

    public ArrowDressing withPart(ArrowPart arrowPart) {
        return new ArrowDressing(this.head, arrowPart);
    }

    public ArrowHead getHead() {
        return this.head;
    }

    public ArrowPart getPart() {
        return this.part;
    }
}

