# use "*_t" for basename of this file.
# symlink to 21-blah-<perl version string to test>.t.
# e.g.,
#   "21-foo-v5.5.3.t"
#   "21-bar-5.005_003"
#   "21-bar-v5.005003"
# will test varieties of the same perl version string.

use 5.008;
use strict;
use version;
use lib qw( lib t/lib );

use Test::More;
use Test::Deep;

use File::Basename  qw( basename    );
use FindBin         qw( $Bin        );

use lib( "$Bin/../../lib", "$Bin/../lib" );
use Test::KwikHaks;

my $madness = 'Module::FromPerlVer';

*output     = Test::KwikHaks->can( 'output' );

Test::KwikHaks::blank_line();

SKIP:
{
    my ( $base, $perl_v )  
    = eval
    {
        Test::KwikHaks::perl_v_from_basename()
    }
    or BAIL_OUT "Missing Perl Version: $@";

    my $sandbox
    = eval
    {
        Test::KwikHaks::verify_git_env
    }
    or skip 'Git test environment unusable', 1;
 
    my $v_file  = Test::KwikHaks::write_version_file( $perl_v )
    or skip "Failed writing version file.", 1;

    eval
    {
        my @argz    = ( use_git => 1,  version_from => $v_file );

        use_ok $madness => @argz
    }
    or skip "Use failed; $@", 1;

    my $prefix  = $madness->source_prefix;

    is $prefix, 'perl/', "Source prefix: '$prefix' (perl/)";

    for my $found ( $madness->source_files )
    {
        note "Source files:\n", explain $found;

        fail "Extraneous souce files: $found";
    }

    eval
    {
        my $tag_v
        = Test::KwikHaks::verify_git_branch
        (
            $prefix,
            $perl_v
        );

        pass "Tag version: '$tag_v' ($prefix, $perl_v)."
    }
    or 
    fail "Unable to determine branch: $@";

    unlink $v_file;

    # reset the directory to avoid cruft messages from 
    # git status in initial checks.
  
    qx{ 'git checkout HEAD' 2>&1 };
}

done_testing;
__END__
