########################################################################
# use "*_t" for basename of this file.
# symlink to *-<perl version string to test>.t.
# e.g.,
#   "20-foo-v5.5.3.t"
#   "20-bar-5.005_003"
#   "20-bar-v5.005003"
# will test varieties of the same perl version string.
########################################################################
use 5.008;
use strict;
use version;

use Test::More;
use Test::Deep;

use Cwd             qw( getcwd      );
use File::Basename  qw( basename    );
use FindBin         qw( $Bin        );

use lib( "$Bin/../../lib", "$Bin/../lib" );
use Test::KwikHaks;

my $madness = 'Module::FromPerlVer';

*output     = Test::KwikHaks->can( 'output' );
*rm_rf      = Test::KwikHaks->can( 'rm_rf' );

Test::KwikHaks::blank_line();

SKIP:
{
    my ( $base, $perl_v )
    = eval
    {
        Test::KwikHaks::perl_v_from_basename()
    }
    or BAIL_OUT "Missing Perl Version: $@";

    my $sandbox
    = eval
    {
        Test::KwikHaks::verify_git_env
    }
    or skip 'Git test environment unusable', 1;

    local $ENV{ PERL_VERSION } = $perl_v;

    use_ok $madness => qw( use_git 1 git_tarball .git.tar )
    or BAIL_OUT "$madness is not usable.";

    my $prefix  = $madness->source_prefix;

    is $prefix, 'perl/', "Source prefix: '$prefix' (perl/)";

    for my $found ( $madness->source_files )
    {
        output( "Source files", explain $found );

        # git objects don't return source files 

        fail "Extraneous souce files: $found";
    }

    eval
    {
        my $tag_v
        = Test::KwikHaks::verify_git_branch
        (
            $prefix,
            $perl_v
        );

        pass "Tag version: '$tag_v' ($prefix, $perl_v)."
    }
    or 
    fail "Unable to determine branch: $@";

    # reset the directory to avoid cruft messages from 
    # git status in initial checks.
  
    qx{ 'git checkout HEAD' 2>&1 };
}

done_testing;
__END__
