#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
static int32_t FIELD_ID_TestCase__Matrix4_16b__x11 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16b__x11 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16b__x21 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16b__x21 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16b__x31 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16b__x31 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16b__x41 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16b__x41 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16b__x12 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16b__x12 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16b__x22 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16b__x22 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16b__x32 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16b__x32 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16b__x42 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16b__x42 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16b__x13 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16b__x13 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16b__x23 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16b__x23 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16b__x33 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16b__x33 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16b__x43 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16b__x43 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16b__x14 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16b__x14 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16b__x24 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16b__x24 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16b__x34 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16b__x34 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16b__x44 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16b__x44 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16d__x11 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16d__x11 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16d__x21 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16d__x21 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16d__x31 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16d__x31 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16d__x41 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16d__x41 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16d__x12 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16d__x12 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16d__x22 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16d__x22 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16d__x32 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16d__x32 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16d__x42 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16d__x42 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16d__x13 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16d__x13 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16d__x23 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16d__x23 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16d__x33 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16d__x33 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16d__x43 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16d__x43 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16d__x14 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16d__x14 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16d__x24 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16d__x24 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16d__x34 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16d__x34 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16d__x44 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16d__x44 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16f__x11 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16f__x11 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16f__x21 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16f__x21 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16f__x31 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16f__x31 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16f__x41 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16f__x41 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16f__x12 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16f__x12 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16f__x22 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16f__x22 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16f__x32 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16f__x32 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16f__x42 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16f__x42 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16f__x13 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16f__x13 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16f__x23 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16f__x23 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16f__x33 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16f__x33 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16f__x43 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16f__x43 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16f__x14 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16f__x14 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16f__x24 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16f__x24 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16f__x34 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16f__x34 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16f__x44 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16f__x44 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16i__x11 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16i__x11 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16i__x21 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16i__x21 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16i__x31 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16i__x31 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16i__x41 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16i__x41 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16i__x12 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16i__x12 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16i__x22 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16i__x22 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16i__x32 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16i__x32 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16i__x42 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16i__x42 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16i__x13 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16i__x13 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16i__x23 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16i__x23 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16i__x33 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16i__x33 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16i__x43 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16i__x43 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16i__x14 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16i__x14 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16i__x24 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16i__x24 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16i__x34 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16i__x34 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16i__x44 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16i__x44 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16l__x11 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16l__x11 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16l__x21 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16l__x21 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16l__x31 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16l__x31 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16l__x41 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16l__x41 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16l__x12 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16l__x12 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16l__x22 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16l__x22 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16l__x32 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16l__x32 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16l__x42 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16l__x42 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16l__x13 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16l__x13 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16l__x23 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16l__x23 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16l__x33 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16l__x33 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16l__x43 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16l__x43 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16l__x14 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16l__x14 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16l__x24 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16l__x24 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16l__x34 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16l__x34 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16l__x44 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16l__x44 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16s__x11 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16s__x11 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16s__x21 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16s__x21 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16s__x31 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16s__x31 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16s__x41 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16s__x41 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16s__x12 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16s__x12 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16s__x22 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16s__x22 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16s__x32 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16s__x32 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16s__x42 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16s__x42 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16s__x13 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16s__x13 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16s__x23 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16s__x23 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16s__x33 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16s__x33 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16s__x43 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16s__x43 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16s__x14 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16s__x14 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16s__x24 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16s__x24 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16s__x34 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16s__x34 = -1;
static int32_t FIELD_ID_TestCase__Matrix4_16s__x44 = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Matrix4_16s__x44 = -1;
// Sub id declarations
static int32_t SUB_ID_SPVM__Util__INT8_MIN = - 1;
static int32_t SUB_ID_SPVM__Util__DBL_MIN = - 1;
static int32_t SUB_ID_SPVM__Util__FLT_MIN = - 1;
static int32_t SUB_ID_SPVM__Util__INT32_MIN = - 1;
static int32_t SUB_ID_SPVM__Util__INT64_MIN = - 1;
static int32_t SUB_ID_SPVM__Util__INT16_MIN = - 1;
// Basic type id declarations
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Value__value_max_fields_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Value__value_max_fields_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Value__value_max_fields_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Value__value_max_fields_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Value__value_max_fields_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Value__value_max_fields_short(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Value__value_max_fields_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[51];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_BYTE
  byte_vars[0] = 0;
  byte_vars[1] = 0;
  byte_vars[2] = 0;
  byte_vars[3] = 0;
  byte_vars[4] = 0;
  byte_vars[5] = 0;
  byte_vars[6] = 0;
  byte_vars[7] = 0;
  byte_vars[8] = 0;
  byte_vars[9] = 0;
  byte_vars[10] = 0;
  byte_vars[11] = 0;
  byte_vars[12] = 0;
  byte_vars[13] = 0;
  byte_vars[14] = 0;
  byte_vars[15] = 0;
L2: // INIT_MULNUM_BYTE
  byte_vars[16] = 0;
  byte_vars[17] = 0;
  byte_vars[18] = 0;
  byte_vars[19] = 0;
  byte_vars[20] = 0;
  byte_vars[21] = 0;
  byte_vars[22] = 0;
  byte_vars[23] = 0;
  byte_vars[24] = 0;
  byte_vars[25] = 0;
  byte_vars[26] = 0;
  byte_vars[27] = 0;
  byte_vars[28] = 0;
  byte_vars[29] = 0;
  byte_vars[30] = 0;
  byte_vars[31] = 0;
L3: // INIT_MULNUM_BYTE
  byte_vars[32] = 0;
  byte_vars[33] = 0;
  byte_vars[34] = 0;
  byte_vars[35] = 0;
  byte_vars[36] = 0;
  byte_vars[37] = 0;
  byte_vars[38] = 0;
  byte_vars[39] = 0;
  byte_vars[40] = 0;
  byte_vars[41] = 0;
  byte_vars[42] = 0;
  byte_vars[43] = 0;
  byte_vars[44] = 0;
  byte_vars[45] = 0;
  byte_vars[46] = 0;
  byte_vars[47] = 0;
L4: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[48] = *(int8_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Value";
    const char* sub_name = "value_max_fields_byte";
    const char* file = "TestCase/Value.spvm";
    int32_t line = 15;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L364;
  }
L6: // MULNUM_SET_FIELD_BYTE
  byte_vars[0] = byte_vars[48];
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 21;
L8: // CONVERT_INT_TO_BYTE
  byte_vars[48] = (int8_t)int_vars[2];
L9: // MULNUM_SET_FIELD_BYTE
  byte_vars[1] = byte_vars[48];
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 31;
L11: // CONVERT_INT_TO_BYTE
  byte_vars[48] = (int8_t)int_vars[2];
L12: // MULNUM_SET_FIELD_BYTE
  byte_vars[2] = byte_vars[48];
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 41;
L14: // CONVERT_INT_TO_BYTE
  byte_vars[48] = (int8_t)int_vars[2];
L15: // MULNUM_SET_FIELD_BYTE
  byte_vars[3] = byte_vars[48];
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 12;
L17: // CONVERT_INT_TO_BYTE
  byte_vars[48] = (int8_t)int_vars[2];
L18: // MULNUM_SET_FIELD_BYTE
  byte_vars[4] = byte_vars[48];
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 22;
L20: // CONVERT_INT_TO_BYTE
  byte_vars[48] = (int8_t)int_vars[2];
L21: // MULNUM_SET_FIELD_BYTE
  byte_vars[5] = byte_vars[48];
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 32;
L23: // CONVERT_INT_TO_BYTE
  byte_vars[48] = (int8_t)int_vars[2];
L24: // MULNUM_SET_FIELD_BYTE
  byte_vars[6] = byte_vars[48];
L25: // MOVE_CONSTANT_INT
  int_vars[2] = 42;
L26: // CONVERT_INT_TO_BYTE
  byte_vars[48] = (int8_t)int_vars[2];
L27: // MULNUM_SET_FIELD_BYTE
  byte_vars[7] = byte_vars[48];
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 13;
L29: // CONVERT_INT_TO_BYTE
  byte_vars[48] = (int8_t)int_vars[2];
L30: // MULNUM_SET_FIELD_BYTE
  byte_vars[8] = byte_vars[48];
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 23;
L32: // CONVERT_INT_TO_BYTE
  byte_vars[48] = (int8_t)int_vars[2];
L33: // MULNUM_SET_FIELD_BYTE
  byte_vars[9] = byte_vars[48];
L34: // MOVE_CONSTANT_INT
  int_vars[2] = 33;
L35: // CONVERT_INT_TO_BYTE
  byte_vars[48] = (int8_t)int_vars[2];
L36: // MULNUM_SET_FIELD_BYTE
  byte_vars[10] = byte_vars[48];
L37: // MOVE_CONSTANT_INT
  int_vars[2] = 43;
L38: // CONVERT_INT_TO_BYTE
  byte_vars[48] = (int8_t)int_vars[2];
L39: // MULNUM_SET_FIELD_BYTE
  byte_vars[11] = byte_vars[48];
L40: // MOVE_CONSTANT_INT
  int_vars[2] = 14;
L41: // CONVERT_INT_TO_BYTE
  byte_vars[48] = (int8_t)int_vars[2];
L42: // MULNUM_SET_FIELD_BYTE
  byte_vars[12] = byte_vars[48];
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 24;
L44: // CONVERT_INT_TO_BYTE
  byte_vars[48] = (int8_t)int_vars[2];
L45: // MULNUM_SET_FIELD_BYTE
  byte_vars[13] = byte_vars[48];
L46: // MOVE_CONSTANT_INT
  int_vars[2] = 34;
L47: // CONVERT_INT_TO_BYTE
  byte_vars[48] = (int8_t)int_vars[2];
L48: // MULNUM_SET_FIELD_BYTE
  byte_vars[14] = byte_vars[48];
L49: // MOVE_CONSTANT_INT
  int_vars[2] = 44;
L50: // CONVERT_INT_TO_BYTE
  byte_vars[48] = (int8_t)int_vars[2];
L51: // MULNUM_SET_FIELD_BYTE
  byte_vars[15] = byte_vars[48];
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 21;
L53: // CONVERT_INT_TO_BYTE
  byte_vars[48] = (int8_t)int_vars[2];
L54: // MULNUM_SET_FIELD_BYTE
  byte_vars[16] = byte_vars[48];
L55: // MOVE_CONSTANT_INT
  int_vars[2] = 31;
L56: // CONVERT_INT_TO_BYTE
  byte_vars[48] = (int8_t)int_vars[2];
L57: // MULNUM_SET_FIELD_BYTE
  byte_vars[17] = byte_vars[48];
L58: // MOVE_CONSTANT_INT
  int_vars[2] = 41;
L59: // CONVERT_INT_TO_BYTE
  byte_vars[48] = (int8_t)int_vars[2];
L60: // MULNUM_SET_FIELD_BYTE
  byte_vars[18] = byte_vars[48];
L61: // MOVE_CONSTANT_INT
  int_vars[2] = 51;
L62: // CONVERT_INT_TO_BYTE
  byte_vars[48] = (int8_t)int_vars[2];
L63: // MULNUM_SET_FIELD_BYTE
  byte_vars[19] = byte_vars[48];
L64: // MOVE_CONSTANT_INT
  int_vars[2] = 22;
L65: // CONVERT_INT_TO_BYTE
  byte_vars[48] = (int8_t)int_vars[2];
L66: // MULNUM_SET_FIELD_BYTE
  byte_vars[20] = byte_vars[48];
L67: // MOVE_CONSTANT_INT
  int_vars[2] = 32;
L68: // CONVERT_INT_TO_BYTE
  byte_vars[48] = (int8_t)int_vars[2];
L69: // MULNUM_SET_FIELD_BYTE
  byte_vars[21] = byte_vars[48];
L70: // MOVE_CONSTANT_INT
  int_vars[2] = 42;
L71: // CONVERT_INT_TO_BYTE
  byte_vars[48] = (int8_t)int_vars[2];
L72: // MULNUM_SET_FIELD_BYTE
  byte_vars[22] = byte_vars[48];
L73: // MOVE_CONSTANT_INT
  int_vars[2] = 52;
L74: // CONVERT_INT_TO_BYTE
  byte_vars[48] = (int8_t)int_vars[2];
L75: // MULNUM_SET_FIELD_BYTE
  byte_vars[23] = byte_vars[48];
L76: // MOVE_CONSTANT_INT
  int_vars[2] = 23;
L77: // CONVERT_INT_TO_BYTE
  byte_vars[48] = (int8_t)int_vars[2];
L78: // MULNUM_SET_FIELD_BYTE
  byte_vars[24] = byte_vars[48];
L79: // MOVE_CONSTANT_INT
  int_vars[2] = 33;
L80: // CONVERT_INT_TO_BYTE
  byte_vars[48] = (int8_t)int_vars[2];
L81: // MULNUM_SET_FIELD_BYTE
  byte_vars[25] = byte_vars[48];
L82: // MOVE_CONSTANT_INT
  int_vars[2] = 43;
L83: // CONVERT_INT_TO_BYTE
  byte_vars[48] = (int8_t)int_vars[2];
L84: // MULNUM_SET_FIELD_BYTE
  byte_vars[26] = byte_vars[48];
L85: // MOVE_CONSTANT_INT
  int_vars[2] = 53;
L86: // CONVERT_INT_TO_BYTE
  byte_vars[48] = (int8_t)int_vars[2];
L87: // MULNUM_SET_FIELD_BYTE
  byte_vars[27] = byte_vars[48];
L88: // MOVE_CONSTANT_INT
  int_vars[2] = 24;
L89: // CONVERT_INT_TO_BYTE
  byte_vars[48] = (int8_t)int_vars[2];
L90: // MULNUM_SET_FIELD_BYTE
  byte_vars[28] = byte_vars[48];
L91: // MOVE_CONSTANT_INT
  int_vars[2] = 34;
L92: // CONVERT_INT_TO_BYTE
  byte_vars[48] = (int8_t)int_vars[2];
L93: // MULNUM_SET_FIELD_BYTE
  byte_vars[29] = byte_vars[48];
L94: // MOVE_CONSTANT_INT
  int_vars[2] = 44;
L95: // CONVERT_INT_TO_BYTE
  byte_vars[48] = (int8_t)int_vars[2];
L96: // MULNUM_SET_FIELD_BYTE
  byte_vars[30] = byte_vars[48];
L97: // MOVE_CONSTANT_INT
  int_vars[2] = 54;
L98: // CONVERT_INT_TO_BYTE
  byte_vars[48] = (int8_t)int_vars[2];
L99: // MULNUM_SET_FIELD_BYTE
  byte_vars[31] = byte_vars[48];
L100: // MULNUM_GET_FIELD_BYTE
  byte_vars[48] = byte_vars[0];
L101: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[48];
L102: // MULNUM_GET_FIELD_BYTE
  byte_vars[49] = byte_vars[16];
L103: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[49];
L104: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L105: // CONVERT_INT_TO_BYTE
  byte_vars[50] = (int8_t)int_vars[4];
L106: // MULNUM_SET_FIELD_BYTE
  byte_vars[32] = byte_vars[50];
L107: // MULNUM_GET_FIELD_BYTE
  byte_vars[48] = byte_vars[1];
L108: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[48];
L109: // MULNUM_GET_FIELD_BYTE
  byte_vars[49] = byte_vars[17];
L110: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[49];
L111: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L112: // CONVERT_INT_TO_BYTE
  byte_vars[50] = (int8_t)int_vars[4];
L113: // MULNUM_SET_FIELD_BYTE
  byte_vars[33] = byte_vars[50];
L114: // MULNUM_GET_FIELD_BYTE
  byte_vars[48] = byte_vars[2];
L115: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[48];
L116: // MULNUM_GET_FIELD_BYTE
  byte_vars[49] = byte_vars[18];
L117: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[49];
L118: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L119: // CONVERT_INT_TO_BYTE
  byte_vars[50] = (int8_t)int_vars[4];
L120: // MULNUM_SET_FIELD_BYTE
  byte_vars[34] = byte_vars[50];
L121: // MULNUM_GET_FIELD_BYTE
  byte_vars[48] = byte_vars[3];
L122: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[48];
L123: // MULNUM_GET_FIELD_BYTE
  byte_vars[49] = byte_vars[19];
L124: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[49];
L125: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L126: // CONVERT_INT_TO_BYTE
  byte_vars[50] = (int8_t)int_vars[4];
L127: // MULNUM_SET_FIELD_BYTE
  byte_vars[35] = byte_vars[50];
L128: // MULNUM_GET_FIELD_BYTE
  byte_vars[48] = byte_vars[4];
L129: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[48];
L130: // MULNUM_GET_FIELD_BYTE
  byte_vars[49] = byte_vars[20];
L131: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[49];
L132: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L133: // CONVERT_INT_TO_BYTE
  byte_vars[50] = (int8_t)int_vars[4];
L134: // MULNUM_SET_FIELD_BYTE
  byte_vars[36] = byte_vars[50];
L135: // MULNUM_GET_FIELD_BYTE
  byte_vars[48] = byte_vars[5];
L136: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[48];
L137: // MULNUM_GET_FIELD_BYTE
  byte_vars[49] = byte_vars[21];
L138: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[49];
L139: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L140: // CONVERT_INT_TO_BYTE
  byte_vars[50] = (int8_t)int_vars[4];
L141: // MULNUM_SET_FIELD_BYTE
  byte_vars[37] = byte_vars[50];
L142: // MULNUM_GET_FIELD_BYTE
  byte_vars[48] = byte_vars[6];
L143: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[48];
L144: // MULNUM_GET_FIELD_BYTE
  byte_vars[49] = byte_vars[22];
L145: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[49];
L146: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L147: // CONVERT_INT_TO_BYTE
  byte_vars[50] = (int8_t)int_vars[4];
L148: // MULNUM_SET_FIELD_BYTE
  byte_vars[38] = byte_vars[50];
L149: // MULNUM_GET_FIELD_BYTE
  byte_vars[48] = byte_vars[7];
L150: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[48];
L151: // MULNUM_GET_FIELD_BYTE
  byte_vars[49] = byte_vars[23];
L152: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[49];
L153: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L154: // CONVERT_INT_TO_BYTE
  byte_vars[50] = (int8_t)int_vars[4];
L155: // MULNUM_SET_FIELD_BYTE
  byte_vars[39] = byte_vars[50];
L156: // MULNUM_GET_FIELD_BYTE
  byte_vars[48] = byte_vars[8];
L157: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[48];
L158: // MULNUM_GET_FIELD_BYTE
  byte_vars[49] = byte_vars[24];
L159: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[49];
L160: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L161: // CONVERT_INT_TO_BYTE
  byte_vars[50] = (int8_t)int_vars[4];
L162: // MULNUM_SET_FIELD_BYTE
  byte_vars[40] = byte_vars[50];
L163: // MULNUM_GET_FIELD_BYTE
  byte_vars[48] = byte_vars[9];
L164: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[48];
L165: // MULNUM_GET_FIELD_BYTE
  byte_vars[49] = byte_vars[25];
L166: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[49];
L167: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L168: // CONVERT_INT_TO_BYTE
  byte_vars[50] = (int8_t)int_vars[4];
L169: // MULNUM_SET_FIELD_BYTE
  byte_vars[41] = byte_vars[50];
L170: // MULNUM_GET_FIELD_BYTE
  byte_vars[48] = byte_vars[10];
L171: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[48];
L172: // MULNUM_GET_FIELD_BYTE
  byte_vars[49] = byte_vars[26];
L173: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[49];
L174: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L175: // CONVERT_INT_TO_BYTE
  byte_vars[50] = (int8_t)int_vars[4];
L176: // MULNUM_SET_FIELD_BYTE
  byte_vars[42] = byte_vars[50];
L177: // MULNUM_GET_FIELD_BYTE
  byte_vars[48] = byte_vars[11];
L178: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[48];
L179: // MULNUM_GET_FIELD_BYTE
  byte_vars[49] = byte_vars[27];
L180: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[49];
L181: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L182: // CONVERT_INT_TO_BYTE
  byte_vars[50] = (int8_t)int_vars[4];
L183: // MULNUM_SET_FIELD_BYTE
  byte_vars[43] = byte_vars[50];
L184: // MULNUM_GET_FIELD_BYTE
  byte_vars[48] = byte_vars[12];
L185: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[48];
L186: // MULNUM_GET_FIELD_BYTE
  byte_vars[49] = byte_vars[28];
L187: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[49];
L188: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L189: // CONVERT_INT_TO_BYTE
  byte_vars[50] = (int8_t)int_vars[4];
L190: // MULNUM_SET_FIELD_BYTE
  byte_vars[44] = byte_vars[50];
L191: // MULNUM_GET_FIELD_BYTE
  byte_vars[48] = byte_vars[13];
L192: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[48];
L193: // MULNUM_GET_FIELD_BYTE
  byte_vars[49] = byte_vars[29];
L194: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[49];
L195: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L196: // CONVERT_INT_TO_BYTE
  byte_vars[50] = (int8_t)int_vars[4];
L197: // MULNUM_SET_FIELD_BYTE
  byte_vars[45] = byte_vars[50];
L198: // MULNUM_GET_FIELD_BYTE
  byte_vars[48] = byte_vars[14];
L199: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[48];
L200: // MULNUM_GET_FIELD_BYTE
  byte_vars[49] = byte_vars[30];
L201: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[49];
L202: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L203: // CONVERT_INT_TO_BYTE
  byte_vars[50] = (int8_t)int_vars[4];
L204: // MULNUM_SET_FIELD_BYTE
  byte_vars[46] = byte_vars[50];
L205: // MULNUM_GET_FIELD_BYTE
  byte_vars[48] = byte_vars[15];
L206: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[48];
L207: // MULNUM_GET_FIELD_BYTE
  byte_vars[49] = byte_vars[31];
L208: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[49];
L209: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L210: // CONVERT_INT_TO_BYTE
  byte_vars[50] = (int8_t)int_vars[4];
L211: // MULNUM_SET_FIELD_BYTE
  byte_vars[47] = byte_vars[50];
L212: // MULNUM_GET_FIELD_BYTE
  byte_vars[48] = byte_vars[32];
L213: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[48];
L214: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[49] = *(int8_t*)&stack[0];
    }
  }
L215: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Value";
    const char* sub_name = "value_max_fields_byte";
    const char* file = "TestCase/Value.spvm";
    int32_t line = 75;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L364;
  }
L216: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[49];
L217: // MOVE_CONSTANT_INT
  int_vars[4] = 21;
L218: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L219: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[5]);
L220: // BOOL_INT
  int_vars[0] = int_vars[0];
L221: // IF_NE_ZERO
  if (int_vars[0]) { goto L225; }
L222: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L223: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L364;
L224: // GOTO
  goto L225;
L225: // MULNUM_GET_FIELD_BYTE
  byte_vars[48] = byte_vars[33];
L226: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[48];
L227: // MOVE_CONSTANT_INT
  int_vars[5] = 52;
L228: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L229: // BOOL_INT
  int_vars[0] = int_vars[0];
L230: // IF_NE_ZERO
  if (int_vars[0]) { goto L234; }
L231: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L232: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L364;
L233: // GOTO
  goto L234;
L234: // MULNUM_GET_FIELD_BYTE
  byte_vars[48] = byte_vars[34];
L235: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[48];
L236: // MOVE_CONSTANT_INT
  int_vars[5] = 72;
L237: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L238: // BOOL_INT
  int_vars[0] = int_vars[0];
L239: // IF_NE_ZERO
  if (int_vars[0]) { goto L243; }
L240: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L241: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L364;
L242: // GOTO
  goto L243;
L243: // MULNUM_GET_FIELD_BYTE
  byte_vars[48] = byte_vars[35];
L244: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[48];
L245: // MOVE_CONSTANT_INT
  int_vars[5] = 92;
L246: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L247: // BOOL_INT
  int_vars[0] = int_vars[0];
L248: // IF_NE_ZERO
  if (int_vars[0]) { goto L252; }
L249: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L250: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L364;
L251: // GOTO
  goto L252;
L252: // MULNUM_GET_FIELD_BYTE
  byte_vars[48] = byte_vars[36];
L253: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[48];
L254: // MOVE_CONSTANT_INT
  int_vars[5] = 34;
L255: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L256: // BOOL_INT
  int_vars[0] = int_vars[0];
L257: // IF_NE_ZERO
  if (int_vars[0]) { goto L261; }
L258: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L259: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L364;
L260: // GOTO
  goto L261;
L261: // MULNUM_GET_FIELD_BYTE
  byte_vars[48] = byte_vars[37];
L262: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[48];
L263: // MOVE_CONSTANT_INT
  int_vars[5] = 54;
L264: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L265: // BOOL_INT
  int_vars[0] = int_vars[0];
L266: // IF_NE_ZERO
  if (int_vars[0]) { goto L270; }
L267: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L268: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L364;
L269: // GOTO
  goto L270;
L270: // MULNUM_GET_FIELD_BYTE
  byte_vars[48] = byte_vars[38];
L271: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[48];
L272: // MOVE_CONSTANT_INT
  int_vars[5] = 74;
L273: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L274: // BOOL_INT
  int_vars[0] = int_vars[0];
L275: // IF_NE_ZERO
  if (int_vars[0]) { goto L279; }
L276: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L277: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L364;
L278: // GOTO
  goto L279;
L279: // MULNUM_GET_FIELD_BYTE
  byte_vars[48] = byte_vars[39];
L280: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[48];
L281: // MOVE_CONSTANT_INT
  int_vars[5] = 94;
L282: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L283: // BOOL_INT
  int_vars[0] = int_vars[0];
L284: // IF_NE_ZERO
  if (int_vars[0]) { goto L288; }
L285: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L286: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L364;
L287: // GOTO
  goto L288;
L288: // MULNUM_GET_FIELD_BYTE
  byte_vars[48] = byte_vars[40];
L289: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[48];
L290: // MOVE_CONSTANT_INT
  int_vars[5] = 36;
L291: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L292: // BOOL_INT
  int_vars[0] = int_vars[0];
L293: // IF_NE_ZERO
  if (int_vars[0]) { goto L297; }
L294: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L295: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L364;
L296: // GOTO
  goto L297;
L297: // MULNUM_GET_FIELD_BYTE
  byte_vars[48] = byte_vars[41];
L298: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[48];
L299: // MOVE_CONSTANT_INT
  int_vars[5] = 56;
L300: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L301: // BOOL_INT
  int_vars[0] = int_vars[0];
L302: // IF_NE_ZERO
  if (int_vars[0]) { goto L306; }
L303: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L304: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L364;
L305: // GOTO
  goto L306;
L306: // MULNUM_GET_FIELD_BYTE
  byte_vars[48] = byte_vars[42];
L307: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[48];
L308: // MOVE_CONSTANT_INT
  int_vars[5] = 76;
L309: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L310: // BOOL_INT
  int_vars[0] = int_vars[0];
L311: // IF_NE_ZERO
  if (int_vars[0]) { goto L315; }
L312: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L313: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L364;
L314: // GOTO
  goto L315;
L315: // MULNUM_GET_FIELD_BYTE
  byte_vars[48] = byte_vars[43];
L316: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[48];
L317: // MOVE_CONSTANT_INT
  int_vars[5] = 96;
L318: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L319: // BOOL_INT
  int_vars[0] = int_vars[0];
L320: // IF_NE_ZERO
  if (int_vars[0]) { goto L324; }
L321: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L322: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L364;
L323: // GOTO
  goto L324;
L324: // MULNUM_GET_FIELD_BYTE
  byte_vars[48] = byte_vars[35];
L325: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[48];
L326: // MOVE_CONSTANT_INT
  int_vars[5] = 92;
L327: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L328: // BOOL_INT
  int_vars[0] = int_vars[0];
L329: // IF_NE_ZERO
  if (int_vars[0]) { goto L333; }
L330: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L331: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L364;
L332: // GOTO
  goto L333;
L333: // MULNUM_GET_FIELD_BYTE
  byte_vars[48] = byte_vars[39];
L334: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[48];
L335: // MOVE_CONSTANT_INT
  int_vars[5] = 94;
L336: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L337: // BOOL_INT
  int_vars[0] = int_vars[0];
L338: // IF_NE_ZERO
  if (int_vars[0]) { goto L342; }
L339: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L340: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L364;
L341: // GOTO
  goto L342;
L342: // MULNUM_GET_FIELD_BYTE
  byte_vars[48] = byte_vars[43];
L343: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[48];
L344: // MOVE_CONSTANT_INT
  int_vars[5] = 96;
L345: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L346: // BOOL_INT
  int_vars[0] = int_vars[0];
L347: // IF_NE_ZERO
  if (int_vars[0]) { goto L351; }
L348: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L349: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L364;
L350: // GOTO
  goto L351;
L351: // MULNUM_GET_FIELD_BYTE
  byte_vars[48] = byte_vars[47];
L352: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[48];
L353: // MOVE_CONSTANT_INT
  int_vars[5] = 98;
L354: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L355: // BOOL_INT
  int_vars[0] = int_vars[0];
L356: // IF_NE_ZERO
  if (int_vars[0]) { goto L360; }
L357: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L358: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L364;
L359: // GOTO
  goto L360;
L360: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L361: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L364;
L362: // INIT_INT
  int_vars[6] = 0;
L363: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L364;
L364: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Value__value_max_fields_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[52];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_DOUBLE
  double_vars[0] = 0;
  double_vars[1] = 0;
  double_vars[2] = 0;
  double_vars[3] = 0;
  double_vars[4] = 0;
  double_vars[5] = 0;
  double_vars[6] = 0;
  double_vars[7] = 0;
  double_vars[8] = 0;
  double_vars[9] = 0;
  double_vars[10] = 0;
  double_vars[11] = 0;
  double_vars[12] = 0;
  double_vars[13] = 0;
  double_vars[14] = 0;
  double_vars[15] = 0;
L2: // INIT_MULNUM_DOUBLE
  double_vars[16] = 0;
  double_vars[17] = 0;
  double_vars[18] = 0;
  double_vars[19] = 0;
  double_vars[20] = 0;
  double_vars[21] = 0;
  double_vars[22] = 0;
  double_vars[23] = 0;
  double_vars[24] = 0;
  double_vars[25] = 0;
  double_vars[26] = 0;
  double_vars[27] = 0;
  double_vars[28] = 0;
  double_vars[29] = 0;
  double_vars[30] = 0;
  double_vars[31] = 0;
L3: // INIT_MULNUM_DOUBLE
  double_vars[32] = 0;
  double_vars[33] = 0;
  double_vars[34] = 0;
  double_vars[35] = 0;
  double_vars[36] = 0;
  double_vars[37] = 0;
  double_vars[38] = 0;
  double_vars[39] = 0;
  double_vars[40] = 0;
  double_vars[41] = 0;
  double_vars[42] = 0;
  double_vars[43] = 0;
  double_vars[44] = 0;
  double_vars[45] = 0;
  double_vars[46] = 0;
  double_vars[47] = 0;
L4: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[48] = *(double*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Value";
    const char* sub_name = "value_max_fields_double";
    const char* file = "TestCase/Value.spvm";
    int32_t line = 600;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L315;
  }
L6: // MULNUM_SET_FIELD_DOUBLE
  double_vars[0] = double_vars[48];
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 21;
L8: // CONVERT_INT_TO_DOUBLE
  double_vars[48] = (double)int_vars[2];
L9: // MULNUM_SET_FIELD_DOUBLE
  double_vars[1] = double_vars[48];
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 31;
L11: // CONVERT_INT_TO_DOUBLE
  double_vars[48] = (double)int_vars[2];
L12: // MULNUM_SET_FIELD_DOUBLE
  double_vars[2] = double_vars[48];
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 41;
L14: // CONVERT_INT_TO_DOUBLE
  double_vars[48] = (double)int_vars[2];
L15: // MULNUM_SET_FIELD_DOUBLE
  double_vars[3] = double_vars[48];
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 12;
L17: // CONVERT_INT_TO_DOUBLE
  double_vars[48] = (double)int_vars[2];
L18: // MULNUM_SET_FIELD_DOUBLE
  double_vars[4] = double_vars[48];
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 22;
L20: // CONVERT_INT_TO_DOUBLE
  double_vars[48] = (double)int_vars[2];
L21: // MULNUM_SET_FIELD_DOUBLE
  double_vars[5] = double_vars[48];
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 32;
L23: // CONVERT_INT_TO_DOUBLE
  double_vars[48] = (double)int_vars[2];
L24: // MULNUM_SET_FIELD_DOUBLE
  double_vars[6] = double_vars[48];
L25: // MOVE_CONSTANT_INT
  int_vars[2] = 42;
L26: // CONVERT_INT_TO_DOUBLE
  double_vars[48] = (double)int_vars[2];
L27: // MULNUM_SET_FIELD_DOUBLE
  double_vars[7] = double_vars[48];
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 13;
L29: // CONVERT_INT_TO_DOUBLE
  double_vars[48] = (double)int_vars[2];
L30: // MULNUM_SET_FIELD_DOUBLE
  double_vars[8] = double_vars[48];
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 23;
L32: // CONVERT_INT_TO_DOUBLE
  double_vars[48] = (double)int_vars[2];
L33: // MULNUM_SET_FIELD_DOUBLE
  double_vars[9] = double_vars[48];
L34: // MOVE_CONSTANT_INT
  int_vars[2] = 33;
L35: // CONVERT_INT_TO_DOUBLE
  double_vars[48] = (double)int_vars[2];
L36: // MULNUM_SET_FIELD_DOUBLE
  double_vars[10] = double_vars[48];
L37: // MOVE_CONSTANT_INT
  int_vars[2] = 43;
L38: // CONVERT_INT_TO_DOUBLE
  double_vars[48] = (double)int_vars[2];
L39: // MULNUM_SET_FIELD_DOUBLE
  double_vars[11] = double_vars[48];
L40: // MOVE_CONSTANT_INT
  int_vars[2] = 14;
L41: // CONVERT_INT_TO_DOUBLE
  double_vars[48] = (double)int_vars[2];
L42: // MULNUM_SET_FIELD_DOUBLE
  double_vars[12] = double_vars[48];
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 24;
L44: // CONVERT_INT_TO_DOUBLE
  double_vars[48] = (double)int_vars[2];
L45: // MULNUM_SET_FIELD_DOUBLE
  double_vars[13] = double_vars[48];
L46: // MOVE_CONSTANT_INT
  int_vars[2] = 34;
L47: // CONVERT_INT_TO_DOUBLE
  double_vars[48] = (double)int_vars[2];
L48: // MULNUM_SET_FIELD_DOUBLE
  double_vars[14] = double_vars[48];
L49: // MOVE_CONSTANT_INT
  int_vars[2] = 44;
L50: // CONVERT_INT_TO_DOUBLE
  double_vars[48] = (double)int_vars[2];
L51: // MULNUM_SET_FIELD_DOUBLE
  double_vars[15] = double_vars[48];
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 111;
L53: // CONVERT_INT_TO_DOUBLE
  double_vars[48] = (double)int_vars[2];
L54: // MULNUM_SET_FIELD_DOUBLE
  double_vars[16] = double_vars[48];
L55: // MOVE_CONSTANT_INT
  int_vars[2] = 121;
L56: // CONVERT_INT_TO_DOUBLE
  double_vars[48] = (double)int_vars[2];
L57: // MULNUM_SET_FIELD_DOUBLE
  double_vars[17] = double_vars[48];
L58: // MOVE_CONSTANT_INT
  int_vars[2] = 131;
L59: // CONVERT_INT_TO_DOUBLE
  double_vars[48] = (double)int_vars[2];
L60: // MULNUM_SET_FIELD_DOUBLE
  double_vars[18] = double_vars[48];
L61: // MOVE_CONSTANT_INT
  int_vars[2] = 141;
L62: // CONVERT_INT_TO_DOUBLE
  double_vars[48] = (double)int_vars[2];
L63: // MULNUM_SET_FIELD_DOUBLE
  double_vars[19] = double_vars[48];
L64: // MOVE_CONSTANT_INT
  int_vars[2] = 112;
L65: // CONVERT_INT_TO_DOUBLE
  double_vars[48] = (double)int_vars[2];
L66: // MULNUM_SET_FIELD_DOUBLE
  double_vars[20] = double_vars[48];
L67: // MOVE_CONSTANT_INT
  int_vars[2] = 122;
L68: // CONVERT_INT_TO_DOUBLE
  double_vars[48] = (double)int_vars[2];
L69: // MULNUM_SET_FIELD_DOUBLE
  double_vars[21] = double_vars[48];
L70: // MOVE_CONSTANT_INT
  int_vars[2] = 132;
L71: // CONVERT_INT_TO_DOUBLE
  double_vars[48] = (double)int_vars[2];
L72: // MULNUM_SET_FIELD_DOUBLE
  double_vars[22] = double_vars[48];
L73: // MOVE_CONSTANT_INT
  int_vars[2] = 142;
L74: // CONVERT_INT_TO_DOUBLE
  double_vars[48] = (double)int_vars[2];
L75: // MULNUM_SET_FIELD_DOUBLE
  double_vars[23] = double_vars[48];
L76: // MOVE_CONSTANT_INT
  int_vars[2] = 113;
L77: // CONVERT_INT_TO_DOUBLE
  double_vars[48] = (double)int_vars[2];
L78: // MULNUM_SET_FIELD_DOUBLE
  double_vars[24] = double_vars[48];
L79: // MOVE_CONSTANT_INT
  int_vars[2] = 123;
L80: // CONVERT_INT_TO_DOUBLE
  double_vars[48] = (double)int_vars[2];
L81: // MULNUM_SET_FIELD_DOUBLE
  double_vars[25] = double_vars[48];
L82: // MOVE_CONSTANT_INT
  int_vars[2] = 133;
L83: // CONVERT_INT_TO_DOUBLE
  double_vars[48] = (double)int_vars[2];
L84: // MULNUM_SET_FIELD_DOUBLE
  double_vars[26] = double_vars[48];
L85: // MOVE_CONSTANT_INT
  int_vars[2] = 143;
L86: // CONVERT_INT_TO_DOUBLE
  double_vars[48] = (double)int_vars[2];
L87: // MULNUM_SET_FIELD_DOUBLE
  double_vars[27] = double_vars[48];
L88: // MOVE_CONSTANT_INT
  int_vars[2] = 114;
L89: // CONVERT_INT_TO_DOUBLE
  double_vars[48] = (double)int_vars[2];
L90: // MULNUM_SET_FIELD_DOUBLE
  double_vars[28] = double_vars[48];
L91: // MOVE_CONSTANT_INT
  int_vars[2] = 124;
L92: // CONVERT_INT_TO_DOUBLE
  double_vars[48] = (double)int_vars[2];
L93: // MULNUM_SET_FIELD_DOUBLE
  double_vars[29] = double_vars[48];
L94: // MOVE_CONSTANT_INT
  int_vars[2] = 134;
L95: // CONVERT_INT_TO_DOUBLE
  double_vars[48] = (double)int_vars[2];
L96: // MULNUM_SET_FIELD_DOUBLE
  double_vars[30] = double_vars[48];
L97: // MOVE_CONSTANT_INT
  int_vars[2] = 144;
L98: // CONVERT_INT_TO_DOUBLE
  double_vars[48] = (double)int_vars[2];
L99: // MULNUM_SET_FIELD_DOUBLE
  double_vars[31] = double_vars[48];
L100: // MULNUM_GET_FIELD_DOUBLE
  double_vars[48] = double_vars[0];
L101: // MULNUM_GET_FIELD_DOUBLE
  double_vars[49] = double_vars[16];
L102: // ADD_DOUBLE
  double_vars[50] = double_vars[48] + double_vars[49];
L103: // MULNUM_SET_FIELD_DOUBLE
  double_vars[32] = double_vars[50];
L104: // MULNUM_GET_FIELD_DOUBLE
  double_vars[48] = double_vars[1];
L105: // MULNUM_GET_FIELD_DOUBLE
  double_vars[49] = double_vars[17];
L106: // ADD_DOUBLE
  double_vars[50] = double_vars[48] + double_vars[49];
L107: // MULNUM_SET_FIELD_DOUBLE
  double_vars[33] = double_vars[50];
L108: // MULNUM_GET_FIELD_DOUBLE
  double_vars[48] = double_vars[2];
L109: // MULNUM_GET_FIELD_DOUBLE
  double_vars[49] = double_vars[18];
L110: // ADD_DOUBLE
  double_vars[50] = double_vars[48] + double_vars[49];
L111: // MULNUM_SET_FIELD_DOUBLE
  double_vars[34] = double_vars[50];
L112: // MULNUM_GET_FIELD_DOUBLE
  double_vars[48] = double_vars[3];
L113: // MULNUM_GET_FIELD_DOUBLE
  double_vars[49] = double_vars[19];
L114: // ADD_DOUBLE
  double_vars[50] = double_vars[48] + double_vars[49];
L115: // MULNUM_SET_FIELD_DOUBLE
  double_vars[35] = double_vars[50];
L116: // MULNUM_GET_FIELD_DOUBLE
  double_vars[48] = double_vars[4];
L117: // MULNUM_GET_FIELD_DOUBLE
  double_vars[49] = double_vars[20];
L118: // ADD_DOUBLE
  double_vars[50] = double_vars[48] + double_vars[49];
L119: // MULNUM_SET_FIELD_DOUBLE
  double_vars[36] = double_vars[50];
L120: // MULNUM_GET_FIELD_DOUBLE
  double_vars[48] = double_vars[5];
L121: // MULNUM_GET_FIELD_DOUBLE
  double_vars[49] = double_vars[21];
L122: // ADD_DOUBLE
  double_vars[50] = double_vars[48] + double_vars[49];
L123: // MULNUM_SET_FIELD_DOUBLE
  double_vars[37] = double_vars[50];
L124: // MULNUM_GET_FIELD_DOUBLE
  double_vars[48] = double_vars[6];
L125: // MULNUM_GET_FIELD_DOUBLE
  double_vars[49] = double_vars[22];
L126: // ADD_DOUBLE
  double_vars[50] = double_vars[48] + double_vars[49];
L127: // MULNUM_SET_FIELD_DOUBLE
  double_vars[38] = double_vars[50];
L128: // MULNUM_GET_FIELD_DOUBLE
  double_vars[48] = double_vars[7];
L129: // MULNUM_GET_FIELD_DOUBLE
  double_vars[49] = double_vars[23];
L130: // ADD_DOUBLE
  double_vars[50] = double_vars[48] + double_vars[49];
L131: // MULNUM_SET_FIELD_DOUBLE
  double_vars[39] = double_vars[50];
L132: // MULNUM_GET_FIELD_DOUBLE
  double_vars[48] = double_vars[8];
L133: // MULNUM_GET_FIELD_DOUBLE
  double_vars[49] = double_vars[24];
L134: // ADD_DOUBLE
  double_vars[50] = double_vars[48] + double_vars[49];
L135: // MULNUM_SET_FIELD_DOUBLE
  double_vars[40] = double_vars[50];
L136: // MULNUM_GET_FIELD_DOUBLE
  double_vars[48] = double_vars[9];
L137: // MULNUM_GET_FIELD_DOUBLE
  double_vars[49] = double_vars[25];
L138: // ADD_DOUBLE
  double_vars[50] = double_vars[48] + double_vars[49];
L139: // MULNUM_SET_FIELD_DOUBLE
  double_vars[41] = double_vars[50];
L140: // MULNUM_GET_FIELD_DOUBLE
  double_vars[48] = double_vars[10];
L141: // MULNUM_GET_FIELD_DOUBLE
  double_vars[49] = double_vars[26];
L142: // ADD_DOUBLE
  double_vars[50] = double_vars[48] + double_vars[49];
L143: // MULNUM_SET_FIELD_DOUBLE
  double_vars[42] = double_vars[50];
L144: // MULNUM_GET_FIELD_DOUBLE
  double_vars[48] = double_vars[11];
L145: // MULNUM_GET_FIELD_DOUBLE
  double_vars[49] = double_vars[27];
L146: // ADD_DOUBLE
  double_vars[50] = double_vars[48] + double_vars[49];
L147: // MULNUM_SET_FIELD_DOUBLE
  double_vars[43] = double_vars[50];
L148: // MULNUM_GET_FIELD_DOUBLE
  double_vars[48] = double_vars[12];
L149: // MULNUM_GET_FIELD_DOUBLE
  double_vars[49] = double_vars[28];
L150: // ADD_DOUBLE
  double_vars[50] = double_vars[48] + double_vars[49];
L151: // MULNUM_SET_FIELD_DOUBLE
  double_vars[44] = double_vars[50];
L152: // MULNUM_GET_FIELD_DOUBLE
  double_vars[48] = double_vars[13];
L153: // MULNUM_GET_FIELD_DOUBLE
  double_vars[49] = double_vars[29];
L154: // ADD_DOUBLE
  double_vars[50] = double_vars[48] + double_vars[49];
L155: // MULNUM_SET_FIELD_DOUBLE
  double_vars[45] = double_vars[50];
L156: // MULNUM_GET_FIELD_DOUBLE
  double_vars[48] = double_vars[14];
L157: // MULNUM_GET_FIELD_DOUBLE
  double_vars[49] = double_vars[30];
L158: // ADD_DOUBLE
  double_vars[50] = double_vars[48] + double_vars[49];
L159: // MULNUM_SET_FIELD_DOUBLE
  double_vars[46] = double_vars[50];
L160: // MULNUM_GET_FIELD_DOUBLE
  double_vars[48] = double_vars[15];
L161: // MULNUM_GET_FIELD_DOUBLE
  double_vars[49] = double_vars[31];
L162: // ADD_DOUBLE
  double_vars[50] = double_vars[48] + double_vars[49];
L163: // MULNUM_SET_FIELD_DOUBLE
  double_vars[47] = double_vars[50];
L164: // MULNUM_GET_FIELD_DOUBLE
  double_vars[48] = double_vars[32];
L165: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[49] = *(double*)&stack[0];
    }
  }
L166: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Value";
    const char* sub_name = "value_max_fields_double";
    const char* file = "TestCase/Value.spvm";
    int32_t line = 660;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L315;
  }
L167: // MOVE_CONSTANT_INT
  int_vars[2] = 111;
L168: // CONVERT_INT_TO_DOUBLE
  double_vars[50] = (double)int_vars[2];
L169: // ADD_DOUBLE
  double_vars[51] = double_vars[49] + double_vars[50];
L170: // EQ_DOUBLE
  int_vars[0] = (double_vars[48] == double_vars[51]);
L171: // BOOL_INT
  int_vars[0] = int_vars[0];
L172: // IF_NE_ZERO
  if (int_vars[0]) { goto L176; }
L173: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L174: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L175: // GOTO
  goto L176;
L176: // MULNUM_GET_FIELD_DOUBLE
  double_vars[48] = double_vars[33];
L177: // MOVE_CONSTANT_INT
  int_vars[4] = 142;
L178: // CONVERT_INT_TO_DOUBLE
  double_vars[49] = (double)int_vars[4];
L179: // EQ_DOUBLE
  int_vars[0] = (double_vars[48] == double_vars[49]);
L180: // BOOL_INT
  int_vars[0] = int_vars[0];
L181: // IF_NE_ZERO
  if (int_vars[0]) { goto L185; }
L182: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L183: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L184: // GOTO
  goto L185;
L185: // MULNUM_GET_FIELD_DOUBLE
  double_vars[48] = double_vars[34];
L186: // MOVE_CONSTANT_INT
  int_vars[4] = 162;
L187: // CONVERT_INT_TO_DOUBLE
  double_vars[49] = (double)int_vars[4];
L188: // EQ_DOUBLE
  int_vars[0] = (double_vars[48] == double_vars[49]);
L189: // BOOL_INT
  int_vars[0] = int_vars[0];
L190: // IF_NE_ZERO
  if (int_vars[0]) { goto L194; }
L191: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L192: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L193: // GOTO
  goto L194;
L194: // MULNUM_GET_FIELD_DOUBLE
  double_vars[48] = double_vars[35];
L195: // MOVE_CONSTANT_INT
  int_vars[4] = 182;
L196: // CONVERT_INT_TO_DOUBLE
  double_vars[49] = (double)int_vars[4];
L197: // EQ_DOUBLE
  int_vars[0] = (double_vars[48] == double_vars[49]);
L198: // BOOL_INT
  int_vars[0] = int_vars[0];
L199: // IF_NE_ZERO
  if (int_vars[0]) { goto L203; }
L200: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L201: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L202: // GOTO
  goto L203;
L203: // MULNUM_GET_FIELD_DOUBLE
  double_vars[48] = double_vars[36];
L204: // MOVE_CONSTANT_INT
  int_vars[4] = 124;
L205: // CONVERT_INT_TO_DOUBLE
  double_vars[49] = (double)int_vars[4];
L206: // EQ_DOUBLE
  int_vars[0] = (double_vars[48] == double_vars[49]);
L207: // BOOL_INT
  int_vars[0] = int_vars[0];
L208: // IF_NE_ZERO
  if (int_vars[0]) { goto L212; }
L209: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L210: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L211: // GOTO
  goto L212;
L212: // MULNUM_GET_FIELD_DOUBLE
  double_vars[48] = double_vars[37];
L213: // MOVE_CONSTANT_INT
  int_vars[4] = 144;
L214: // CONVERT_INT_TO_DOUBLE
  double_vars[49] = (double)int_vars[4];
L215: // EQ_DOUBLE
  int_vars[0] = (double_vars[48] == double_vars[49]);
L216: // BOOL_INT
  int_vars[0] = int_vars[0];
L217: // IF_NE_ZERO
  if (int_vars[0]) { goto L221; }
L218: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L219: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L220: // GOTO
  goto L221;
L221: // MULNUM_GET_FIELD_DOUBLE
  double_vars[48] = double_vars[38];
L222: // MOVE_CONSTANT_INT
  int_vars[4] = 164;
L223: // CONVERT_INT_TO_DOUBLE
  double_vars[49] = (double)int_vars[4];
L224: // EQ_DOUBLE
  int_vars[0] = (double_vars[48] == double_vars[49]);
L225: // BOOL_INT
  int_vars[0] = int_vars[0];
L226: // IF_NE_ZERO
  if (int_vars[0]) { goto L230; }
L227: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L228: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L229: // GOTO
  goto L230;
L230: // MULNUM_GET_FIELD_DOUBLE
  double_vars[48] = double_vars[39];
L231: // MOVE_CONSTANT_INT
  int_vars[4] = 184;
L232: // CONVERT_INT_TO_DOUBLE
  double_vars[49] = (double)int_vars[4];
L233: // EQ_DOUBLE
  int_vars[0] = (double_vars[48] == double_vars[49]);
L234: // BOOL_INT
  int_vars[0] = int_vars[0];
L235: // IF_NE_ZERO
  if (int_vars[0]) { goto L239; }
L236: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L237: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L238: // GOTO
  goto L239;
L239: // MULNUM_GET_FIELD_DOUBLE
  double_vars[48] = double_vars[40];
L240: // MOVE_CONSTANT_INT
  int_vars[4] = 126;
L241: // CONVERT_INT_TO_DOUBLE
  double_vars[49] = (double)int_vars[4];
L242: // EQ_DOUBLE
  int_vars[0] = (double_vars[48] == double_vars[49]);
L243: // BOOL_INT
  int_vars[0] = int_vars[0];
L244: // IF_NE_ZERO
  if (int_vars[0]) { goto L248; }
L245: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L246: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L247: // GOTO
  goto L248;
L248: // MULNUM_GET_FIELD_DOUBLE
  double_vars[48] = double_vars[41];
L249: // MOVE_CONSTANT_INT
  int_vars[4] = 146;
L250: // CONVERT_INT_TO_DOUBLE
  double_vars[49] = (double)int_vars[4];
L251: // EQ_DOUBLE
  int_vars[0] = (double_vars[48] == double_vars[49]);
L252: // BOOL_INT
  int_vars[0] = int_vars[0];
L253: // IF_NE_ZERO
  if (int_vars[0]) { goto L257; }
L254: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L255: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L256: // GOTO
  goto L257;
L257: // MULNUM_GET_FIELD_DOUBLE
  double_vars[48] = double_vars[42];
L258: // MOVE_CONSTANT_INT
  int_vars[4] = 166;
L259: // CONVERT_INT_TO_DOUBLE
  double_vars[49] = (double)int_vars[4];
L260: // EQ_DOUBLE
  int_vars[0] = (double_vars[48] == double_vars[49]);
L261: // BOOL_INT
  int_vars[0] = int_vars[0];
L262: // IF_NE_ZERO
  if (int_vars[0]) { goto L266; }
L263: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L264: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L265: // GOTO
  goto L266;
L266: // MULNUM_GET_FIELD_DOUBLE
  double_vars[48] = double_vars[43];
L267: // MOVE_CONSTANT_INT
  int_vars[4] = 186;
L268: // CONVERT_INT_TO_DOUBLE
  double_vars[49] = (double)int_vars[4];
L269: // EQ_DOUBLE
  int_vars[0] = (double_vars[48] == double_vars[49]);
L270: // BOOL_INT
  int_vars[0] = int_vars[0];
L271: // IF_NE_ZERO
  if (int_vars[0]) { goto L275; }
L272: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L273: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L274: // GOTO
  goto L275;
L275: // MULNUM_GET_FIELD_DOUBLE
  double_vars[48] = double_vars[35];
L276: // MOVE_CONSTANT_INT
  int_vars[4] = 182;
L277: // CONVERT_INT_TO_DOUBLE
  double_vars[49] = (double)int_vars[4];
L278: // EQ_DOUBLE
  int_vars[0] = (double_vars[48] == double_vars[49]);
L279: // BOOL_INT
  int_vars[0] = int_vars[0];
L280: // IF_NE_ZERO
  if (int_vars[0]) { goto L284; }
L281: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L282: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L283: // GOTO
  goto L284;
L284: // MULNUM_GET_FIELD_DOUBLE
  double_vars[48] = double_vars[39];
L285: // MOVE_CONSTANT_INT
  int_vars[4] = 184;
L286: // CONVERT_INT_TO_DOUBLE
  double_vars[49] = (double)int_vars[4];
L287: // EQ_DOUBLE
  int_vars[0] = (double_vars[48] == double_vars[49]);
L288: // BOOL_INT
  int_vars[0] = int_vars[0];
L289: // IF_NE_ZERO
  if (int_vars[0]) { goto L293; }
L290: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L291: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L292: // GOTO
  goto L293;
L293: // MULNUM_GET_FIELD_DOUBLE
  double_vars[48] = double_vars[43];
L294: // MOVE_CONSTANT_INT
  int_vars[4] = 186;
L295: // CONVERT_INT_TO_DOUBLE
  double_vars[49] = (double)int_vars[4];
L296: // EQ_DOUBLE
  int_vars[0] = (double_vars[48] == double_vars[49]);
L297: // BOOL_INT
  int_vars[0] = int_vars[0];
L298: // IF_NE_ZERO
  if (int_vars[0]) { goto L302; }
L299: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L300: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L301: // GOTO
  goto L302;
L302: // MULNUM_GET_FIELD_DOUBLE
  double_vars[48] = double_vars[47];
L303: // MOVE_CONSTANT_INT
  int_vars[4] = 188;
L304: // CONVERT_INT_TO_DOUBLE
  double_vars[49] = (double)int_vars[4];
L305: // EQ_DOUBLE
  int_vars[0] = (double_vars[48] == double_vars[49]);
L306: // BOOL_INT
  int_vars[0] = int_vars[0];
L307: // IF_NE_ZERO
  if (int_vars[0]) { goto L311; }
L308: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L309: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L310: // GOTO
  goto L311;
L311: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L312: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L315;
L313: // INIT_INT
  int_vars[6] = 0;
L314: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L315;
L315: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Value__value_max_fields_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[52];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_FLOAT
  float_vars[0] = 0;
  float_vars[1] = 0;
  float_vars[2] = 0;
  float_vars[3] = 0;
  float_vars[4] = 0;
  float_vars[5] = 0;
  float_vars[6] = 0;
  float_vars[7] = 0;
  float_vars[8] = 0;
  float_vars[9] = 0;
  float_vars[10] = 0;
  float_vars[11] = 0;
  float_vars[12] = 0;
  float_vars[13] = 0;
  float_vars[14] = 0;
  float_vars[15] = 0;
L2: // INIT_MULNUM_FLOAT
  float_vars[16] = 0;
  float_vars[17] = 0;
  float_vars[18] = 0;
  float_vars[19] = 0;
  float_vars[20] = 0;
  float_vars[21] = 0;
  float_vars[22] = 0;
  float_vars[23] = 0;
  float_vars[24] = 0;
  float_vars[25] = 0;
  float_vars[26] = 0;
  float_vars[27] = 0;
  float_vars[28] = 0;
  float_vars[29] = 0;
  float_vars[30] = 0;
  float_vars[31] = 0;
L3: // INIT_MULNUM_FLOAT
  float_vars[32] = 0;
  float_vars[33] = 0;
  float_vars[34] = 0;
  float_vars[35] = 0;
  float_vars[36] = 0;
  float_vars[37] = 0;
  float_vars[38] = 0;
  float_vars[39] = 0;
  float_vars[40] = 0;
  float_vars[41] = 0;
  float_vars[42] = 0;
  float_vars[43] = 0;
  float_vars[44] = 0;
  float_vars[45] = 0;
  float_vars[46] = 0;
  float_vars[47] = 0;
L4: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[48] = *(float*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Value";
    const char* sub_name = "value_max_fields_float";
    const char* file = "TestCase/Value.spvm";
    int32_t line = 483;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L315;
  }
L6: // MULNUM_SET_FIELD_FLOAT
  float_vars[0] = float_vars[48];
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 21;
L8: // CONVERT_INT_TO_FLOAT
  float_vars[48] = (float)int_vars[2];
L9: // MULNUM_SET_FIELD_FLOAT
  float_vars[1] = float_vars[48];
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 31;
L11: // CONVERT_INT_TO_FLOAT
  float_vars[48] = (float)int_vars[2];
L12: // MULNUM_SET_FIELD_FLOAT
  float_vars[2] = float_vars[48];
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 41;
L14: // CONVERT_INT_TO_FLOAT
  float_vars[48] = (float)int_vars[2];
L15: // MULNUM_SET_FIELD_FLOAT
  float_vars[3] = float_vars[48];
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 12;
L17: // CONVERT_INT_TO_FLOAT
  float_vars[48] = (float)int_vars[2];
L18: // MULNUM_SET_FIELD_FLOAT
  float_vars[4] = float_vars[48];
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 22;
L20: // CONVERT_INT_TO_FLOAT
  float_vars[48] = (float)int_vars[2];
L21: // MULNUM_SET_FIELD_FLOAT
  float_vars[5] = float_vars[48];
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 32;
L23: // CONVERT_INT_TO_FLOAT
  float_vars[48] = (float)int_vars[2];
L24: // MULNUM_SET_FIELD_FLOAT
  float_vars[6] = float_vars[48];
L25: // MOVE_CONSTANT_INT
  int_vars[2] = 42;
L26: // CONVERT_INT_TO_FLOAT
  float_vars[48] = (float)int_vars[2];
L27: // MULNUM_SET_FIELD_FLOAT
  float_vars[7] = float_vars[48];
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 13;
L29: // CONVERT_INT_TO_FLOAT
  float_vars[48] = (float)int_vars[2];
L30: // MULNUM_SET_FIELD_FLOAT
  float_vars[8] = float_vars[48];
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 23;
L32: // CONVERT_INT_TO_FLOAT
  float_vars[48] = (float)int_vars[2];
L33: // MULNUM_SET_FIELD_FLOAT
  float_vars[9] = float_vars[48];
L34: // MOVE_CONSTANT_INT
  int_vars[2] = 33;
L35: // CONVERT_INT_TO_FLOAT
  float_vars[48] = (float)int_vars[2];
L36: // MULNUM_SET_FIELD_FLOAT
  float_vars[10] = float_vars[48];
L37: // MOVE_CONSTANT_INT
  int_vars[2] = 43;
L38: // CONVERT_INT_TO_FLOAT
  float_vars[48] = (float)int_vars[2];
L39: // MULNUM_SET_FIELD_FLOAT
  float_vars[11] = float_vars[48];
L40: // MOVE_CONSTANT_INT
  int_vars[2] = 14;
L41: // CONVERT_INT_TO_FLOAT
  float_vars[48] = (float)int_vars[2];
L42: // MULNUM_SET_FIELD_FLOAT
  float_vars[12] = float_vars[48];
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 24;
L44: // CONVERT_INT_TO_FLOAT
  float_vars[48] = (float)int_vars[2];
L45: // MULNUM_SET_FIELD_FLOAT
  float_vars[13] = float_vars[48];
L46: // MOVE_CONSTANT_INT
  int_vars[2] = 34;
L47: // CONVERT_INT_TO_FLOAT
  float_vars[48] = (float)int_vars[2];
L48: // MULNUM_SET_FIELD_FLOAT
  float_vars[14] = float_vars[48];
L49: // MOVE_CONSTANT_INT
  int_vars[2] = 44;
L50: // CONVERT_INT_TO_FLOAT
  float_vars[48] = (float)int_vars[2];
L51: // MULNUM_SET_FIELD_FLOAT
  float_vars[15] = float_vars[48];
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 111;
L53: // CONVERT_INT_TO_FLOAT
  float_vars[48] = (float)int_vars[2];
L54: // MULNUM_SET_FIELD_FLOAT
  float_vars[16] = float_vars[48];
L55: // MOVE_CONSTANT_INT
  int_vars[2] = 121;
L56: // CONVERT_INT_TO_FLOAT
  float_vars[48] = (float)int_vars[2];
L57: // MULNUM_SET_FIELD_FLOAT
  float_vars[17] = float_vars[48];
L58: // MOVE_CONSTANT_INT
  int_vars[2] = 131;
L59: // CONVERT_INT_TO_FLOAT
  float_vars[48] = (float)int_vars[2];
L60: // MULNUM_SET_FIELD_FLOAT
  float_vars[18] = float_vars[48];
L61: // MOVE_CONSTANT_INT
  int_vars[2] = 141;
L62: // CONVERT_INT_TO_FLOAT
  float_vars[48] = (float)int_vars[2];
L63: // MULNUM_SET_FIELD_FLOAT
  float_vars[19] = float_vars[48];
L64: // MOVE_CONSTANT_INT
  int_vars[2] = 112;
L65: // CONVERT_INT_TO_FLOAT
  float_vars[48] = (float)int_vars[2];
L66: // MULNUM_SET_FIELD_FLOAT
  float_vars[20] = float_vars[48];
L67: // MOVE_CONSTANT_INT
  int_vars[2] = 122;
L68: // CONVERT_INT_TO_FLOAT
  float_vars[48] = (float)int_vars[2];
L69: // MULNUM_SET_FIELD_FLOAT
  float_vars[21] = float_vars[48];
L70: // MOVE_CONSTANT_INT
  int_vars[2] = 132;
L71: // CONVERT_INT_TO_FLOAT
  float_vars[48] = (float)int_vars[2];
L72: // MULNUM_SET_FIELD_FLOAT
  float_vars[22] = float_vars[48];
L73: // MOVE_CONSTANT_INT
  int_vars[2] = 142;
L74: // CONVERT_INT_TO_FLOAT
  float_vars[48] = (float)int_vars[2];
L75: // MULNUM_SET_FIELD_FLOAT
  float_vars[23] = float_vars[48];
L76: // MOVE_CONSTANT_INT
  int_vars[2] = 113;
L77: // CONVERT_INT_TO_FLOAT
  float_vars[48] = (float)int_vars[2];
L78: // MULNUM_SET_FIELD_FLOAT
  float_vars[24] = float_vars[48];
L79: // MOVE_CONSTANT_INT
  int_vars[2] = 123;
L80: // CONVERT_INT_TO_FLOAT
  float_vars[48] = (float)int_vars[2];
L81: // MULNUM_SET_FIELD_FLOAT
  float_vars[25] = float_vars[48];
L82: // MOVE_CONSTANT_INT
  int_vars[2] = 133;
L83: // CONVERT_INT_TO_FLOAT
  float_vars[48] = (float)int_vars[2];
L84: // MULNUM_SET_FIELD_FLOAT
  float_vars[26] = float_vars[48];
L85: // MOVE_CONSTANT_INT
  int_vars[2] = 143;
L86: // CONVERT_INT_TO_FLOAT
  float_vars[48] = (float)int_vars[2];
L87: // MULNUM_SET_FIELD_FLOAT
  float_vars[27] = float_vars[48];
L88: // MOVE_CONSTANT_INT
  int_vars[2] = 114;
L89: // CONVERT_INT_TO_FLOAT
  float_vars[48] = (float)int_vars[2];
L90: // MULNUM_SET_FIELD_FLOAT
  float_vars[28] = float_vars[48];
L91: // MOVE_CONSTANT_INT
  int_vars[2] = 124;
L92: // CONVERT_INT_TO_FLOAT
  float_vars[48] = (float)int_vars[2];
L93: // MULNUM_SET_FIELD_FLOAT
  float_vars[29] = float_vars[48];
L94: // MOVE_CONSTANT_INT
  int_vars[2] = 134;
L95: // CONVERT_INT_TO_FLOAT
  float_vars[48] = (float)int_vars[2];
L96: // MULNUM_SET_FIELD_FLOAT
  float_vars[30] = float_vars[48];
L97: // MOVE_CONSTANT_INT
  int_vars[2] = 144;
L98: // CONVERT_INT_TO_FLOAT
  float_vars[48] = (float)int_vars[2];
L99: // MULNUM_SET_FIELD_FLOAT
  float_vars[31] = float_vars[48];
L100: // MULNUM_GET_FIELD_FLOAT
  float_vars[48] = float_vars[0];
L101: // MULNUM_GET_FIELD_FLOAT
  float_vars[49] = float_vars[16];
L102: // ADD_FLOAT
  float_vars[50] = float_vars[48] + float_vars[49];
L103: // MULNUM_SET_FIELD_FLOAT
  float_vars[32] = float_vars[50];
L104: // MULNUM_GET_FIELD_FLOAT
  float_vars[48] = float_vars[1];
L105: // MULNUM_GET_FIELD_FLOAT
  float_vars[49] = float_vars[17];
L106: // ADD_FLOAT
  float_vars[50] = float_vars[48] + float_vars[49];
L107: // MULNUM_SET_FIELD_FLOAT
  float_vars[33] = float_vars[50];
L108: // MULNUM_GET_FIELD_FLOAT
  float_vars[48] = float_vars[2];
L109: // MULNUM_GET_FIELD_FLOAT
  float_vars[49] = float_vars[18];
L110: // ADD_FLOAT
  float_vars[50] = float_vars[48] + float_vars[49];
L111: // MULNUM_SET_FIELD_FLOAT
  float_vars[34] = float_vars[50];
L112: // MULNUM_GET_FIELD_FLOAT
  float_vars[48] = float_vars[3];
L113: // MULNUM_GET_FIELD_FLOAT
  float_vars[49] = float_vars[19];
L114: // ADD_FLOAT
  float_vars[50] = float_vars[48] + float_vars[49];
L115: // MULNUM_SET_FIELD_FLOAT
  float_vars[35] = float_vars[50];
L116: // MULNUM_GET_FIELD_FLOAT
  float_vars[48] = float_vars[4];
L117: // MULNUM_GET_FIELD_FLOAT
  float_vars[49] = float_vars[20];
L118: // ADD_FLOAT
  float_vars[50] = float_vars[48] + float_vars[49];
L119: // MULNUM_SET_FIELD_FLOAT
  float_vars[36] = float_vars[50];
L120: // MULNUM_GET_FIELD_FLOAT
  float_vars[48] = float_vars[5];
L121: // MULNUM_GET_FIELD_FLOAT
  float_vars[49] = float_vars[21];
L122: // ADD_FLOAT
  float_vars[50] = float_vars[48] + float_vars[49];
L123: // MULNUM_SET_FIELD_FLOAT
  float_vars[37] = float_vars[50];
L124: // MULNUM_GET_FIELD_FLOAT
  float_vars[48] = float_vars[6];
L125: // MULNUM_GET_FIELD_FLOAT
  float_vars[49] = float_vars[22];
L126: // ADD_FLOAT
  float_vars[50] = float_vars[48] + float_vars[49];
L127: // MULNUM_SET_FIELD_FLOAT
  float_vars[38] = float_vars[50];
L128: // MULNUM_GET_FIELD_FLOAT
  float_vars[48] = float_vars[7];
L129: // MULNUM_GET_FIELD_FLOAT
  float_vars[49] = float_vars[23];
L130: // ADD_FLOAT
  float_vars[50] = float_vars[48] + float_vars[49];
L131: // MULNUM_SET_FIELD_FLOAT
  float_vars[39] = float_vars[50];
L132: // MULNUM_GET_FIELD_FLOAT
  float_vars[48] = float_vars[8];
L133: // MULNUM_GET_FIELD_FLOAT
  float_vars[49] = float_vars[24];
L134: // ADD_FLOAT
  float_vars[50] = float_vars[48] + float_vars[49];
L135: // MULNUM_SET_FIELD_FLOAT
  float_vars[40] = float_vars[50];
L136: // MULNUM_GET_FIELD_FLOAT
  float_vars[48] = float_vars[9];
L137: // MULNUM_GET_FIELD_FLOAT
  float_vars[49] = float_vars[25];
L138: // ADD_FLOAT
  float_vars[50] = float_vars[48] + float_vars[49];
L139: // MULNUM_SET_FIELD_FLOAT
  float_vars[41] = float_vars[50];
L140: // MULNUM_GET_FIELD_FLOAT
  float_vars[48] = float_vars[10];
L141: // MULNUM_GET_FIELD_FLOAT
  float_vars[49] = float_vars[26];
L142: // ADD_FLOAT
  float_vars[50] = float_vars[48] + float_vars[49];
L143: // MULNUM_SET_FIELD_FLOAT
  float_vars[42] = float_vars[50];
L144: // MULNUM_GET_FIELD_FLOAT
  float_vars[48] = float_vars[11];
L145: // MULNUM_GET_FIELD_FLOAT
  float_vars[49] = float_vars[27];
L146: // ADD_FLOAT
  float_vars[50] = float_vars[48] + float_vars[49];
L147: // MULNUM_SET_FIELD_FLOAT
  float_vars[43] = float_vars[50];
L148: // MULNUM_GET_FIELD_FLOAT
  float_vars[48] = float_vars[12];
L149: // MULNUM_GET_FIELD_FLOAT
  float_vars[49] = float_vars[28];
L150: // ADD_FLOAT
  float_vars[50] = float_vars[48] + float_vars[49];
L151: // MULNUM_SET_FIELD_FLOAT
  float_vars[44] = float_vars[50];
L152: // MULNUM_GET_FIELD_FLOAT
  float_vars[48] = float_vars[13];
L153: // MULNUM_GET_FIELD_FLOAT
  float_vars[49] = float_vars[29];
L154: // ADD_FLOAT
  float_vars[50] = float_vars[48] + float_vars[49];
L155: // MULNUM_SET_FIELD_FLOAT
  float_vars[45] = float_vars[50];
L156: // MULNUM_GET_FIELD_FLOAT
  float_vars[48] = float_vars[14];
L157: // MULNUM_GET_FIELD_FLOAT
  float_vars[49] = float_vars[30];
L158: // ADD_FLOAT
  float_vars[50] = float_vars[48] + float_vars[49];
L159: // MULNUM_SET_FIELD_FLOAT
  float_vars[46] = float_vars[50];
L160: // MULNUM_GET_FIELD_FLOAT
  float_vars[48] = float_vars[15];
L161: // MULNUM_GET_FIELD_FLOAT
  float_vars[49] = float_vars[31];
L162: // ADD_FLOAT
  float_vars[50] = float_vars[48] + float_vars[49];
L163: // MULNUM_SET_FIELD_FLOAT
  float_vars[47] = float_vars[50];
L164: // MULNUM_GET_FIELD_FLOAT
  float_vars[48] = float_vars[32];
L165: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[49] = *(float*)&stack[0];
    }
  }
L166: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Value";
    const char* sub_name = "value_max_fields_float";
    const char* file = "TestCase/Value.spvm";
    int32_t line = 543;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L315;
  }
L167: // MOVE_CONSTANT_INT
  int_vars[2] = 111;
L168: // CONVERT_INT_TO_FLOAT
  float_vars[50] = (float)int_vars[2];
L169: // ADD_FLOAT
  float_vars[51] = float_vars[49] + float_vars[50];
L170: // EQ_FLOAT
  int_vars[0] = (float_vars[48] == float_vars[51]);
L171: // BOOL_INT
  int_vars[0] = int_vars[0];
L172: // IF_NE_ZERO
  if (int_vars[0]) { goto L176; }
L173: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L174: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L175: // GOTO
  goto L176;
L176: // MULNUM_GET_FIELD_FLOAT
  float_vars[48] = float_vars[33];
L177: // MOVE_CONSTANT_INT
  int_vars[4] = 142;
L178: // CONVERT_INT_TO_FLOAT
  float_vars[49] = (float)int_vars[4];
L179: // EQ_FLOAT
  int_vars[0] = (float_vars[48] == float_vars[49]);
L180: // BOOL_INT
  int_vars[0] = int_vars[0];
L181: // IF_NE_ZERO
  if (int_vars[0]) { goto L185; }
L182: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L183: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L184: // GOTO
  goto L185;
L185: // MULNUM_GET_FIELD_FLOAT
  float_vars[48] = float_vars[34];
L186: // MOVE_CONSTANT_INT
  int_vars[4] = 162;
L187: // CONVERT_INT_TO_FLOAT
  float_vars[49] = (float)int_vars[4];
L188: // EQ_FLOAT
  int_vars[0] = (float_vars[48] == float_vars[49]);
L189: // BOOL_INT
  int_vars[0] = int_vars[0];
L190: // IF_NE_ZERO
  if (int_vars[0]) { goto L194; }
L191: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L192: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L193: // GOTO
  goto L194;
L194: // MULNUM_GET_FIELD_FLOAT
  float_vars[48] = float_vars[35];
L195: // MOVE_CONSTANT_INT
  int_vars[4] = 182;
L196: // CONVERT_INT_TO_FLOAT
  float_vars[49] = (float)int_vars[4];
L197: // EQ_FLOAT
  int_vars[0] = (float_vars[48] == float_vars[49]);
L198: // BOOL_INT
  int_vars[0] = int_vars[0];
L199: // IF_NE_ZERO
  if (int_vars[0]) { goto L203; }
L200: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L201: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L202: // GOTO
  goto L203;
L203: // MULNUM_GET_FIELD_FLOAT
  float_vars[48] = float_vars[36];
L204: // MOVE_CONSTANT_INT
  int_vars[4] = 124;
L205: // CONVERT_INT_TO_FLOAT
  float_vars[49] = (float)int_vars[4];
L206: // EQ_FLOAT
  int_vars[0] = (float_vars[48] == float_vars[49]);
L207: // BOOL_INT
  int_vars[0] = int_vars[0];
L208: // IF_NE_ZERO
  if (int_vars[0]) { goto L212; }
L209: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L210: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L211: // GOTO
  goto L212;
L212: // MULNUM_GET_FIELD_FLOAT
  float_vars[48] = float_vars[37];
L213: // MOVE_CONSTANT_INT
  int_vars[4] = 144;
L214: // CONVERT_INT_TO_FLOAT
  float_vars[49] = (float)int_vars[4];
L215: // EQ_FLOAT
  int_vars[0] = (float_vars[48] == float_vars[49]);
L216: // BOOL_INT
  int_vars[0] = int_vars[0];
L217: // IF_NE_ZERO
  if (int_vars[0]) { goto L221; }
L218: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L219: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L220: // GOTO
  goto L221;
L221: // MULNUM_GET_FIELD_FLOAT
  float_vars[48] = float_vars[38];
L222: // MOVE_CONSTANT_INT
  int_vars[4] = 164;
L223: // CONVERT_INT_TO_FLOAT
  float_vars[49] = (float)int_vars[4];
L224: // EQ_FLOAT
  int_vars[0] = (float_vars[48] == float_vars[49]);
L225: // BOOL_INT
  int_vars[0] = int_vars[0];
L226: // IF_NE_ZERO
  if (int_vars[0]) { goto L230; }
L227: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L228: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L229: // GOTO
  goto L230;
L230: // MULNUM_GET_FIELD_FLOAT
  float_vars[48] = float_vars[39];
L231: // MOVE_CONSTANT_INT
  int_vars[4] = 184;
L232: // CONVERT_INT_TO_FLOAT
  float_vars[49] = (float)int_vars[4];
L233: // EQ_FLOAT
  int_vars[0] = (float_vars[48] == float_vars[49]);
L234: // BOOL_INT
  int_vars[0] = int_vars[0];
L235: // IF_NE_ZERO
  if (int_vars[0]) { goto L239; }
L236: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L237: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L238: // GOTO
  goto L239;
L239: // MULNUM_GET_FIELD_FLOAT
  float_vars[48] = float_vars[40];
L240: // MOVE_CONSTANT_INT
  int_vars[4] = 126;
L241: // CONVERT_INT_TO_FLOAT
  float_vars[49] = (float)int_vars[4];
L242: // EQ_FLOAT
  int_vars[0] = (float_vars[48] == float_vars[49]);
L243: // BOOL_INT
  int_vars[0] = int_vars[0];
L244: // IF_NE_ZERO
  if (int_vars[0]) { goto L248; }
L245: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L246: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L247: // GOTO
  goto L248;
L248: // MULNUM_GET_FIELD_FLOAT
  float_vars[48] = float_vars[41];
L249: // MOVE_CONSTANT_INT
  int_vars[4] = 146;
L250: // CONVERT_INT_TO_FLOAT
  float_vars[49] = (float)int_vars[4];
L251: // EQ_FLOAT
  int_vars[0] = (float_vars[48] == float_vars[49]);
L252: // BOOL_INT
  int_vars[0] = int_vars[0];
L253: // IF_NE_ZERO
  if (int_vars[0]) { goto L257; }
L254: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L255: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L256: // GOTO
  goto L257;
L257: // MULNUM_GET_FIELD_FLOAT
  float_vars[48] = float_vars[42];
L258: // MOVE_CONSTANT_INT
  int_vars[4] = 166;
L259: // CONVERT_INT_TO_FLOAT
  float_vars[49] = (float)int_vars[4];
L260: // EQ_FLOAT
  int_vars[0] = (float_vars[48] == float_vars[49]);
L261: // BOOL_INT
  int_vars[0] = int_vars[0];
L262: // IF_NE_ZERO
  if (int_vars[0]) { goto L266; }
L263: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L264: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L265: // GOTO
  goto L266;
L266: // MULNUM_GET_FIELD_FLOAT
  float_vars[48] = float_vars[43];
L267: // MOVE_CONSTANT_INT
  int_vars[4] = 186;
L268: // CONVERT_INT_TO_FLOAT
  float_vars[49] = (float)int_vars[4];
L269: // EQ_FLOAT
  int_vars[0] = (float_vars[48] == float_vars[49]);
L270: // BOOL_INT
  int_vars[0] = int_vars[0];
L271: // IF_NE_ZERO
  if (int_vars[0]) { goto L275; }
L272: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L273: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L274: // GOTO
  goto L275;
L275: // MULNUM_GET_FIELD_FLOAT
  float_vars[48] = float_vars[35];
L276: // MOVE_CONSTANT_INT
  int_vars[4] = 182;
L277: // CONVERT_INT_TO_FLOAT
  float_vars[49] = (float)int_vars[4];
L278: // EQ_FLOAT
  int_vars[0] = (float_vars[48] == float_vars[49]);
L279: // BOOL_INT
  int_vars[0] = int_vars[0];
L280: // IF_NE_ZERO
  if (int_vars[0]) { goto L284; }
L281: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L282: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L283: // GOTO
  goto L284;
L284: // MULNUM_GET_FIELD_FLOAT
  float_vars[48] = float_vars[39];
L285: // MOVE_CONSTANT_INT
  int_vars[4] = 184;
L286: // CONVERT_INT_TO_FLOAT
  float_vars[49] = (float)int_vars[4];
L287: // EQ_FLOAT
  int_vars[0] = (float_vars[48] == float_vars[49]);
L288: // BOOL_INT
  int_vars[0] = int_vars[0];
L289: // IF_NE_ZERO
  if (int_vars[0]) { goto L293; }
L290: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L291: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L292: // GOTO
  goto L293;
L293: // MULNUM_GET_FIELD_FLOAT
  float_vars[48] = float_vars[43];
L294: // MOVE_CONSTANT_INT
  int_vars[4] = 186;
L295: // CONVERT_INT_TO_FLOAT
  float_vars[49] = (float)int_vars[4];
L296: // EQ_FLOAT
  int_vars[0] = (float_vars[48] == float_vars[49]);
L297: // BOOL_INT
  int_vars[0] = int_vars[0];
L298: // IF_NE_ZERO
  if (int_vars[0]) { goto L302; }
L299: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L300: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L301: // GOTO
  goto L302;
L302: // MULNUM_GET_FIELD_FLOAT
  float_vars[48] = float_vars[47];
L303: // MOVE_CONSTANT_INT
  int_vars[4] = 188;
L304: // CONVERT_INT_TO_FLOAT
  float_vars[49] = (float)int_vars[4];
L305: // EQ_FLOAT
  int_vars[0] = (float_vars[48] == float_vars[49]);
L306: // BOOL_INT
  int_vars[0] = int_vars[0];
L307: // IF_NE_ZERO
  if (int_vars[0]) { goto L311; }
L308: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L309: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L310: // GOTO
  goto L311;
L311: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L312: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L315;
L313: // INIT_INT
  int_vars[6] = 0;
L314: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L315;
L315: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Value__value_max_fields_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[56];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_INT
  int_vars[1] = 0;
  int_vars[2] = 0;
  int_vars[3] = 0;
  int_vars[4] = 0;
  int_vars[5] = 0;
  int_vars[6] = 0;
  int_vars[7] = 0;
  int_vars[8] = 0;
  int_vars[9] = 0;
  int_vars[10] = 0;
  int_vars[11] = 0;
  int_vars[12] = 0;
  int_vars[13] = 0;
  int_vars[14] = 0;
  int_vars[15] = 0;
  int_vars[16] = 0;
L2: // INIT_MULNUM_INT
  int_vars[18] = 0;
  int_vars[19] = 0;
  int_vars[20] = 0;
  int_vars[21] = 0;
  int_vars[22] = 0;
  int_vars[23] = 0;
  int_vars[24] = 0;
  int_vars[25] = 0;
  int_vars[26] = 0;
  int_vars[27] = 0;
  int_vars[28] = 0;
  int_vars[29] = 0;
  int_vars[30] = 0;
  int_vars[31] = 0;
  int_vars[32] = 0;
  int_vars[33] = 0;
L3: // INIT_MULNUM_INT
  int_vars[34] = 0;
  int_vars[35] = 0;
  int_vars[36] = 0;
  int_vars[37] = 0;
  int_vars[38] = 0;
  int_vars[39] = 0;
  int_vars[40] = 0;
  int_vars[41] = 0;
  int_vars[42] = 0;
  int_vars[43] = 0;
  int_vars[44] = 0;
  int_vars[45] = 0;
  int_vars[46] = 0;
  int_vars[47] = 0;
  int_vars[48] = 0;
  int_vars[49] = 0;
L4: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[50] = *(int32_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Value";
    const char* sub_name = "value_max_fields_int";
    const char* file = "TestCase/Value.spvm";
    int32_t line = 249;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L268;
  }
L6: // MULNUM_SET_FIELD_INT
  int_vars[1] = int_vars[50];
L7: // MOVE_CONSTANT_INT
  int_vars[50] = 21;
L8: // MULNUM_SET_FIELD_INT
  int_vars[2] = int_vars[50];
L9: // MOVE_CONSTANT_INT
  int_vars[50] = 31;
L10: // MULNUM_SET_FIELD_INT
  int_vars[3] = int_vars[50];
L11: // MOVE_CONSTANT_INT
  int_vars[50] = 41;
L12: // MULNUM_SET_FIELD_INT
  int_vars[4] = int_vars[50];
L13: // MOVE_CONSTANT_INT
  int_vars[50] = 12;
L14: // MULNUM_SET_FIELD_INT
  int_vars[5] = int_vars[50];
L15: // MOVE_CONSTANT_INT
  int_vars[50] = 22;
L16: // MULNUM_SET_FIELD_INT
  int_vars[6] = int_vars[50];
L17: // MOVE_CONSTANT_INT
  int_vars[50] = 32;
L18: // MULNUM_SET_FIELD_INT
  int_vars[7] = int_vars[50];
L19: // MOVE_CONSTANT_INT
  int_vars[50] = 42;
L20: // MULNUM_SET_FIELD_INT
  int_vars[8] = int_vars[50];
L21: // MOVE_CONSTANT_INT
  int_vars[50] = 13;
L22: // MULNUM_SET_FIELD_INT
  int_vars[9] = int_vars[50];
L23: // MOVE_CONSTANT_INT
  int_vars[50] = 23;
L24: // MULNUM_SET_FIELD_INT
  int_vars[10] = int_vars[50];
L25: // MOVE_CONSTANT_INT
  int_vars[50] = 33;
L26: // MULNUM_SET_FIELD_INT
  int_vars[11] = int_vars[50];
L27: // MOVE_CONSTANT_INT
  int_vars[50] = 43;
L28: // MULNUM_SET_FIELD_INT
  int_vars[12] = int_vars[50];
L29: // MOVE_CONSTANT_INT
  int_vars[50] = 14;
L30: // MULNUM_SET_FIELD_INT
  int_vars[13] = int_vars[50];
L31: // MOVE_CONSTANT_INT
  int_vars[50] = 24;
L32: // MULNUM_SET_FIELD_INT
  int_vars[14] = int_vars[50];
L33: // MOVE_CONSTANT_INT
  int_vars[50] = 34;
L34: // MULNUM_SET_FIELD_INT
  int_vars[15] = int_vars[50];
L35: // MOVE_CONSTANT_INT
  int_vars[50] = 44;
L36: // MULNUM_SET_FIELD_INT
  int_vars[16] = int_vars[50];
L37: // MOVE_CONSTANT_INT
  int_vars[50] = 111;
L38: // MULNUM_SET_FIELD_INT
  int_vars[18] = int_vars[50];
L39: // MOVE_CONSTANT_INT
  int_vars[50] = 121;
L40: // MULNUM_SET_FIELD_INT
  int_vars[19] = int_vars[50];
L41: // MOVE_CONSTANT_INT
  int_vars[50] = 131;
L42: // MULNUM_SET_FIELD_INT
  int_vars[20] = int_vars[50];
L43: // MOVE_CONSTANT_INT
  int_vars[50] = 141;
L44: // MULNUM_SET_FIELD_INT
  int_vars[21] = int_vars[50];
L45: // MOVE_CONSTANT_INT
  int_vars[50] = 112;
L46: // MULNUM_SET_FIELD_INT
  int_vars[22] = int_vars[50];
L47: // MOVE_CONSTANT_INT
  int_vars[50] = 122;
L48: // MULNUM_SET_FIELD_INT
  int_vars[23] = int_vars[50];
L49: // MOVE_CONSTANT_INT
  int_vars[50] = 132;
L50: // MULNUM_SET_FIELD_INT
  int_vars[24] = int_vars[50];
L51: // MOVE_CONSTANT_INT
  int_vars[50] = 142;
L52: // MULNUM_SET_FIELD_INT
  int_vars[25] = int_vars[50];
L53: // MOVE_CONSTANT_INT
  int_vars[50] = 113;
L54: // MULNUM_SET_FIELD_INT
  int_vars[26] = int_vars[50];
L55: // MOVE_CONSTANT_INT
  int_vars[50] = 123;
L56: // MULNUM_SET_FIELD_INT
  int_vars[27] = int_vars[50];
L57: // MOVE_CONSTANT_INT
  int_vars[50] = 133;
L58: // MULNUM_SET_FIELD_INT
  int_vars[28] = int_vars[50];
L59: // MOVE_CONSTANT_INT
  int_vars[50] = 143;
L60: // MULNUM_SET_FIELD_INT
  int_vars[29] = int_vars[50];
L61: // MOVE_CONSTANT_INT
  int_vars[50] = 114;
L62: // MULNUM_SET_FIELD_INT
  int_vars[30] = int_vars[50];
L63: // MOVE_CONSTANT_INT
  int_vars[50] = 124;
L64: // MULNUM_SET_FIELD_INT
  int_vars[31] = int_vars[50];
L65: // MOVE_CONSTANT_INT
  int_vars[50] = 134;
L66: // MULNUM_SET_FIELD_INT
  int_vars[32] = int_vars[50];
L67: // MOVE_CONSTANT_INT
  int_vars[50] = 144;
L68: // MULNUM_SET_FIELD_INT
  int_vars[33] = int_vars[50];
L69: // MULNUM_GET_FIELD_INT
  int_vars[50] = int_vars[1];
L70: // MULNUM_GET_FIELD_INT
  int_vars[51] = int_vars[18];
L71: // ADD_INT
  int_vars[52] = int_vars[50] + int_vars[51];
L72: // MULNUM_SET_FIELD_INT
  int_vars[34] = int_vars[52];
L73: // MULNUM_GET_FIELD_INT
  int_vars[50] = int_vars[2];
L74: // MULNUM_GET_FIELD_INT
  int_vars[51] = int_vars[19];
L75: // ADD_INT
  int_vars[52] = int_vars[50] + int_vars[51];
L76: // MULNUM_SET_FIELD_INT
  int_vars[35] = int_vars[52];
L77: // MULNUM_GET_FIELD_INT
  int_vars[50] = int_vars[3];
L78: // MULNUM_GET_FIELD_INT
  int_vars[51] = int_vars[20];
L79: // ADD_INT
  int_vars[52] = int_vars[50] + int_vars[51];
L80: // MULNUM_SET_FIELD_INT
  int_vars[36] = int_vars[52];
L81: // MULNUM_GET_FIELD_INT
  int_vars[50] = int_vars[4];
L82: // MULNUM_GET_FIELD_INT
  int_vars[51] = int_vars[21];
L83: // ADD_INT
  int_vars[52] = int_vars[50] + int_vars[51];
L84: // MULNUM_SET_FIELD_INT
  int_vars[37] = int_vars[52];
L85: // MULNUM_GET_FIELD_INT
  int_vars[50] = int_vars[5];
L86: // MULNUM_GET_FIELD_INT
  int_vars[51] = int_vars[22];
L87: // ADD_INT
  int_vars[52] = int_vars[50] + int_vars[51];
L88: // MULNUM_SET_FIELD_INT
  int_vars[38] = int_vars[52];
L89: // MULNUM_GET_FIELD_INT
  int_vars[50] = int_vars[6];
L90: // MULNUM_GET_FIELD_INT
  int_vars[51] = int_vars[23];
L91: // ADD_INT
  int_vars[52] = int_vars[50] + int_vars[51];
L92: // MULNUM_SET_FIELD_INT
  int_vars[39] = int_vars[52];
L93: // MULNUM_GET_FIELD_INT
  int_vars[50] = int_vars[7];
L94: // MULNUM_GET_FIELD_INT
  int_vars[51] = int_vars[24];
L95: // ADD_INT
  int_vars[52] = int_vars[50] + int_vars[51];
L96: // MULNUM_SET_FIELD_INT
  int_vars[40] = int_vars[52];
L97: // MULNUM_GET_FIELD_INT
  int_vars[50] = int_vars[8];
L98: // MULNUM_GET_FIELD_INT
  int_vars[51] = int_vars[25];
L99: // ADD_INT
  int_vars[52] = int_vars[50] + int_vars[51];
L100: // MULNUM_SET_FIELD_INT
  int_vars[41] = int_vars[52];
L101: // MULNUM_GET_FIELD_INT
  int_vars[50] = int_vars[9];
L102: // MULNUM_GET_FIELD_INT
  int_vars[51] = int_vars[26];
L103: // ADD_INT
  int_vars[52] = int_vars[50] + int_vars[51];
L104: // MULNUM_SET_FIELD_INT
  int_vars[42] = int_vars[52];
L105: // MULNUM_GET_FIELD_INT
  int_vars[50] = int_vars[10];
L106: // MULNUM_GET_FIELD_INT
  int_vars[51] = int_vars[27];
L107: // ADD_INT
  int_vars[52] = int_vars[50] + int_vars[51];
L108: // MULNUM_SET_FIELD_INT
  int_vars[43] = int_vars[52];
L109: // MULNUM_GET_FIELD_INT
  int_vars[50] = int_vars[11];
L110: // MULNUM_GET_FIELD_INT
  int_vars[51] = int_vars[28];
L111: // ADD_INT
  int_vars[52] = int_vars[50] + int_vars[51];
L112: // MULNUM_SET_FIELD_INT
  int_vars[44] = int_vars[52];
L113: // MULNUM_GET_FIELD_INT
  int_vars[50] = int_vars[12];
L114: // MULNUM_GET_FIELD_INT
  int_vars[51] = int_vars[29];
L115: // ADD_INT
  int_vars[52] = int_vars[50] + int_vars[51];
L116: // MULNUM_SET_FIELD_INT
  int_vars[45] = int_vars[52];
L117: // MULNUM_GET_FIELD_INT
  int_vars[50] = int_vars[13];
L118: // MULNUM_GET_FIELD_INT
  int_vars[51] = int_vars[30];
L119: // ADD_INT
  int_vars[52] = int_vars[50] + int_vars[51];
L120: // MULNUM_SET_FIELD_INT
  int_vars[46] = int_vars[52];
L121: // MULNUM_GET_FIELD_INT
  int_vars[50] = int_vars[14];
L122: // MULNUM_GET_FIELD_INT
  int_vars[51] = int_vars[31];
L123: // ADD_INT
  int_vars[52] = int_vars[50] + int_vars[51];
L124: // MULNUM_SET_FIELD_INT
  int_vars[47] = int_vars[52];
L125: // MULNUM_GET_FIELD_INT
  int_vars[50] = int_vars[15];
L126: // MULNUM_GET_FIELD_INT
  int_vars[51] = int_vars[32];
L127: // ADD_INT
  int_vars[52] = int_vars[50] + int_vars[51];
L128: // MULNUM_SET_FIELD_INT
  int_vars[48] = int_vars[52];
L129: // MULNUM_GET_FIELD_INT
  int_vars[50] = int_vars[16];
L130: // MULNUM_GET_FIELD_INT
  int_vars[51] = int_vars[33];
L131: // ADD_INT
  int_vars[52] = int_vars[50] + int_vars[51];
L132: // MULNUM_SET_FIELD_INT
  int_vars[49] = int_vars[52];
L133: // MULNUM_GET_FIELD_INT
  int_vars[50] = int_vars[34];
L134: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[51] = *(int32_t*)&stack[0];
    }
  }
L135: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Value";
    const char* sub_name = "value_max_fields_int";
    const char* file = "TestCase/Value.spvm";
    int32_t line = 309;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L268;
  }
L136: // MOVE_CONSTANT_INT
  int_vars[52] = 111;
L137: // ADD_INT
  int_vars[53] = int_vars[51] + int_vars[52];
L138: // EQ_INT
  int_vars[0] = (int_vars[50] == int_vars[53]);
L139: // BOOL_INT
  int_vars[0] = int_vars[0];
L140: // IF_NE_ZERO
  if (int_vars[0]) { goto L144; }
L141: // MOVE_CONSTANT_INT
  int_vars[50] = 0;
L142: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[50];
  goto L268;
L143: // GOTO
  goto L144;
L144: // MULNUM_GET_FIELD_INT
  int_vars[52] = int_vars[35];
L145: // MOVE_CONSTANT_INT
  int_vars[53] = 142;
L146: // EQ_INT
  int_vars[0] = (int_vars[52] == int_vars[53]);
L147: // BOOL_INT
  int_vars[0] = int_vars[0];
L148: // IF_NE_ZERO
  if (int_vars[0]) { goto L152; }
L149: // MOVE_CONSTANT_INT
  int_vars[50] = 0;
L150: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[50];
  goto L268;
L151: // GOTO
  goto L152;
L152: // MULNUM_GET_FIELD_INT
  int_vars[52] = int_vars[36];
L153: // MOVE_CONSTANT_INT
  int_vars[53] = 162;
L154: // EQ_INT
  int_vars[0] = (int_vars[52] == int_vars[53]);
L155: // BOOL_INT
  int_vars[0] = int_vars[0];
L156: // IF_NE_ZERO
  if (int_vars[0]) { goto L160; }
L157: // MOVE_CONSTANT_INT
  int_vars[50] = 0;
L158: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[50];
  goto L268;
L159: // GOTO
  goto L160;
L160: // MULNUM_GET_FIELD_INT
  int_vars[52] = int_vars[37];
L161: // MOVE_CONSTANT_INT
  int_vars[53] = 182;
L162: // EQ_INT
  int_vars[0] = (int_vars[52] == int_vars[53]);
L163: // BOOL_INT
  int_vars[0] = int_vars[0];
L164: // IF_NE_ZERO
  if (int_vars[0]) { goto L168; }
L165: // MOVE_CONSTANT_INT
  int_vars[50] = 0;
L166: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[50];
  goto L268;
L167: // GOTO
  goto L168;
L168: // MULNUM_GET_FIELD_INT
  int_vars[52] = int_vars[38];
L169: // MOVE_CONSTANT_INT
  int_vars[53] = 124;
L170: // EQ_INT
  int_vars[0] = (int_vars[52] == int_vars[53]);
L171: // BOOL_INT
  int_vars[0] = int_vars[0];
L172: // IF_NE_ZERO
  if (int_vars[0]) { goto L176; }
L173: // MOVE_CONSTANT_INT
  int_vars[50] = 0;
L174: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[50];
  goto L268;
L175: // GOTO
  goto L176;
L176: // MULNUM_GET_FIELD_INT
  int_vars[52] = int_vars[39];
L177: // MOVE_CONSTANT_INT
  int_vars[53] = 144;
L178: // EQ_INT
  int_vars[0] = (int_vars[52] == int_vars[53]);
L179: // BOOL_INT
  int_vars[0] = int_vars[0];
L180: // IF_NE_ZERO
  if (int_vars[0]) { goto L184; }
L181: // MOVE_CONSTANT_INT
  int_vars[50] = 0;
L182: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[50];
  goto L268;
L183: // GOTO
  goto L184;
L184: // MULNUM_GET_FIELD_INT
  int_vars[52] = int_vars[40];
L185: // MOVE_CONSTANT_INT
  int_vars[53] = 164;
L186: // EQ_INT
  int_vars[0] = (int_vars[52] == int_vars[53]);
L187: // BOOL_INT
  int_vars[0] = int_vars[0];
L188: // IF_NE_ZERO
  if (int_vars[0]) { goto L192; }
L189: // MOVE_CONSTANT_INT
  int_vars[50] = 0;
L190: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[50];
  goto L268;
L191: // GOTO
  goto L192;
L192: // MULNUM_GET_FIELD_INT
  int_vars[52] = int_vars[41];
L193: // MOVE_CONSTANT_INT
  int_vars[53] = 184;
L194: // EQ_INT
  int_vars[0] = (int_vars[52] == int_vars[53]);
L195: // BOOL_INT
  int_vars[0] = int_vars[0];
L196: // IF_NE_ZERO
  if (int_vars[0]) { goto L200; }
L197: // MOVE_CONSTANT_INT
  int_vars[50] = 0;
L198: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[50];
  goto L268;
L199: // GOTO
  goto L200;
L200: // MULNUM_GET_FIELD_INT
  int_vars[52] = int_vars[42];
L201: // MOVE_CONSTANT_INT
  int_vars[53] = 126;
L202: // EQ_INT
  int_vars[0] = (int_vars[52] == int_vars[53]);
L203: // BOOL_INT
  int_vars[0] = int_vars[0];
L204: // IF_NE_ZERO
  if (int_vars[0]) { goto L208; }
L205: // MOVE_CONSTANT_INT
  int_vars[50] = 0;
L206: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[50];
  goto L268;
L207: // GOTO
  goto L208;
L208: // MULNUM_GET_FIELD_INT
  int_vars[52] = int_vars[43];
L209: // MOVE_CONSTANT_INT
  int_vars[53] = 146;
L210: // EQ_INT
  int_vars[0] = (int_vars[52] == int_vars[53]);
L211: // BOOL_INT
  int_vars[0] = int_vars[0];
L212: // IF_NE_ZERO
  if (int_vars[0]) { goto L216; }
L213: // MOVE_CONSTANT_INT
  int_vars[50] = 0;
L214: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[50];
  goto L268;
L215: // GOTO
  goto L216;
L216: // MULNUM_GET_FIELD_INT
  int_vars[52] = int_vars[44];
L217: // MOVE_CONSTANT_INT
  int_vars[53] = 166;
L218: // EQ_INT
  int_vars[0] = (int_vars[52] == int_vars[53]);
L219: // BOOL_INT
  int_vars[0] = int_vars[0];
L220: // IF_NE_ZERO
  if (int_vars[0]) { goto L224; }
L221: // MOVE_CONSTANT_INT
  int_vars[50] = 0;
L222: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[50];
  goto L268;
L223: // GOTO
  goto L224;
L224: // MULNUM_GET_FIELD_INT
  int_vars[52] = int_vars[45];
L225: // MOVE_CONSTANT_INT
  int_vars[53] = 186;
L226: // EQ_INT
  int_vars[0] = (int_vars[52] == int_vars[53]);
L227: // BOOL_INT
  int_vars[0] = int_vars[0];
L228: // IF_NE_ZERO
  if (int_vars[0]) { goto L232; }
L229: // MOVE_CONSTANT_INT
  int_vars[50] = 0;
L230: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[50];
  goto L268;
L231: // GOTO
  goto L232;
L232: // MULNUM_GET_FIELD_INT
  int_vars[52] = int_vars[37];
L233: // MOVE_CONSTANT_INT
  int_vars[53] = 182;
L234: // EQ_INT
  int_vars[0] = (int_vars[52] == int_vars[53]);
L235: // BOOL_INT
  int_vars[0] = int_vars[0];
L236: // IF_NE_ZERO
  if (int_vars[0]) { goto L240; }
L237: // MOVE_CONSTANT_INT
  int_vars[50] = 0;
L238: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[50];
  goto L268;
L239: // GOTO
  goto L240;
L240: // MULNUM_GET_FIELD_INT
  int_vars[52] = int_vars[41];
L241: // MOVE_CONSTANT_INT
  int_vars[53] = 184;
L242: // EQ_INT
  int_vars[0] = (int_vars[52] == int_vars[53]);
L243: // BOOL_INT
  int_vars[0] = int_vars[0];
L244: // IF_NE_ZERO
  if (int_vars[0]) { goto L248; }
L245: // MOVE_CONSTANT_INT
  int_vars[50] = 0;
L246: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[50];
  goto L268;
L247: // GOTO
  goto L248;
L248: // MULNUM_GET_FIELD_INT
  int_vars[52] = int_vars[45];
L249: // MOVE_CONSTANT_INT
  int_vars[53] = 186;
L250: // EQ_INT
  int_vars[0] = (int_vars[52] == int_vars[53]);
L251: // BOOL_INT
  int_vars[0] = int_vars[0];
L252: // IF_NE_ZERO
  if (int_vars[0]) { goto L256; }
L253: // MOVE_CONSTANT_INT
  int_vars[50] = 0;
L254: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[50];
  goto L268;
L255: // GOTO
  goto L256;
L256: // MULNUM_GET_FIELD_INT
  int_vars[52] = int_vars[49];
L257: // MOVE_CONSTANT_INT
  int_vars[53] = 188;
L258: // EQ_INT
  int_vars[0] = (int_vars[52] == int_vars[53]);
L259: // BOOL_INT
  int_vars[0] = int_vars[0];
L260: // IF_NE_ZERO
  if (int_vars[0]) { goto L264; }
L261: // MOVE_CONSTANT_INT
  int_vars[50] = 0;
L262: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[50];
  goto L268;
L263: // GOTO
  goto L264;
L264: // MOVE_CONSTANT_INT
  int_vars[52] = 1;
L265: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[52];
  goto L268;
L266: // INIT_INT
  int_vars[54] = 0;
L267: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[54];
  goto L268;
L268: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Value__value_max_fields_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[52];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_LONG
  long_vars[0] = 0;
  long_vars[1] = 0;
  long_vars[2] = 0;
  long_vars[3] = 0;
  long_vars[4] = 0;
  long_vars[5] = 0;
  long_vars[6] = 0;
  long_vars[7] = 0;
  long_vars[8] = 0;
  long_vars[9] = 0;
  long_vars[10] = 0;
  long_vars[11] = 0;
  long_vars[12] = 0;
  long_vars[13] = 0;
  long_vars[14] = 0;
  long_vars[15] = 0;
L2: // INIT_MULNUM_LONG
  long_vars[16] = 0;
  long_vars[17] = 0;
  long_vars[18] = 0;
  long_vars[19] = 0;
  long_vars[20] = 0;
  long_vars[21] = 0;
  long_vars[22] = 0;
  long_vars[23] = 0;
  long_vars[24] = 0;
  long_vars[25] = 0;
  long_vars[26] = 0;
  long_vars[27] = 0;
  long_vars[28] = 0;
  long_vars[29] = 0;
  long_vars[30] = 0;
  long_vars[31] = 0;
L3: // INIT_MULNUM_LONG
  long_vars[32] = 0;
  long_vars[33] = 0;
  long_vars[34] = 0;
  long_vars[35] = 0;
  long_vars[36] = 0;
  long_vars[37] = 0;
  long_vars[38] = 0;
  long_vars[39] = 0;
  long_vars[40] = 0;
  long_vars[41] = 0;
  long_vars[42] = 0;
  long_vars[43] = 0;
  long_vars[44] = 0;
  long_vars[45] = 0;
  long_vars[46] = 0;
  long_vars[47] = 0;
L4: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[48] = *(int64_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Value";
    const char* sub_name = "value_max_fields_long";
    const char* file = "TestCase/Value.spvm";
    int32_t line = 366;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L315;
  }
L6: // MULNUM_SET_FIELD_LONG
  long_vars[0] = long_vars[48];
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 21;
L8: // CONVERT_INT_TO_LONG
  long_vars[48] = (int64_t)int_vars[2];
L9: // MULNUM_SET_FIELD_LONG
  long_vars[1] = long_vars[48];
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 31;
L11: // CONVERT_INT_TO_LONG
  long_vars[48] = (int64_t)int_vars[2];
L12: // MULNUM_SET_FIELD_LONG
  long_vars[2] = long_vars[48];
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 41;
L14: // CONVERT_INT_TO_LONG
  long_vars[48] = (int64_t)int_vars[2];
L15: // MULNUM_SET_FIELD_LONG
  long_vars[3] = long_vars[48];
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 12;
L17: // CONVERT_INT_TO_LONG
  long_vars[48] = (int64_t)int_vars[2];
L18: // MULNUM_SET_FIELD_LONG
  long_vars[4] = long_vars[48];
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 22;
L20: // CONVERT_INT_TO_LONG
  long_vars[48] = (int64_t)int_vars[2];
L21: // MULNUM_SET_FIELD_LONG
  long_vars[5] = long_vars[48];
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 32;
L23: // CONVERT_INT_TO_LONG
  long_vars[48] = (int64_t)int_vars[2];
L24: // MULNUM_SET_FIELD_LONG
  long_vars[6] = long_vars[48];
L25: // MOVE_CONSTANT_INT
  int_vars[2] = 42;
L26: // CONVERT_INT_TO_LONG
  long_vars[48] = (int64_t)int_vars[2];
L27: // MULNUM_SET_FIELD_LONG
  long_vars[7] = long_vars[48];
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 13;
L29: // CONVERT_INT_TO_LONG
  long_vars[48] = (int64_t)int_vars[2];
L30: // MULNUM_SET_FIELD_LONG
  long_vars[8] = long_vars[48];
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 23;
L32: // CONVERT_INT_TO_LONG
  long_vars[48] = (int64_t)int_vars[2];
L33: // MULNUM_SET_FIELD_LONG
  long_vars[9] = long_vars[48];
L34: // MOVE_CONSTANT_INT
  int_vars[2] = 33;
L35: // CONVERT_INT_TO_LONG
  long_vars[48] = (int64_t)int_vars[2];
L36: // MULNUM_SET_FIELD_LONG
  long_vars[10] = long_vars[48];
L37: // MOVE_CONSTANT_INT
  int_vars[2] = 43;
L38: // CONVERT_INT_TO_LONG
  long_vars[48] = (int64_t)int_vars[2];
L39: // MULNUM_SET_FIELD_LONG
  long_vars[11] = long_vars[48];
L40: // MOVE_CONSTANT_INT
  int_vars[2] = 14;
L41: // CONVERT_INT_TO_LONG
  long_vars[48] = (int64_t)int_vars[2];
L42: // MULNUM_SET_FIELD_LONG
  long_vars[12] = long_vars[48];
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 24;
L44: // CONVERT_INT_TO_LONG
  long_vars[48] = (int64_t)int_vars[2];
L45: // MULNUM_SET_FIELD_LONG
  long_vars[13] = long_vars[48];
L46: // MOVE_CONSTANT_INT
  int_vars[2] = 34;
L47: // CONVERT_INT_TO_LONG
  long_vars[48] = (int64_t)int_vars[2];
L48: // MULNUM_SET_FIELD_LONG
  long_vars[14] = long_vars[48];
L49: // MOVE_CONSTANT_INT
  int_vars[2] = 44;
L50: // CONVERT_INT_TO_LONG
  long_vars[48] = (int64_t)int_vars[2];
L51: // MULNUM_SET_FIELD_LONG
  long_vars[15] = long_vars[48];
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 111;
L53: // CONVERT_INT_TO_LONG
  long_vars[48] = (int64_t)int_vars[2];
L54: // MULNUM_SET_FIELD_LONG
  long_vars[16] = long_vars[48];
L55: // MOVE_CONSTANT_INT
  int_vars[2] = 121;
L56: // CONVERT_INT_TO_LONG
  long_vars[48] = (int64_t)int_vars[2];
L57: // MULNUM_SET_FIELD_LONG
  long_vars[17] = long_vars[48];
L58: // MOVE_CONSTANT_INT
  int_vars[2] = 131;
L59: // CONVERT_INT_TO_LONG
  long_vars[48] = (int64_t)int_vars[2];
L60: // MULNUM_SET_FIELD_LONG
  long_vars[18] = long_vars[48];
L61: // MOVE_CONSTANT_INT
  int_vars[2] = 141;
L62: // CONVERT_INT_TO_LONG
  long_vars[48] = (int64_t)int_vars[2];
L63: // MULNUM_SET_FIELD_LONG
  long_vars[19] = long_vars[48];
L64: // MOVE_CONSTANT_INT
  int_vars[2] = 112;
L65: // CONVERT_INT_TO_LONG
  long_vars[48] = (int64_t)int_vars[2];
L66: // MULNUM_SET_FIELD_LONG
  long_vars[20] = long_vars[48];
L67: // MOVE_CONSTANT_INT
  int_vars[2] = 122;
L68: // CONVERT_INT_TO_LONG
  long_vars[48] = (int64_t)int_vars[2];
L69: // MULNUM_SET_FIELD_LONG
  long_vars[21] = long_vars[48];
L70: // MOVE_CONSTANT_INT
  int_vars[2] = 132;
L71: // CONVERT_INT_TO_LONG
  long_vars[48] = (int64_t)int_vars[2];
L72: // MULNUM_SET_FIELD_LONG
  long_vars[22] = long_vars[48];
L73: // MOVE_CONSTANT_INT
  int_vars[2] = 142;
L74: // CONVERT_INT_TO_LONG
  long_vars[48] = (int64_t)int_vars[2];
L75: // MULNUM_SET_FIELD_LONG
  long_vars[23] = long_vars[48];
L76: // MOVE_CONSTANT_INT
  int_vars[2] = 113;
L77: // CONVERT_INT_TO_LONG
  long_vars[48] = (int64_t)int_vars[2];
L78: // MULNUM_SET_FIELD_LONG
  long_vars[24] = long_vars[48];
L79: // MOVE_CONSTANT_INT
  int_vars[2] = 123;
L80: // CONVERT_INT_TO_LONG
  long_vars[48] = (int64_t)int_vars[2];
L81: // MULNUM_SET_FIELD_LONG
  long_vars[25] = long_vars[48];
L82: // MOVE_CONSTANT_INT
  int_vars[2] = 133;
L83: // CONVERT_INT_TO_LONG
  long_vars[48] = (int64_t)int_vars[2];
L84: // MULNUM_SET_FIELD_LONG
  long_vars[26] = long_vars[48];
L85: // MOVE_CONSTANT_INT
  int_vars[2] = 143;
L86: // CONVERT_INT_TO_LONG
  long_vars[48] = (int64_t)int_vars[2];
L87: // MULNUM_SET_FIELD_LONG
  long_vars[27] = long_vars[48];
L88: // MOVE_CONSTANT_INT
  int_vars[2] = 114;
L89: // CONVERT_INT_TO_LONG
  long_vars[48] = (int64_t)int_vars[2];
L90: // MULNUM_SET_FIELD_LONG
  long_vars[28] = long_vars[48];
L91: // MOVE_CONSTANT_INT
  int_vars[2] = 124;
L92: // CONVERT_INT_TO_LONG
  long_vars[48] = (int64_t)int_vars[2];
L93: // MULNUM_SET_FIELD_LONG
  long_vars[29] = long_vars[48];
L94: // MOVE_CONSTANT_INT
  int_vars[2] = 134;
L95: // CONVERT_INT_TO_LONG
  long_vars[48] = (int64_t)int_vars[2];
L96: // MULNUM_SET_FIELD_LONG
  long_vars[30] = long_vars[48];
L97: // MOVE_CONSTANT_INT
  int_vars[2] = 144;
L98: // CONVERT_INT_TO_LONG
  long_vars[48] = (int64_t)int_vars[2];
L99: // MULNUM_SET_FIELD_LONG
  long_vars[31] = long_vars[48];
L100: // MULNUM_GET_FIELD_LONG
  long_vars[48] = long_vars[0];
L101: // MULNUM_GET_FIELD_LONG
  long_vars[49] = long_vars[16];
L102: // ADD_LONG
  long_vars[50] = long_vars[48] + long_vars[49];
L103: // MULNUM_SET_FIELD_LONG
  long_vars[32] = long_vars[50];
L104: // MULNUM_GET_FIELD_LONG
  long_vars[48] = long_vars[1];
L105: // MULNUM_GET_FIELD_LONG
  long_vars[49] = long_vars[17];
L106: // ADD_LONG
  long_vars[50] = long_vars[48] + long_vars[49];
L107: // MULNUM_SET_FIELD_LONG
  long_vars[33] = long_vars[50];
L108: // MULNUM_GET_FIELD_LONG
  long_vars[48] = long_vars[2];
L109: // MULNUM_GET_FIELD_LONG
  long_vars[49] = long_vars[18];
L110: // ADD_LONG
  long_vars[50] = long_vars[48] + long_vars[49];
L111: // MULNUM_SET_FIELD_LONG
  long_vars[34] = long_vars[50];
L112: // MULNUM_GET_FIELD_LONG
  long_vars[48] = long_vars[3];
L113: // MULNUM_GET_FIELD_LONG
  long_vars[49] = long_vars[19];
L114: // ADD_LONG
  long_vars[50] = long_vars[48] + long_vars[49];
L115: // MULNUM_SET_FIELD_LONG
  long_vars[35] = long_vars[50];
L116: // MULNUM_GET_FIELD_LONG
  long_vars[48] = long_vars[4];
L117: // MULNUM_GET_FIELD_LONG
  long_vars[49] = long_vars[20];
L118: // ADD_LONG
  long_vars[50] = long_vars[48] + long_vars[49];
L119: // MULNUM_SET_FIELD_LONG
  long_vars[36] = long_vars[50];
L120: // MULNUM_GET_FIELD_LONG
  long_vars[48] = long_vars[5];
L121: // MULNUM_GET_FIELD_LONG
  long_vars[49] = long_vars[21];
L122: // ADD_LONG
  long_vars[50] = long_vars[48] + long_vars[49];
L123: // MULNUM_SET_FIELD_LONG
  long_vars[37] = long_vars[50];
L124: // MULNUM_GET_FIELD_LONG
  long_vars[48] = long_vars[6];
L125: // MULNUM_GET_FIELD_LONG
  long_vars[49] = long_vars[22];
L126: // ADD_LONG
  long_vars[50] = long_vars[48] + long_vars[49];
L127: // MULNUM_SET_FIELD_LONG
  long_vars[38] = long_vars[50];
L128: // MULNUM_GET_FIELD_LONG
  long_vars[48] = long_vars[7];
L129: // MULNUM_GET_FIELD_LONG
  long_vars[49] = long_vars[23];
L130: // ADD_LONG
  long_vars[50] = long_vars[48] + long_vars[49];
L131: // MULNUM_SET_FIELD_LONG
  long_vars[39] = long_vars[50];
L132: // MULNUM_GET_FIELD_LONG
  long_vars[48] = long_vars[8];
L133: // MULNUM_GET_FIELD_LONG
  long_vars[49] = long_vars[24];
L134: // ADD_LONG
  long_vars[50] = long_vars[48] + long_vars[49];
L135: // MULNUM_SET_FIELD_LONG
  long_vars[40] = long_vars[50];
L136: // MULNUM_GET_FIELD_LONG
  long_vars[48] = long_vars[9];
L137: // MULNUM_GET_FIELD_LONG
  long_vars[49] = long_vars[25];
L138: // ADD_LONG
  long_vars[50] = long_vars[48] + long_vars[49];
L139: // MULNUM_SET_FIELD_LONG
  long_vars[41] = long_vars[50];
L140: // MULNUM_GET_FIELD_LONG
  long_vars[48] = long_vars[10];
L141: // MULNUM_GET_FIELD_LONG
  long_vars[49] = long_vars[26];
L142: // ADD_LONG
  long_vars[50] = long_vars[48] + long_vars[49];
L143: // MULNUM_SET_FIELD_LONG
  long_vars[42] = long_vars[50];
L144: // MULNUM_GET_FIELD_LONG
  long_vars[48] = long_vars[11];
L145: // MULNUM_GET_FIELD_LONG
  long_vars[49] = long_vars[27];
L146: // ADD_LONG
  long_vars[50] = long_vars[48] + long_vars[49];
L147: // MULNUM_SET_FIELD_LONG
  long_vars[43] = long_vars[50];
L148: // MULNUM_GET_FIELD_LONG
  long_vars[48] = long_vars[12];
L149: // MULNUM_GET_FIELD_LONG
  long_vars[49] = long_vars[28];
L150: // ADD_LONG
  long_vars[50] = long_vars[48] + long_vars[49];
L151: // MULNUM_SET_FIELD_LONG
  long_vars[44] = long_vars[50];
L152: // MULNUM_GET_FIELD_LONG
  long_vars[48] = long_vars[13];
L153: // MULNUM_GET_FIELD_LONG
  long_vars[49] = long_vars[29];
L154: // ADD_LONG
  long_vars[50] = long_vars[48] + long_vars[49];
L155: // MULNUM_SET_FIELD_LONG
  long_vars[45] = long_vars[50];
L156: // MULNUM_GET_FIELD_LONG
  long_vars[48] = long_vars[14];
L157: // MULNUM_GET_FIELD_LONG
  long_vars[49] = long_vars[30];
L158: // ADD_LONG
  long_vars[50] = long_vars[48] + long_vars[49];
L159: // MULNUM_SET_FIELD_LONG
  long_vars[46] = long_vars[50];
L160: // MULNUM_GET_FIELD_LONG
  long_vars[48] = long_vars[15];
L161: // MULNUM_GET_FIELD_LONG
  long_vars[49] = long_vars[31];
L162: // ADD_LONG
  long_vars[50] = long_vars[48] + long_vars[49];
L163: // MULNUM_SET_FIELD_LONG
  long_vars[47] = long_vars[50];
L164: // MULNUM_GET_FIELD_LONG
  long_vars[48] = long_vars[32];
L165: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[49] = *(int64_t*)&stack[0];
    }
  }
L166: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Value";
    const char* sub_name = "value_max_fields_long";
    const char* file = "TestCase/Value.spvm";
    int32_t line = 426;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L315;
  }
L167: // MOVE_CONSTANT_INT
  int_vars[2] = 111;
L168: // CONVERT_INT_TO_LONG
  long_vars[50] = (int64_t)int_vars[2];
L169: // ADD_LONG
  long_vars[51] = long_vars[49] + long_vars[50];
L170: // EQ_LONG
  int_vars[0] = (long_vars[48] == long_vars[51]);
L171: // BOOL_INT
  int_vars[0] = int_vars[0];
L172: // IF_NE_ZERO
  if (int_vars[0]) { goto L176; }
L173: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L174: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L175: // GOTO
  goto L176;
L176: // MULNUM_GET_FIELD_LONG
  long_vars[48] = long_vars[33];
L177: // MOVE_CONSTANT_INT
  int_vars[4] = 142;
L178: // CONVERT_INT_TO_LONG
  long_vars[49] = (int64_t)int_vars[4];
L179: // EQ_LONG
  int_vars[0] = (long_vars[48] == long_vars[49]);
L180: // BOOL_INT
  int_vars[0] = int_vars[0];
L181: // IF_NE_ZERO
  if (int_vars[0]) { goto L185; }
L182: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L183: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L184: // GOTO
  goto L185;
L185: // MULNUM_GET_FIELD_LONG
  long_vars[48] = long_vars[34];
L186: // MOVE_CONSTANT_INT
  int_vars[4] = 162;
L187: // CONVERT_INT_TO_LONG
  long_vars[49] = (int64_t)int_vars[4];
L188: // EQ_LONG
  int_vars[0] = (long_vars[48] == long_vars[49]);
L189: // BOOL_INT
  int_vars[0] = int_vars[0];
L190: // IF_NE_ZERO
  if (int_vars[0]) { goto L194; }
L191: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L192: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L193: // GOTO
  goto L194;
L194: // MULNUM_GET_FIELD_LONG
  long_vars[48] = long_vars[35];
L195: // MOVE_CONSTANT_INT
  int_vars[4] = 182;
L196: // CONVERT_INT_TO_LONG
  long_vars[49] = (int64_t)int_vars[4];
L197: // EQ_LONG
  int_vars[0] = (long_vars[48] == long_vars[49]);
L198: // BOOL_INT
  int_vars[0] = int_vars[0];
L199: // IF_NE_ZERO
  if (int_vars[0]) { goto L203; }
L200: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L201: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L202: // GOTO
  goto L203;
L203: // MULNUM_GET_FIELD_LONG
  long_vars[48] = long_vars[36];
L204: // MOVE_CONSTANT_INT
  int_vars[4] = 124;
L205: // CONVERT_INT_TO_LONG
  long_vars[49] = (int64_t)int_vars[4];
L206: // EQ_LONG
  int_vars[0] = (long_vars[48] == long_vars[49]);
L207: // BOOL_INT
  int_vars[0] = int_vars[0];
L208: // IF_NE_ZERO
  if (int_vars[0]) { goto L212; }
L209: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L210: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L211: // GOTO
  goto L212;
L212: // MULNUM_GET_FIELD_LONG
  long_vars[48] = long_vars[37];
L213: // MOVE_CONSTANT_INT
  int_vars[4] = 144;
L214: // CONVERT_INT_TO_LONG
  long_vars[49] = (int64_t)int_vars[4];
L215: // EQ_LONG
  int_vars[0] = (long_vars[48] == long_vars[49]);
L216: // BOOL_INT
  int_vars[0] = int_vars[0];
L217: // IF_NE_ZERO
  if (int_vars[0]) { goto L221; }
L218: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L219: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L220: // GOTO
  goto L221;
L221: // MULNUM_GET_FIELD_LONG
  long_vars[48] = long_vars[38];
L222: // MOVE_CONSTANT_INT
  int_vars[4] = 164;
L223: // CONVERT_INT_TO_LONG
  long_vars[49] = (int64_t)int_vars[4];
L224: // EQ_LONG
  int_vars[0] = (long_vars[48] == long_vars[49]);
L225: // BOOL_INT
  int_vars[0] = int_vars[0];
L226: // IF_NE_ZERO
  if (int_vars[0]) { goto L230; }
L227: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L228: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L229: // GOTO
  goto L230;
L230: // MULNUM_GET_FIELD_LONG
  long_vars[48] = long_vars[39];
L231: // MOVE_CONSTANT_INT
  int_vars[4] = 184;
L232: // CONVERT_INT_TO_LONG
  long_vars[49] = (int64_t)int_vars[4];
L233: // EQ_LONG
  int_vars[0] = (long_vars[48] == long_vars[49]);
L234: // BOOL_INT
  int_vars[0] = int_vars[0];
L235: // IF_NE_ZERO
  if (int_vars[0]) { goto L239; }
L236: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L237: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L238: // GOTO
  goto L239;
L239: // MULNUM_GET_FIELD_LONG
  long_vars[48] = long_vars[40];
L240: // MOVE_CONSTANT_INT
  int_vars[4] = 126;
L241: // CONVERT_INT_TO_LONG
  long_vars[49] = (int64_t)int_vars[4];
L242: // EQ_LONG
  int_vars[0] = (long_vars[48] == long_vars[49]);
L243: // BOOL_INT
  int_vars[0] = int_vars[0];
L244: // IF_NE_ZERO
  if (int_vars[0]) { goto L248; }
L245: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L246: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L247: // GOTO
  goto L248;
L248: // MULNUM_GET_FIELD_LONG
  long_vars[48] = long_vars[41];
L249: // MOVE_CONSTANT_INT
  int_vars[4] = 146;
L250: // CONVERT_INT_TO_LONG
  long_vars[49] = (int64_t)int_vars[4];
L251: // EQ_LONG
  int_vars[0] = (long_vars[48] == long_vars[49]);
L252: // BOOL_INT
  int_vars[0] = int_vars[0];
L253: // IF_NE_ZERO
  if (int_vars[0]) { goto L257; }
L254: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L255: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L256: // GOTO
  goto L257;
L257: // MULNUM_GET_FIELD_LONG
  long_vars[48] = long_vars[42];
L258: // MOVE_CONSTANT_INT
  int_vars[4] = 166;
L259: // CONVERT_INT_TO_LONG
  long_vars[49] = (int64_t)int_vars[4];
L260: // EQ_LONG
  int_vars[0] = (long_vars[48] == long_vars[49]);
L261: // BOOL_INT
  int_vars[0] = int_vars[0];
L262: // IF_NE_ZERO
  if (int_vars[0]) { goto L266; }
L263: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L264: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L265: // GOTO
  goto L266;
L266: // MULNUM_GET_FIELD_LONG
  long_vars[48] = long_vars[43];
L267: // MOVE_CONSTANT_INT
  int_vars[4] = 186;
L268: // CONVERT_INT_TO_LONG
  long_vars[49] = (int64_t)int_vars[4];
L269: // EQ_LONG
  int_vars[0] = (long_vars[48] == long_vars[49]);
L270: // BOOL_INT
  int_vars[0] = int_vars[0];
L271: // IF_NE_ZERO
  if (int_vars[0]) { goto L275; }
L272: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L273: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L274: // GOTO
  goto L275;
L275: // MULNUM_GET_FIELD_LONG
  long_vars[48] = long_vars[35];
L276: // MOVE_CONSTANT_INT
  int_vars[4] = 182;
L277: // CONVERT_INT_TO_LONG
  long_vars[49] = (int64_t)int_vars[4];
L278: // EQ_LONG
  int_vars[0] = (long_vars[48] == long_vars[49]);
L279: // BOOL_INT
  int_vars[0] = int_vars[0];
L280: // IF_NE_ZERO
  if (int_vars[0]) { goto L284; }
L281: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L282: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L283: // GOTO
  goto L284;
L284: // MULNUM_GET_FIELD_LONG
  long_vars[48] = long_vars[39];
L285: // MOVE_CONSTANT_INT
  int_vars[4] = 184;
L286: // CONVERT_INT_TO_LONG
  long_vars[49] = (int64_t)int_vars[4];
L287: // EQ_LONG
  int_vars[0] = (long_vars[48] == long_vars[49]);
L288: // BOOL_INT
  int_vars[0] = int_vars[0];
L289: // IF_NE_ZERO
  if (int_vars[0]) { goto L293; }
L290: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L291: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L292: // GOTO
  goto L293;
L293: // MULNUM_GET_FIELD_LONG
  long_vars[48] = long_vars[43];
L294: // MOVE_CONSTANT_INT
  int_vars[4] = 186;
L295: // CONVERT_INT_TO_LONG
  long_vars[49] = (int64_t)int_vars[4];
L296: // EQ_LONG
  int_vars[0] = (long_vars[48] == long_vars[49]);
L297: // BOOL_INT
  int_vars[0] = int_vars[0];
L298: // IF_NE_ZERO
  if (int_vars[0]) { goto L302; }
L299: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L300: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L301: // GOTO
  goto L302;
L302: // MULNUM_GET_FIELD_LONG
  long_vars[48] = long_vars[47];
L303: // MOVE_CONSTANT_INT
  int_vars[4] = 188;
L304: // CONVERT_INT_TO_LONG
  long_vars[49] = (int64_t)int_vars[4];
L305: // EQ_LONG
  int_vars[0] = (long_vars[48] == long_vars[49]);
L306: // BOOL_INT
  int_vars[0] = int_vars[0];
L307: // IF_NE_ZERO
  if (int_vars[0]) { goto L311; }
L308: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L309: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L315;
L310: // GOTO
  goto L311;
L311: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L312: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L315;
L313: // INIT_INT
  int_vars[6] = 0;
L314: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L315;
L315: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Value__value_max_fields_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[51];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // INIT_MULNUM_SHORT
  short_vars[0] = 0;
  short_vars[1] = 0;
  short_vars[2] = 0;
  short_vars[3] = 0;
  short_vars[4] = 0;
  short_vars[5] = 0;
  short_vars[6] = 0;
  short_vars[7] = 0;
  short_vars[8] = 0;
  short_vars[9] = 0;
  short_vars[10] = 0;
  short_vars[11] = 0;
  short_vars[12] = 0;
  short_vars[13] = 0;
  short_vars[14] = 0;
  short_vars[15] = 0;
L2: // INIT_MULNUM_SHORT
  short_vars[16] = 0;
  short_vars[17] = 0;
  short_vars[18] = 0;
  short_vars[19] = 0;
  short_vars[20] = 0;
  short_vars[21] = 0;
  short_vars[22] = 0;
  short_vars[23] = 0;
  short_vars[24] = 0;
  short_vars[25] = 0;
  short_vars[26] = 0;
  short_vars[27] = 0;
  short_vars[28] = 0;
  short_vars[29] = 0;
  short_vars[30] = 0;
  short_vars[31] = 0;
L3: // INIT_MULNUM_SHORT
  short_vars[32] = 0;
  short_vars[33] = 0;
  short_vars[34] = 0;
  short_vars[35] = 0;
  short_vars[36] = 0;
  short_vars[37] = 0;
  short_vars[38] = 0;
  short_vars[39] = 0;
  short_vars[40] = 0;
  short_vars[41] = 0;
  short_vars[42] = 0;
  short_vars[43] = 0;
  short_vars[44] = 0;
  short_vars[45] = 0;
  short_vars[46] = 0;
  short_vars[47] = 0;
L4: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[48] = *(int16_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Value";
    const char* sub_name = "value_max_fields_short";
    const char* file = "TestCase/Value.spvm";
    int32_t line = 132;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L364;
  }
L6: // MULNUM_SET_FIELD_SHORT
  short_vars[0] = short_vars[48];
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 21;
L8: // CONVERT_INT_TO_SHORT
  short_vars[48] = (int16_t)int_vars[2];
L9: // MULNUM_SET_FIELD_SHORT
  short_vars[1] = short_vars[48];
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 31;
L11: // CONVERT_INT_TO_SHORT
  short_vars[48] = (int16_t)int_vars[2];
L12: // MULNUM_SET_FIELD_SHORT
  short_vars[2] = short_vars[48];
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 41;
L14: // CONVERT_INT_TO_SHORT
  short_vars[48] = (int16_t)int_vars[2];
L15: // MULNUM_SET_FIELD_SHORT
  short_vars[3] = short_vars[48];
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 12;
L17: // CONVERT_INT_TO_SHORT
  short_vars[48] = (int16_t)int_vars[2];
L18: // MULNUM_SET_FIELD_SHORT
  short_vars[4] = short_vars[48];
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 22;
L20: // CONVERT_INT_TO_SHORT
  short_vars[48] = (int16_t)int_vars[2];
L21: // MULNUM_SET_FIELD_SHORT
  short_vars[5] = short_vars[48];
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 32;
L23: // CONVERT_INT_TO_SHORT
  short_vars[48] = (int16_t)int_vars[2];
L24: // MULNUM_SET_FIELD_SHORT
  short_vars[6] = short_vars[48];
L25: // MOVE_CONSTANT_INT
  int_vars[2] = 42;
L26: // CONVERT_INT_TO_SHORT
  short_vars[48] = (int16_t)int_vars[2];
L27: // MULNUM_SET_FIELD_SHORT
  short_vars[7] = short_vars[48];
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 13;
L29: // CONVERT_INT_TO_SHORT
  short_vars[48] = (int16_t)int_vars[2];
L30: // MULNUM_SET_FIELD_SHORT
  short_vars[8] = short_vars[48];
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 23;
L32: // CONVERT_INT_TO_SHORT
  short_vars[48] = (int16_t)int_vars[2];
L33: // MULNUM_SET_FIELD_SHORT
  short_vars[9] = short_vars[48];
L34: // MOVE_CONSTANT_INT
  int_vars[2] = 33;
L35: // CONVERT_INT_TO_SHORT
  short_vars[48] = (int16_t)int_vars[2];
L36: // MULNUM_SET_FIELD_SHORT
  short_vars[10] = short_vars[48];
L37: // MOVE_CONSTANT_INT
  int_vars[2] = 43;
L38: // CONVERT_INT_TO_SHORT
  short_vars[48] = (int16_t)int_vars[2];
L39: // MULNUM_SET_FIELD_SHORT
  short_vars[11] = short_vars[48];
L40: // MOVE_CONSTANT_INT
  int_vars[2] = 14;
L41: // CONVERT_INT_TO_SHORT
  short_vars[48] = (int16_t)int_vars[2];
L42: // MULNUM_SET_FIELD_SHORT
  short_vars[12] = short_vars[48];
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 24;
L44: // CONVERT_INT_TO_SHORT
  short_vars[48] = (int16_t)int_vars[2];
L45: // MULNUM_SET_FIELD_SHORT
  short_vars[13] = short_vars[48];
L46: // MOVE_CONSTANT_INT
  int_vars[2] = 34;
L47: // CONVERT_INT_TO_SHORT
  short_vars[48] = (int16_t)int_vars[2];
L48: // MULNUM_SET_FIELD_SHORT
  short_vars[14] = short_vars[48];
L49: // MOVE_CONSTANT_INT
  int_vars[2] = 44;
L50: // CONVERT_INT_TO_SHORT
  short_vars[48] = (int16_t)int_vars[2];
L51: // MULNUM_SET_FIELD_SHORT
  short_vars[15] = short_vars[48];
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 111;
L53: // CONVERT_INT_TO_SHORT
  short_vars[48] = (int16_t)int_vars[2];
L54: // MULNUM_SET_FIELD_SHORT
  short_vars[16] = short_vars[48];
L55: // MOVE_CONSTANT_INT
  int_vars[2] = 121;
L56: // CONVERT_INT_TO_SHORT
  short_vars[48] = (int16_t)int_vars[2];
L57: // MULNUM_SET_FIELD_SHORT
  short_vars[17] = short_vars[48];
L58: // MOVE_CONSTANT_INT
  int_vars[2] = 131;
L59: // CONVERT_INT_TO_SHORT
  short_vars[48] = (int16_t)int_vars[2];
L60: // MULNUM_SET_FIELD_SHORT
  short_vars[18] = short_vars[48];
L61: // MOVE_CONSTANT_INT
  int_vars[2] = 141;
L62: // CONVERT_INT_TO_SHORT
  short_vars[48] = (int16_t)int_vars[2];
L63: // MULNUM_SET_FIELD_SHORT
  short_vars[19] = short_vars[48];
L64: // MOVE_CONSTANT_INT
  int_vars[2] = 112;
L65: // CONVERT_INT_TO_SHORT
  short_vars[48] = (int16_t)int_vars[2];
L66: // MULNUM_SET_FIELD_SHORT
  short_vars[20] = short_vars[48];
L67: // MOVE_CONSTANT_INT
  int_vars[2] = 122;
L68: // CONVERT_INT_TO_SHORT
  short_vars[48] = (int16_t)int_vars[2];
L69: // MULNUM_SET_FIELD_SHORT
  short_vars[21] = short_vars[48];
L70: // MOVE_CONSTANT_INT
  int_vars[2] = 132;
L71: // CONVERT_INT_TO_SHORT
  short_vars[48] = (int16_t)int_vars[2];
L72: // MULNUM_SET_FIELD_SHORT
  short_vars[22] = short_vars[48];
L73: // MOVE_CONSTANT_INT
  int_vars[2] = 142;
L74: // CONVERT_INT_TO_SHORT
  short_vars[48] = (int16_t)int_vars[2];
L75: // MULNUM_SET_FIELD_SHORT
  short_vars[23] = short_vars[48];
L76: // MOVE_CONSTANT_INT
  int_vars[2] = 113;
L77: // CONVERT_INT_TO_SHORT
  short_vars[48] = (int16_t)int_vars[2];
L78: // MULNUM_SET_FIELD_SHORT
  short_vars[24] = short_vars[48];
L79: // MOVE_CONSTANT_INT
  int_vars[2] = 123;
L80: // CONVERT_INT_TO_SHORT
  short_vars[48] = (int16_t)int_vars[2];
L81: // MULNUM_SET_FIELD_SHORT
  short_vars[25] = short_vars[48];
L82: // MOVE_CONSTANT_INT
  int_vars[2] = 133;
L83: // CONVERT_INT_TO_SHORT
  short_vars[48] = (int16_t)int_vars[2];
L84: // MULNUM_SET_FIELD_SHORT
  short_vars[26] = short_vars[48];
L85: // MOVE_CONSTANT_INT
  int_vars[2] = 143;
L86: // CONVERT_INT_TO_SHORT
  short_vars[48] = (int16_t)int_vars[2];
L87: // MULNUM_SET_FIELD_SHORT
  short_vars[27] = short_vars[48];
L88: // MOVE_CONSTANT_INT
  int_vars[2] = 114;
L89: // CONVERT_INT_TO_SHORT
  short_vars[48] = (int16_t)int_vars[2];
L90: // MULNUM_SET_FIELD_SHORT
  short_vars[28] = short_vars[48];
L91: // MOVE_CONSTANT_INT
  int_vars[2] = 124;
L92: // CONVERT_INT_TO_SHORT
  short_vars[48] = (int16_t)int_vars[2];
L93: // MULNUM_SET_FIELD_SHORT
  short_vars[29] = short_vars[48];
L94: // MOVE_CONSTANT_INT
  int_vars[2] = 134;
L95: // CONVERT_INT_TO_SHORT
  short_vars[48] = (int16_t)int_vars[2];
L96: // MULNUM_SET_FIELD_SHORT
  short_vars[30] = short_vars[48];
L97: // MOVE_CONSTANT_INT
  int_vars[2] = 144;
L98: // CONVERT_INT_TO_SHORT
  short_vars[48] = (int16_t)int_vars[2];
L99: // MULNUM_SET_FIELD_SHORT
  short_vars[31] = short_vars[48];
L100: // MULNUM_GET_FIELD_SHORT
  short_vars[48] = short_vars[0];
L101: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[48];
L102: // MULNUM_GET_FIELD_SHORT
  short_vars[49] = short_vars[16];
L103: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[49];
L104: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L105: // CONVERT_INT_TO_SHORT
  short_vars[50] = (int16_t)int_vars[4];
L106: // MULNUM_SET_FIELD_SHORT
  short_vars[32] = short_vars[50];
L107: // MULNUM_GET_FIELD_SHORT
  short_vars[48] = short_vars[1];
L108: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[48];
L109: // MULNUM_GET_FIELD_SHORT
  short_vars[49] = short_vars[17];
L110: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[49];
L111: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L112: // CONVERT_INT_TO_SHORT
  short_vars[50] = (int16_t)int_vars[4];
L113: // MULNUM_SET_FIELD_SHORT
  short_vars[33] = short_vars[50];
L114: // MULNUM_GET_FIELD_SHORT
  short_vars[48] = short_vars[2];
L115: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[48];
L116: // MULNUM_GET_FIELD_SHORT
  short_vars[49] = short_vars[18];
L117: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[49];
L118: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L119: // CONVERT_INT_TO_SHORT
  short_vars[50] = (int16_t)int_vars[4];
L120: // MULNUM_SET_FIELD_SHORT
  short_vars[34] = short_vars[50];
L121: // MULNUM_GET_FIELD_SHORT
  short_vars[48] = short_vars[3];
L122: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[48];
L123: // MULNUM_GET_FIELD_SHORT
  short_vars[49] = short_vars[19];
L124: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[49];
L125: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L126: // CONVERT_INT_TO_SHORT
  short_vars[50] = (int16_t)int_vars[4];
L127: // MULNUM_SET_FIELD_SHORT
  short_vars[35] = short_vars[50];
L128: // MULNUM_GET_FIELD_SHORT
  short_vars[48] = short_vars[4];
L129: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[48];
L130: // MULNUM_GET_FIELD_SHORT
  short_vars[49] = short_vars[20];
L131: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[49];
L132: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L133: // CONVERT_INT_TO_SHORT
  short_vars[50] = (int16_t)int_vars[4];
L134: // MULNUM_SET_FIELD_SHORT
  short_vars[36] = short_vars[50];
L135: // MULNUM_GET_FIELD_SHORT
  short_vars[48] = short_vars[5];
L136: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[48];
L137: // MULNUM_GET_FIELD_SHORT
  short_vars[49] = short_vars[21];
L138: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[49];
L139: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L140: // CONVERT_INT_TO_SHORT
  short_vars[50] = (int16_t)int_vars[4];
L141: // MULNUM_SET_FIELD_SHORT
  short_vars[37] = short_vars[50];
L142: // MULNUM_GET_FIELD_SHORT
  short_vars[48] = short_vars[6];
L143: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[48];
L144: // MULNUM_GET_FIELD_SHORT
  short_vars[49] = short_vars[22];
L145: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[49];
L146: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L147: // CONVERT_INT_TO_SHORT
  short_vars[50] = (int16_t)int_vars[4];
L148: // MULNUM_SET_FIELD_SHORT
  short_vars[38] = short_vars[50];
L149: // MULNUM_GET_FIELD_SHORT
  short_vars[48] = short_vars[7];
L150: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[48];
L151: // MULNUM_GET_FIELD_SHORT
  short_vars[49] = short_vars[23];
L152: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[49];
L153: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L154: // CONVERT_INT_TO_SHORT
  short_vars[50] = (int16_t)int_vars[4];
L155: // MULNUM_SET_FIELD_SHORT
  short_vars[39] = short_vars[50];
L156: // MULNUM_GET_FIELD_SHORT
  short_vars[48] = short_vars[8];
L157: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[48];
L158: // MULNUM_GET_FIELD_SHORT
  short_vars[49] = short_vars[24];
L159: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[49];
L160: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L161: // CONVERT_INT_TO_SHORT
  short_vars[50] = (int16_t)int_vars[4];
L162: // MULNUM_SET_FIELD_SHORT
  short_vars[40] = short_vars[50];
L163: // MULNUM_GET_FIELD_SHORT
  short_vars[48] = short_vars[9];
L164: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[48];
L165: // MULNUM_GET_FIELD_SHORT
  short_vars[49] = short_vars[25];
L166: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[49];
L167: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L168: // CONVERT_INT_TO_SHORT
  short_vars[50] = (int16_t)int_vars[4];
L169: // MULNUM_SET_FIELD_SHORT
  short_vars[41] = short_vars[50];
L170: // MULNUM_GET_FIELD_SHORT
  short_vars[48] = short_vars[10];
L171: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[48];
L172: // MULNUM_GET_FIELD_SHORT
  short_vars[49] = short_vars[26];
L173: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[49];
L174: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L175: // CONVERT_INT_TO_SHORT
  short_vars[50] = (int16_t)int_vars[4];
L176: // MULNUM_SET_FIELD_SHORT
  short_vars[42] = short_vars[50];
L177: // MULNUM_GET_FIELD_SHORT
  short_vars[48] = short_vars[11];
L178: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[48];
L179: // MULNUM_GET_FIELD_SHORT
  short_vars[49] = short_vars[27];
L180: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[49];
L181: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L182: // CONVERT_INT_TO_SHORT
  short_vars[50] = (int16_t)int_vars[4];
L183: // MULNUM_SET_FIELD_SHORT
  short_vars[43] = short_vars[50];
L184: // MULNUM_GET_FIELD_SHORT
  short_vars[48] = short_vars[12];
L185: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[48];
L186: // MULNUM_GET_FIELD_SHORT
  short_vars[49] = short_vars[28];
L187: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[49];
L188: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L189: // CONVERT_INT_TO_SHORT
  short_vars[50] = (int16_t)int_vars[4];
L190: // MULNUM_SET_FIELD_SHORT
  short_vars[44] = short_vars[50];
L191: // MULNUM_GET_FIELD_SHORT
  short_vars[48] = short_vars[13];
L192: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[48];
L193: // MULNUM_GET_FIELD_SHORT
  short_vars[49] = short_vars[29];
L194: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[49];
L195: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L196: // CONVERT_INT_TO_SHORT
  short_vars[50] = (int16_t)int_vars[4];
L197: // MULNUM_SET_FIELD_SHORT
  short_vars[45] = short_vars[50];
L198: // MULNUM_GET_FIELD_SHORT
  short_vars[48] = short_vars[14];
L199: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[48];
L200: // MULNUM_GET_FIELD_SHORT
  short_vars[49] = short_vars[30];
L201: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[49];
L202: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L203: // CONVERT_INT_TO_SHORT
  short_vars[50] = (int16_t)int_vars[4];
L204: // MULNUM_SET_FIELD_SHORT
  short_vars[46] = short_vars[50];
L205: // MULNUM_GET_FIELD_SHORT
  short_vars[48] = short_vars[15];
L206: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[48];
L207: // MULNUM_GET_FIELD_SHORT
  short_vars[49] = short_vars[31];
L208: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[49];
L209: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L210: // CONVERT_INT_TO_SHORT
  short_vars[50] = (int16_t)int_vars[4];
L211: // MULNUM_SET_FIELD_SHORT
  short_vars[47] = short_vars[50];
L212: // MULNUM_GET_FIELD_SHORT
  short_vars[48] = short_vars[32];
L213: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[48];
L214: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[49] = *(int16_t*)&stack[0];
    }
  }
L215: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Value";
    const char* sub_name = "value_max_fields_short";
    const char* file = "TestCase/Value.spvm";
    int32_t line = 192;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L364;
  }
L216: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[49];
L217: // MOVE_CONSTANT_INT
  int_vars[4] = 111;
L218: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L219: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[5]);
L220: // BOOL_INT
  int_vars[0] = int_vars[0];
L221: // IF_NE_ZERO
  if (int_vars[0]) { goto L225; }
L222: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L223: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L364;
L224: // GOTO
  goto L225;
L225: // MULNUM_GET_FIELD_SHORT
  short_vars[48] = short_vars[33];
L226: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[48];
L227: // MOVE_CONSTANT_INT
  int_vars[5] = 142;
L228: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L229: // BOOL_INT
  int_vars[0] = int_vars[0];
L230: // IF_NE_ZERO
  if (int_vars[0]) { goto L234; }
L231: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L232: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L364;
L233: // GOTO
  goto L234;
L234: // MULNUM_GET_FIELD_SHORT
  short_vars[48] = short_vars[34];
L235: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[48];
L236: // MOVE_CONSTANT_INT
  int_vars[5] = 162;
L237: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L238: // BOOL_INT
  int_vars[0] = int_vars[0];
L239: // IF_NE_ZERO
  if (int_vars[0]) { goto L243; }
L240: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L241: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L364;
L242: // GOTO
  goto L243;
L243: // MULNUM_GET_FIELD_SHORT
  short_vars[48] = short_vars[35];
L244: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[48];
L245: // MOVE_CONSTANT_INT
  int_vars[5] = 182;
L246: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L247: // BOOL_INT
  int_vars[0] = int_vars[0];
L248: // IF_NE_ZERO
  if (int_vars[0]) { goto L252; }
L249: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L250: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L364;
L251: // GOTO
  goto L252;
L252: // MULNUM_GET_FIELD_SHORT
  short_vars[48] = short_vars[36];
L253: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[48];
L254: // MOVE_CONSTANT_INT
  int_vars[5] = 124;
L255: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L256: // BOOL_INT
  int_vars[0] = int_vars[0];
L257: // IF_NE_ZERO
  if (int_vars[0]) { goto L261; }
L258: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L259: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L364;
L260: // GOTO
  goto L261;
L261: // MULNUM_GET_FIELD_SHORT
  short_vars[48] = short_vars[37];
L262: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[48];
L263: // MOVE_CONSTANT_INT
  int_vars[5] = 144;
L264: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L265: // BOOL_INT
  int_vars[0] = int_vars[0];
L266: // IF_NE_ZERO
  if (int_vars[0]) { goto L270; }
L267: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L268: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L364;
L269: // GOTO
  goto L270;
L270: // MULNUM_GET_FIELD_SHORT
  short_vars[48] = short_vars[38];
L271: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[48];
L272: // MOVE_CONSTANT_INT
  int_vars[5] = 164;
L273: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L274: // BOOL_INT
  int_vars[0] = int_vars[0];
L275: // IF_NE_ZERO
  if (int_vars[0]) { goto L279; }
L276: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L277: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L364;
L278: // GOTO
  goto L279;
L279: // MULNUM_GET_FIELD_SHORT
  short_vars[48] = short_vars[39];
L280: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[48];
L281: // MOVE_CONSTANT_INT
  int_vars[5] = 184;
L282: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L283: // BOOL_INT
  int_vars[0] = int_vars[0];
L284: // IF_NE_ZERO
  if (int_vars[0]) { goto L288; }
L285: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L286: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L364;
L287: // GOTO
  goto L288;
L288: // MULNUM_GET_FIELD_SHORT
  short_vars[48] = short_vars[40];
L289: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[48];
L290: // MOVE_CONSTANT_INT
  int_vars[5] = 126;
L291: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L292: // BOOL_INT
  int_vars[0] = int_vars[0];
L293: // IF_NE_ZERO
  if (int_vars[0]) { goto L297; }
L294: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L295: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L364;
L296: // GOTO
  goto L297;
L297: // MULNUM_GET_FIELD_SHORT
  short_vars[48] = short_vars[41];
L298: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[48];
L299: // MOVE_CONSTANT_INT
  int_vars[5] = 146;
L300: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L301: // BOOL_INT
  int_vars[0] = int_vars[0];
L302: // IF_NE_ZERO
  if (int_vars[0]) { goto L306; }
L303: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L304: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L364;
L305: // GOTO
  goto L306;
L306: // MULNUM_GET_FIELD_SHORT
  short_vars[48] = short_vars[42];
L307: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[48];
L308: // MOVE_CONSTANT_INT
  int_vars[5] = 166;
L309: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L310: // BOOL_INT
  int_vars[0] = int_vars[0];
L311: // IF_NE_ZERO
  if (int_vars[0]) { goto L315; }
L312: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L313: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L364;
L314: // GOTO
  goto L315;
L315: // MULNUM_GET_FIELD_SHORT
  short_vars[48] = short_vars[43];
L316: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[48];
L317: // MOVE_CONSTANT_INT
  int_vars[5] = 186;
L318: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L319: // BOOL_INT
  int_vars[0] = int_vars[0];
L320: // IF_NE_ZERO
  if (int_vars[0]) { goto L324; }
L321: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L322: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L364;
L323: // GOTO
  goto L324;
L324: // MULNUM_GET_FIELD_SHORT
  short_vars[48] = short_vars[35];
L325: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[48];
L326: // MOVE_CONSTANT_INT
  int_vars[5] = 182;
L327: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L328: // BOOL_INT
  int_vars[0] = int_vars[0];
L329: // IF_NE_ZERO
  if (int_vars[0]) { goto L333; }
L330: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L331: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L364;
L332: // GOTO
  goto L333;
L333: // MULNUM_GET_FIELD_SHORT
  short_vars[48] = short_vars[39];
L334: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[48];
L335: // MOVE_CONSTANT_INT
  int_vars[5] = 184;
L336: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L337: // BOOL_INT
  int_vars[0] = int_vars[0];
L338: // IF_NE_ZERO
  if (int_vars[0]) { goto L342; }
L339: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L340: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L364;
L341: // GOTO
  goto L342;
L342: // MULNUM_GET_FIELD_SHORT
  short_vars[48] = short_vars[43];
L343: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[48];
L344: // MOVE_CONSTANT_INT
  int_vars[5] = 186;
L345: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L346: // BOOL_INT
  int_vars[0] = int_vars[0];
L347: // IF_NE_ZERO
  if (int_vars[0]) { goto L351; }
L348: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L349: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L364;
L350: // GOTO
  goto L351;
L351: // MULNUM_GET_FIELD_SHORT
  short_vars[48] = short_vars[47];
L352: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[48];
L353: // MOVE_CONSTANT_INT
  int_vars[5] = 188;
L354: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L355: // BOOL_INT
  int_vars[0] = int_vars[0];
L356: // IF_NE_ZERO
  if (int_vars[0]) { goto L360; }
L357: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L358: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L364;
L359: // GOTO
  goto L360;
L360: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L361: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L364;
L362: // INIT_INT
  int_vars[6] = 0;
L363: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L364;
L364: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


