#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
static int32_t VAR_PACKAGE_VAR_ID_TestCase__Increment__BYTE_VALUE = -1;
static int32_t VAR_PACKAGE_VAR_ID_TestCase__Increment__SHORT_VALUE = -1;
static int32_t VAR_PACKAGE_VAR_ID_TestCase__Increment__INT_VALUE = -1;
static int32_t VAR_PACKAGE_VAR_ID_TestCase__Increment__LONG_VALUE = -1;
static int32_t VAR_PACKAGE_VAR_ID_TestCase__Increment__FLOAT_VALUE = -1;
static int32_t VAR_PACKAGE_VAR_ID_TestCase__Increment__DOUBLE_VALUE = -1;
// Field id and index declarations
static int32_t FIELD_ID_TestCase__Point_3b__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3b__x = -1;
static int32_t FIELD_ID_TestCase__Point_3s__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3s__x = -1;
static int32_t FIELD_ID_TestCase__Point_3i__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3i__x = -1;
static int32_t FIELD_ID_TestCase__Point_3l__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3l__x = -1;
static int32_t FIELD_ID_TestCase__Point_3f__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3f__x = -1;
static int32_t FIELD_ID_TestCase__Point_3d__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Point_3d__x = -1;
static int32_t FIELD_ID_TestCase__Simple__byte_value = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Simple__byte_value = -1;
static int32_t FIELD_ID_TestCase__Simple__short_value = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Simple__short_value = -1;
static int32_t FIELD_ID_TestCase__Simple__int_value = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Simple__int_value = -1;
static int32_t FIELD_ID_TestCase__Simple__long_value = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Simple__long_value = -1;
static int32_t FIELD_ID_TestCase__Simple__float_value = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Simple__float_value = -1;
static int32_t FIELD_ID_TestCase__Simple__double_value = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Simple__double_value = -1;
static int32_t FIELD_ID_TestCase__Minimal__x = -1;
static int32_t FIELD_BYTE_OFFSET_TestCase__Minimal__x = -1;
// Sub id declarations
static int32_t SUB_ID_SPVM__Util__INT8_MAX = - 1;
static int32_t SUB_ID_SPVM__Util__INT16_MAX = - 1;
static int32_t SUB_ID_SPVM__Util__INT32_MAX = - 1;
static int32_t SUB_ID_SPVM__Util__INT64_MAX = - 1;
static int32_t SUB_ID_SPVM__Util__FLT_MAX = - 1;
static int32_t SUB_ID_SPVM__Util__DBL_MAX = - 1;
static int32_t SUB_ID_TestCase__Simple__new = - 1;
static int32_t SUB_ID_TestCase__Minimal__new = - 1;
static int32_t SUB_ID_SPVM__Util__INT8_MIN = - 1;
static int32_t SUB_ID_SPVM__Util__INT16_MIN = - 1;
static int32_t SUB_ID_SPVM__Util__INT32_MIN = - 1;
static int32_t SUB_ID_SPVM__Util__INT64_MIN = - 1;
static int32_t SUB_ID_SPVM__Util__FLT_MIN = - 1;
static int32_t SUB_ID_SPVM__Util__DBL_MIN = - 1;
// Basic type id declarations
static int32_t BASIC_TYPE_ID_byte = -1;
static int32_t BASIC_TYPE_ID_short = -1;
static int32_t BASIC_TYPE_ID_int = -1;
static int32_t BASIC_TYPE_ID_long = -1;
static int32_t BASIC_TYPE_ID_float = -1;
static int32_t BASIC_TYPE_ID_double = -1;
static int32_t BASIC_TYPE_ID_TestCase__Point_3b = -1;
static int32_t BASIC_TYPE_ID_TestCase__Point_3s = -1;
static int32_t BASIC_TYPE_ID_TestCase__Point_3i = -1;
static int32_t BASIC_TYPE_ID_TestCase__Point_3l = -1;
static int32_t BASIC_TYPE_ID_TestCase__Point_3f = -1;
static int32_t BASIC_TYPE_ID_TestCase__Point_3d = -1;
static int32_t BASIC_TYPE_ID_TestCase__Minimal = -1;
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__post_dec(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__post_dec_array_access_constant_index(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__post_dec_array_access_invocant_not_var(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__post_dec_array_access_var_index(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__post_dec_array_field_access_constant_index(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__post_dec_array_field_access_invocant_not_var(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__post_dec_deref(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__post_dec_field_access(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__post_dec_field_access_invocant_not_var(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__post_dec_package_var_access(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__post_dec_var(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__post_inc_array_access_constant_index(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__post_inc_array_access_invocant_not_var(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__post_inc_array_access_var_index(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__post_inc_array_field_access_constant_index(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__post_inc_array_field_access_invocant_not_var(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__post_inc_deref(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__post_inc_field_access(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__post_inc_field_access_invocant_not_var(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__post_inc_package_var_access(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__post_inc_var(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__pre_dec_array_access_constant_index(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__pre_dec_array_access_invocant_not_var(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__pre_dec_array_access_var_index(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__pre_dec_array_field_access_constant_index(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__pre_dec_array_field_access_invocant_not_var(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__pre_dec_deref(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__pre_dec_field_access(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__pre_dec_field_access_invocant_not_var(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__pre_dec_package_var_access(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__pre_dec_var(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__pre_inc_array_access_constant_index(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__pre_inc_array_access_invocant_not_var(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__pre_inc_array_access_var_index(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__pre_inc_array_field_access_constant_index(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__pre_inc_array_field_access_invocant_not_var(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__pre_inc_deref(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__pre_inc_field_access(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__pre_inc_field_access_invocant_not_var(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__pre_inc_package_var_access(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Increment__pre_inc_var(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Increment__post_dec(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[4];
  float float_vars[4];
  int64_t long_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  int8_t byte_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L4: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L6: // MOVE_CONSTANT_LONG
  long_vars[0] = 0LL;
L7: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.25;
L8: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.25;
L9: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L10: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[1];
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L12: // SUBTRACT_INT
  int_vars[5] = int_vars[3] - int_vars[4];
L13: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[5];
L14: // MOVE_BYTE
  byte_vars[2] = byte_vars[1];
L15: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L16: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[1];
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L18: // SUBTRACT_INT
  int_vars[5] = int_vars[3] - int_vars[4];
L19: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[5];
L20: // MOVE_SHORT
  short_vars[2] = short_vars[1];
L21: // MOVE_INT
  int_vars[3] = int_vars[2];
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L23: // SUBTRACT_INT
  int_vars[2] = int_vars[3] - int_vars[4];
L24: // MOVE_INT
  int_vars[5] = int_vars[3];
L25: // MOVE_LONG
  long_vars[1] = long_vars[0];
L26: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L27: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[3];
L28: // SUBTRACT_LONG
  long_vars[0] = long_vars[1] - long_vars[2];
L29: // MOVE_LONG
  long_vars[3] = long_vars[1];
L30: // MOVE_FLOAT
  float_vars[1] = float_vars[0];
L31: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L32: // CONVERT_INT_TO_FLOAT
  float_vars[2] = (float)int_vars[3];
L33: // SUBTRACT_FLOAT
  float_vars[0] = float_vars[1] - float_vars[2];
L34: // MOVE_FLOAT
  float_vars[3] = float_vars[1];
L35: // MOVE_DOUBLE
  double_vars[1] = double_vars[0];
L36: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L37: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[3];
L38: // SUBTRACT_DOUBLE
  double_vars[0] = double_vars[1] - double_vars[2];
L39: // MOVE_DOUBLE
  double_vars[3] = double_vars[1];
L40: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L41: // MOVE_CONSTANT_INT
  int_vars[4] = -1;
L42: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L43: // BOOL_INT
  int_vars[0] = int_vars[0];
L44: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L106; }
L45: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[2];
L46: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L47: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L48: // BOOL_INT
  int_vars[0] = int_vars[0];
L49: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L105; }
L50: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L51: // MOVE_CONSTANT_INT
  int_vars[4] = -1;
L52: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L53: // BOOL_INT
  int_vars[0] = int_vars[0];
L54: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L104; }
L55: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[2];
L56: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L57: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L58: // BOOL_INT
  int_vars[0] = int_vars[0];
L59: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L103; }
L60: // MOVE_CONSTANT_INT
  int_vars[3] = -1;
L61: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L62: // BOOL_INT
  int_vars[0] = int_vars[0];
L63: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L102; }
L64: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L65: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[3]);
L66: // BOOL_INT
  int_vars[0] = int_vars[0];
L67: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L101; }
L68: // MOVE_CONSTANT_LONG
  long_vars[1] = -1LL;
L69: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L70: // BOOL_INT
  int_vars[0] = int_vars[0];
L71: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L100; }
L72: // MOVE_CONSTANT_LONG
  long_vars[1] = 0LL;
L73: // EQ_LONG
  int_vars[0] = (long_vars[3] == long_vars[1]);
L74: // BOOL_INT
  int_vars[0] = int_vars[0];
L75: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L99; }
L76: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.25;
L77: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L78: // BOOL_INT
  int_vars[0] = int_vars[0];
L79: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L98; }
L80: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 1.25;
L81: // EQ_FLOAT
  int_vars[0] = (float_vars[3] == float_vars[1]);
L82: // BOOL_INT
  int_vars[0] = int_vars[0];
L83: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L97; }
L84: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.25;
L85: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L86: // BOOL_INT
  int_vars[0] = int_vars[0];
L87: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L96; }
L88: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 1.25;
L89: // EQ_DOUBLE
  int_vars[0] = (double_vars[3] == double_vars[1]);
L90: // BOOL_INT
  int_vars[0] = int_vars[0];
L91: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L95; }
L92: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L93: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L108;
L94: // GOTO
  goto L95;
L95: // GOTO
  goto L96;
L96: // GOTO
  goto L97;
L97: // GOTO
  goto L98;
L98: // GOTO
  goto L99;
L99: // GOTO
  goto L100;
L100: // GOTO
  goto L101;
L101: // GOTO
  goto L102;
L102: // GOTO
  goto L103;
L103: // GOTO
  goto L104;
L104: // GOTO
  goto L105;
L105: // GOTO
  goto L106;
L106: // INIT_INT
  int_vars[6] = 0;
L107: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L108;
L108: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Increment__post_dec_array_access_constant_index(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[6] = {0};
  double double_vars[5];
  float float_vars[5];
  int64_t long_vars[5];
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  int8_t byte_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 298;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 299;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L11: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 300;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L15: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[3], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 301;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L19: // NEW_FLOAT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_float_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 302;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L23: // NEW_DOUBLE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_double_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[5], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 303;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L25: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 305;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L27: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 305;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L31: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 306;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L33: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L34: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L35: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 306;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L37: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 307;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L40: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[2];
      } 
    } 
  } 
L41: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 307;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L42: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 308;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L45: // ARRAY_STORE_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 308;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L47: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 309;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L49: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L50: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[0];
      } 
    } 
  } 
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 309;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L52: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 310;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L54: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L55: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[0];
      } 
    } 
  } 
L56: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 310;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L57: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L58: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 312;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L60: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L61: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L62: // SUBTRACT_INT
  int_vars[5] = int_vars[3] - int_vars[4];
L63: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L64: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L65: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 312;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L66: // MOVE_BYTE
  byte_vars[2] = byte_vars[0];
L67: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L68: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L69: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 313;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L70: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L71: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L72: // SUBTRACT_INT
  int_vars[5] = int_vars[3] - int_vars[4];
L73: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[5];
L74: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L75: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 313;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L76: // MOVE_SHORT
  short_vars[2] = short_vars[0];
L77: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L78: // ARRAY_FETCH_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L79: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 314;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L80: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L81: // SUBTRACT_INT
  int_vars[5] = int_vars[3] - int_vars[4];
L82: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L83: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 314;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L84: // MOVE_INT
  int_vars[6] = int_vars[3];
L85: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L86: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L87: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 315;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L88: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L89: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[3];
L90: // SUBTRACT_LONG
  long_vars[2] = long_vars[0] - long_vars[1];
L91: // ARRAY_STORE_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L92: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 315;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L93: // MOVE_LONG
  long_vars[3] = long_vars[0];
L94: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L95: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L96: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 316;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L97: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L98: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[3];
L99: // SUBTRACT_FLOAT
  float_vars[2] = float_vars[0] - float_vars[1];
L100: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[2];
      } 
    } 
  } 
L101: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 316;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L102: // MOVE_FLOAT
  float_vars[3] = float_vars[0];
L103: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L104: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L105: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 317;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L106: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L107: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[3];
L108: // SUBTRACT_DOUBLE
  double_vars[2] = double_vars[0] - double_vars[1];
L109: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[2];
      } 
    } 
  } 
L110: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 317;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L111: // MOVE_DOUBLE
  double_vars[3] = double_vars[0];
L112: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L113: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L114: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 319;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L115: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L116: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[1] = *(int8_t*)&stack[0];
    }
  }
L117: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 319;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L118: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L119: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L120: // SUBTRACT_INT
  int_vars[7] = int_vars[4] - int_vars[5];
L121: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L122: // BOOL_INT
  int_vars[0] = int_vars[0];
L123: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L226; }
L124: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[2];
L125: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L126: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 320;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L127: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L128: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L129: // BOOL_INT
  int_vars[0] = int_vars[0];
L130: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L225; }
L131: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L132: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L133: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 321;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L134: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L135: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L136: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 321;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L137: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L138: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L139: // SUBTRACT_INT
  int_vars[7] = int_vars[4] - int_vars[5];
L140: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L141: // BOOL_INT
  int_vars[0] = int_vars[0];
L142: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L224; }
L143: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[2];
L144: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L145: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 322;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L146: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L147: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L148: // BOOL_INT
  int_vars[0] = int_vars[0];
L149: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L223; }
L150: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L151: // ARRAY_FETCH_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L152: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 323;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L153: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L154: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 323;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L155: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L156: // SUBTRACT_INT
  int_vars[7] = int_vars[4] - int_vars[5];
L157: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L158: // BOOL_INT
  int_vars[0] = int_vars[0];
L159: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L222; }
L160: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L161: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 324;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L162: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[2]);
L163: // BOOL_INT
  int_vars[0] = int_vars[0];
L164: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L221; }
L165: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L166: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L167: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 325;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L168: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L169: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 325;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L170: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L171: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[3];
L172: // SUBTRACT_LONG
  long_vars[4] = long_vars[1] - long_vars[2];
L173: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[4]);
L174: // BOOL_INT
  int_vars[0] = int_vars[0];
L175: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L220; }
L176: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L177: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 326;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L178: // EQ_LONG
  int_vars[0] = (long_vars[3] == long_vars[0]);
L179: // BOOL_INT
  int_vars[0] = int_vars[0];
L180: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L219; }
L181: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L182: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L183: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 327;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L184: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L185: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 327;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L186: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L187: // CONVERT_INT_TO_FLOAT
  float_vars[2] = (float)int_vars[3];
L188: // SUBTRACT_FLOAT
  float_vars[4] = float_vars[1] - float_vars[2];
L189: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[4]);
L190: // BOOL_INT
  int_vars[0] = int_vars[0];
L191: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L218; }
L192: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L193: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 328;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L194: // EQ_FLOAT
  int_vars[0] = (float_vars[3] == float_vars[0]);
L195: // BOOL_INT
  int_vars[0] = int_vars[0];
L196: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L217; }
L197: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L198: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L199: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 329;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L200: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L201: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 329;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L202: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L203: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[3];
L204: // SUBTRACT_DOUBLE
  double_vars[4] = double_vars[1] - double_vars[2];
L205: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[4]);
L206: // BOOL_INT
  int_vars[0] = int_vars[0];
L207: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L216; }
L208: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L209: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 330;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L210: // BOOL_DOUBLE
  int_vars[0] = !!double_vars[3];
L211: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L215; }
L212: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L213: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L228;
L214: // GOTO
  goto L215;
L215: // GOTO
  goto L216;
L216: // GOTO
  goto L217;
L217: // GOTO
  goto L218;
L218: // GOTO
  goto L219;
L219: // GOTO
  goto L220;
L220: // GOTO
  goto L221;
L221: // GOTO
  goto L222;
L222: // GOTO
  goto L223;
L223: // GOTO
  goto L224;
L224: // GOTO
  goto L225;
L225: // GOTO
  goto L226;
L226: // INIT_INT
  int_vars[4] = 0;
L227: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L228;
L228: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L229: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Increment__post_dec_array_access_invocant_not_var(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULTI_ARRAY
  {
    if (BASIC_TYPE_ID_int < 0) {
      BASIC_TYPE_ID_int = env->get_basic_type_id(env, "int");
      if (BASIC_TYPE_ID_int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_int;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_muldim_array_raw(env, basic_type_id, 1, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 34;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L51;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 35;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L51;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L10: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 35;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L51;
  }
L12: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L15: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 37;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L51;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L18: // ARRAY_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 37;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L51;
  }
L20: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L21: // SUBTRACT_INT
  int_vars[6] = int_vars[4] - int_vars[5];
L22: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[6];
      } 
    } 
  } 
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 37;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L51;
  }
L24: // MOVE_INT
  int_vars[7] = int_vars[4];
L25: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L27: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L28: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 39;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L51;
  }
L30: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L31: // ARRAY_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 39;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L51;
  }
L33: // MOVE_CONSTANT_INT
  int_vars[5] = -1;
L34: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L35: // BOOL_INT
  int_vars[0] = int_vars[0];
L36: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L46; }
L37: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L38: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L39: // EQ_INT
  int_vars[0] = (int_vars[7] == int_vars[2]);
L40: // BOOL_INT
  int_vars[0] = int_vars[0];
L41: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L45; }
L42: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L43: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L51;
L44: // GOTO
  goto L45;
L45: // GOTO
  goto L46;
L46: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L47: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L48: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L51;
L49: // INIT_INT
  int_vars[6] = 0;
L50: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L51;
L51: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L52: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Increment__post_dec_array_access_var_index(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[6] = {0};
  double double_vars[5];
  float float_vars[5];
  int64_t long_vars[5];
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  int8_t byte_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 248;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 249;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L11: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 250;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L15: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[3], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 251;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L19: // NEW_FLOAT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_float_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 252;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L23: // NEW_DOUBLE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_double_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[5], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 253;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L25: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 255;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L27: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 255;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L31: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 256;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L33: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L34: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L35: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 256;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L37: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 257;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L40: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[2];
      } 
    } 
  } 
L41: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 257;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L42: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 258;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L45: // ARRAY_STORE_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 258;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L47: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 259;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L49: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L50: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[0];
      } 
    } 
  } 
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 259;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L52: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 260;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L54: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L55: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[0];
      } 
    } 
  } 
L56: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 260;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L57: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L58: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 263;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L60: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L61: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L62: // SUBTRACT_INT
  int_vars[5] = int_vars[3] - int_vars[4];
L63: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L64: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L65: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 263;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L66: // MOVE_BYTE
  byte_vars[2] = byte_vars[0];
L67: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L68: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 264;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L69: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L70: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L71: // SUBTRACT_INT
  int_vars[5] = int_vars[3] - int_vars[4];
L72: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[5];
L73: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L74: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 264;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L75: // MOVE_SHORT
  short_vars[2] = short_vars[0];
L76: // ARRAY_FETCH_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L77: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 265;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L78: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L79: // SUBTRACT_INT
  int_vars[5] = int_vars[3] - int_vars[4];
L80: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L81: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 265;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L82: // MOVE_INT
  int_vars[6] = int_vars[3];
L83: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L84: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 266;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L85: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L86: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[3];
L87: // SUBTRACT_LONG
  long_vars[2] = long_vars[0] - long_vars[1];
L88: // ARRAY_STORE_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L89: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 266;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L90: // MOVE_LONG
  long_vars[3] = long_vars[0];
L91: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L92: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 267;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L93: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L94: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[3];
L95: // SUBTRACT_FLOAT
  float_vars[2] = float_vars[0] - float_vars[1];
L96: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[2];
      } 
    } 
  } 
L97: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 267;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L98: // MOVE_FLOAT
  float_vars[3] = float_vars[0];
L99: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L100: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 268;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L101: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L102: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[3];
L103: // SUBTRACT_DOUBLE
  double_vars[2] = double_vars[0] - double_vars[1];
L104: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[2];
      } 
    } 
  } 
L105: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 268;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L106: // MOVE_DOUBLE
  double_vars[3] = double_vars[0];
L107: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L108: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L109: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 270;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L110: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L111: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[1] = *(int8_t*)&stack[0];
    }
  }
L112: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 270;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L113: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[1];
L114: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L115: // SUBTRACT_INT
  int_vars[8] = int_vars[5] - int_vars[7];
L116: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L117: // BOOL_INT
  int_vars[0] = int_vars[0];
L118: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L221; }
L119: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[2];
L120: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L121: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 271;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L122: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L123: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L124: // BOOL_INT
  int_vars[0] = int_vars[0];
L125: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L220; }
L126: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L127: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L128: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 272;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L129: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L130: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L131: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 272;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L132: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[1];
L133: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L134: // SUBTRACT_INT
  int_vars[8] = int_vars[5] - int_vars[7];
L135: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L136: // BOOL_INT
  int_vars[0] = int_vars[0];
L137: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L219; }
L138: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[2];
L139: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L140: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 273;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L141: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L142: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L143: // BOOL_INT
  int_vars[0] = int_vars[0];
L144: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L218; }
L145: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L146: // ARRAY_FETCH_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L147: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 274;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L148: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L149: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 274;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L150: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L151: // SUBTRACT_INT
  int_vars[8] = int_vars[5] - int_vars[7];
L152: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L153: // BOOL_INT
  int_vars[0] = int_vars[0];
L154: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L217; }
L155: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L156: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 275;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L157: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[3]);
L158: // BOOL_INT
  int_vars[0] = int_vars[0];
L159: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L216; }
L160: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L161: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L162: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 276;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L163: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L164: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 276;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L165: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L166: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[4];
L167: // SUBTRACT_LONG
  long_vars[4] = long_vars[1] - long_vars[2];
L168: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[4]);
L169: // BOOL_INT
  int_vars[0] = int_vars[0];
L170: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L215; }
L171: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L172: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 277;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L173: // EQ_LONG
  int_vars[0] = (long_vars[3] == long_vars[0]);
L174: // BOOL_INT
  int_vars[0] = int_vars[0];
L175: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L214; }
L176: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L177: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L178: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 278;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L179: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L180: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 278;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L181: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L182: // CONVERT_INT_TO_FLOAT
  float_vars[2] = (float)int_vars[4];
L183: // SUBTRACT_FLOAT
  float_vars[4] = float_vars[1] - float_vars[2];
L184: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[4]);
L185: // BOOL_INT
  int_vars[0] = int_vars[0];
L186: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L213; }
L187: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L188: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 279;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L189: // EQ_FLOAT
  int_vars[0] = (float_vars[3] == float_vars[0]);
L190: // BOOL_INT
  int_vars[0] = int_vars[0];
L191: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L212; }
L192: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L193: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L194: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 280;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L195: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L196: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 280;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L197: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L198: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[4];
L199: // SUBTRACT_DOUBLE
  double_vars[4] = double_vars[1] - double_vars[2];
L200: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[4]);
L201: // BOOL_INT
  int_vars[0] = int_vars[0];
L202: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L211; }
L203: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L204: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 281;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L205: // BOOL_DOUBLE
  int_vars[0] = !!double_vars[3];
L206: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L210; }
L207: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L208: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L223;
L209: // GOTO
  goto L210;
L210: // GOTO
  goto L211;
L211: // GOTO
  goto L212;
L212: // GOTO
  goto L213;
L213: // GOTO
  goto L214;
L214: // GOTO
  goto L215;
L215: // GOTO
  goto L216;
L216: // GOTO
  goto L217;
L217: // GOTO
  goto L218;
L218: // GOTO
  goto L219;
L219: // GOTO
  goto L220;
L220: // GOTO
  goto L221;
L221: // INIT_INT
  int_vars[5] = 0;
L222: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L223;
L223: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L224: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Increment__post_dec_array_field_access_constant_index(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[6] = {0};
  double double_vars[5];
  float float_vars[5];
  int64_t long_vars[5];
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  int8_t byte_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3b < 0) {
      BASIC_TYPE_ID_TestCase__Point_3b = env->get_basic_type_id(env, "TestCase::Point_3b");
      if (BASIC_TYPE_ID_TestCase__Point_3b < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3b");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3b;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 64;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3s < 0) {
      BASIC_TYPE_ID_TestCase__Point_3s = env->get_basic_type_id(env, "TestCase::Point_3s");
      if (BASIC_TYPE_ID_TestCase__Point_3s < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3s");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3s;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 65;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L11: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3i < 0) {
      BASIC_TYPE_ID_TestCase__Point_3i = env->get_basic_type_id(env, "TestCase::Point_3i");
      if (BASIC_TYPE_ID_TestCase__Point_3i < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3i");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3i;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 66;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L15: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3l < 0) {
      BASIC_TYPE_ID_TestCase__Point_3l = env->get_basic_type_id(env, "TestCase::Point_3l");
      if (BASIC_TYPE_ID_TestCase__Point_3l < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3l");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3l;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[3], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 67;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L19: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3f < 0) {
      BASIC_TYPE_ID_TestCase__Point_3f = env->get_basic_type_id(env, "TestCase::Point_3f");
      if (BASIC_TYPE_ID_TestCase__Point_3f < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3f");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3f;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 68;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L23: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3d < 0) {
      BASIC_TYPE_ID_TestCase__Point_3d = env->get_basic_type_id(env, "TestCase::Point_3d");
      if (BASIC_TYPE_ID_TestCase__Point_3d < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3d");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3d;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[5], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 69;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L25: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 71;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L27: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // MOVE_INT
  int_vars[3] = int_vars[2];
L30: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = byte_vars[1];
      }
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 71;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L32: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 72;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L34: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L36: // MOVE_INT
  int_vars[3] = int_vars[2];
L37: // MULNUM_ARRAY_FIELD_STORE_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = short_vars[1];
      }
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 72;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L39: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 73;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L41: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L42: // MOVE_INT
  int_vars[4] = int_vars[3];
L43: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = int_vars[2];
      }
    }
  }
L44: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 73;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L45: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 74;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L47: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L48: // MOVE_INT
  int_vars[3] = int_vars[2];
L49: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = long_vars[0];
      }
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 74;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L51: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L52: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 75;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L53: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L54: // MOVE_INT
  int_vars[3] = int_vars[2];
L55: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = float_vars[0];
      }
    }
  }
L56: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 75;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L57: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L58: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 76;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L59: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L60: // MOVE_INT
  int_vars[3] = int_vars[2];
L61: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = double_vars[0];
      }
    }
  }
L62: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 76;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L63: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L64: // MOVE_INT
  int_vars[3] = int_vars[2];
L65: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L66: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 78;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L67: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L68: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L69: // SUBTRACT_INT
  int_vars[6] = int_vars[4] - int_vars[5];
L70: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[6];
L71: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = byte_vars[1];
      }
    }
  }
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 78;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L73: // MOVE_BYTE
  byte_vars[2] = byte_vars[0];
L74: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L75: // MOVE_INT
  int_vars[3] = int_vars[2];
L76: // MULNUM_ARRAY_FIELD_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] =((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L77: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 79;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L78: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L79: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L80: // SUBTRACT_INT
  int_vars[6] = int_vars[4] - int_vars[5];
L81: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[6];
L82: // MULNUM_ARRAY_FIELD_STORE_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = short_vars[1];
      }
    }
  }
L83: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 79;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L84: // MOVE_SHORT
  short_vars[2] = short_vars[0];
L85: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L86: // MOVE_INT
  int_vars[3] = int_vars[2];
L87: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L88: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 80;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L89: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L90: // SUBTRACT_INT
  int_vars[6] = int_vars[4] - int_vars[5];
L91: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = int_vars[6];
      }
    }
  }
L92: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 80;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L93: // MOVE_INT
  int_vars[7] = int_vars[4];
L94: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L95: // MOVE_INT
  int_vars[3] = int_vars[2];
L96: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L97: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 81;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L98: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L99: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L100: // SUBTRACT_LONG
  long_vars[2] = long_vars[0] - long_vars[1];
L101: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = long_vars[2];
      }
    }
  }
L102: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 81;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L103: // MOVE_LONG
  long_vars[3] = long_vars[0];
L104: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L105: // MOVE_INT
  int_vars[3] = int_vars[2];
L106: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L107: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 82;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L108: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L109: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[4];
L110: // SUBTRACT_FLOAT
  float_vars[2] = float_vars[0] - float_vars[1];
L111: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = float_vars[2];
      }
    }
  }
L112: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 82;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L113: // MOVE_FLOAT
  float_vars[3] = float_vars[0];
L114: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L115: // MOVE_INT
  int_vars[3] = int_vars[2];
L116: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L117: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 83;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L118: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L119: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[4];
L120: // SUBTRACT_DOUBLE
  double_vars[2] = double_vars[0] - double_vars[1];
L121: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = double_vars[2];
      }
    }
  }
L122: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 83;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L123: // MOVE_DOUBLE
  double_vars[3] = double_vars[0];
L124: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L125: // MOVE_INT
  int_vars[3] = int_vars[2];
L126: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L127: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 85;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L128: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L129: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[1] = *(int8_t*)&stack[0];
    }
  }
L130: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 85;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L131: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[1];
L132: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L133: // SUBTRACT_INT
  int_vars[8] = int_vars[5] - int_vars[6];
L134: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L135: // BOOL_INT
  int_vars[0] = int_vars[0];
L136: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L244; }
L137: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[2];
L138: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L139: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 86;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L140: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L141: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L142: // BOOL_INT
  int_vars[0] = int_vars[0];
L143: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L243; }
L144: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L145: // MOVE_INT
  int_vars[3] = int_vars[2];
L146: // MULNUM_ARRAY_FIELD_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] =((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L147: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 87;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L148: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L149: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L150: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 87;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L151: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[1];
L152: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L153: // SUBTRACT_INT
  int_vars[8] = int_vars[5] - int_vars[6];
L154: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L155: // BOOL_INT
  int_vars[0] = int_vars[0];
L156: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L242; }
L157: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[2];
L158: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L159: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 88;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L160: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L161: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L162: // BOOL_INT
  int_vars[0] = int_vars[0];
L163: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L241; }
L164: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L165: // MOVE_INT
  int_vars[3] = int_vars[2];
L166: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L167: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 89;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L168: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L169: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 89;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L170: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L171: // SUBTRACT_INT
  int_vars[8] = int_vars[5] - int_vars[6];
L172: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L173: // BOOL_INT
  int_vars[0] = int_vars[0];
L174: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L240; }
L175: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L176: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 90;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L177: // EQ_INT
  int_vars[0] = (int_vars[7] == int_vars[2]);
L178: // BOOL_INT
  int_vars[0] = int_vars[0];
L179: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L239; }
L180: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L181: // MOVE_INT
  int_vars[3] = int_vars[2];
L182: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L183: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 91;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L184: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L185: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 91;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L186: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L187: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[4];
L188: // SUBTRACT_LONG
  long_vars[4] = long_vars[1] - long_vars[2];
L189: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[4]);
L190: // BOOL_INT
  int_vars[0] = int_vars[0];
L191: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L238; }
L192: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L193: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 92;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L194: // EQ_LONG
  int_vars[0] = (long_vars[3] == long_vars[0]);
L195: // BOOL_INT
  int_vars[0] = int_vars[0];
L196: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L237; }
L197: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L198: // MOVE_INT
  int_vars[3] = int_vars[2];
L199: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L200: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 93;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L201: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L202: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 93;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L203: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L204: // CONVERT_INT_TO_FLOAT
  float_vars[2] = (float)int_vars[4];
L205: // SUBTRACT_FLOAT
  float_vars[4] = float_vars[1] - float_vars[2];
L206: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[4]);
L207: // BOOL_INT
  int_vars[0] = int_vars[0];
L208: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L236; }
L209: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L210: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 94;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L211: // EQ_FLOAT
  int_vars[0] = (float_vars[3] == float_vars[0]);
L212: // BOOL_INT
  int_vars[0] = int_vars[0];
L213: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L235; }
L214: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L215: // MOVE_INT
  int_vars[3] = int_vars[2];
L216: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L217: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 95;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L218: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L219: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 95;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L220: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L221: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[4];
L222: // SUBTRACT_DOUBLE
  double_vars[4] = double_vars[1] - double_vars[2];
L223: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[4]);
L224: // BOOL_INT
  int_vars[0] = int_vars[0];
L225: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L234; }
L226: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L227: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 96;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L228: // BOOL_DOUBLE
  int_vars[0] = !!double_vars[3];
L229: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L233; }
L230: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L231: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L246;
L232: // GOTO
  goto L233;
L233: // GOTO
  goto L234;
L234: // GOTO
  goto L235;
L235: // GOTO
  goto L236;
L236: // GOTO
  goto L237;
L237: // GOTO
  goto L238;
L238: // GOTO
  goto L239;
L239: // GOTO
  goto L240;
L240: // GOTO
  goto L241;
L241: // GOTO
  goto L242;
L242: // GOTO
  goto L243;
L243: // GOTO
  goto L244;
L244: // INIT_INT
  int_vars[4] = 0;
L245: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L246;
L246: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L247: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Increment__post_dec_array_field_access_invocant_not_var(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULTI_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3i < 0) {
      BASIC_TYPE_ID_TestCase__Point_3i = env->get_basic_type_id(env, "TestCase::Point_3i");
      if (BASIC_TYPE_ID_TestCase__Point_3i < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3i");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3i;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_muldim_array_raw(env, basic_type_id, 1, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 49;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3i < 0) {
      BASIC_TYPE_ID_TestCase__Point_3i = env->get_basic_type_id(env, "TestCase::Point_3i");
      if (BASIC_TYPE_ID_TestCase__Point_3i < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3i");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3i;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 50;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L10: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 50;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L12: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L15: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 52;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L18: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L19: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L20: // MOVE_INT
  int_vars[4] = int_vars[3];
L21: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[5] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 52;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L23: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L24: // SUBTRACT_INT
  int_vars[7] = int_vars[5] - int_vars[6];
L25: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = int_vars[7];
      }
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 52;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L27: // MOVE_INT
  int_vars[8] = int_vars[5];
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L29: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L30: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L31: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L32: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 54;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L34: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L35: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L36: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L37: // MOVE_INT
  int_vars[4] = int_vars[3];
L38: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[5] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_array_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 54;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L40: // MOVE_CONSTANT_INT
  int_vars[6] = -1;
L41: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L42: // BOOL_INT
  int_vars[0] = int_vars[0];
L43: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L54; }
L44: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L45: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L46: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L47: // EQ_INT
  int_vars[0] = (int_vars[8] == int_vars[2]);
L48: // BOOL_INT
  int_vars[0] = int_vars[0];
L49: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L53; }
L50: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L51: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L59;
L52: // GOTO
  goto L53;
L53: // GOTO
  goto L54;
L54: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L55: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L56: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L59;
L57: // INIT_INT
  int_vars[6] = 0;
L58: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L59;
L59: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L60: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Increment__post_dec_deref(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[6] = {0};
  double double_vars[6];
  float float_vars[6];
  int64_t long_vars[6];
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[4];
  int8_t byte_vars[4];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 155;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L3: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L4: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 156;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L6: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L7: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 157;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L9: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 158;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L11: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 159;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L13: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 160;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L15: // REF_BYTE
  *(void**)&ref_vars[0] = &byte_vars[1];
L16: // REF_SHORT
  *(void**)&ref_vars[1] = &short_vars[1];
L17: // REF_INT
  *(void**)&ref_vars[2] = &int_vars[2];
L18: // REF_LONG
  *(void**)&ref_vars[3] = &long_vars[0];
L19: // REF_FLOAT
  *(void**)&ref_vars[4] = &float_vars[0];
L20: // REF_DOUBLE
  *(void**)&ref_vars[5] = &double_vars[0];
L21: // GET_DEREF_BYTE
  byte_vars[0] = *(int8_t*)*(void**)&ref_vars[0];
L22: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L24: // SUBTRACT_INT
  int_vars[5] = int_vars[3] - int_vars[4];
L25: // CONVERT_INT_TO_BYTE
  byte_vars[2] = (int8_t)int_vars[5];
L26: // SET_DEREF_BYTE
  *(int8_t*)*(void**)&ref_vars[0] = byte_vars[2];
L27: // MOVE_BYTE
  byte_vars[3] = byte_vars[0];
L28: // GET_DEREF_SHORT
  short_vars[0] = *(int16_t*)*(void**)&ref_vars[1];
L29: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L30: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L31: // SUBTRACT_INT
  int_vars[5] = int_vars[3] - int_vars[4];
L32: // CONVERT_INT_TO_SHORT
  short_vars[2] = (int16_t)int_vars[5];
L33: // SET_DEREF_SHORT
  *(int16_t*)*(void**)&ref_vars[1] = short_vars[2];
L34: // MOVE_SHORT
  short_vars[3] = short_vars[0];
L35: // GET_DEREF_INT
  int_vars[3] = *(int32_t*)*(void**)&ref_vars[2];
L36: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L37: // SUBTRACT_INT
  int_vars[5] = int_vars[3] - int_vars[4];
L38: // SET_DEREF_INT
  *(int32_t*)*(void**)&ref_vars[2] = int_vars[5];
L39: // MOVE_INT
  int_vars[6] = int_vars[3];
L40: // GET_DEREF_LONG
  long_vars[1] = *(int64_t*)*(void**)&ref_vars[3];
L41: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L42: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[3];
L43: // SUBTRACT_LONG
  long_vars[3] = long_vars[1] - long_vars[2];
L44: // SET_DEREF_LONG
  *(int64_t*)*(void**)&ref_vars[3] = long_vars[3];
L45: // MOVE_LONG
  long_vars[4] = long_vars[1];
L46: // GET_DEREF_FLOAT
  float_vars[1] = *(float*)*(void**)&ref_vars[4];
L47: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L48: // CONVERT_INT_TO_FLOAT
  float_vars[2] = (float)int_vars[3];
L49: // SUBTRACT_FLOAT
  float_vars[3] = float_vars[1] - float_vars[2];
L50: // SET_DEREF_FLOAT
  *(float*)*(void**)&ref_vars[4] = float_vars[3];
L51: // MOVE_FLOAT
  float_vars[4] = float_vars[1];
L52: // GET_DEREF_DOUBLE
  double_vars[1] = *(double*)*(void**)&ref_vars[5];
L53: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L54: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[3];
L55: // SUBTRACT_DOUBLE
  double_vars[3] = double_vars[1] - double_vars[2];
L56: // SET_DEREF_DOUBLE
  *(double*)*(void**)&ref_vars[5] = double_vars[3];
L57: // MOVE_DOUBLE
  double_vars[4] = double_vars[1];
L58: // GET_DEREF_BYTE
  byte_vars[0] = *(int8_t*)*(void**)&ref_vars[0];
L59: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L60: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[2] = *(int8_t*)&stack[0];
    }
  }
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 176;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L62: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[2];
L63: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L64: // SUBTRACT_INT
  int_vars[7] = int_vars[4] - int_vars[5];
L65: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L66: // BOOL_INT
  int_vars[0] = int_vars[0];
L67: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L160; }
L68: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[3];
L69: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 177;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L71: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L72: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L73: // BOOL_INT
  int_vars[0] = int_vars[0];
L74: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L159; }
L75: // GET_DEREF_SHORT
  short_vars[0] = *(int16_t*)*(void**)&ref_vars[1];
L76: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L77: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[2] = *(int16_t*)&stack[0];
    }
  }
L78: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 178;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L79: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[2];
L80: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L81: // SUBTRACT_INT
  int_vars[7] = int_vars[4] - int_vars[5];
L82: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L83: // BOOL_INT
  int_vars[0] = int_vars[0];
L84: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L158; }
L85: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[3];
L86: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L87: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 179;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L88: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L89: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L90: // BOOL_INT
  int_vars[0] = int_vars[0];
L91: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L157; }
L92: // GET_DEREF_INT
  int_vars[3] = *(int32_t*)*(void**)&ref_vars[2];
L93: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L94: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 180;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L95: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L96: // SUBTRACT_INT
  int_vars[7] = int_vars[4] - int_vars[5];
L97: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L98: // BOOL_INT
  int_vars[0] = int_vars[0];
L99: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L156; }
L100: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L101: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 181;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L102: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[3]);
L103: // BOOL_INT
  int_vars[0] = int_vars[0];
L104: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L155; }
L105: // GET_DEREF_LONG
  long_vars[1] = *(int64_t*)*(void**)&ref_vars[3];
L106: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[2] = *(int64_t*)&stack[0];
    }
  }
L107: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 182;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L108: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L109: // CONVERT_INT_TO_LONG
  long_vars[3] = (int64_t)int_vars[3];
L110: // SUBTRACT_LONG
  long_vars[5] = long_vars[2] - long_vars[3];
L111: // EQ_LONG
  int_vars[0] = (long_vars[1] == long_vars[5]);
L112: // BOOL_INT
  int_vars[0] = int_vars[0];
L113: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L154; }
L114: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L115: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 183;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L116: // EQ_LONG
  int_vars[0] = (long_vars[4] == long_vars[1]);
L117: // BOOL_INT
  int_vars[0] = int_vars[0];
L118: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L153; }
L119: // GET_DEREF_FLOAT
  float_vars[1] = *(float*)*(void**)&ref_vars[4];
L120: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L121: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 184;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L122: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L123: // CONVERT_INT_TO_FLOAT
  float_vars[3] = (float)int_vars[3];
L124: // SUBTRACT_FLOAT
  float_vars[5] = float_vars[2] - float_vars[3];
L125: // EQ_FLOAT
  int_vars[0] = (float_vars[1] == float_vars[5]);
L126: // BOOL_INT
  int_vars[0] = int_vars[0];
L127: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L152; }
L128: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L129: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 185;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L130: // EQ_FLOAT
  int_vars[0] = (float_vars[4] == float_vars[1]);
L131: // BOOL_INT
  int_vars[0] = int_vars[0];
L132: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L151; }
L133: // GET_DEREF_DOUBLE
  double_vars[1] = *(double*)*(void**)&ref_vars[5];
L134: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L135: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 186;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L136: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L137: // CONVERT_INT_TO_DOUBLE
  double_vars[3] = (double)int_vars[3];
L138: // SUBTRACT_DOUBLE
  double_vars[5] = double_vars[2] - double_vars[3];
L139: // EQ_DOUBLE
  int_vars[0] = (double_vars[1] == double_vars[5]);
L140: // BOOL_INT
  int_vars[0] = int_vars[0];
L141: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L150; }
L142: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[4] = *(double*)&stack[0];
    }
  }
L143: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 187;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L144: // BOOL_DOUBLE
  int_vars[0] = !!double_vars[4];
L145: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L149; }
L146: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L147: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L162;
L148: // GOTO
  goto L149;
L149: // GOTO
  goto L150;
L150: // GOTO
  goto L151;
L151: // GOTO
  goto L152;
L152: // GOTO
  goto L153;
L153: // GOTO
  goto L154;
L154: // GOTO
  goto L155;
L155: // GOTO
  goto L156;
L156: // GOTO
  goto L157;
L157: // GOTO
  goto L158;
L158: // GOTO
  goto L159;
L159: // GOTO
  goto L160;
L160: // INIT_INT
  int_vars[5] = 0;
L161: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L162;
L162: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Increment__post_dec_field_access(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  double double_vars[5];
  float float_vars[5];
  int64_t long_vars[5];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  int8_t byte_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Simple->new
  {
    if (SUB_ID_TestCase__Simple__new < 0) {
      SUB_ID_TestCase__Simple__new = env->get_sub_id(env, "TestCase::Simple", "new", "TestCase::Simple()");
      if (SUB_ID_TestCase__Simple__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Simple new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Simple__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 204;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L4: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 206;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L6: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L7: // SET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__byte_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__byte_value = env->get_field_id(env, "TestCase::Simple", "byte_value", "byte");
      if (FIELD_ID_TestCase__Simple__byte_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple byte_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__byte_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__byte_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__byte_value) = byte_vars[1];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 206;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L9: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 207;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L11: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L12: // SET_FIELD_SHORT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__short_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__short_value = env->get_field_id(env, "TestCase::Simple", "short_value", "short");
      if (FIELD_ID_TestCase__Simple__short_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple short_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__short_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__short_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int16_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__short_value) = short_vars[1];
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 207;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L14: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 208;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L16: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__int_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__int_value = env->get_field_id(env, "TestCase::Simple", "int_value", "int");
      if (FIELD_ID_TestCase__Simple__int_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple int_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__int_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__int_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__int_value) = int_vars[2];
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 208;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L18: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 209;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L20: // SET_FIELD_LONG
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__long_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__long_value = env->get_field_id(env, "TestCase::Simple", "long_value", "long");
      if (FIELD_ID_TestCase__Simple__long_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple long_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__long_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__long_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int64_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__long_value) = long_vars[0];
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 209;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L22: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 210;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L24: // SET_FIELD_FLOAT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__float_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__float_value = env->get_field_id(env, "TestCase::Simple", "float_value", "float");
      if (FIELD_ID_TestCase__Simple__float_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple float_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__float_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__float_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(float*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__float_value) = float_vars[0];
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 210;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L26: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 211;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L28: // SET_FIELD_DOUBLE
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__double_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__double_value = env->get_field_id(env, "TestCase::Simple", "double_value", "double");
      if (FIELD_ID_TestCase__Simple__double_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple double_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__double_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__double_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(double*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__double_value) = double_vars[0];
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 211;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L30: // GET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__byte_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__byte_value = env->get_field_id(env, "TestCase::Simple", "byte_value", "byte");
      if (FIELD_ID_TestCase__Simple__byte_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple byte_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__byte_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__byte_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      byte_vars[0] = *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__byte_value);
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 213;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L32: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L33: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L34: // SUBTRACT_INT
  int_vars[4] = int_vars[2] - int_vars[3];
L35: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[4];
L36: // SET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__byte_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__byte_value = env->get_field_id(env, "TestCase::Simple", "byte_value", "byte");
      if (FIELD_ID_TestCase__Simple__byte_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple byte_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__byte_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__byte_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__byte_value) = byte_vars[1];
    }
  }
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 213;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L38: // MOVE_BYTE
  byte_vars[2] = byte_vars[0];
L39: // GET_FIELD_SHORT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__short_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__short_value = env->get_field_id(env, "TestCase::Simple", "short_value", "short");
      if (FIELD_ID_TestCase__Simple__short_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple short_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__short_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__short_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      short_vars[0] = *(int16_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__short_value);
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 214;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L41: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L42: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L43: // SUBTRACT_INT
  int_vars[4] = int_vars[2] - int_vars[3];
L44: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L45: // SET_FIELD_SHORT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__short_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__short_value = env->get_field_id(env, "TestCase::Simple", "short_value", "short");
      if (FIELD_ID_TestCase__Simple__short_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple short_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__short_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__short_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int16_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__short_value) = short_vars[1];
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 214;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L47: // MOVE_SHORT
  short_vars[2] = short_vars[0];
L48: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__int_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__int_value = env->get_field_id(env, "TestCase::Simple", "int_value", "int");
      if (FIELD_ID_TestCase__Simple__int_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple int_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__int_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__int_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__int_value);
    }
  }
L49: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 215;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L50: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L51: // SUBTRACT_INT
  int_vars[4] = int_vars[2] - int_vars[3];
L52: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__int_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__int_value = env->get_field_id(env, "TestCase::Simple", "int_value", "int");
      if (FIELD_ID_TestCase__Simple__int_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple int_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__int_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__int_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__int_value) = int_vars[4];
    }
  }
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 215;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L54: // MOVE_INT
  int_vars[5] = int_vars[2];
L55: // GET_FIELD_LONG
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__long_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__long_value = env->get_field_id(env, "TestCase::Simple", "long_value", "long");
      if (FIELD_ID_TestCase__Simple__long_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple long_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__long_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__long_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      long_vars[0] = *(int64_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__long_value);
    }
  }
L56: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 216;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L57: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L58: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L59: // SUBTRACT_LONG
  long_vars[2] = long_vars[0] - long_vars[1];
L60: // SET_FIELD_LONG
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__long_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__long_value = env->get_field_id(env, "TestCase::Simple", "long_value", "long");
      if (FIELD_ID_TestCase__Simple__long_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple long_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__long_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__long_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int64_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__long_value) = long_vars[2];
    }
  }
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 216;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L62: // MOVE_LONG
  long_vars[3] = long_vars[0];
L63: // GET_FIELD_FLOAT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__float_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__float_value = env->get_field_id(env, "TestCase::Simple", "float_value", "float");
      if (FIELD_ID_TestCase__Simple__float_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple float_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__float_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__float_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      float_vars[0] = *(float*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__float_value);
    }
  }
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 217;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L65: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L66: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[2];
L67: // SUBTRACT_FLOAT
  float_vars[2] = float_vars[0] - float_vars[1];
L68: // SET_FIELD_FLOAT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__float_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__float_value = env->get_field_id(env, "TestCase::Simple", "float_value", "float");
      if (FIELD_ID_TestCase__Simple__float_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple float_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__float_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__float_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(float*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__float_value) = float_vars[2];
    }
  }
L69: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 217;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L70: // MOVE_FLOAT
  float_vars[3] = float_vars[0];
L71: // GET_FIELD_DOUBLE
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__double_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__double_value = env->get_field_id(env, "TestCase::Simple", "double_value", "double");
      if (FIELD_ID_TestCase__Simple__double_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple double_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__double_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__double_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      double_vars[0] = *(double*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__double_value);
    }
  }
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 218;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L73: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L74: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[2];
L75: // SUBTRACT_DOUBLE
  double_vars[2] = double_vars[0] - double_vars[1];
L76: // SET_FIELD_DOUBLE
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__double_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__double_value = env->get_field_id(env, "TestCase::Simple", "double_value", "double");
      if (FIELD_ID_TestCase__Simple__double_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple double_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__double_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__double_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(double*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__double_value) = double_vars[2];
    }
  }
L77: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 218;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L78: // MOVE_DOUBLE
  double_vars[3] = double_vars[0];
L79: // GET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__byte_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__byte_value = env->get_field_id(env, "TestCase::Simple", "byte_value", "byte");
      if (FIELD_ID_TestCase__Simple__byte_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple byte_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__byte_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__byte_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      byte_vars[0] = *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__byte_value);
    }
  }
L80: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 220;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L81: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L82: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[1] = *(int8_t*)&stack[0];
    }
  }
L83: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 220;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L84: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[1];
L85: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L86: // SUBTRACT_INT
  int_vars[6] = int_vars[3] - int_vars[4];
L87: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L88: // BOOL_INT
  int_vars[0] = int_vars[0];
L89: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L187; }
L90: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[2];
L91: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L92: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 221;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L93: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L94: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L95: // BOOL_INT
  int_vars[0] = int_vars[0];
L96: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L186; }
L97: // GET_FIELD_SHORT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__short_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__short_value = env->get_field_id(env, "TestCase::Simple", "short_value", "short");
      if (FIELD_ID_TestCase__Simple__short_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple short_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__short_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__short_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      short_vars[0] = *(int16_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__short_value);
    }
  }
L98: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 222;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L99: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L100: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L101: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 222;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L102: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[1];
L103: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L104: // SUBTRACT_INT
  int_vars[6] = int_vars[3] - int_vars[4];
L105: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L106: // BOOL_INT
  int_vars[0] = int_vars[0];
L107: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L185; }
L108: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[2];
L109: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L110: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 223;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L111: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L112: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L113: // BOOL_INT
  int_vars[0] = int_vars[0];
L114: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L184; }
L115: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__int_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__int_value = env->get_field_id(env, "TestCase::Simple", "int_value", "int");
      if (FIELD_ID_TestCase__Simple__int_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple int_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__int_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__int_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__int_value);
    }
  }
L116: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 224;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L117: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L118: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 224;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L119: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L120: // SUBTRACT_INT
  int_vars[6] = int_vars[3] - int_vars[4];
L121: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L122: // BOOL_INT
  int_vars[0] = int_vars[0];
L123: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L183; }
L124: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L125: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 225;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L126: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[2]);
L127: // BOOL_INT
  int_vars[0] = int_vars[0];
L128: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L182; }
L129: // GET_FIELD_LONG
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__long_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__long_value = env->get_field_id(env, "TestCase::Simple", "long_value", "long");
      if (FIELD_ID_TestCase__Simple__long_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple long_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__long_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__long_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      long_vars[0] = *(int64_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__long_value);
    }
  }
L130: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 226;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L131: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L132: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 226;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L133: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L134: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[2];
L135: // SUBTRACT_LONG
  long_vars[4] = long_vars[1] - long_vars[2];
L136: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[4]);
L137: // BOOL_INT
  int_vars[0] = int_vars[0];
L138: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L181; }
L139: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L140: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 227;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L141: // EQ_LONG
  int_vars[0] = (long_vars[3] == long_vars[0]);
L142: // BOOL_INT
  int_vars[0] = int_vars[0];
L143: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L180; }
L144: // GET_FIELD_FLOAT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__float_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__float_value = env->get_field_id(env, "TestCase::Simple", "float_value", "float");
      if (FIELD_ID_TestCase__Simple__float_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple float_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__float_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__float_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      float_vars[0] = *(float*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__float_value);
    }
  }
L145: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 228;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L146: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L147: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 228;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L148: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L149: // CONVERT_INT_TO_FLOAT
  float_vars[2] = (float)int_vars[2];
L150: // SUBTRACT_FLOAT
  float_vars[4] = float_vars[1] - float_vars[2];
L151: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[4]);
L152: // BOOL_INT
  int_vars[0] = int_vars[0];
L153: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L179; }
L154: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L155: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 229;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L156: // EQ_FLOAT
  int_vars[0] = (float_vars[3] == float_vars[0]);
L157: // BOOL_INT
  int_vars[0] = int_vars[0];
L158: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L178; }
L159: // GET_FIELD_DOUBLE
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__double_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__double_value = env->get_field_id(env, "TestCase::Simple", "double_value", "double");
      if (FIELD_ID_TestCase__Simple__double_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple double_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__double_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__double_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      double_vars[0] = *(double*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__double_value);
    }
  }
L160: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 230;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L161: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L162: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 230;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L163: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L164: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[2];
L165: // SUBTRACT_DOUBLE
  double_vars[4] = double_vars[1] - double_vars[2];
L166: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[4]);
L167: // BOOL_INT
  int_vars[0] = int_vars[0];
L168: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L177; }
L169: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L170: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 231;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L171: // BOOL_DOUBLE
  int_vars[0] = !!double_vars[3];
L172: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L176; }
L173: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L174: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L189;
L175: // GOTO
  goto L176;
L176: // GOTO
  goto L177;
L177: // GOTO
  goto L178;
L178: // GOTO
  goto L179;
L179: // GOTO
  goto L180;
L180: // GOTO
  goto L181;
L181: // GOTO
  goto L182;
L182: // GOTO
  goto L183;
L183: // GOTO
  goto L184;
L184: // GOTO
  goto L185;
L185: // GOTO
  goto L186;
L186: // GOTO
  goto L187;
L187: // INIT_INT
  int_vars[4] = 0;
L188: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L189;
L189: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L190: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Increment__post_dec_field_access_invocant_not_var(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 19;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 20;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 20;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L11: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L12: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L14: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 22;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L16: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[3] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x);
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 22;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L18: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L19: // SUBTRACT_INT
  int_vars[5] = int_vars[3] - int_vars[4];
L20: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x) = int_vars[5];
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 22;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L22: // MOVE_INT
  int_vars[6] = int_vars[3];
L23: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L24: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L25: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L26: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 24;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L28: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[3] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x);
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 24;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L30: // MOVE_CONSTANT_INT
  int_vars[4] = -1;
L31: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L32: // BOOL_INT
  int_vars[0] = int_vars[0];
L33: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L43; }
L34: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L36: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[2]);
L37: // BOOL_INT
  int_vars[0] = int_vars[0];
L38: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L42; }
L39: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L48;
L41: // GOTO
  goto L42;
L42: // GOTO
  goto L43;
L43: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L45: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L48;
L46: // INIT_INT
  int_vars[7] = 0;
L47: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L48;
L48: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L49: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Increment__post_dec_package_var_access(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[5];
  float float_vars[5];
  int64_t long_vars[5];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  int8_t byte_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_package_var_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 113;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L3: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L4: // SET_PACKAGE_VAR_BYTE
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__Increment__BYTE_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__BYTE_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$BYTE_VALUE", "byte");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__BYTE_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $BYTE_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(int8_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__BYTE_VALUE] = byte_vars[1];
  }
L5: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_package_var_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 114;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L7: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L8: // SET_PACKAGE_VAR_SHORT
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__Increment__SHORT_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__SHORT_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$SHORT_VALUE", "short");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__SHORT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $SHORT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(int16_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__SHORT_VALUE] = short_vars[1];
  }
L9: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_package_var_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 115;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L11: // SET_PACKAGE_VAR_INT
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__Increment__INT_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__INT_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$INT_VALUE", "int");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__INT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $INT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(int32_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__INT_VALUE] = int_vars[2];
  }
L12: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_package_var_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 116;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L14: // SET_PACKAGE_VAR_LONG
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__Increment__LONG_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__LONG_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$LONG_VALUE", "long");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__LONG_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $LONG_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(int64_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__LONG_VALUE] = long_vars[0];
  }
L15: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_package_var_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 117;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L17: // SET_PACKAGE_VAR_FLOAT
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__Increment__FLOAT_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__FLOAT_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$FLOAT_VALUE", "float");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__FLOAT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $FLOAT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(float*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__FLOAT_VALUE] = float_vars[0];
  }
L18: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_package_var_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 118;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L20: // SET_PACKAGE_VAR_DOUBLE
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__Increment__DOUBLE_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__DOUBLE_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$DOUBLE_VALUE", "double");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__DOUBLE_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $DOUBLE_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(double*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__DOUBLE_VALUE] = double_vars[0];
  }
L21: // GET_PACKAGE_VAR_BYTE
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__Increment__BYTE_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__BYTE_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$BYTE_VALUE", "byte");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__BYTE_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $BYTE_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    byte_vars[0] = *(int8_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__BYTE_VALUE];
  }
L22: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L23: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L24: // SUBTRACT_INT
  int_vars[4] = int_vars[2] - int_vars[3];
L25: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[4];
L26: // SET_PACKAGE_VAR_BYTE
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__Increment__BYTE_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__BYTE_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$BYTE_VALUE", "byte");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__BYTE_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $BYTE_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(int8_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__BYTE_VALUE] = byte_vars[1];
  }
L27: // MOVE_BYTE
  byte_vars[2] = byte_vars[0];
L28: // GET_PACKAGE_VAR_SHORT
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__Increment__SHORT_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__SHORT_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$SHORT_VALUE", "short");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__SHORT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $SHORT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    short_vars[0] = *(int16_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__SHORT_VALUE];
  }
L29: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L30: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L31: // SUBTRACT_INT
  int_vars[4] = int_vars[2] - int_vars[3];
L32: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L33: // SET_PACKAGE_VAR_SHORT
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__Increment__SHORT_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__SHORT_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$SHORT_VALUE", "short");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__SHORT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $SHORT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(int16_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__SHORT_VALUE] = short_vars[1];
  }
L34: // MOVE_SHORT
  short_vars[2] = short_vars[0];
L35: // GET_PACKAGE_VAR_INT
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__Increment__INT_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__INT_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$INT_VALUE", "int");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__INT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $INT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int_vars[2] = *(int32_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__INT_VALUE];
  }
L36: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L37: // SUBTRACT_INT
  int_vars[4] = int_vars[2] - int_vars[3];
L38: // SET_PACKAGE_VAR_INT
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__Increment__INT_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__INT_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$INT_VALUE", "int");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__INT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $INT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(int32_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__INT_VALUE] = int_vars[4];
  }
L39: // MOVE_INT
  int_vars[5] = int_vars[2];
L40: // GET_PACKAGE_VAR_LONG
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__Increment__LONG_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__LONG_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$LONG_VALUE", "long");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__LONG_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $LONG_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    long_vars[0] = *(int64_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__LONG_VALUE];
  }
L41: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L42: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L43: // SUBTRACT_LONG
  long_vars[2] = long_vars[0] - long_vars[1];
L44: // SET_PACKAGE_VAR_LONG
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__Increment__LONG_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__LONG_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$LONG_VALUE", "long");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__LONG_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $LONG_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(int64_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__LONG_VALUE] = long_vars[2];
  }
L45: // MOVE_LONG
  long_vars[3] = long_vars[0];
L46: // GET_PACKAGE_VAR_FLOAT
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__Increment__FLOAT_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__FLOAT_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$FLOAT_VALUE", "float");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__FLOAT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $FLOAT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    float_vars[0] = *(float*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__FLOAT_VALUE];
  }
L47: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L48: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[2];
L49: // SUBTRACT_FLOAT
  float_vars[2] = float_vars[0] - float_vars[1];
L50: // SET_PACKAGE_VAR_FLOAT
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__Increment__FLOAT_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__FLOAT_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$FLOAT_VALUE", "float");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__FLOAT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $FLOAT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(float*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__FLOAT_VALUE] = float_vars[2];
  }
L51: // MOVE_FLOAT
  float_vars[3] = float_vars[0];
L52: // GET_PACKAGE_VAR_DOUBLE
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__Increment__DOUBLE_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__DOUBLE_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$DOUBLE_VALUE", "double");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__DOUBLE_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $DOUBLE_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    double_vars[0] = *(double*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__DOUBLE_VALUE];
  }
L53: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L54: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[2];
L55: // SUBTRACT_DOUBLE
  double_vars[2] = double_vars[0] - double_vars[1];
L56: // SET_PACKAGE_VAR_DOUBLE
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__Increment__DOUBLE_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__DOUBLE_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$DOUBLE_VALUE", "double");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__DOUBLE_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $DOUBLE_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(double*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__DOUBLE_VALUE] = double_vars[2];
  }
L57: // MOVE_DOUBLE
  double_vars[3] = double_vars[0];
L58: // GET_PACKAGE_VAR_BYTE
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__Increment__BYTE_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__BYTE_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$BYTE_VALUE", "byte");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__BYTE_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $BYTE_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    byte_vars[0] = *(int8_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__BYTE_VALUE];
  }
L59: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L60: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[1] = *(int8_t*)&stack[0];
    }
  }
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_package_var_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 127;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L62: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[1];
L63: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L64: // SUBTRACT_INT
  int_vars[6] = int_vars[3] - int_vars[4];
L65: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L66: // BOOL_INT
  int_vars[0] = int_vars[0];
L67: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L160; }
L68: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[2];
L69: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_package_var_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 128;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L71: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L72: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L73: // BOOL_INT
  int_vars[0] = int_vars[0];
L74: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L159; }
L75: // GET_PACKAGE_VAR_SHORT
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__Increment__SHORT_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__SHORT_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$SHORT_VALUE", "short");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__SHORT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $SHORT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    short_vars[0] = *(int16_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__SHORT_VALUE];
  }
L76: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L77: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L78: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_package_var_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 129;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L79: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[1];
L80: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L81: // SUBTRACT_INT
  int_vars[6] = int_vars[3] - int_vars[4];
L82: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L83: // BOOL_INT
  int_vars[0] = int_vars[0];
L84: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L158; }
L85: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[2];
L86: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L87: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_package_var_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 130;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L88: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L89: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L90: // BOOL_INT
  int_vars[0] = int_vars[0];
L91: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L157; }
L92: // GET_PACKAGE_VAR_INT
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__Increment__INT_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__INT_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$INT_VALUE", "int");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__INT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $INT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int_vars[2] = *(int32_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__INT_VALUE];
  }
L93: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L94: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_package_var_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 131;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L95: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L96: // SUBTRACT_INT
  int_vars[6] = int_vars[3] - int_vars[4];
L97: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L98: // BOOL_INT
  int_vars[0] = int_vars[0];
L99: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L156; }
L100: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L101: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_package_var_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 132;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L102: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[2]);
L103: // BOOL_INT
  int_vars[0] = int_vars[0];
L104: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L155; }
L105: // GET_PACKAGE_VAR_LONG
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__Increment__LONG_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__LONG_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$LONG_VALUE", "long");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__LONG_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $LONG_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    long_vars[0] = *(int64_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__LONG_VALUE];
  }
L106: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L107: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_package_var_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 133;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L108: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L109: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[2];
L110: // SUBTRACT_LONG
  long_vars[4] = long_vars[1] - long_vars[2];
L111: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[4]);
L112: // BOOL_INT
  int_vars[0] = int_vars[0];
L113: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L154; }
L114: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L115: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_package_var_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 134;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L116: // EQ_LONG
  int_vars[0] = (long_vars[3] == long_vars[0]);
L117: // BOOL_INT
  int_vars[0] = int_vars[0];
L118: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L153; }
L119: // GET_PACKAGE_VAR_FLOAT
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__Increment__FLOAT_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__FLOAT_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$FLOAT_VALUE", "float");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__FLOAT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $FLOAT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    float_vars[0] = *(float*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__FLOAT_VALUE];
  }
L120: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L121: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_package_var_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 135;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L122: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L123: // CONVERT_INT_TO_FLOAT
  float_vars[2] = (float)int_vars[2];
L124: // SUBTRACT_FLOAT
  float_vars[4] = float_vars[1] - float_vars[2];
L125: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[4]);
L126: // BOOL_INT
  int_vars[0] = int_vars[0];
L127: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L152; }
L128: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L129: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_package_var_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 136;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L130: // EQ_FLOAT
  int_vars[0] = (float_vars[3] == float_vars[0]);
L131: // BOOL_INT
  int_vars[0] = int_vars[0];
L132: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L151; }
L133: // GET_PACKAGE_VAR_DOUBLE
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__Increment__DOUBLE_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__DOUBLE_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$DOUBLE_VALUE", "double");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__DOUBLE_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $DOUBLE_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    double_vars[0] = *(double*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__DOUBLE_VALUE];
  }
L134: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L135: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_package_var_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 137;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L136: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L137: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[2];
L138: // SUBTRACT_DOUBLE
  double_vars[4] = double_vars[1] - double_vars[2];
L139: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[4]);
L140: // BOOL_INT
  int_vars[0] = int_vars[0];
L141: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L150; }
L142: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L143: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_package_var_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 138;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L144: // BOOL_DOUBLE
  int_vars[0] = !!double_vars[3];
L145: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L149; }
L146: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L147: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L162;
L148: // GOTO
  goto L149;
L149: // GOTO
  goto L150;
L150: // GOTO
  goto L151;
L151: // GOTO
  goto L152;
L152: // GOTO
  goto L153;
L153: // GOTO
  goto L154;
L154: // GOTO
  goto L155;
L155: // GOTO
  goto L156;
L156: // GOTO
  goto L157;
L157: // GOTO
  goto L158;
L158: // GOTO
  goto L159;
L159: // GOTO
  goto L160;
L160: // INIT_INT
  int_vars[4] = 0;
L161: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L162;
L162: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Increment__post_dec_var(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[5];
  float float_vars[5];
  int64_t long_vars[5];
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  int8_t byte_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 347;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L144;
  }
L3: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L4: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 348;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L144;
  }
L6: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L7: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 349;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L144;
  }
L9: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 350;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L144;
  }
L11: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 351;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L144;
  }
L13: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 352;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L144;
  }
L15: // MOVE_BYTE
  byte_vars[0] = byte_vars[1];
L16: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L18: // SUBTRACT_INT
  int_vars[5] = int_vars[3] - int_vars[4];
L19: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L20: // MOVE_BYTE
  byte_vars[2] = byte_vars[0];
L21: // MOVE_SHORT
  short_vars[0] = short_vars[1];
L22: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L24: // SUBTRACT_INT
  int_vars[5] = int_vars[3] - int_vars[4];
L25: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[5];
L26: // MOVE_SHORT
  short_vars[2] = short_vars[0];
L27: // MOVE_INT
  int_vars[3] = int_vars[2];
L28: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L29: // SUBTRACT_INT
  int_vars[2] = int_vars[3] - int_vars[4];
L30: // MOVE_INT
  int_vars[5] = int_vars[3];
L31: // MOVE_LONG
  long_vars[1] = long_vars[0];
L32: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L33: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[3];
L34: // SUBTRACT_LONG
  long_vars[0] = long_vars[1] - long_vars[2];
L35: // MOVE_LONG
  long_vars[3] = long_vars[1];
L36: // MOVE_FLOAT
  float_vars[1] = float_vars[0];
L37: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L38: // CONVERT_INT_TO_FLOAT
  float_vars[2] = (float)int_vars[3];
L39: // SUBTRACT_FLOAT
  float_vars[0] = float_vars[1] - float_vars[2];
L40: // MOVE_FLOAT
  float_vars[3] = float_vars[1];
L41: // MOVE_DOUBLE
  double_vars[1] = double_vars[0];
L42: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L43: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[3];
L44: // SUBTRACT_DOUBLE
  double_vars[0] = double_vars[1] - double_vars[2];
L45: // MOVE_DOUBLE
  double_vars[3] = double_vars[1];
L46: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[1];
L47: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 361;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L144;
  }
L49: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L50: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L51: // SUBTRACT_INT
  int_vars[7] = int_vars[4] - int_vars[6];
L52: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L53: // BOOL_INT
  int_vars[0] = int_vars[0];
L54: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L142; }
L55: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[2];
L56: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L57: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 362;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L144;
  }
L58: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L59: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L60: // BOOL_INT
  int_vars[0] = int_vars[0];
L61: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L141; }
L62: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[1];
L63: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 363;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L144;
  }
L65: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L66: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L67: // SUBTRACT_INT
  int_vars[7] = int_vars[4] - int_vars[6];
L68: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L69: // BOOL_INT
  int_vars[0] = int_vars[0];
L70: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L140; }
L71: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[2];
L72: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L73: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 364;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L144;
  }
L74: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L75: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L76: // BOOL_INT
  int_vars[0] = int_vars[0];
L77: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L139; }
L78: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L79: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 365;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L144;
  }
L80: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L81: // SUBTRACT_INT
  int_vars[6] = int_vars[3] - int_vars[4];
L82: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L83: // BOOL_INT
  int_vars[0] = int_vars[0];
L84: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L138; }
L85: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L86: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 366;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L144;
  }
L87: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[3]);
L88: // BOOL_INT
  int_vars[0] = int_vars[0];
L89: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L137; }
L90: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L91: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 367;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L144;
  }
L92: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L93: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[3];
L94: // SUBTRACT_LONG
  long_vars[4] = long_vars[1] - long_vars[2];
L95: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[4]);
L96: // BOOL_INT
  int_vars[0] = int_vars[0];
L97: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L136; }
L98: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L99: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 368;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L144;
  }
L100: // EQ_LONG
  int_vars[0] = (long_vars[3] == long_vars[1]);
L101: // BOOL_INT
  int_vars[0] = int_vars[0];
L102: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L135; }
L103: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L104: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 369;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L144;
  }
L105: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L106: // CONVERT_INT_TO_FLOAT
  float_vars[2] = (float)int_vars[3];
L107: // SUBTRACT_FLOAT
  float_vars[4] = float_vars[1] - float_vars[2];
L108: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[4]);
L109: // BOOL_INT
  int_vars[0] = int_vars[0];
L110: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L134; }
L111: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[3] = *(float*)&stack[0];
    }
  }
L112: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 370;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L144;
  }
L113: // BOOL_FLOAT
  int_vars[0] = !!float_vars[3];
L114: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L133; }
L115: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L116: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 371;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L144;
  }
L117: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L118: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[3];
L119: // SUBTRACT_DOUBLE
  double_vars[4] = double_vars[1] - double_vars[2];
L120: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[4]);
L121: // BOOL_INT
  int_vars[0] = int_vars[0];
L122: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L132; }
L123: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L124: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_dec_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 372;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L144;
  }
L125: // EQ_DOUBLE
  int_vars[0] = (double_vars[3] == double_vars[1]);
L126: // BOOL_INT
  int_vars[0] = int_vars[0];
L127: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L131; }
L128: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L129: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L144;
L130: // GOTO
  goto L131;
L131: // GOTO
  goto L132;
L132: // GOTO
  goto L133;
L133: // GOTO
  goto L134;
L134: // GOTO
  goto L135;
L135: // GOTO
  goto L136;
L136: // GOTO
  goto L137;
L137: // GOTO
  goto L138;
L138: // GOTO
  goto L139;
L139: // GOTO
  goto L140;
L140: // GOTO
  goto L141;
L141: // GOTO
  goto L142;
L142: // INIT_INT
  int_vars[6] = 0;
L143: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L144;
L144: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Increment__post_inc_array_access_constant_index(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[6] = {0};
  double double_vars[5];
  float float_vars[5];
  int64_t long_vars[5];
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  int8_t byte_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 668;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 669;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L11: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 670;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L15: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[3], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 671;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L19: // NEW_FLOAT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_float_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 672;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L23: // NEW_DOUBLE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_double_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[5], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 673;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L25: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 675;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L27: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 675;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L31: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 676;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L33: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L34: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L35: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 676;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L37: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 677;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L40: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[2];
      } 
    } 
  } 
L41: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 677;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L42: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 678;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L45: // ARRAY_STORE_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 678;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L47: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 679;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L49: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L50: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[0];
      } 
    } 
  } 
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 679;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L52: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 680;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L54: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L55: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[0];
      } 
    } 
  } 
L56: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 680;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L57: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L58: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 682;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L60: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L61: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L62: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L63: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L64: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L65: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 682;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L66: // MOVE_BYTE
  byte_vars[2] = byte_vars[0];
L67: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L68: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L69: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 683;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L70: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L71: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L72: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L73: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[5];
L74: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L75: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 683;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L76: // MOVE_SHORT
  short_vars[2] = short_vars[0];
L77: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L78: // ARRAY_FETCH_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L79: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 684;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L80: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L81: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L82: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L83: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 684;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L84: // MOVE_INT
  int_vars[6] = int_vars[3];
L85: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L86: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L87: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 685;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L88: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L89: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[3];
L90: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L91: // ARRAY_STORE_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L92: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 685;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L93: // MOVE_LONG
  long_vars[3] = long_vars[0];
L94: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L95: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L96: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 686;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L97: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L98: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[3];
L99: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L100: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[2];
      } 
    } 
  } 
L101: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 686;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L102: // MOVE_FLOAT
  float_vars[3] = float_vars[0];
L103: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L104: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L105: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 687;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L106: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L107: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[3];
L108: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L109: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[2];
      } 
    } 
  } 
L110: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 687;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L111: // MOVE_DOUBLE
  double_vars[3] = double_vars[0];
L112: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L113: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L114: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 689;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L115: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L116: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[1] = *(int8_t*)&stack[0];
    }
  }
L117: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 689;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L118: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L119: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L120: // ADD_INT
  int_vars[7] = int_vars[4] + int_vars[5];
L121: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L122: // BOOL_INT
  int_vars[0] = int_vars[0];
L123: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L226; }
L124: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[2];
L125: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L126: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 690;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L127: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L128: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L129: // BOOL_INT
  int_vars[0] = int_vars[0];
L130: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L225; }
L131: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L132: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L133: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 691;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L134: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L135: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L136: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 691;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L137: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L138: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L139: // ADD_INT
  int_vars[7] = int_vars[4] + int_vars[5];
L140: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L141: // BOOL_INT
  int_vars[0] = int_vars[0];
L142: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L224; }
L143: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[2];
L144: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L145: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 692;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L146: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L147: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L148: // BOOL_INT
  int_vars[0] = int_vars[0];
L149: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L223; }
L150: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L151: // ARRAY_FETCH_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L152: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 693;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L153: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L154: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 693;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L155: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L156: // ADD_INT
  int_vars[7] = int_vars[4] + int_vars[5];
L157: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L158: // BOOL_INT
  int_vars[0] = int_vars[0];
L159: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L222; }
L160: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L161: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 694;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L162: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[2]);
L163: // BOOL_INT
  int_vars[0] = int_vars[0];
L164: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L221; }
L165: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L166: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L167: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 695;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L168: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L169: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 695;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L170: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L171: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[3];
L172: // ADD_LONG
  long_vars[4] = long_vars[1] + long_vars[2];
L173: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[4]);
L174: // BOOL_INT
  int_vars[0] = int_vars[0];
L175: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L220; }
L176: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L177: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 696;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L178: // EQ_LONG
  int_vars[0] = (long_vars[3] == long_vars[0]);
L179: // BOOL_INT
  int_vars[0] = int_vars[0];
L180: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L219; }
L181: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L182: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L183: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 697;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L184: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L185: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 697;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L186: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L187: // CONVERT_INT_TO_FLOAT
  float_vars[2] = (float)int_vars[3];
L188: // ADD_FLOAT
  float_vars[4] = float_vars[1] + float_vars[2];
L189: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[4]);
L190: // BOOL_INT
  int_vars[0] = int_vars[0];
L191: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L218; }
L192: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L193: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 698;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L194: // EQ_FLOAT
  int_vars[0] = (float_vars[3] == float_vars[0]);
L195: // BOOL_INT
  int_vars[0] = int_vars[0];
L196: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L217; }
L197: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L198: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L199: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 699;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L200: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L201: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 699;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L202: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L203: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[3];
L204: // ADD_DOUBLE
  double_vars[4] = double_vars[1] + double_vars[2];
L205: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[4]);
L206: // BOOL_INT
  int_vars[0] = int_vars[0];
L207: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L216; }
L208: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L209: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 700;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L210: // BOOL_DOUBLE
  int_vars[0] = !!double_vars[3];
L211: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L215; }
L212: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L213: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L228;
L214: // GOTO
  goto L215;
L215: // GOTO
  goto L216;
L216: // GOTO
  goto L217;
L217: // GOTO
  goto L218;
L218: // GOTO
  goto L219;
L219: // GOTO
  goto L220;
L220: // GOTO
  goto L221;
L221: // GOTO
  goto L222;
L222: // GOTO
  goto L223;
L223: // GOTO
  goto L224;
L224: // GOTO
  goto L225;
L225: // GOTO
  goto L226;
L226: // INIT_INT
  int_vars[4] = 0;
L227: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L228;
L228: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L229: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Increment__post_inc_array_access_invocant_not_var(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULTI_ARRAY
  {
    if (BASIC_TYPE_ID_int < 0) {
      BASIC_TYPE_ID_int = env->get_basic_type_id(env, "int");
      if (BASIC_TYPE_ID_int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_int;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_muldim_array_raw(env, basic_type_id, 1, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 404;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L51;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 405;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L51;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L10: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 405;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L51;
  }
L12: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L15: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 407;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L51;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L18: // ARRAY_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 407;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L51;
  }
L20: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L21: // ADD_INT
  int_vars[6] = int_vars[4] + int_vars[5];
L22: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[6];
      } 
    } 
  } 
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 407;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L51;
  }
L24: // MOVE_INT
  int_vars[7] = int_vars[4];
L25: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L27: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L28: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 409;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L51;
  }
L30: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L31: // ARRAY_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 409;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L51;
  }
L33: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L34: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L35: // BOOL_INT
  int_vars[0] = int_vars[0];
L36: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L46; }
L37: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L38: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L39: // EQ_INT
  int_vars[0] = (int_vars[7] == int_vars[2]);
L40: // BOOL_INT
  int_vars[0] = int_vars[0];
L41: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L45; }
L42: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L43: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L51;
L44: // GOTO
  goto L45;
L45: // GOTO
  goto L46;
L46: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L47: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L48: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L51;
L49: // INIT_INT
  int_vars[6] = 0;
L50: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L51;
L51: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L52: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Increment__post_inc_array_access_var_index(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[6] = {0};
  double double_vars[5];
  float float_vars[5];
  int64_t long_vars[5];
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  int8_t byte_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 618;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 619;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L11: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 620;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L15: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[3], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 621;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L19: // NEW_FLOAT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_float_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 622;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L23: // NEW_DOUBLE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_double_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[5], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 623;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L25: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 625;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L27: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 625;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L31: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 626;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L33: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L34: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L35: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 626;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L37: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 627;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L40: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[2];
      } 
    } 
  } 
L41: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 627;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L42: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 628;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L45: // ARRAY_STORE_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 628;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L47: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 629;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L49: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L50: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[0];
      } 
    } 
  } 
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 629;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L52: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 630;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L54: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L55: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[0];
      } 
    } 
  } 
L56: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 630;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L57: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L58: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 633;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L60: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L61: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L62: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L63: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L64: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L65: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 633;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L66: // MOVE_BYTE
  byte_vars[2] = byte_vars[0];
L67: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L68: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 634;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L69: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L70: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L71: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L72: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[5];
L73: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L74: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 634;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L75: // MOVE_SHORT
  short_vars[2] = short_vars[0];
L76: // ARRAY_FETCH_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L77: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 635;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L78: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L79: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L80: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L81: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 635;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L82: // MOVE_INT
  int_vars[6] = int_vars[3];
L83: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L84: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 636;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L85: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L86: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[3];
L87: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L88: // ARRAY_STORE_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L89: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 636;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L90: // MOVE_LONG
  long_vars[3] = long_vars[0];
L91: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L92: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 637;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L93: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L94: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[3];
L95: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L96: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[2];
      } 
    } 
  } 
L97: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 637;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L98: // MOVE_FLOAT
  float_vars[3] = float_vars[0];
L99: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L100: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 638;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L101: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L102: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[3];
L103: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L104: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[2];
      } 
    } 
  } 
L105: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 638;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L106: // MOVE_DOUBLE
  double_vars[3] = double_vars[0];
L107: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L108: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L109: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 640;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L110: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L111: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[1] = *(int8_t*)&stack[0];
    }
  }
L112: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 640;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L113: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[1];
L114: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L115: // ADD_INT
  int_vars[8] = int_vars[5] + int_vars[7];
L116: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L117: // BOOL_INT
  int_vars[0] = int_vars[0];
L118: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L221; }
L119: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[2];
L120: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L121: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 641;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L122: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L123: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L124: // BOOL_INT
  int_vars[0] = int_vars[0];
L125: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L220; }
L126: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L127: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L128: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 642;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L129: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L130: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L131: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 642;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L132: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[1];
L133: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L134: // ADD_INT
  int_vars[8] = int_vars[5] + int_vars[7];
L135: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L136: // BOOL_INT
  int_vars[0] = int_vars[0];
L137: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L219; }
L138: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[2];
L139: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L140: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 643;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L141: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L142: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L143: // BOOL_INT
  int_vars[0] = int_vars[0];
L144: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L218; }
L145: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L146: // ARRAY_FETCH_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L147: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 644;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L148: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L149: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 644;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L150: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L151: // ADD_INT
  int_vars[8] = int_vars[5] + int_vars[7];
L152: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L153: // BOOL_INT
  int_vars[0] = int_vars[0];
L154: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L217; }
L155: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L156: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 645;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L157: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[3]);
L158: // BOOL_INT
  int_vars[0] = int_vars[0];
L159: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L216; }
L160: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L161: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L162: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 646;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L163: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L164: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 646;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L165: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L166: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[4];
L167: // ADD_LONG
  long_vars[4] = long_vars[1] + long_vars[2];
L168: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[4]);
L169: // BOOL_INT
  int_vars[0] = int_vars[0];
L170: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L215; }
L171: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L172: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 647;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L173: // EQ_LONG
  int_vars[0] = (long_vars[3] == long_vars[0]);
L174: // BOOL_INT
  int_vars[0] = int_vars[0];
L175: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L214; }
L176: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L177: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L178: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 648;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L179: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L180: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 648;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L181: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L182: // CONVERT_INT_TO_FLOAT
  float_vars[2] = (float)int_vars[4];
L183: // ADD_FLOAT
  float_vars[4] = float_vars[1] + float_vars[2];
L184: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[4]);
L185: // BOOL_INT
  int_vars[0] = int_vars[0];
L186: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L213; }
L187: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L188: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 649;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L189: // EQ_FLOAT
  int_vars[0] = (float_vars[3] == float_vars[0]);
L190: // BOOL_INT
  int_vars[0] = int_vars[0];
L191: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L212; }
L192: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L193: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L194: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 650;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L195: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L196: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 650;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L197: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L198: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[4];
L199: // ADD_DOUBLE
  double_vars[4] = double_vars[1] + double_vars[2];
L200: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[4]);
L201: // BOOL_INT
  int_vars[0] = int_vars[0];
L202: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L211; }
L203: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L204: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 651;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L223;
  }
L205: // BOOL_DOUBLE
  int_vars[0] = !!double_vars[3];
L206: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L210; }
L207: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L208: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L223;
L209: // GOTO
  goto L210;
L210: // GOTO
  goto L211;
L211: // GOTO
  goto L212;
L212: // GOTO
  goto L213;
L213: // GOTO
  goto L214;
L214: // GOTO
  goto L215;
L215: // GOTO
  goto L216;
L216: // GOTO
  goto L217;
L217: // GOTO
  goto L218;
L218: // GOTO
  goto L219;
L219: // GOTO
  goto L220;
L220: // GOTO
  goto L221;
L221: // INIT_INT
  int_vars[5] = 0;
L222: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L223;
L223: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L224: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Increment__post_inc_array_field_access_constant_index(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[6] = {0};
  double double_vars[5];
  float float_vars[5];
  int64_t long_vars[5];
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  int8_t byte_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3b < 0) {
      BASIC_TYPE_ID_TestCase__Point_3b = env->get_basic_type_id(env, "TestCase::Point_3b");
      if (BASIC_TYPE_ID_TestCase__Point_3b < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3b");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3b;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 434;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3s < 0) {
      BASIC_TYPE_ID_TestCase__Point_3s = env->get_basic_type_id(env, "TestCase::Point_3s");
      if (BASIC_TYPE_ID_TestCase__Point_3s < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3s");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3s;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 435;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L11: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3i < 0) {
      BASIC_TYPE_ID_TestCase__Point_3i = env->get_basic_type_id(env, "TestCase::Point_3i");
      if (BASIC_TYPE_ID_TestCase__Point_3i < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3i");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3i;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 436;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L15: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3l < 0) {
      BASIC_TYPE_ID_TestCase__Point_3l = env->get_basic_type_id(env, "TestCase::Point_3l");
      if (BASIC_TYPE_ID_TestCase__Point_3l < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3l");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3l;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[3], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 437;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L19: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3f < 0) {
      BASIC_TYPE_ID_TestCase__Point_3f = env->get_basic_type_id(env, "TestCase::Point_3f");
      if (BASIC_TYPE_ID_TestCase__Point_3f < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3f");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3f;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 438;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L23: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3d < 0) {
      BASIC_TYPE_ID_TestCase__Point_3d = env->get_basic_type_id(env, "TestCase::Point_3d");
      if (BASIC_TYPE_ID_TestCase__Point_3d < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3d");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3d;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[5], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 439;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L25: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 441;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L27: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // MOVE_INT
  int_vars[3] = int_vars[2];
L30: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = byte_vars[1];
      }
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 441;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L32: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 442;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L34: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L36: // MOVE_INT
  int_vars[3] = int_vars[2];
L37: // MULNUM_ARRAY_FIELD_STORE_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = short_vars[1];
      }
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 442;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L39: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 443;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L41: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L42: // MOVE_INT
  int_vars[4] = int_vars[3];
L43: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = int_vars[2];
      }
    }
  }
L44: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 443;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L45: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 444;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L47: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L48: // MOVE_INT
  int_vars[3] = int_vars[2];
L49: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = long_vars[0];
      }
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 444;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L51: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L52: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 445;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L53: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L54: // MOVE_INT
  int_vars[3] = int_vars[2];
L55: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = float_vars[0];
      }
    }
  }
L56: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 445;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L57: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L58: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 446;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L59: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L60: // MOVE_INT
  int_vars[3] = int_vars[2];
L61: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = double_vars[0];
      }
    }
  }
L62: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 446;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L63: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L64: // MOVE_INT
  int_vars[3] = int_vars[2];
L65: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L66: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 448;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L67: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L68: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L69: // ADD_INT
  int_vars[6] = int_vars[4] + int_vars[5];
L70: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[6];
L71: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = byte_vars[1];
      }
    }
  }
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 448;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L73: // MOVE_BYTE
  byte_vars[2] = byte_vars[0];
L74: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L75: // MOVE_INT
  int_vars[3] = int_vars[2];
L76: // MULNUM_ARRAY_FIELD_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] =((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L77: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 449;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L78: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L79: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L80: // ADD_INT
  int_vars[6] = int_vars[4] + int_vars[5];
L81: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[6];
L82: // MULNUM_ARRAY_FIELD_STORE_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = short_vars[1];
      }
    }
  }
L83: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 449;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L84: // MOVE_SHORT
  short_vars[2] = short_vars[0];
L85: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L86: // MOVE_INT
  int_vars[3] = int_vars[2];
L87: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L88: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 450;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L89: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L90: // ADD_INT
  int_vars[6] = int_vars[4] + int_vars[5];
L91: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = int_vars[6];
      }
    }
  }
L92: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 450;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L93: // MOVE_INT
  int_vars[7] = int_vars[4];
L94: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L95: // MOVE_INT
  int_vars[3] = int_vars[2];
L96: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L97: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 451;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L98: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L99: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L100: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L101: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = long_vars[2];
      }
    }
  }
L102: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 451;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L103: // MOVE_LONG
  long_vars[3] = long_vars[0];
L104: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L105: // MOVE_INT
  int_vars[3] = int_vars[2];
L106: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L107: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 452;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L108: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L109: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[4];
L110: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L111: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = float_vars[2];
      }
    }
  }
L112: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 452;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L113: // MOVE_FLOAT
  float_vars[3] = float_vars[0];
L114: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L115: // MOVE_INT
  int_vars[3] = int_vars[2];
L116: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L117: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 453;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L118: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L119: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[4];
L120: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L121: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = double_vars[2];
      }
    }
  }
L122: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 453;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L123: // MOVE_DOUBLE
  double_vars[3] = double_vars[0];
L124: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L125: // MOVE_INT
  int_vars[3] = int_vars[2];
L126: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L127: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 455;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L128: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L129: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[1] = *(int8_t*)&stack[0];
    }
  }
L130: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 455;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L131: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[1];
L132: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L133: // ADD_INT
  int_vars[8] = int_vars[5] + int_vars[6];
L134: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L135: // BOOL_INT
  int_vars[0] = int_vars[0];
L136: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L244; }
L137: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[2];
L138: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L139: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 456;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L140: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L141: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L142: // BOOL_INT
  int_vars[0] = int_vars[0];
L143: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L243; }
L144: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L145: // MOVE_INT
  int_vars[3] = int_vars[2];
L146: // MULNUM_ARRAY_FIELD_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] =((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L147: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 457;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L148: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L149: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L150: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 457;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L151: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[1];
L152: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L153: // ADD_INT
  int_vars[8] = int_vars[5] + int_vars[6];
L154: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L155: // BOOL_INT
  int_vars[0] = int_vars[0];
L156: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L242; }
L157: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[2];
L158: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L159: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 458;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L160: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L161: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L162: // BOOL_INT
  int_vars[0] = int_vars[0];
L163: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L241; }
L164: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L165: // MOVE_INT
  int_vars[3] = int_vars[2];
L166: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L167: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 459;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L168: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L169: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 459;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L170: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L171: // ADD_INT
  int_vars[8] = int_vars[5] + int_vars[6];
L172: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L173: // BOOL_INT
  int_vars[0] = int_vars[0];
L174: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L240; }
L175: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L176: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 460;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L177: // EQ_INT
  int_vars[0] = (int_vars[7] == int_vars[2]);
L178: // BOOL_INT
  int_vars[0] = int_vars[0];
L179: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L239; }
L180: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L181: // MOVE_INT
  int_vars[3] = int_vars[2];
L182: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L183: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 461;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L184: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L185: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 461;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L186: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L187: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[4];
L188: // ADD_LONG
  long_vars[4] = long_vars[1] + long_vars[2];
L189: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[4]);
L190: // BOOL_INT
  int_vars[0] = int_vars[0];
L191: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L238; }
L192: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L193: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 462;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L194: // EQ_LONG
  int_vars[0] = (long_vars[3] == long_vars[0]);
L195: // BOOL_INT
  int_vars[0] = int_vars[0];
L196: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L237; }
L197: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L198: // MOVE_INT
  int_vars[3] = int_vars[2];
L199: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L200: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 463;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L201: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L202: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 463;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L203: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L204: // CONVERT_INT_TO_FLOAT
  float_vars[2] = (float)int_vars[4];
L205: // ADD_FLOAT
  float_vars[4] = float_vars[1] + float_vars[2];
L206: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[4]);
L207: // BOOL_INT
  int_vars[0] = int_vars[0];
L208: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L236; }
L209: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L210: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 464;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L211: // EQ_FLOAT
  int_vars[0] = (float_vars[3] == float_vars[0]);
L212: // BOOL_INT
  int_vars[0] = int_vars[0];
L213: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L235; }
L214: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L215: // MOVE_INT
  int_vars[3] = int_vars[2];
L216: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L217: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 465;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L218: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L219: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 465;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L220: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L221: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[4];
L222: // ADD_DOUBLE
  double_vars[4] = double_vars[1] + double_vars[2];
L223: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[4]);
L224: // BOOL_INT
  int_vars[0] = int_vars[0];
L225: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L234; }
L226: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L227: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 466;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L246;
  }
L228: // BOOL_DOUBLE
  int_vars[0] = !!double_vars[3];
L229: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L233; }
L230: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L231: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L246;
L232: // GOTO
  goto L233;
L233: // GOTO
  goto L234;
L234: // GOTO
  goto L235;
L235: // GOTO
  goto L236;
L236: // GOTO
  goto L237;
L237: // GOTO
  goto L238;
L238: // GOTO
  goto L239;
L239: // GOTO
  goto L240;
L240: // GOTO
  goto L241;
L241: // GOTO
  goto L242;
L242: // GOTO
  goto L243;
L243: // GOTO
  goto L244;
L244: // INIT_INT
  int_vars[4] = 0;
L245: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L246;
L246: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L247: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Increment__post_inc_array_field_access_invocant_not_var(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULTI_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3i < 0) {
      BASIC_TYPE_ID_TestCase__Point_3i = env->get_basic_type_id(env, "TestCase::Point_3i");
      if (BASIC_TYPE_ID_TestCase__Point_3i < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3i");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3i;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_muldim_array_raw(env, basic_type_id, 1, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 419;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3i < 0) {
      BASIC_TYPE_ID_TestCase__Point_3i = env->get_basic_type_id(env, "TestCase::Point_3i");
      if (BASIC_TYPE_ID_TestCase__Point_3i < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3i");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3i;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 420;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L10: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 420;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L12: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L15: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 422;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L18: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L19: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L20: // MOVE_INT
  int_vars[4] = int_vars[3];
L21: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[5] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 422;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L23: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L24: // ADD_INT
  int_vars[7] = int_vars[5] + int_vars[6];
L25: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = int_vars[7];
      }
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 422;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L27: // MOVE_INT
  int_vars[8] = int_vars[5];
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L29: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L30: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L31: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L32: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 424;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L34: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L35: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L36: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L37: // MOVE_INT
  int_vars[4] = int_vars[3];
L38: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[5] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_array_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 424;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L40: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L41: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L42: // BOOL_INT
  int_vars[0] = int_vars[0];
L43: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L54; }
L44: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L45: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L46: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L47: // EQ_INT
  int_vars[0] = (int_vars[8] == int_vars[2]);
L48: // BOOL_INT
  int_vars[0] = int_vars[0];
L49: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L53; }
L50: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L51: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L59;
L52: // GOTO
  goto L53;
L53: // GOTO
  goto L54;
L54: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L55: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L56: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L59;
L57: // INIT_INT
  int_vars[6] = 0;
L58: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L59;
L59: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L60: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Increment__post_inc_deref(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[6] = {0};
  double double_vars[6];
  float float_vars[6];
  int64_t long_vars[6];
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[4];
  int8_t byte_vars[4];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 525;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L3: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L4: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 526;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L6: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L7: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 527;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L9: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 528;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L11: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 529;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L13: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 530;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L15: // REF_BYTE
  *(void**)&ref_vars[0] = &byte_vars[1];
L16: // REF_SHORT
  *(void**)&ref_vars[1] = &short_vars[1];
L17: // REF_INT
  *(void**)&ref_vars[2] = &int_vars[2];
L18: // REF_LONG
  *(void**)&ref_vars[3] = &long_vars[0];
L19: // REF_FLOAT
  *(void**)&ref_vars[4] = &float_vars[0];
L20: // REF_DOUBLE
  *(void**)&ref_vars[5] = &double_vars[0];
L21: // GET_DEREF_BYTE
  byte_vars[0] = *(int8_t*)*(void**)&ref_vars[0];
L22: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L24: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L25: // CONVERT_INT_TO_BYTE
  byte_vars[2] = (int8_t)int_vars[5];
L26: // SET_DEREF_BYTE
  *(int8_t*)*(void**)&ref_vars[0] = byte_vars[2];
L27: // MOVE_BYTE
  byte_vars[3] = byte_vars[0];
L28: // GET_DEREF_SHORT
  short_vars[0] = *(int16_t*)*(void**)&ref_vars[1];
L29: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L30: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L31: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L32: // CONVERT_INT_TO_SHORT
  short_vars[2] = (int16_t)int_vars[5];
L33: // SET_DEREF_SHORT
  *(int16_t*)*(void**)&ref_vars[1] = short_vars[2];
L34: // MOVE_SHORT
  short_vars[3] = short_vars[0];
L35: // GET_DEREF_INT
  int_vars[3] = *(int32_t*)*(void**)&ref_vars[2];
L36: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L37: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L38: // SET_DEREF_INT
  *(int32_t*)*(void**)&ref_vars[2] = int_vars[5];
L39: // MOVE_INT
  int_vars[6] = int_vars[3];
L40: // GET_DEREF_LONG
  long_vars[1] = *(int64_t*)*(void**)&ref_vars[3];
L41: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L42: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[3];
L43: // ADD_LONG
  long_vars[3] = long_vars[1] + long_vars[2];
L44: // SET_DEREF_LONG
  *(int64_t*)*(void**)&ref_vars[3] = long_vars[3];
L45: // MOVE_LONG
  long_vars[4] = long_vars[1];
L46: // GET_DEREF_FLOAT
  float_vars[1] = *(float*)*(void**)&ref_vars[4];
L47: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L48: // CONVERT_INT_TO_FLOAT
  float_vars[2] = (float)int_vars[3];
L49: // ADD_FLOAT
  float_vars[3] = float_vars[1] + float_vars[2];
L50: // SET_DEREF_FLOAT
  *(float*)*(void**)&ref_vars[4] = float_vars[3];
L51: // MOVE_FLOAT
  float_vars[4] = float_vars[1];
L52: // GET_DEREF_DOUBLE
  double_vars[1] = *(double*)*(void**)&ref_vars[5];
L53: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L54: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[3];
L55: // ADD_DOUBLE
  double_vars[3] = double_vars[1] + double_vars[2];
L56: // SET_DEREF_DOUBLE
  *(double*)*(void**)&ref_vars[5] = double_vars[3];
L57: // MOVE_DOUBLE
  double_vars[4] = double_vars[1];
L58: // GET_DEREF_BYTE
  byte_vars[0] = *(int8_t*)*(void**)&ref_vars[0];
L59: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L60: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[2] = *(int8_t*)&stack[0];
    }
  }
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 546;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L62: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[2];
L63: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L64: // ADD_INT
  int_vars[7] = int_vars[4] + int_vars[5];
L65: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L66: // BOOL_INT
  int_vars[0] = int_vars[0];
L67: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L160; }
L68: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[3];
L69: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 547;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L71: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L72: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L73: // BOOL_INT
  int_vars[0] = int_vars[0];
L74: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L159; }
L75: // GET_DEREF_SHORT
  short_vars[0] = *(int16_t*)*(void**)&ref_vars[1];
L76: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L77: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[2] = *(int16_t*)&stack[0];
    }
  }
L78: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 548;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L79: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[2];
L80: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L81: // ADD_INT
  int_vars[7] = int_vars[4] + int_vars[5];
L82: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L83: // BOOL_INT
  int_vars[0] = int_vars[0];
L84: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L158; }
L85: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[3];
L86: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L87: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 549;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L88: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L89: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L90: // BOOL_INT
  int_vars[0] = int_vars[0];
L91: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L157; }
L92: // GET_DEREF_INT
  int_vars[3] = *(int32_t*)*(void**)&ref_vars[2];
L93: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L94: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 550;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L95: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L96: // ADD_INT
  int_vars[7] = int_vars[4] + int_vars[5];
L97: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L98: // BOOL_INT
  int_vars[0] = int_vars[0];
L99: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L156; }
L100: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L101: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 551;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L102: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[3]);
L103: // BOOL_INT
  int_vars[0] = int_vars[0];
L104: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L155; }
L105: // GET_DEREF_LONG
  long_vars[1] = *(int64_t*)*(void**)&ref_vars[3];
L106: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[2] = *(int64_t*)&stack[0];
    }
  }
L107: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 552;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L108: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L109: // CONVERT_INT_TO_LONG
  long_vars[3] = (int64_t)int_vars[3];
L110: // ADD_LONG
  long_vars[5] = long_vars[2] + long_vars[3];
L111: // EQ_LONG
  int_vars[0] = (long_vars[1] == long_vars[5]);
L112: // BOOL_INT
  int_vars[0] = int_vars[0];
L113: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L154; }
L114: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L115: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 553;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L116: // EQ_LONG
  int_vars[0] = (long_vars[4] == long_vars[1]);
L117: // BOOL_INT
  int_vars[0] = int_vars[0];
L118: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L153; }
L119: // GET_DEREF_FLOAT
  float_vars[1] = *(float*)*(void**)&ref_vars[4];
L120: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L121: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 554;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L122: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L123: // CONVERT_INT_TO_FLOAT
  float_vars[3] = (float)int_vars[3];
L124: // ADD_FLOAT
  float_vars[5] = float_vars[2] + float_vars[3];
L125: // EQ_FLOAT
  int_vars[0] = (float_vars[1] == float_vars[5]);
L126: // BOOL_INT
  int_vars[0] = int_vars[0];
L127: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L152; }
L128: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L129: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 555;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L130: // EQ_FLOAT
  int_vars[0] = (float_vars[4] == float_vars[1]);
L131: // BOOL_INT
  int_vars[0] = int_vars[0];
L132: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L151; }
L133: // GET_DEREF_DOUBLE
  double_vars[1] = *(double*)*(void**)&ref_vars[5];
L134: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L135: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 556;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L136: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L137: // CONVERT_INT_TO_DOUBLE
  double_vars[3] = (double)int_vars[3];
L138: // ADD_DOUBLE
  double_vars[5] = double_vars[2] + double_vars[3];
L139: // EQ_DOUBLE
  int_vars[0] = (double_vars[1] == double_vars[5]);
L140: // BOOL_INT
  int_vars[0] = int_vars[0];
L141: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L150; }
L142: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[4] = *(double*)&stack[0];
    }
  }
L143: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 557;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L144: // BOOL_DOUBLE
  int_vars[0] = !!double_vars[4];
L145: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L149; }
L146: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L147: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L162;
L148: // GOTO
  goto L149;
L149: // GOTO
  goto L150;
L150: // GOTO
  goto L151;
L151: // GOTO
  goto L152;
L152: // GOTO
  goto L153;
L153: // GOTO
  goto L154;
L154: // GOTO
  goto L155;
L155: // GOTO
  goto L156;
L156: // GOTO
  goto L157;
L157: // GOTO
  goto L158;
L158: // GOTO
  goto L159;
L159: // GOTO
  goto L160;
L160: // INIT_INT
  int_vars[5] = 0;
L161: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L162;
L162: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Increment__post_inc_field_access(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  double double_vars[5];
  float float_vars[5];
  int64_t long_vars[5];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  int8_t byte_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Simple->new
  {
    if (SUB_ID_TestCase__Simple__new < 0) {
      SUB_ID_TestCase__Simple__new = env->get_sub_id(env, "TestCase::Simple", "new", "TestCase::Simple()");
      if (SUB_ID_TestCase__Simple__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Simple new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Simple__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 574;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L4: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 576;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L6: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L7: // SET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__byte_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__byte_value = env->get_field_id(env, "TestCase::Simple", "byte_value", "byte");
      if (FIELD_ID_TestCase__Simple__byte_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple byte_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__byte_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__byte_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__byte_value) = byte_vars[1];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 576;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L9: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 577;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L11: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L12: // SET_FIELD_SHORT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__short_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__short_value = env->get_field_id(env, "TestCase::Simple", "short_value", "short");
      if (FIELD_ID_TestCase__Simple__short_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple short_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__short_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__short_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int16_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__short_value) = short_vars[1];
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 577;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L14: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 578;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L16: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__int_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__int_value = env->get_field_id(env, "TestCase::Simple", "int_value", "int");
      if (FIELD_ID_TestCase__Simple__int_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple int_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__int_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__int_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__int_value) = int_vars[2];
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 578;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L18: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 579;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L20: // SET_FIELD_LONG
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__long_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__long_value = env->get_field_id(env, "TestCase::Simple", "long_value", "long");
      if (FIELD_ID_TestCase__Simple__long_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple long_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__long_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__long_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int64_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__long_value) = long_vars[0];
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 579;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L22: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 580;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L24: // SET_FIELD_FLOAT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__float_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__float_value = env->get_field_id(env, "TestCase::Simple", "float_value", "float");
      if (FIELD_ID_TestCase__Simple__float_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple float_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__float_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__float_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(float*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__float_value) = float_vars[0];
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 580;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L26: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 581;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L28: // SET_FIELD_DOUBLE
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__double_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__double_value = env->get_field_id(env, "TestCase::Simple", "double_value", "double");
      if (FIELD_ID_TestCase__Simple__double_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple double_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__double_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__double_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(double*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__double_value) = double_vars[0];
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 581;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L30: // GET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__byte_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__byte_value = env->get_field_id(env, "TestCase::Simple", "byte_value", "byte");
      if (FIELD_ID_TestCase__Simple__byte_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple byte_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__byte_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__byte_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      byte_vars[0] = *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__byte_value);
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 583;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L32: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L33: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L34: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L35: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[4];
L36: // SET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__byte_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__byte_value = env->get_field_id(env, "TestCase::Simple", "byte_value", "byte");
      if (FIELD_ID_TestCase__Simple__byte_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple byte_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__byte_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__byte_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__byte_value) = byte_vars[1];
    }
  }
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 583;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L38: // MOVE_BYTE
  byte_vars[2] = byte_vars[0];
L39: // GET_FIELD_SHORT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__short_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__short_value = env->get_field_id(env, "TestCase::Simple", "short_value", "short");
      if (FIELD_ID_TestCase__Simple__short_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple short_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__short_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__short_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      short_vars[0] = *(int16_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__short_value);
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 584;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L41: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L42: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L43: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L44: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L45: // SET_FIELD_SHORT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__short_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__short_value = env->get_field_id(env, "TestCase::Simple", "short_value", "short");
      if (FIELD_ID_TestCase__Simple__short_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple short_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__short_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__short_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int16_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__short_value) = short_vars[1];
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 584;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L47: // MOVE_SHORT
  short_vars[2] = short_vars[0];
L48: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__int_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__int_value = env->get_field_id(env, "TestCase::Simple", "int_value", "int");
      if (FIELD_ID_TestCase__Simple__int_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple int_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__int_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__int_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__int_value);
    }
  }
L49: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 585;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L50: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L51: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L52: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__int_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__int_value = env->get_field_id(env, "TestCase::Simple", "int_value", "int");
      if (FIELD_ID_TestCase__Simple__int_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple int_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__int_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__int_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__int_value) = int_vars[4];
    }
  }
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 585;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L54: // MOVE_INT
  int_vars[5] = int_vars[2];
L55: // GET_FIELD_LONG
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__long_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__long_value = env->get_field_id(env, "TestCase::Simple", "long_value", "long");
      if (FIELD_ID_TestCase__Simple__long_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple long_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__long_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__long_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      long_vars[0] = *(int64_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__long_value);
    }
  }
L56: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 586;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L57: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L58: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L59: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L60: // SET_FIELD_LONG
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__long_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__long_value = env->get_field_id(env, "TestCase::Simple", "long_value", "long");
      if (FIELD_ID_TestCase__Simple__long_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple long_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__long_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__long_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int64_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__long_value) = long_vars[2];
    }
  }
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 586;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L62: // MOVE_LONG
  long_vars[3] = long_vars[0];
L63: // GET_FIELD_FLOAT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__float_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__float_value = env->get_field_id(env, "TestCase::Simple", "float_value", "float");
      if (FIELD_ID_TestCase__Simple__float_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple float_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__float_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__float_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      float_vars[0] = *(float*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__float_value);
    }
  }
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 587;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L65: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L66: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[2];
L67: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L68: // SET_FIELD_FLOAT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__float_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__float_value = env->get_field_id(env, "TestCase::Simple", "float_value", "float");
      if (FIELD_ID_TestCase__Simple__float_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple float_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__float_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__float_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(float*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__float_value) = float_vars[2];
    }
  }
L69: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 587;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L70: // MOVE_FLOAT
  float_vars[3] = float_vars[0];
L71: // GET_FIELD_DOUBLE
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__double_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__double_value = env->get_field_id(env, "TestCase::Simple", "double_value", "double");
      if (FIELD_ID_TestCase__Simple__double_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple double_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__double_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__double_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      double_vars[0] = *(double*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__double_value);
    }
  }
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 588;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L73: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L74: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[2];
L75: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L76: // SET_FIELD_DOUBLE
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__double_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__double_value = env->get_field_id(env, "TestCase::Simple", "double_value", "double");
      if (FIELD_ID_TestCase__Simple__double_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple double_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__double_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__double_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(double*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__double_value) = double_vars[2];
    }
  }
L77: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 588;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L78: // MOVE_DOUBLE
  double_vars[3] = double_vars[0];
L79: // GET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__byte_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__byte_value = env->get_field_id(env, "TestCase::Simple", "byte_value", "byte");
      if (FIELD_ID_TestCase__Simple__byte_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple byte_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__byte_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__byte_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      byte_vars[0] = *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__byte_value);
    }
  }
L80: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 590;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L81: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L82: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[1] = *(int8_t*)&stack[0];
    }
  }
L83: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 590;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L84: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[1];
L85: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L86: // ADD_INT
  int_vars[6] = int_vars[3] + int_vars[4];
L87: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L88: // BOOL_INT
  int_vars[0] = int_vars[0];
L89: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L187; }
L90: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[2];
L91: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L92: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 591;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L93: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L94: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L95: // BOOL_INT
  int_vars[0] = int_vars[0];
L96: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L186; }
L97: // GET_FIELD_SHORT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__short_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__short_value = env->get_field_id(env, "TestCase::Simple", "short_value", "short");
      if (FIELD_ID_TestCase__Simple__short_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple short_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__short_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__short_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      short_vars[0] = *(int16_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__short_value);
    }
  }
L98: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 592;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L99: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L100: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L101: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 592;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L102: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[1];
L103: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L104: // ADD_INT
  int_vars[6] = int_vars[3] + int_vars[4];
L105: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L106: // BOOL_INT
  int_vars[0] = int_vars[0];
L107: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L185; }
L108: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[2];
L109: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L110: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 593;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L111: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L112: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L113: // BOOL_INT
  int_vars[0] = int_vars[0];
L114: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L184; }
L115: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__int_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__int_value = env->get_field_id(env, "TestCase::Simple", "int_value", "int");
      if (FIELD_ID_TestCase__Simple__int_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple int_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__int_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__int_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__int_value);
    }
  }
L116: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 594;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L117: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L118: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 594;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L119: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L120: // ADD_INT
  int_vars[6] = int_vars[3] + int_vars[4];
L121: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L122: // BOOL_INT
  int_vars[0] = int_vars[0];
L123: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L183; }
L124: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L125: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 595;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L126: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[2]);
L127: // BOOL_INT
  int_vars[0] = int_vars[0];
L128: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L182; }
L129: // GET_FIELD_LONG
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__long_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__long_value = env->get_field_id(env, "TestCase::Simple", "long_value", "long");
      if (FIELD_ID_TestCase__Simple__long_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple long_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__long_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__long_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      long_vars[0] = *(int64_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__long_value);
    }
  }
L130: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 596;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L131: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L132: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 596;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L133: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L134: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[2];
L135: // ADD_LONG
  long_vars[4] = long_vars[1] + long_vars[2];
L136: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[4]);
L137: // BOOL_INT
  int_vars[0] = int_vars[0];
L138: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L181; }
L139: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L140: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 597;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L141: // EQ_LONG
  int_vars[0] = (long_vars[3] == long_vars[0]);
L142: // BOOL_INT
  int_vars[0] = int_vars[0];
L143: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L180; }
L144: // GET_FIELD_FLOAT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__float_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__float_value = env->get_field_id(env, "TestCase::Simple", "float_value", "float");
      if (FIELD_ID_TestCase__Simple__float_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple float_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__float_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__float_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      float_vars[0] = *(float*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__float_value);
    }
  }
L145: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 598;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L146: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L147: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 598;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L148: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L149: // CONVERT_INT_TO_FLOAT
  float_vars[2] = (float)int_vars[2];
L150: // ADD_FLOAT
  float_vars[4] = float_vars[1] + float_vars[2];
L151: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[4]);
L152: // BOOL_INT
  int_vars[0] = int_vars[0];
L153: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L179; }
L154: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L155: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 599;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L156: // EQ_FLOAT
  int_vars[0] = (float_vars[3] == float_vars[0]);
L157: // BOOL_INT
  int_vars[0] = int_vars[0];
L158: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L178; }
L159: // GET_FIELD_DOUBLE
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__double_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__double_value = env->get_field_id(env, "TestCase::Simple", "double_value", "double");
      if (FIELD_ID_TestCase__Simple__double_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple double_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__double_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__double_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      double_vars[0] = *(double*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__double_value);
    }
  }
L160: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 600;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L161: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L162: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 600;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L163: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L164: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[2];
L165: // ADD_DOUBLE
  double_vars[4] = double_vars[1] + double_vars[2];
L166: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[4]);
L167: // BOOL_INT
  int_vars[0] = int_vars[0];
L168: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L177; }
L169: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L170: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 601;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L189;
  }
L171: // BOOL_DOUBLE
  int_vars[0] = !!double_vars[3];
L172: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L176; }
L173: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L174: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L189;
L175: // GOTO
  goto L176;
L176: // GOTO
  goto L177;
L177: // GOTO
  goto L178;
L178: // GOTO
  goto L179;
L179: // GOTO
  goto L180;
L180: // GOTO
  goto L181;
L181: // GOTO
  goto L182;
L182: // GOTO
  goto L183;
L183: // GOTO
  goto L184;
L184: // GOTO
  goto L185;
L185: // GOTO
  goto L186;
L186: // GOTO
  goto L187;
L187: // INIT_INT
  int_vars[4] = 0;
L188: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L189;
L189: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L190: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Increment__post_inc_field_access_invocant_not_var(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 389;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 390;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 390;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L11: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L12: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L14: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 392;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L16: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[3] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x);
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 392;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L18: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L19: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L20: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x) = int_vars[5];
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 392;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L22: // MOVE_INT
  int_vars[6] = int_vars[3];
L23: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L24: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L25: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L26: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 394;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L28: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Minimal__x < 0, 0)) {
      FIELD_ID_TestCase__Minimal__x = env->get_field_id(env, "TestCase::Minimal", "x", "int");
      if (FIELD_ID_TestCase__Minimal__x < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Minimal x");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Minimal__x = env->get_field_offset(env, FIELD_ID_TestCase__Minimal__x);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[3] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Minimal__x);
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 394;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L48;
  }
L30: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L31: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L32: // BOOL_INT
  int_vars[0] = int_vars[0];
L33: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L43; }
L34: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L36: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[2]);
L37: // BOOL_INT
  int_vars[0] = int_vars[0];
L38: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L42; }
L39: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L48;
L41: // GOTO
  goto L42;
L42: // GOTO
  goto L43;
L43: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L45: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L48;
L46: // INIT_INT
  int_vars[7] = 0;
L47: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L48;
L48: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L49: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Increment__post_inc_package_var_access(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[5];
  float float_vars[5];
  int64_t long_vars[5];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  int8_t byte_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_package_var_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 483;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L3: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L4: // SET_PACKAGE_VAR_BYTE
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__Increment__BYTE_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__BYTE_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$BYTE_VALUE", "byte");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__BYTE_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $BYTE_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(int8_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__BYTE_VALUE] = byte_vars[1];
  }
L5: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_package_var_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 484;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L7: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L8: // SET_PACKAGE_VAR_SHORT
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__Increment__SHORT_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__SHORT_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$SHORT_VALUE", "short");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__SHORT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $SHORT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(int16_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__SHORT_VALUE] = short_vars[1];
  }
L9: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_package_var_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 485;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L11: // SET_PACKAGE_VAR_INT
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__Increment__INT_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__INT_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$INT_VALUE", "int");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__INT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $INT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(int32_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__INT_VALUE] = int_vars[2];
  }
L12: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_package_var_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 486;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L14: // SET_PACKAGE_VAR_LONG
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__Increment__LONG_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__LONG_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$LONG_VALUE", "long");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__LONG_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $LONG_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(int64_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__LONG_VALUE] = long_vars[0];
  }
L15: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_package_var_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 487;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L17: // SET_PACKAGE_VAR_FLOAT
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__Increment__FLOAT_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__FLOAT_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$FLOAT_VALUE", "float");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__FLOAT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $FLOAT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(float*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__FLOAT_VALUE] = float_vars[0];
  }
L18: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_package_var_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 488;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L20: // SET_PACKAGE_VAR_DOUBLE
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__Increment__DOUBLE_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__DOUBLE_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$DOUBLE_VALUE", "double");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__DOUBLE_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $DOUBLE_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(double*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__DOUBLE_VALUE] = double_vars[0];
  }
L21: // GET_PACKAGE_VAR_BYTE
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__Increment__BYTE_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__BYTE_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$BYTE_VALUE", "byte");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__BYTE_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $BYTE_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    byte_vars[0] = *(int8_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__BYTE_VALUE];
  }
L22: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L23: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L24: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L25: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[4];
L26: // SET_PACKAGE_VAR_BYTE
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__Increment__BYTE_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__BYTE_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$BYTE_VALUE", "byte");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__BYTE_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $BYTE_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(int8_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__BYTE_VALUE] = byte_vars[1];
  }
L27: // MOVE_BYTE
  byte_vars[2] = byte_vars[0];
L28: // GET_PACKAGE_VAR_SHORT
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__Increment__SHORT_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__SHORT_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$SHORT_VALUE", "short");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__SHORT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $SHORT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    short_vars[0] = *(int16_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__SHORT_VALUE];
  }
L29: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L30: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L31: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L32: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L33: // SET_PACKAGE_VAR_SHORT
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__Increment__SHORT_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__SHORT_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$SHORT_VALUE", "short");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__SHORT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $SHORT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(int16_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__SHORT_VALUE] = short_vars[1];
  }
L34: // MOVE_SHORT
  short_vars[2] = short_vars[0];
L35: // GET_PACKAGE_VAR_INT
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__Increment__INT_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__INT_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$INT_VALUE", "int");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__INT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $INT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int_vars[2] = *(int32_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__INT_VALUE];
  }
L36: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L37: // ADD_INT
  int_vars[4] = int_vars[2] + int_vars[3];
L38: // SET_PACKAGE_VAR_INT
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__Increment__INT_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__INT_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$INT_VALUE", "int");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__INT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $INT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(int32_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__INT_VALUE] = int_vars[4];
  }
L39: // MOVE_INT
  int_vars[5] = int_vars[2];
L40: // GET_PACKAGE_VAR_LONG
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__Increment__LONG_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__LONG_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$LONG_VALUE", "long");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__LONG_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $LONG_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    long_vars[0] = *(int64_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__LONG_VALUE];
  }
L41: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L42: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L43: // ADD_LONG
  long_vars[2] = long_vars[0] + long_vars[1];
L44: // SET_PACKAGE_VAR_LONG
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__Increment__LONG_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__LONG_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$LONG_VALUE", "long");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__LONG_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $LONG_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(int64_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__LONG_VALUE] = long_vars[2];
  }
L45: // MOVE_LONG
  long_vars[3] = long_vars[0];
L46: // GET_PACKAGE_VAR_FLOAT
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__Increment__FLOAT_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__FLOAT_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$FLOAT_VALUE", "float");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__FLOAT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $FLOAT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    float_vars[0] = *(float*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__FLOAT_VALUE];
  }
L47: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L48: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[2];
L49: // ADD_FLOAT
  float_vars[2] = float_vars[0] + float_vars[1];
L50: // SET_PACKAGE_VAR_FLOAT
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__Increment__FLOAT_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__FLOAT_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$FLOAT_VALUE", "float");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__FLOAT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $FLOAT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(float*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__FLOAT_VALUE] = float_vars[2];
  }
L51: // MOVE_FLOAT
  float_vars[3] = float_vars[0];
L52: // GET_PACKAGE_VAR_DOUBLE
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__Increment__DOUBLE_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__DOUBLE_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$DOUBLE_VALUE", "double");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__DOUBLE_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $DOUBLE_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    double_vars[0] = *(double*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__DOUBLE_VALUE];
  }
L53: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L54: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[2];
L55: // ADD_DOUBLE
  double_vars[2] = double_vars[0] + double_vars[1];
L56: // SET_PACKAGE_VAR_DOUBLE
  {
    if ( __builtin_expect(VAR_PACKAGE_VAR_ID_TestCase__Increment__DOUBLE_VALUE < 0, 0)) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__DOUBLE_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$DOUBLE_VALUE", "double");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__DOUBLE_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $DOUBLE_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    *(double*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__DOUBLE_VALUE] = double_vars[2];
  }
L57: // MOVE_DOUBLE
  double_vars[3] = double_vars[0];
L58: // GET_PACKAGE_VAR_BYTE
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__Increment__BYTE_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__BYTE_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$BYTE_VALUE", "byte");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__BYTE_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $BYTE_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    byte_vars[0] = *(int8_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__BYTE_VALUE];
  }
L59: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L60: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[1] = *(int8_t*)&stack[0];
    }
  }
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_package_var_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 497;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L62: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[1];
L63: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L64: // ADD_INT
  int_vars[6] = int_vars[3] + int_vars[4];
L65: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L66: // BOOL_INT
  int_vars[0] = int_vars[0];
L67: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L160; }
L68: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[2];
L69: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_package_var_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 498;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L71: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L72: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L73: // BOOL_INT
  int_vars[0] = int_vars[0];
L74: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L159; }
L75: // GET_PACKAGE_VAR_SHORT
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__Increment__SHORT_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__SHORT_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$SHORT_VALUE", "short");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__SHORT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $SHORT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    short_vars[0] = *(int16_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__SHORT_VALUE];
  }
L76: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L77: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L78: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_package_var_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 499;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L79: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[1];
L80: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L81: // ADD_INT
  int_vars[6] = int_vars[3] + int_vars[4];
L82: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L83: // BOOL_INT
  int_vars[0] = int_vars[0];
L84: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L158; }
L85: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[2];
L86: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L87: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_package_var_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 500;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L88: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L89: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L90: // BOOL_INT
  int_vars[0] = int_vars[0];
L91: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L157; }
L92: // GET_PACKAGE_VAR_INT
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__Increment__INT_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__INT_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$INT_VALUE", "int");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__INT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $INT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int_vars[2] = *(int32_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__INT_VALUE];
  }
L93: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L94: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_package_var_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 501;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L95: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L96: // ADD_INT
  int_vars[6] = int_vars[3] + int_vars[4];
L97: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L98: // BOOL_INT
  int_vars[0] = int_vars[0];
L99: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L156; }
L100: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L101: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_package_var_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 502;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L102: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[2]);
L103: // BOOL_INT
  int_vars[0] = int_vars[0];
L104: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L155; }
L105: // GET_PACKAGE_VAR_LONG
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__Increment__LONG_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__LONG_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$LONG_VALUE", "long");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__LONG_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $LONG_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    long_vars[0] = *(int64_t*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__LONG_VALUE];
  }
L106: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L107: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_package_var_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 503;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L108: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L109: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[2];
L110: // ADD_LONG
  long_vars[4] = long_vars[1] + long_vars[2];
L111: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[4]);
L112: // BOOL_INT
  int_vars[0] = int_vars[0];
L113: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L154; }
L114: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L115: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_package_var_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 504;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L116: // EQ_LONG
  int_vars[0] = (long_vars[3] == long_vars[0]);
L117: // BOOL_INT
  int_vars[0] = int_vars[0];
L118: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L153; }
L119: // GET_PACKAGE_VAR_FLOAT
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__Increment__FLOAT_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__FLOAT_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$FLOAT_VALUE", "float");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__FLOAT_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $FLOAT_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    float_vars[0] = *(float*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__FLOAT_VALUE];
  }
L120: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L121: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_package_var_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 505;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L122: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L123: // CONVERT_INT_TO_FLOAT
  float_vars[2] = (float)int_vars[2];
L124: // ADD_FLOAT
  float_vars[4] = float_vars[1] + float_vars[2];
L125: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[4]);
L126: // BOOL_INT
  int_vars[0] = int_vars[0];
L127: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L152; }
L128: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L129: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_package_var_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 506;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L130: // EQ_FLOAT
  int_vars[0] = (float_vars[3] == float_vars[0]);
L131: // BOOL_INT
  int_vars[0] = int_vars[0];
L132: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L151; }
L133: // GET_PACKAGE_VAR_DOUBLE
  {
    if (VAR_PACKAGE_VAR_ID_TestCase__Increment__DOUBLE_VALUE < 0) {
      VAR_PACKAGE_VAR_ID_TestCase__Increment__DOUBLE_VALUE = env->get_package_var_id(env, "TestCase::Increment", "$DOUBLE_VALUE", "double");
      if (VAR_PACKAGE_VAR_ID_TestCase__Increment__DOUBLE_VALUE < 0) {
        void* exception = env->new_string_raw(env, "Package variable not found TestCase::Increment $DOUBLE_VALUE");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    double_vars[0] = *(double*)&(*(SPVM_VALUE**)(env->runtime + (intptr_t)env->runtime_package_vars_heap_offset))[VAR_PACKAGE_VAR_ID_TestCase__Increment__DOUBLE_VALUE];
  }
L134: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L135: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_package_var_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 507;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L136: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L137: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[2];
L138: // ADD_DOUBLE
  double_vars[4] = double_vars[1] + double_vars[2];
L139: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[4]);
L140: // BOOL_INT
  int_vars[0] = int_vars[0];
L141: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L150; }
L142: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L143: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_package_var_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 508;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L162;
  }
L144: // BOOL_DOUBLE
  int_vars[0] = !!double_vars[3];
L145: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L149; }
L146: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L147: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L162;
L148: // GOTO
  goto L149;
L149: // GOTO
  goto L150;
L150: // GOTO
  goto L151;
L151: // GOTO
  goto L152;
L152: // GOTO
  goto L153;
L153: // GOTO
  goto L154;
L154: // GOTO
  goto L155;
L155: // GOTO
  goto L156;
L156: // GOTO
  goto L157;
L157: // GOTO
  goto L158;
L158: // GOTO
  goto L159;
L159: // GOTO
  goto L160;
L160: // INIT_INT
  int_vars[4] = 0;
L161: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L162;
L162: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Increment__post_inc_var(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[5];
  float float_vars[5];
  int64_t long_vars[5];
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  int8_t byte_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 717;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L144;
  }
L3: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L4: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 718;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L144;
  }
L6: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L7: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 719;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L144;
  }
L9: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 720;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L144;
  }
L11: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 721;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L144;
  }
L13: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 722;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L144;
  }
L15: // MOVE_BYTE
  byte_vars[0] = byte_vars[1];
L16: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L18: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L19: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L20: // MOVE_BYTE
  byte_vars[2] = byte_vars[0];
L21: // MOVE_SHORT
  short_vars[0] = short_vars[1];
L22: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L24: // ADD_INT
  int_vars[5] = int_vars[3] + int_vars[4];
L25: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[5];
L26: // MOVE_SHORT
  short_vars[2] = short_vars[0];
L27: // MOVE_INT
  int_vars[3] = int_vars[2];
L28: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L29: // ADD_INT
  int_vars[2] = int_vars[3] + int_vars[4];
L30: // MOVE_INT
  int_vars[5] = int_vars[3];
L31: // MOVE_LONG
  long_vars[1] = long_vars[0];
L32: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L33: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[3];
L34: // ADD_LONG
  long_vars[0] = long_vars[1] + long_vars[2];
L35: // MOVE_LONG
  long_vars[3] = long_vars[1];
L36: // MOVE_FLOAT
  float_vars[1] = float_vars[0];
L37: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L38: // CONVERT_INT_TO_FLOAT
  float_vars[2] = (float)int_vars[3];
L39: // ADD_FLOAT
  float_vars[0] = float_vars[1] + float_vars[2];
L40: // MOVE_FLOAT
  float_vars[3] = float_vars[1];
L41: // MOVE_DOUBLE
  double_vars[1] = double_vars[0];
L42: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L43: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[3];
L44: // ADD_DOUBLE
  double_vars[0] = double_vars[1] + double_vars[2];
L45: // MOVE_DOUBLE
  double_vars[3] = double_vars[1];
L46: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[1];
L47: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 731;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L144;
  }
L49: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L50: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L51: // ADD_INT
  int_vars[7] = int_vars[4] + int_vars[6];
L52: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L53: // BOOL_INT
  int_vars[0] = int_vars[0];
L54: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L142; }
L55: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[2];
L56: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L57: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 732;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L144;
  }
L58: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L59: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L60: // BOOL_INT
  int_vars[0] = int_vars[0];
L61: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L141; }
L62: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[1];
L63: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 733;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L144;
  }
L65: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L66: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L67: // ADD_INT
  int_vars[7] = int_vars[4] + int_vars[6];
L68: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L69: // BOOL_INT
  int_vars[0] = int_vars[0];
L70: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L140; }
L71: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[2];
L72: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L73: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 734;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L144;
  }
L74: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L75: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L76: // BOOL_INT
  int_vars[0] = int_vars[0];
L77: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L139; }
L78: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L79: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 735;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L144;
  }
L80: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L81: // ADD_INT
  int_vars[6] = int_vars[3] + int_vars[4];
L82: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L83: // BOOL_INT
  int_vars[0] = int_vars[0];
L84: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L138; }
L85: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L86: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 736;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L144;
  }
L87: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[3]);
L88: // BOOL_INT
  int_vars[0] = int_vars[0];
L89: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L137; }
L90: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L91: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 737;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L144;
  }
L92: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L93: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[3];
L94: // ADD_LONG
  long_vars[4] = long_vars[1] + long_vars[2];
L95: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[4]);
L96: // BOOL_INT
  int_vars[0] = int_vars[0];
L97: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L136; }
L98: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L99: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 738;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L144;
  }
L100: // EQ_LONG
  int_vars[0] = (long_vars[3] == long_vars[1]);
L101: // BOOL_INT
  int_vars[0] = int_vars[0];
L102: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L135; }
L103: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L104: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 739;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L144;
  }
L105: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L106: // CONVERT_INT_TO_FLOAT
  float_vars[2] = (float)int_vars[3];
L107: // ADD_FLOAT
  float_vars[4] = float_vars[1] + float_vars[2];
L108: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[4]);
L109: // BOOL_INT
  int_vars[0] = int_vars[0];
L110: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L134; }
L111: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[3] = *(float*)&stack[0];
    }
  }
L112: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 740;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L144;
  }
L113: // BOOL_FLOAT
  int_vars[0] = !!float_vars[3];
L114: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L133; }
L115: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L116: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 741;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L144;
  }
L117: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L118: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[3];
L119: // ADD_DOUBLE
  double_vars[4] = double_vars[1] + double_vars[2];
L120: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[4]);
L121: // BOOL_INT
  int_vars[0] = int_vars[0];
L122: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L132; }
L123: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L124: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "post_inc_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 742;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L144;
  }
L125: // EQ_DOUBLE
  int_vars[0] = (double_vars[3] == double_vars[1]);
L126: // BOOL_INT
  int_vars[0] = int_vars[0];
L127: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L131; }
L128: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L129: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L144;
L130: // GOTO
  goto L131;
L131: // GOTO
  goto L132;
L132: // GOTO
  goto L133;
L133: // GOTO
  goto L134;
L134: // GOTO
  goto L135;
L135: // GOTO
  goto L136;
L136: // GOTO
  goto L137;
L137: // GOTO
  goto L138;
L138: // GOTO
  goto L139;
L139: // GOTO
  goto L140;
L140: // GOTO
  goto L141;
L141: // GOTO
  goto L142;
L142: // INIT_INT
  int_vars[6] = 0;
L143: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L144;
L144: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Increment__pre_dec_array_access_constant_index(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[6] = {0};
  double double_vars[5];
  float float_vars[5];
  int64_t long_vars[5];
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  int8_t byte_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1038;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1039;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L11: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1040;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L15: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[3], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1041;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L19: // NEW_FLOAT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_float_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1042;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L23: // NEW_DOUBLE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_double_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[5], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1043;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L25: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1045;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L27: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1045;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L31: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1046;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L33: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L34: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L35: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1046;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L37: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1047;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L40: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[2];
      } 
    } 
  } 
L41: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1047;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L42: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1048;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L45: // ARRAY_STORE_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1048;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L47: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1049;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L49: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L50: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[0];
      } 
    } 
  } 
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1049;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L52: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1050;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L54: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L55: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[0];
      } 
    } 
  } 
L56: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1050;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L57: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L58: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1052;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L60: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L61: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L62: // SUBTRACT_INT
  int_vars[5] = int_vars[3] - int_vars[4];
L63: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L64: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L65: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1052;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L66: // MOVE_BYTE
  byte_vars[2] = byte_vars[1];
L67: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L68: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L69: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1053;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L70: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L71: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L72: // SUBTRACT_INT
  int_vars[5] = int_vars[3] - int_vars[4];
L73: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[5];
L74: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L75: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1053;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L76: // MOVE_SHORT
  short_vars[2] = short_vars[1];
L77: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L78: // ARRAY_FETCH_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L79: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1054;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L80: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L81: // SUBTRACT_INT
  int_vars[5] = int_vars[3] - int_vars[4];
L82: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L83: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1054;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L84: // MOVE_INT
  int_vars[6] = int_vars[5];
L85: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L86: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L87: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1055;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L88: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L89: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[3];
L90: // SUBTRACT_LONG
  long_vars[2] = long_vars[0] - long_vars[1];
L91: // ARRAY_STORE_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L92: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1055;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L93: // MOVE_LONG
  long_vars[3] = long_vars[2];
L94: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L95: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L96: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1056;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L97: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L98: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[3];
L99: // SUBTRACT_FLOAT
  float_vars[2] = float_vars[0] - float_vars[1];
L100: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[2];
      } 
    } 
  } 
L101: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1056;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L102: // MOVE_FLOAT
  float_vars[3] = float_vars[2];
L103: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L104: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L105: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1057;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L106: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L107: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[3];
L108: // SUBTRACT_DOUBLE
  double_vars[2] = double_vars[0] - double_vars[1];
L109: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[2];
      } 
    } 
  } 
L110: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1057;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L111: // MOVE_DOUBLE
  double_vars[3] = double_vars[2];
L112: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L113: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L114: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1059;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L115: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L116: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[1] = *(int8_t*)&stack[0];
    }
  }
L117: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1059;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L118: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L119: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L120: // SUBTRACT_INT
  int_vars[7] = int_vars[4] - int_vars[5];
L121: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L122: // BOOL_INT
  int_vars[0] = int_vars[0];
L123: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L241; }
L124: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[2];
L125: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L126: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1060;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L127: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L128: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L129: // SUBTRACT_INT
  int_vars[5] = int_vars[3] - int_vars[4];
L130: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[5]);
L131: // BOOL_INT
  int_vars[0] = int_vars[0];
L132: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L240; }
L133: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L134: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L135: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1061;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L136: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L137: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L138: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1061;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L139: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L140: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L141: // SUBTRACT_INT
  int_vars[7] = int_vars[4] - int_vars[5];
L142: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L143: // BOOL_INT
  int_vars[0] = int_vars[0];
L144: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L239; }
L145: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[2];
L146: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L147: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1062;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L148: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L149: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L150: // SUBTRACT_INT
  int_vars[5] = int_vars[3] - int_vars[4];
L151: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[5]);
L152: // BOOL_INT
  int_vars[0] = int_vars[0];
L153: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L238; }
L154: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L155: // ARRAY_FETCH_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L156: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1063;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L157: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L158: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1063;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L159: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L160: // SUBTRACT_INT
  int_vars[7] = int_vars[4] - int_vars[5];
L161: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L162: // BOOL_INT
  int_vars[0] = int_vars[0];
L163: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L237; }
L164: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L165: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1064;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L166: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L167: // SUBTRACT_INT
  int_vars[4] = int_vars[2] - int_vars[3];
L168: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[4]);
L169: // BOOL_INT
  int_vars[0] = int_vars[0];
L170: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L236; }
L171: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L172: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L173: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1065;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L174: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L175: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1065;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L176: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L177: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[3];
L178: // SUBTRACT_LONG
  long_vars[4] = long_vars[1] - long_vars[2];
L179: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[4]);
L180: // BOOL_INT
  int_vars[0] = int_vars[0];
L181: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L235; }
L182: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L183: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1066;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L184: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L185: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L186: // SUBTRACT_LONG
  long_vars[2] = long_vars[0] - long_vars[1];
L187: // EQ_LONG
  int_vars[0] = (long_vars[3] == long_vars[2]);
L188: // BOOL_INT
  int_vars[0] = int_vars[0];
L189: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L234; }
L190: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L191: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L192: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1067;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L193: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L194: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1067;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L195: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L196: // CONVERT_INT_TO_FLOAT
  float_vars[2] = (float)int_vars[3];
L197: // SUBTRACT_FLOAT
  float_vars[4] = float_vars[1] - float_vars[2];
L198: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[4]);
L199: // BOOL_INT
  int_vars[0] = int_vars[0];
L200: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L233; }
L201: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L202: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1068;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L203: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L204: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[2];
L205: // SUBTRACT_FLOAT
  float_vars[2] = float_vars[0] - float_vars[1];
L206: // EQ_FLOAT
  int_vars[0] = (float_vars[3] == float_vars[2]);
L207: // BOOL_INT
  int_vars[0] = int_vars[0];
L208: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L232; }
L209: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L210: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L211: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1069;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L212: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L213: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1069;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L214: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L215: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[3];
L216: // SUBTRACT_DOUBLE
  double_vars[4] = double_vars[1] - double_vars[2];
L217: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[4]);
L218: // BOOL_INT
  int_vars[0] = int_vars[0];
L219: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L231; }
L220: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L221: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1070;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L243;
  }
L222: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L223: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[2];
L224: // SUBTRACT_DOUBLE
  double_vars[3] = double_vars[0] - double_vars[1];
L225: // BOOL_DOUBLE
  int_vars[0] = !!double_vars[3];
L226: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L230; }
L227: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L228: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L243;
L229: // GOTO
  goto L230;
L230: // GOTO
  goto L231;
L231: // GOTO
  goto L232;
L232: // GOTO
  goto L233;
L233: // GOTO
  goto L234;
L234: // GOTO
  goto L235;
L235: // GOTO
  goto L236;
L236: // GOTO
  goto L237;
L237: // GOTO
  goto L238;
L238: // GOTO
  goto L239;
L239: // GOTO
  goto L240;
L240: // GOTO
  goto L241;
L241: // INIT_INT
  int_vars[4] = 0;
L242: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L243;
L243: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L244: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Increment__pre_dec_array_access_invocant_not_var(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULTI_ARRAY
  {
    if (BASIC_TYPE_ID_int < 0) {
      BASIC_TYPE_ID_int = env->get_basic_type_id(env, "int");
      if (BASIC_TYPE_ID_int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_int;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_muldim_array_raw(env, basic_type_id, 1, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 774;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L51;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 775;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L51;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L10: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 775;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L51;
  }
L12: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L15: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 777;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L51;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L18: // ARRAY_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 777;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L51;
  }
L20: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L21: // SUBTRACT_INT
  int_vars[6] = int_vars[4] - int_vars[5];
L22: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[6];
      } 
    } 
  } 
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 777;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L51;
  }
L24: // MOVE_INT
  int_vars[7] = int_vars[6];
L25: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L27: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L28: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 779;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L51;
  }
L30: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L31: // ARRAY_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 779;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L51;
  }
L33: // MOVE_CONSTANT_INT
  int_vars[5] = -1;
L34: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L35: // BOOL_INT
  int_vars[0] = int_vars[0];
L36: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L46; }
L37: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L38: // MOVE_CONSTANT_INT
  int_vars[2] = -1;
L39: // EQ_INT
  int_vars[0] = (int_vars[7] == int_vars[2]);
L40: // BOOL_INT
  int_vars[0] = int_vars[0];
L41: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L45; }
L42: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L43: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L51;
L44: // GOTO
  goto L45;
L45: // GOTO
  goto L46;
L46: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L47: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L48: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L51;
L49: // INIT_INT
  int_vars[6] = 0;
L50: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L51;
L51: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L52: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Increment__pre_dec_array_access_var_index(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[6] = {0};
  double double_vars[5];
  float float_vars[5];
  int64_t long_vars[5];
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  int8_t byte_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 988;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 989;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L11: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 990;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L15: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[3], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 991;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L19: // NEW_FLOAT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_float_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 992;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L23: // NEW_DOUBLE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_double_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[5], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 993;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L25: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 995;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L27: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 995;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L31: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 996;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L33: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L34: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L35: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 996;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L37: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 997;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L40: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[2];
      } 
    } 
  } 
L41: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 997;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L42: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 998;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L45: // ARRAY_STORE_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 998;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L47: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 999;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L49: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L50: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[0];
      } 
    } 
  } 
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 999;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L52: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1000;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L54: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L55: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[0];
      } 
    } 
  } 
L56: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1000;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L57: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L58: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1003;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L60: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L61: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L62: // SUBTRACT_INT
  int_vars[5] = int_vars[3] - int_vars[4];
L63: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L64: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L65: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1003;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L66: // MOVE_BYTE
  byte_vars[2] = byte_vars[1];
L67: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L68: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1004;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L69: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L70: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L71: // SUBTRACT_INT
  int_vars[5] = int_vars[3] - int_vars[4];
L72: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[5];
L73: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L74: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1004;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L75: // MOVE_SHORT
  short_vars[2] = short_vars[1];
L76: // ARRAY_FETCH_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L77: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1005;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L78: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L79: // SUBTRACT_INT
  int_vars[5] = int_vars[3] - int_vars[4];
L80: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L81: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1005;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L82: // MOVE_INT
  int_vars[6] = int_vars[5];
L83: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L84: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1006;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L85: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L86: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[3];
L87: // SUBTRACT_LONG
  long_vars[2] = long_vars[0] - long_vars[1];
L88: // ARRAY_STORE_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L89: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1006;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L90: // MOVE_LONG
  long_vars[3] = long_vars[2];
L91: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L92: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1007;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L93: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L94: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[3];
L95: // SUBTRACT_FLOAT
  float_vars[2] = float_vars[0] - float_vars[1];
L96: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[2];
      } 
    } 
  } 
L97: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1007;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L98: // MOVE_FLOAT
  float_vars[3] = float_vars[2];
L99: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L100: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1008;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L101: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L102: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[3];
L103: // SUBTRACT_DOUBLE
  double_vars[2] = double_vars[0] - double_vars[1];
L104: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[2];
      } 
    } 
  } 
L105: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1008;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L106: // MOVE_DOUBLE
  double_vars[3] = double_vars[2];
L107: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L108: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L109: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1010;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L110: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L111: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[1] = *(int8_t*)&stack[0];
    }
  }
L112: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1010;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L113: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[1];
L114: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L115: // SUBTRACT_INT
  int_vars[8] = int_vars[5] - int_vars[7];
L116: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L117: // BOOL_INT
  int_vars[0] = int_vars[0];
L118: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L236; }
L119: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[2];
L120: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L121: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1011;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L122: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L123: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L124: // SUBTRACT_INT
  int_vars[7] = int_vars[4] - int_vars[5];
L125: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L126: // BOOL_INT
  int_vars[0] = int_vars[0];
L127: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L235; }
L128: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L129: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L130: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1012;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L131: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L132: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L133: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1012;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L134: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[1];
L135: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L136: // SUBTRACT_INT
  int_vars[8] = int_vars[5] - int_vars[7];
L137: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L138: // BOOL_INT
  int_vars[0] = int_vars[0];
L139: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L234; }
L140: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[2];
L141: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L142: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1013;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L143: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L144: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L145: // SUBTRACT_INT
  int_vars[7] = int_vars[4] - int_vars[5];
L146: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L147: // BOOL_INT
  int_vars[0] = int_vars[0];
L148: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L233; }
L149: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L150: // ARRAY_FETCH_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L151: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1014;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L152: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L153: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1014;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L154: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L155: // SUBTRACT_INT
  int_vars[8] = int_vars[5] - int_vars[7];
L156: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L157: // BOOL_INT
  int_vars[0] = int_vars[0];
L158: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L232; }
L159: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L160: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1015;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L161: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L162: // SUBTRACT_INT
  int_vars[5] = int_vars[3] - int_vars[4];
L163: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[5]);
L164: // BOOL_INT
  int_vars[0] = int_vars[0];
L165: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L231; }
L166: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L167: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L168: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1016;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L169: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L170: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1016;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L171: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L172: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[4];
L173: // SUBTRACT_LONG
  long_vars[4] = long_vars[1] - long_vars[2];
L174: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[4]);
L175: // BOOL_INT
  int_vars[0] = int_vars[0];
L176: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L230; }
L177: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L178: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1017;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L179: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L180: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[3];
L181: // SUBTRACT_LONG
  long_vars[2] = long_vars[0] - long_vars[1];
L182: // EQ_LONG
  int_vars[0] = (long_vars[3] == long_vars[2]);
L183: // BOOL_INT
  int_vars[0] = int_vars[0];
L184: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L229; }
L185: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L186: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L187: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1018;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L188: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L189: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1018;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L190: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L191: // CONVERT_INT_TO_FLOAT
  float_vars[2] = (float)int_vars[4];
L192: // SUBTRACT_FLOAT
  float_vars[4] = float_vars[1] - float_vars[2];
L193: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[4]);
L194: // BOOL_INT
  int_vars[0] = int_vars[0];
L195: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L228; }
L196: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L197: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1019;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L198: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L199: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[3];
L200: // SUBTRACT_FLOAT
  float_vars[2] = float_vars[0] - float_vars[1];
L201: // EQ_FLOAT
  int_vars[0] = (float_vars[3] == float_vars[2]);
L202: // BOOL_INT
  int_vars[0] = int_vars[0];
L203: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L227; }
L204: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L205: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L206: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1020;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L207: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L208: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1020;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L209: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L210: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[4];
L211: // SUBTRACT_DOUBLE
  double_vars[4] = double_vars[1] - double_vars[2];
L212: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[4]);
L213: // BOOL_INT
  int_vars[0] = int_vars[0];
L214: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L226; }
L215: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L216: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_access_var_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 1021;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L238;
  }
L217: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L218: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[3];
L219: // SUBTRACT_DOUBLE
  double_vars[3] = double_vars[0] - double_vars[1];
L220: // BOOL_DOUBLE
  int_vars[0] = !!double_vars[3];
L221: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L225; }
L222: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L223: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L238;
L224: // GOTO
  goto L225;
L225: // GOTO
  goto L226;
L226: // GOTO
  goto L227;
L227: // GOTO
  goto L228;
L228: // GOTO
  goto L229;
L229: // GOTO
  goto L230;
L230: // GOTO
  goto L231;
L231: // GOTO
  goto L232;
L232: // GOTO
  goto L233;
L233: // GOTO
  goto L234;
L234: // GOTO
  goto L235;
L235: // GOTO
  goto L236;
L236: // INIT_INT
  int_vars[5] = 0;
L237: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L238;
L238: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L239: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Increment__pre_dec_array_field_access_constant_index(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[6] = {0};
  double double_vars[5];
  float float_vars[5];
  int64_t long_vars[5];
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  int8_t byte_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3b < 0) {
      BASIC_TYPE_ID_TestCase__Point_3b = env->get_basic_type_id(env, "TestCase::Point_3b");
      if (BASIC_TYPE_ID_TestCase__Point_3b < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3b");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3b;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 804;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3s < 0) {
      BASIC_TYPE_ID_TestCase__Point_3s = env->get_basic_type_id(env, "TestCase::Point_3s");
      if (BASIC_TYPE_ID_TestCase__Point_3s < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3s");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3s;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 805;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L11: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3i < 0) {
      BASIC_TYPE_ID_TestCase__Point_3i = env->get_basic_type_id(env, "TestCase::Point_3i");
      if (BASIC_TYPE_ID_TestCase__Point_3i < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3i");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3i;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 806;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L15: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3l < 0) {
      BASIC_TYPE_ID_TestCase__Point_3l = env->get_basic_type_id(env, "TestCase::Point_3l");
      if (BASIC_TYPE_ID_TestCase__Point_3l < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3l");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3l;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[3], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 807;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L19: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3f < 0) {
      BASIC_TYPE_ID_TestCase__Point_3f = env->get_basic_type_id(env, "TestCase::Point_3f");
      if (BASIC_TYPE_ID_TestCase__Point_3f < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3f");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3f;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 808;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L23: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3d < 0) {
      BASIC_TYPE_ID_TestCase__Point_3d = env->get_basic_type_id(env, "TestCase::Point_3d");
      if (BASIC_TYPE_ID_TestCase__Point_3d < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3d");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3d;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[5], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 809;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L25: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 811;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L27: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // MOVE_INT
  int_vars[3] = int_vars[2];
L30: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = byte_vars[1];
      }
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 811;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L32: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 812;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L34: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L36: // MOVE_INT
  int_vars[3] = int_vars[2];
L37: // MULNUM_ARRAY_FIELD_STORE_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = short_vars[1];
      }
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 812;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L39: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 813;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L41: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L42: // MOVE_INT
  int_vars[4] = int_vars[3];
L43: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = int_vars[2];
      }
    }
  }
L44: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 813;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L45: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 814;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L47: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L48: // MOVE_INT
  int_vars[3] = int_vars[2];
L49: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = long_vars[0];
      }
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 814;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L51: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L52: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 815;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L53: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L54: // MOVE_INT
  int_vars[3] = int_vars[2];
L55: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = float_vars[0];
      }
    }
  }
L56: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 815;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L57: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L58: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 816;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L59: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L60: // MOVE_INT
  int_vars[3] = int_vars[2];
L61: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = double_vars[0];
      }
    }
  }
L62: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 816;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L63: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L64: // MOVE_INT
  int_vars[3] = int_vars[2];
L65: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L66: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 818;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L67: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L68: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L69: // SUBTRACT_INT
  int_vars[6] = int_vars[4] - int_vars[5];
L70: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[6];
L71: // MULNUM_ARRAY_FIELD_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = byte_vars[1];
      }
    }
  }
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 818;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L73: // MOVE_BYTE
  byte_vars[2] = byte_vars[1];
L74: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L75: // MOVE_INT
  int_vars[3] = int_vars[2];
L76: // MULNUM_ARRAY_FIELD_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] =((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L77: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 819;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L78: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L79: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L80: // SUBTRACT_INT
  int_vars[6] = int_vars[4] - int_vars[5];
L81: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[6];
L82: // MULNUM_ARRAY_FIELD_STORE_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = short_vars[1];
      }
    }
  }
L83: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 819;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L84: // MOVE_SHORT
  short_vars[2] = short_vars[1];
L85: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L86: // MOVE_INT
  int_vars[3] = int_vars[2];
L87: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L88: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 820;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L89: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L90: // SUBTRACT_INT
  int_vars[6] = int_vars[4] - int_vars[5];
L91: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = int_vars[6];
      }
    }
  }
L92: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 820;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L93: // MOVE_INT
  int_vars[7] = int_vars[6];
L94: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L95: // MOVE_INT
  int_vars[3] = int_vars[2];
L96: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L97: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 821;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L98: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L99: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L100: // SUBTRACT_LONG
  long_vars[2] = long_vars[0] - long_vars[1];
L101: // MULNUM_ARRAY_FIELD_STORE_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = long_vars[2];
      }
    }
  }
L102: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 821;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L103: // MOVE_LONG
  long_vars[3] = long_vars[2];
L104: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L105: // MOVE_INT
  int_vars[3] = int_vars[2];
L106: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L107: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 822;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L108: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L109: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[4];
L110: // SUBTRACT_FLOAT
  float_vars[2] = float_vars[0] - float_vars[1];
L111: // MULNUM_ARRAY_FIELD_STORE_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((float*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = float_vars[2];
      }
    }
  }
L112: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 822;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L113: // MOVE_FLOAT
  float_vars[3] = float_vars[2];
L114: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L115: // MOVE_INT
  int_vars[3] = int_vars[2];
L116: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L117: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 823;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L118: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L119: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[4];
L120: // SUBTRACT_DOUBLE
  double_vars[2] = double_vars[0] - double_vars[1];
L121: // MULNUM_ARRAY_FIELD_STORE_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((double*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = double_vars[2];
      }
    }
  }
L122: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 823;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L123: // MOVE_DOUBLE
  double_vars[3] = double_vars[2];
L124: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L125: // MOVE_INT
  int_vars[3] = int_vars[2];
L126: // MULNUM_ARRAY_FIELD_FETCH_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] =((int8_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L127: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 825;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L128: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L129: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[1] = *(int8_t*)&stack[0];
    }
  }
L130: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 825;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L131: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[1];
L132: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L133: // SUBTRACT_INT
  int_vars[8] = int_vars[5] - int_vars[6];
L134: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L135: // BOOL_INT
  int_vars[0] = int_vars[0];
L136: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L259; }
L137: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[2];
L138: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L139: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 826;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L140: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L141: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L142: // SUBTRACT_INT
  int_vars[5] = int_vars[3] - int_vars[4];
L143: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[5]);
L144: // BOOL_INT
  int_vars[0] = int_vars[0];
L145: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L258; }
L146: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L147: // MOVE_INT
  int_vars[3] = int_vars[2];
L148: // MULNUM_ARRAY_FIELD_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] =((int16_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L149: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 827;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L150: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L151: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L152: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 827;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L153: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[1];
L154: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L155: // SUBTRACT_INT
  int_vars[8] = int_vars[5] - int_vars[6];
L156: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L157: // BOOL_INT
  int_vars[0] = int_vars[0];
L158: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L257; }
L159: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[2];
L160: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L161: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 828;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L162: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L163: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L164: // SUBTRACT_INT
  int_vars[5] = int_vars[3] - int_vars[4];
L165: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[5]);
L166: // BOOL_INT
  int_vars[0] = int_vars[0];
L167: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L256; }
L168: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L169: // MOVE_INT
  int_vars[3] = int_vars[2];
L170: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[4] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L171: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 829;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L172: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L173: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 829;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L174: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L175: // SUBTRACT_INT
  int_vars[8] = int_vars[5] - int_vars[6];
L176: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[8]);
L177: // BOOL_INT
  int_vars[0] = int_vars[0];
L178: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L255; }
L179: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L180: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 830;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L181: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L182: // SUBTRACT_INT
  int_vars[4] = int_vars[2] - int_vars[3];
L183: // EQ_INT
  int_vars[0] = (int_vars[7] == int_vars[4]);
L184: // BOOL_INT
  int_vars[0] = int_vars[0];
L185: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L254; }
L186: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L187: // MOVE_INT
  int_vars[3] = int_vars[2];
L188: // MULNUM_ARRAY_FIELD_FETCH_LONG
  {
    void* array = object_vars[3];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] =((int64_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L189: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 831;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L190: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L191: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 831;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L192: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L193: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[4];
L194: // SUBTRACT_LONG
  long_vars[4] = long_vars[1] - long_vars[2];
L195: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[4]);
L196: // BOOL_INT
  int_vars[0] = int_vars[0];
L197: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L253; }
L198: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L199: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 832;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L200: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L201: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L202: // SUBTRACT_LONG
  long_vars[2] = long_vars[0] - long_vars[1];
L203: // EQ_LONG
  int_vars[0] = (long_vars[3] == long_vars[2]);
L204: // BOOL_INT
  int_vars[0] = int_vars[0];
L205: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L252; }
L206: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L207: // MOVE_INT
  int_vars[3] = int_vars[2];
L208: // MULNUM_ARRAY_FIELD_FETCH_FLOAT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] =((float*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L209: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 833;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L210: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L211: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 833;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L212: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L213: // CONVERT_INT_TO_FLOAT
  float_vars[2] = (float)int_vars[4];
L214: // SUBTRACT_FLOAT
  float_vars[4] = float_vars[1] - float_vars[2];
L215: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[4]);
L216: // BOOL_INT
  int_vars[0] = int_vars[0];
L217: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L251; }
L218: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L219: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 834;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L220: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L221: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[2];
L222: // SUBTRACT_FLOAT
  float_vars[2] = float_vars[0] - float_vars[1];
L223: // EQ_FLOAT
  int_vars[0] = (float_vars[3] == float_vars[2]);
L224: // BOOL_INT
  int_vars[0] = int_vars[0];
L225: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L250; }
L226: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L227: // MOVE_INT
  int_vars[3] = int_vars[2];
L228: // MULNUM_ARRAY_FIELD_FETCH_DOUBLE
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] =((double*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L229: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 835;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L230: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L231: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 835;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L232: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L233: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[4];
L234: // SUBTRACT_DOUBLE
  double_vars[4] = double_vars[1] - double_vars[2];
L235: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[4]);
L236: // BOOL_INT
  int_vars[0] = int_vars[0];
L237: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L249; }
L238: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L239: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_constant_index";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 836;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L261;
  }
L240: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L241: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[2];
L242: // SUBTRACT_DOUBLE
  double_vars[3] = double_vars[0] - double_vars[1];
L243: // BOOL_DOUBLE
  int_vars[0] = !!double_vars[3];
L244: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L248; }
L245: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L246: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L261;
L247: // GOTO
  goto L248;
L248: // GOTO
  goto L249;
L249: // GOTO
  goto L250;
L250: // GOTO
  goto L251;
L251: // GOTO
  goto L252;
L252: // GOTO
  goto L253;
L253: // GOTO
  goto L254;
L254: // GOTO
  goto L255;
L255: // GOTO
  goto L256;
L256: // GOTO
  goto L257;
L257: // GOTO
  goto L258;
L258: // GOTO
  goto L259;
L259: // INIT_INT
  int_vars[4] = 0;
L260: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L261;
L261: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L262: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Increment__pre_dec_array_field_access_invocant_not_var(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULTI_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3i < 0) {
      BASIC_TYPE_ID_TestCase__Point_3i = env->get_basic_type_id(env, "TestCase::Point_3i");
      if (BASIC_TYPE_ID_TestCase__Point_3i < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3i");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3i;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_muldim_array_raw(env, basic_type_id, 1, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 789;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // NEW_MULNUM_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Point_3i < 0) {
      BASIC_TYPE_ID_TestCase__Point_3i = env->get_basic_type_id(env, "TestCase::Point_3i");
      if (BASIC_TYPE_ID_TestCase__Point_3i < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Point_3i");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Point_3i;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_mulnum_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 790;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L10: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 790;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L12: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L15: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 792;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L18: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L19: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L20: // MOVE_INT
  int_vars[4] = int_vars[3];
L21: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[5] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 792;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L23: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L24: // SUBTRACT_INT
  int_vars[7] = int_vars[5] - int_vars[6];
L25: // MULNUM_ARRAY_FIELD_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        ((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0] = int_vars[7];
      }
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 792;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L27: // MOVE_INT
  int_vars[8] = int_vars[7];
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L29: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L30: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L31: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L32: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 794;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L34: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L35: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L36: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L37: // MOVE_INT
  int_vars[4] = int_vars[3];
L38: // MULNUM_ARRAY_FIELD_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[5] =((int32_t*)((intptr_t)array + object_header_byte_size))[3 * index + 0]; 
      } 
    } 
  } 
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_array_field_access_invocant_not_var";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 794;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L40: // MOVE_CONSTANT_INT
  int_vars[6] = -1;
L41: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L42: // BOOL_INT
  int_vars[0] = int_vars[0];
L43: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L54; }
L44: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L45: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L46: // MOVE_CONSTANT_INT
  int_vars[2] = -1;
L47: // EQ_INT
  int_vars[0] = (int_vars[8] == int_vars[2]);
L48: // BOOL_INT
  int_vars[0] = int_vars[0];
L49: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L53; }
L50: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L51: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L59;
L52: // GOTO
  goto L53;
L53: // GOTO
  goto L54;
L54: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L55: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L56: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L59;
L57: // INIT_INT
  int_vars[6] = 0;
L58: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L59;
L59: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L60: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Increment__pre_dec_deref(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* ref_vars[6] = {0};
  double double_vars[6];
  float float_vars[6];
  int64_t long_vars[6];
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[4];
  int8_t byte_vars[4];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 895;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L3: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L4: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 896;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L6: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L7: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 897;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L9: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 898;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L11: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 899;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L13: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 900;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L15: // REF_BYTE
  *(void**)&ref_vars[0] = &byte_vars[1];
L16: // REF_SHORT
  *(void**)&ref_vars[1] = &short_vars[1];
L17: // REF_INT
  *(void**)&ref_vars[2] = &int_vars[2];
L18: // REF_LONG
  *(void**)&ref_vars[3] = &long_vars[0];
L19: // REF_FLOAT
  *(void**)&ref_vars[4] = &float_vars[0];
L20: // REF_DOUBLE
  *(void**)&ref_vars[5] = &double_vars[0];
L21: // GET_DEREF_BYTE
  byte_vars[0] = *(int8_t*)*(void**)&ref_vars[0];
L22: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L24: // SUBTRACT_INT
  int_vars[5] = int_vars[3] - int_vars[4];
L25: // CONVERT_INT_TO_BYTE
  byte_vars[2] = (int8_t)int_vars[5];
L26: // SET_DEREF_BYTE
  *(int8_t*)*(void**)&ref_vars[0] = byte_vars[2];
L27: // MOVE_BYTE
  byte_vars[3] = byte_vars[2];
L28: // GET_DEREF_SHORT
  short_vars[0] = *(int16_t*)*(void**)&ref_vars[1];
L29: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L30: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L31: // SUBTRACT_INT
  int_vars[5] = int_vars[3] - int_vars[4];
L32: // CONVERT_INT_TO_SHORT
  short_vars[2] = (int16_t)int_vars[5];
L33: // SET_DEREF_SHORT
  *(int16_t*)*(void**)&ref_vars[1] = short_vars[2];
L34: // MOVE_SHORT
  short_vars[3] = short_vars[2];
L35: // GET_DEREF_INT
  int_vars[3] = *(int32_t*)*(void**)&ref_vars[2];
L36: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L37: // SUBTRACT_INT
  int_vars[5] = int_vars[3] - int_vars[4];
L38: // SET_DEREF_INT
  *(int32_t*)*(void**)&ref_vars[2] = int_vars[5];
L39: // MOVE_INT
  int_vars[6] = int_vars[5];
L40: // GET_DEREF_LONG
  long_vars[1] = *(int64_t*)*(void**)&ref_vars[3];
L41: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L42: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[3];
L43: // SUBTRACT_LONG
  long_vars[3] = long_vars[1] - long_vars[2];
L44: // SET_DEREF_LONG
  *(int64_t*)*(void**)&ref_vars[3] = long_vars[3];
L45: // MOVE_LONG
  long_vars[4] = long_vars[3];
L46: // GET_DEREF_FLOAT
  float_vars[1] = *(float*)*(void**)&ref_vars[4];
L47: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L48: // CONVERT_INT_TO_FLOAT
  float_vars[2] = (float)int_vars[3];
L49: // SUBTRACT_FLOAT
  float_vars[3] = float_vars[1] - float_vars[2];
L50: // SET_DEREF_FLOAT
  *(float*)*(void**)&ref_vars[4] = float_vars[3];
L51: // MOVE_FLOAT
  float_vars[4] = float_vars[3];
L52: // GET_DEREF_DOUBLE
  double_vars[1] = *(double*)*(void**)&ref_vars[5];
L53: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L54: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[3];
L55: // SUBTRACT_DOUBLE
  double_vars[3] = double_vars[1] - double_vars[2];
L56: // SET_DEREF_DOUBLE
  *(double*)*(void**)&ref_vars[5] = double_vars[3];
L57: // MOVE_DOUBLE
  double_vars[4] = double_vars[3];
L58: // GET_DEREF_BYTE
  byte_vars[0] = *(int8_t*)*(void**)&ref_vars[0];
L59: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L60: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[2] = *(int8_t*)&stack[0];
    }
  }
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 916;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L62: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[2];
L63: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L64: // SUBTRACT_INT
  int_vars[7] = int_vars[4] - int_vars[5];
L65: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L66: // BOOL_INT
  int_vars[0] = int_vars[0];
L67: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L175; }
L68: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[3];
L69: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 917;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L71: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L72: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L73: // SUBTRACT_INT
  int_vars[7] = int_vars[4] - int_vars[5];
L74: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L75: // BOOL_INT
  int_vars[0] = int_vars[0];
L76: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L174; }
L77: // GET_DEREF_SHORT
  short_vars[0] = *(int16_t*)*(void**)&ref_vars[1];
L78: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L79: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[2] = *(int16_t*)&stack[0];
    }
  }
L80: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 918;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L81: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[2];
L82: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L83: // SUBTRACT_INT
  int_vars[7] = int_vars[4] - int_vars[5];
L84: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L85: // BOOL_INT
  int_vars[0] = int_vars[0];
L86: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L173; }
L87: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[3];
L88: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L89: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 919;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L90: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L91: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L92: // SUBTRACT_INT
  int_vars[7] = int_vars[4] - int_vars[5];
L93: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L94: // BOOL_INT
  int_vars[0] = int_vars[0];
L95: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L172; }
L96: // GET_DEREF_INT
  int_vars[3] = *(int32_t*)*(void**)&ref_vars[2];
L97: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L98: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 920;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L99: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L100: // SUBTRACT_INT
  int_vars[7] = int_vars[4] - int_vars[5];
L101: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[7]);
L102: // BOOL_INT
  int_vars[0] = int_vars[0];
L103: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L171; }
L104: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L105: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 921;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L106: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L107: // SUBTRACT_INT
  int_vars[5] = int_vars[3] - int_vars[4];
L108: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[5]);
L109: // BOOL_INT
  int_vars[0] = int_vars[0];
L110: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L170; }
L111: // GET_DEREF_LONG
  long_vars[1] = *(int64_t*)*(void**)&ref_vars[3];
L112: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[2] = *(int64_t*)&stack[0];
    }
  }
L113: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 922;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L114: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L115: // CONVERT_INT_TO_LONG
  long_vars[3] = (int64_t)int_vars[3];
L116: // SUBTRACT_LONG
  long_vars[5] = long_vars[2] - long_vars[3];
L117: // EQ_LONG
  int_vars[0] = (long_vars[1] == long_vars[5]);
L118: // BOOL_INT
  int_vars[0] = int_vars[0];
L119: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L169; }
L120: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L121: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 923;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L122: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L123: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[3];
L124: // SUBTRACT_LONG
  long_vars[3] = long_vars[1] - long_vars[2];
L125: // EQ_LONG
  int_vars[0] = (long_vars[4] == long_vars[3]);
L126: // BOOL_INT
  int_vars[0] = int_vars[0];
L127: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L168; }
L128: // GET_DEREF_FLOAT
  float_vars[1] = *(float*)*(void**)&ref_vars[4];
L129: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L130: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 924;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L131: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L132: // CONVERT_INT_TO_FLOAT
  float_vars[3] = (float)int_vars[3];
L133: // SUBTRACT_FLOAT
  float_vars[5] = float_vars[2] - float_vars[3];
L134: // EQ_FLOAT
  int_vars[0] = (float_vars[1] == float_vars[5]);
L135: // BOOL_INT
  int_vars[0] = int_vars[0];
L136: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L167; }
L137: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L138: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 925;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L139: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L140: // CONVERT_INT_TO_FLOAT
  float_vars[2] = (float)int_vars[3];
L141: // SUBTRACT_FLOAT
  float_vars[3] = float_vars[1] - float_vars[2];
L142: // EQ_FLOAT
  int_vars[0] = (float_vars[4] == float_vars[3]);
L143: // BOOL_INT
  int_vars[0] = int_vars[0];
L144: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L166; }
L145: // GET_DEREF_DOUBLE
  double_vars[1] = *(double*)*(void**)&ref_vars[5];
L146: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L147: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 926;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L148: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L149: // CONVERT_INT_TO_DOUBLE
  double_vars[3] = (double)int_vars[3];
L150: // SUBTRACT_DOUBLE
  double_vars[5] = double_vars[2] - double_vars[3];
L151: // EQ_DOUBLE
  int_vars[0] = (double_vars[1] == double_vars[5]);
L152: // BOOL_INT
  int_vars[0] = int_vars[0];
L153: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L165; }
L154: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L155: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_deref";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 927;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L177;
  }
L156: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L157: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[3];
L158: // SUBTRACT_DOUBLE
  double_vars[4] = double_vars[1] - double_vars[2];
L159: // BOOL_DOUBLE
  int_vars[0] = !!double_vars[4];
L160: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L164; }
L161: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L162: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L177;
L163: // GOTO
  goto L164;
L164: // GOTO
  goto L165;
L165: // GOTO
  goto L166;
L166: // GOTO
  goto L167;
L167: // GOTO
  goto L168;
L168: // GOTO
  goto L169;
L169: // GOTO
  goto L170;
L170: // GOTO
  goto L171;
L171: // GOTO
  goto L172;
L172: // GOTO
  goto L173;
L173: // GOTO
  goto L174;
L174: // GOTO
  goto L175;
L175: // INIT_INT
  int_vars[5] = 0;
L176: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L177;
L177: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Increment__pre_dec_field_access(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  double double_vars[5];
  float float_vars[5];
  int64_t long_vars[5];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  int8_t byte_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Simple->new
  {
    if (SUB_ID_TestCase__Simple__new < 0) {
      SUB_ID_TestCase__Simple__new = env->get_sub_id(env, "TestCase::Simple", "new", "TestCase::Simple()");
      if (SUB_ID_TestCase__Simple__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Simple new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Simple__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 944;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L4: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 946;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L6: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L7: // SET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__byte_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__byte_value = env->get_field_id(env, "TestCase::Simple", "byte_value", "byte");
      if (FIELD_ID_TestCase__Simple__byte_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple byte_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__byte_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__byte_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__byte_value) = byte_vars[1];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 946;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L9: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 947;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L11: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L12: // SET_FIELD_SHORT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__short_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__short_value = env->get_field_id(env, "TestCase::Simple", "short_value", "short");
      if (FIELD_ID_TestCase__Simple__short_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple short_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__short_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__short_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int16_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__short_value) = short_vars[1];
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 947;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L14: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 948;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L16: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__int_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__int_value = env->get_field_id(env, "TestCase::Simple", "int_value", "int");
      if (FIELD_ID_TestCase__Simple__int_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple int_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__int_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__int_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__int_value) = int_vars[2];
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 948;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L18: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 949;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L20: // SET_FIELD_LONG
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__long_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__long_value = env->get_field_id(env, "TestCase::Simple", "long_value", "long");
      if (FIELD_ID_TestCase__Simple__long_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple long_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__long_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__long_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int64_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__long_value) = long_vars[0];
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 949;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L22: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 950;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L24: // SET_FIELD_FLOAT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__float_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__float_value = env->get_field_id(env, "TestCase::Simple", "float_value", "float");
      if (FIELD_ID_TestCase__Simple__float_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple float_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__float_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__float_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(float*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__float_value) = float_vars[0];
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 950;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L26: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 951;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L28: // SET_FIELD_DOUBLE
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__double_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__double_value = env->get_field_id(env, "TestCase::Simple", "double_value", "double");
      if (FIELD_ID_TestCase__Simple__double_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple double_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__double_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__double_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(double*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__double_value) = double_vars[0];
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 951;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L30: // GET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__byte_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__byte_value = env->get_field_id(env, "TestCase::Simple", "byte_value", "byte");
      if (FIELD_ID_TestCase__Simple__byte_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple byte_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__byte_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__byte_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      byte_vars[0] = *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__byte_value);
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 953;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L32: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L33: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L34: // SUBTRACT_INT
  int_vars[4] = int_vars[2] - int_vars[3];
L35: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[4];
L36: // SET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__byte_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__byte_value = env->get_field_id(env, "TestCase::Simple", "byte_value", "byte");
      if (FIELD_ID_TestCase__Simple__byte_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple byte_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__byte_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__byte_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__byte_value) = byte_vars[1];
    }
  }
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 953;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L38: // MOVE_BYTE
  byte_vars[2] = byte_vars[1];
L39: // GET_FIELD_SHORT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__short_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__short_value = env->get_field_id(env, "TestCase::Simple", "short_value", "short");
      if (FIELD_ID_TestCase__Simple__short_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple short_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__short_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__short_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      short_vars[0] = *(int16_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__short_value);
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 954;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L41: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L42: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L43: // SUBTRACT_INT
  int_vars[4] = int_vars[2] - int_vars[3];
L44: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L45: // SET_FIELD_SHORT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__short_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__short_value = env->get_field_id(env, "TestCase::Simple", "short_value", "short");
      if (FIELD_ID_TestCase__Simple__short_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple short_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__short_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__short_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int16_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__short_value) = short_vars[1];
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 954;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L47: // MOVE_SHORT
  short_vars[2] = short_vars[1];
L48: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__int_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__int_value = env->get_field_id(env, "TestCase::Simple", "int_value", "int");
      if (FIELD_ID_TestCase__Simple__int_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple int_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__int_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__int_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__int_value);
    }
  }
L49: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 955;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L50: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L51: // SUBTRACT_INT
  int_vars[4] = int_vars[2] - int_vars[3];
L52: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__int_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__int_value = env->get_field_id(env, "TestCase::Simple", "int_value", "int");
      if (FIELD_ID_TestCase__Simple__int_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple int_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__int_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__int_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__int_value) = int_vars[4];
    }
  }
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 955;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L54: // MOVE_INT
  int_vars[5] = int_vars[4];
L55: // GET_FIELD_LONG
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__long_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__long_value = env->get_field_id(env, "TestCase::Simple", "long_value", "long");
      if (FIELD_ID_TestCase__Simple__long_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple long_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__long_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__long_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      long_vars[0] = *(int64_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__long_value);
    }
  }
L56: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 956;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L57: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L58: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[2];
L59: // SUBTRACT_LONG
  long_vars[2] = long_vars[0] - long_vars[1];
L60: // SET_FIELD_LONG
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__long_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__long_value = env->get_field_id(env, "TestCase::Simple", "long_value", "long");
      if (FIELD_ID_TestCase__Simple__long_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple long_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__long_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__long_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int64_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__long_value) = long_vars[2];
    }
  }
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 956;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L62: // MOVE_LONG
  long_vars[3] = long_vars[2];
L63: // GET_FIELD_FLOAT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__float_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__float_value = env->get_field_id(env, "TestCase::Simple", "float_value", "float");
      if (FIELD_ID_TestCase__Simple__float_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple float_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__float_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__float_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      float_vars[0] = *(float*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__float_value);
    }
  }
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 957;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L65: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L66: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[2];
L67: // SUBTRACT_FLOAT
  float_vars[2] = float_vars[0] - float_vars[1];
L68: // SET_FIELD_FLOAT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__float_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__float_value = env->get_field_id(env, "TestCase::Simple", "float_value", "float");
      if (FIELD_ID_TestCase__Simple__float_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple float_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__float_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__float_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(float*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__float_value) = float_vars[2];
    }
  }
L69: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 957;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L70: // MOVE_FLOAT
  float_vars[3] = float_vars[2];
L71: // GET_FIELD_DOUBLE
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__double_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__double_value = env->get_field_id(env, "TestCase::Simple", "double_value", "double");
      if (FIELD_ID_TestCase__Simple__double_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple double_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__double_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__double_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      double_vars[0] = *(double*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__double_value);
    }
  }
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 958;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L73: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L74: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[2];
L75: // SUBTRACT_DOUBLE
  double_vars[2] = double_vars[0] - double_vars[1];
L76: // SET_FIELD_DOUBLE
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__double_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__double_value = env->get_field_id(env, "TestCase::Simple", "double_value", "double");
      if (FIELD_ID_TestCase__Simple__double_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple double_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__double_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__double_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(double*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__double_value) = double_vars[2];
    }
  }
L77: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 958;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L78: // MOVE_DOUBLE
  double_vars[3] = double_vars[2];
L79: // GET_FIELD_BYTE
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__byte_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__byte_value = env->get_field_id(env, "TestCase::Simple", "byte_value", "byte");
      if (FIELD_ID_TestCase__Simple__byte_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple byte_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__byte_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__byte_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      byte_vars[0] = *(int8_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__byte_value);
    }
  }
L80: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 960;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L81: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L82: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[1] = *(int8_t*)&stack[0];
    }
  }
L83: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 960;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L84: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[1];
L85: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L86: // SUBTRACT_INT
  int_vars[6] = int_vars[3] - int_vars[4];
L87: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L88: // BOOL_INT
  int_vars[0] = int_vars[0];
L89: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L202; }
L90: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[2];
L91: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L92: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_field_access";
    const char* file = "TestCase/Increment.spvm";
    int32_t line = 961;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L204;
  }
L93: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L94: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L95: // SUBTRACT_INT
  int_vars[6] = int_vars[3] - int_vars[4];
L96: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L97: // BOOL_INT
  int_vars[0] = int_vars[0];
L98: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L201; }
L99: // GET_FIELD_SHORT
  {
    if (__builtin_expect(FIELD_ID_TestCase__Simple__short_value < 0, 0)) {
      FIELD_ID_TestCase__Simple__short_value = env->get_field_id(env, "TestCase::Simple", "short_value", "short");
      if (FIELD_ID_TestCase__Simple__short_value < 0) {
        void* exception = env->new_string_raw(env, "Field not found TestCase::Simple short_value");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_TestCase__Simple__short_value = env->get_field_offset(env, FIELD_ID_TestCase__Simple__short_value);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      short_vars[0] = *(int16_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_TestCase__Simple__short_value);
    }
  }
L100: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Increment";
    const char* sub_name = "pre_dec_field_access";
    const char* file = "Tes