#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#include <complex.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
static int32_t FIELD_ID_SPVM__Complex_2d__x = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__Complex_2d__x = -1;
static int32_t FIELD_ID_SPVM__Complex_2d__y = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__Complex_2d__y = -1;
static int32_t FIELD_ID_SPVM__Complex_2f__x = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__Complex_2f__x = -1;
static int32_t FIELD_ID_SPVM__Complex_2f__y = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__Complex_2f__y = -1;
// Sub id declarations
static int32_t SUB_ID_SPVM__Util__complexd = - 1;
static int32_t SUB_ID_SPVM__Util__DBL_MIN = - 1;
static int32_t SUB_ID_SPVM__Util__complexf = - 1;
static int32_t SUB_ID_SPVM__Util__FLT_MIN = - 1;
// Basic type id declarations
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Complex__test_cadd(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Complex__test_cadd_min(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Complex__test_caddf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Complex__test_caddf_min(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Complex__test_cdiv(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Complex__test_cdiv_min(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Complex__test_cdivf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Complex__test_cdivf_min(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Complex__test_cmul(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Complex__test_cmul_min(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Complex__test_cmulf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Complex__test_cmulf_min(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Complex__test_csub(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Complex__test_csub_min(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Complex__test_csubf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Complex__test_csubf_min(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Complex__test_cadd(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[8];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.25;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.5;
L3: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L4: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L5: // CALL_SUB_MULNUM_DOUBLE
  // SPVM::Util->complexd
  {
    if (SUB_ID_SPVM__Util__complexd < 0) {
      SUB_ID_SPVM__Util__complexd = env->get_sub_id(env, "SPVM::Util", "complexd", "SPVM::Complex_2d(double,double)");
      if (SUB_ID_SPVM__Util__complexd < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util complexd");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__complexd;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
      double_vars[3] = *(double*)&stack[1];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_cadd";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 7;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L41;
  }
L7: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.5;
L8: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.125;
L9: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L10: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L11: // CALL_SUB_MULNUM_DOUBLE
  // SPVM::Util->complexd
  {
    if (SUB_ID_SPVM__Util__complexd < 0) {
      SUB_ID_SPVM__Util__complexd = env->get_sub_id(env, "SPVM::Util", "complexd", "SPVM::Complex_2d(double,double)");
      if (SUB_ID_SPVM__Util__complexd < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util complexd");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__complexd;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[4] = *(double*)&stack[0];
      double_vars[5] = *(double*)&stack[1];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_cadd";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 8;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L41;
  }
L13: // COMPLEX_ADD_DOUBLE
  {
    double _Complex x_in1 = double_vars[2] + double_vars[3]  * _Complex_I ;
    double _Complex x_in2 = double_vars[4] + double_vars[5]  * _Complex_I ;
    double _Complex x_out = x_in1 + x_in2;
    double_vars[0] = creal(x_out);
    double_vars[1] = cimag(x_out);
  }
L14: // MULNUM_GET_FIELD_DOUBLE
  double_vars[6] = double_vars[0];
L15: // MOVE_CONSTANT_DOUBLE
  double_vars[7] = 0.75;
L16: // EQ_DOUBLE
  int_vars[0] = (double_vars[6] == double_vars[7]);
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L30; }
L19: // MULNUM_GET_FIELD_DOUBLE
  double_vars[6] = double_vars[1];
L20: // MOVE_CONSTANT_DOUBLE
  double_vars[7] = 0.625;
L21: // EQ_DOUBLE
  int_vars[0] = (double_vars[6] == double_vars[7]);
L22: // BOOL_INT
  int_vars[0] = int_vars[0];
L23: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L27; }
L24: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L25: // BOOL_INT
  int_vars[0] = int_vars[2];
L26: // GOTO
  goto L29;
L27: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L28: // BOOL_INT
  int_vars[0] = int_vars[3];
L29: // GOTO
  goto L32;
L30: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L31: // BOOL_INT
  int_vars[0] = int_vars[4];
L32: // BOOL_INT
  int_vars[0] = int_vars[0];
L33: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L37; }
L34: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L35: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L41;
L36: // GOTO
  goto L37;
L37: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L38: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L41;
L39: // INIT_INT
  int_vars[6] = 0;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L41;
L41: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Complex__test_cadd_min(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[8];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_cadd_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 18;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L3: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_cadd_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 18;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L5: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L6: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L7: // CALL_SUB_MULNUM_DOUBLE
  // SPVM::Util->complexd
  {
    if (SUB_ID_SPVM__Util__complexd < 0) {
      SUB_ID_SPVM__Util__complexd = env->get_sub_id(env, "SPVM::Util", "complexd", "SPVM::Complex_2d(double,double)");
      if (SUB_ID_SPVM__Util__complexd < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util complexd");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__complexd;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
      double_vars[3] = *(double*)&stack[1];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_cadd_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 18;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L11: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L12: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[3];
L13: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L14: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L15: // CALL_SUB_MULNUM_DOUBLE
  // SPVM::Util->complexd
  {
    if (SUB_ID_SPVM__Util__complexd < 0) {
      SUB_ID_SPVM__Util__complexd = env->get_sub_id(env, "SPVM::Util", "complexd", "SPVM::Complex_2d(double,double)");
      if (SUB_ID_SPVM__Util__complexd < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util complexd");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__complexd;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[4] = *(double*)&stack[0];
      double_vars[5] = *(double*)&stack[1];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_cadd_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 19;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L17: // COMPLEX_ADD_DOUBLE
  {
    double _Complex x_in1 = double_vars[2] + double_vars[3]  * _Complex_I ;
    double _Complex x_in2 = double_vars[4] + double_vars[5]  * _Complex_I ;
    double _Complex x_out = x_in1 + x_in2;
    double_vars[0] = creal(x_out);
    double_vars[1] = cimag(x_out);
  }
L18: // MULNUM_GET_FIELD_DOUBLE
  double_vars[6] = double_vars[0];
L19: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[7] = *(double*)&stack[0];
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_cadd_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 22;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L21: // EQ_DOUBLE
  int_vars[0] = (double_vars[6] == double_vars[7]);
L22: // BOOL_INT
  int_vars[0] = int_vars[0];
L23: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L36; }
L24: // MULNUM_GET_FIELD_DOUBLE
  double_vars[6] = double_vars[1];
L25: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[7] = *(double*)&stack[0];
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_cadd_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 22;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L27: // EQ_DOUBLE
  int_vars[0] = (double_vars[6] == double_vars[7]);
L28: // BOOL_INT
  int_vars[0] = int_vars[0];
L29: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L33; }
L30: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L31: // BOOL_INT
  int_vars[0] = int_vars[2];
L32: // GOTO
  goto L35;
L33: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L34: // BOOL_INT
  int_vars[0] = int_vars[3];
L35: // GOTO
  goto L38;
L36: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L37: // BOOL_INT
  int_vars[0] = int_vars[4];
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L43; }
L40: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L47;
L42: // GOTO
  goto L43;
L43: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L47;
L45: // INIT_INT
  int_vars[6] = 0;
L46: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L47;
L47: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Complex__test_caddf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  float float_vars[7];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.25;
L2: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.5;
L3: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L4: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L5: // CALL_SUB_MULNUM_FLOAT
  // SPVM::Util->complexf
  {
    if (SUB_ID_SPVM__Util__complexf < 0) {
      SUB_ID_SPVM__Util__complexf = env->get_sub_id(env, "SPVM::Util", "complexf", "SPVM::Complex_2f(float,float)");
      if (SUB_ID_SPVM__Util__complexf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util complexf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__complexf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
      float_vars[3] = *(float*)&stack[1];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_caddf";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 100;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L7: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L8: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.125;
L9: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L10: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L11: // CALL_SUB_MULNUM_FLOAT
  // SPVM::Util->complexf
  {
    if (SUB_ID_SPVM__Util__complexf < 0) {
      SUB_ID_SPVM__Util__complexf = env->get_sub_id(env, "SPVM::Util", "complexf", "SPVM::Complex_2f(float,float)");
      if (SUB_ID_SPVM__Util__complexf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util complexf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__complexf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[4] = *(float*)&stack[0];
      float_vars[5] = *(float*)&stack[1];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_caddf";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 101;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L13: // COMPLEX_ADD_FLOAT
  {
    float _Complex x_in1 = float_vars[2] + float_vars[3]  * _Complex_I ;
    float _Complex x_in2 = float_vars[4] + float_vars[5]  * _Complex_I ;
    float _Complex x_out = x_in1 + x_in2;
    float_vars[0] = creal(x_out);
    float_vars[1] = cimag(x_out);
  }
L14: // MULNUM_GET_FIELD_FLOAT
  float_vars[6] = float_vars[0];
L15: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[6];
L16: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.75;
L17: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L32; }
L20: // MULNUM_GET_FIELD_FLOAT
  float_vars[6] = float_vars[1];
L21: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[6];
L22: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.625;
L23: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L27: // BOOL_INT
  int_vars[0] = int_vars[2];
L28: // GOTO
  goto L31;
L29: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L30: // BOOL_INT
  int_vars[0] = int_vars[3];
L31: // GOTO
  goto L34;
L32: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L33: // BOOL_INT
  int_vars[0] = int_vars[4];
L34: // BOOL_INT
  int_vars[0] = int_vars[0];
L35: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L39; }
L36: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L37: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L43;
L38: // GOTO
  goto L39;
L39: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L43;
L41: // INIT_INT
  int_vars[6] = 0;
L42: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L43;
L43: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Complex__test_caddf_min(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[8];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_caddf_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 111;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L3: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_caddf_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 111;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L5: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L6: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L7: // CALL_SUB_MULNUM_FLOAT
  // SPVM::Util->complexf
  {
    if (SUB_ID_SPVM__Util__complexf < 0) {
      SUB_ID_SPVM__Util__complexf = env->get_sub_id(env, "SPVM::Util", "complexf", "SPVM::Complex_2f(float,float)");
      if (SUB_ID_SPVM__Util__complexf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util complexf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__complexf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
      float_vars[3] = *(float*)&stack[1];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_caddf_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 111;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L11: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L12: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[3];
L13: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L14: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L15: // CALL_SUB_MULNUM_FLOAT
  // SPVM::Util->complexf
  {
    if (SUB_ID_SPVM__Util__complexf < 0) {
      SUB_ID_SPVM__Util__complexf = env->get_sub_id(env, "SPVM::Util", "complexf", "SPVM::Complex_2f(float,float)");
      if (SUB_ID_SPVM__Util__complexf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util complexf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__complexf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[4] = *(float*)&stack[0];
      float_vars[5] = *(float*)&stack[1];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_caddf_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L17: // COMPLEX_ADD_FLOAT
  {
    float _Complex x_in1 = float_vars[2] + float_vars[3]  * _Complex_I ;
    float _Complex x_in2 = float_vars[4] + float_vars[5]  * _Complex_I ;
    float _Complex x_out = x_in1 + x_in2;
    float_vars[0] = creal(x_out);
    float_vars[1] = cimag(x_out);
  }
L18: // MULNUM_GET_FIELD_FLOAT
  float_vars[6] = float_vars[0];
L19: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[7] = *(float*)&stack[0];
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_caddf_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 115;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L21: // EQ_FLOAT
  int_vars[0] = (float_vars[6] == float_vars[7]);
L22: // BOOL_INT
  int_vars[0] = int_vars[0];
L23: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L36; }
L24: // MULNUM_GET_FIELD_FLOAT
  float_vars[6] = float_vars[1];
L25: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[7] = *(float*)&stack[0];
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_caddf_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 115;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L27: // EQ_FLOAT
  int_vars[0] = (float_vars[6] == float_vars[7]);
L28: // BOOL_INT
  int_vars[0] = int_vars[0];
L29: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L33; }
L30: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L31: // BOOL_INT
  int_vars[0] = int_vars[2];
L32: // GOTO
  goto L35;
L33: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L34: // BOOL_INT
  int_vars[0] = int_vars[3];
L35: // GOTO
  goto L38;
L36: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L37: // BOOL_INT
  int_vars[0] = int_vars[4];
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L43; }
L40: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L47;
L42: // GOTO
  goto L43;
L43: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L47;
L45: // INIT_INT
  int_vars[6] = 0;
L46: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L47;
L47: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Complex__test_cdiv(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[10];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.25;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.5;
L3: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L4: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L5: // CALL_SUB_MULNUM_DOUBLE
  // SPVM::Util->complexd
  {
    if (SUB_ID_SPVM__Util__complexd < 0) {
      SUB_ID_SPVM__Util__complexd = env->get_sub_id(env, "SPVM::Util", "complexd", "SPVM::Complex_2d(double,double)");
      if (SUB_ID_SPVM__Util__complexd < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util complexd");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__complexd;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
      double_vars[3] = *(double*)&stack[1];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_cdiv";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 76;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L45;
  }
L7: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.5;
L8: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.125;
L9: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L10: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L11: // CALL_SUB_MULNUM_DOUBLE
  // SPVM::Util->complexd
  {
    if (SUB_ID_SPVM__Util__complexd < 0) {
      SUB_ID_SPVM__Util__complexd = env->get_sub_id(env, "SPVM::Util", "complexd", "SPVM::Complex_2d(double,double)");
      if (SUB_ID_SPVM__Util__complexd < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util complexd");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__complexd;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[4] = *(double*)&stack[0];
      double_vars[5] = *(double*)&stack[1];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_cdiv";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 77;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L45;
  }
L13: // COMPLEX_DIVIDE_DOUBLE
  {
    double _Complex x_in1 = double_vars[2] + double_vars[3]  * _Complex_I ;
    double _Complex x_in2 = double_vars[4] + double_vars[5]  * _Complex_I ;
    double _Complex x_out = x_in1 / x_in2;
    double_vars[0] = creal(x_out);
    double_vars[1] = cimag(x_out);
  }
L14: // MULNUM_GET_FIELD_DOUBLE
  double_vars[6] = double_vars[0];
L15: // MOVE_CONSTANT_DOUBLE
  double_vars[7] = 0.70587999999999995;
L16: // SUBTRACT_DOUBLE
  double_vars[8] = double_vars[6] - double_vars[7];
L17: // MOVE_CONSTANT_DOUBLE
  double_vars[9] = 1.0000000000000001e-05;
L18: // LT_DOUBLE
  int_vars[0] = (double_vars[8] < double_vars[9]);
L19: // BOOL_INT
  int_vars[0] = int_vars[0];
L20: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L34; }
L21: // MULNUM_GET_FIELD_DOUBLE
  double_vars[6] = double_vars[1];
L22: // MOVE_CONSTANT_DOUBLE
  double_vars[7] = 0.82352000000000003;
L23: // SUBTRACT_DOUBLE
  double_vars[8] = double_vars[6] - double_vars[7];
L24: // MOVE_CONSTANT_DOUBLE
  double_vars[9] = 1.0000000000000001e-05;
L25: // LT_DOUBLE
  int_vars[0] = (double_vars[8] < double_vars[9]);
L26: // BOOL_INT
  int_vars[0] = int_vars[0];
L27: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L31; }
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L29: // BOOL_INT
  int_vars[0] = int_vars[2];
L30: // GOTO
  goto L33;
L31: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L32: // BOOL_INT
  int_vars[0] = int_vars[3];
L33: // GOTO
  goto L36;
L34: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L35: // BOOL_INT
  int_vars[0] = int_vars[4];
L36: // BOOL_INT
  int_vars[0] = int_vars[0];
L37: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L41; }
L38: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L39: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L45;
L40: // GOTO
  goto L41;
L41: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L42: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L45;
L43: // INIT_INT
  int_vars[6] = 0;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L45;
L45: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Complex__test_cdiv_min(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[8];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_cdiv_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 88;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L3: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L4: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[1];
L5: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L6: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L7: // CALL_SUB_MULNUM_DOUBLE
  // SPVM::Util->complexd
  {
    if (SUB_ID_SPVM__Util__complexd < 0) {
      SUB_ID_SPVM__Util__complexd = env->get_sub_id(env, "SPVM::Util", "complexd", "SPVM::Complex_2d(double,double)");
      if (SUB_ID_SPVM__Util__complexd < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util complexd");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__complexd;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
      double_vars[3] = *(double*)&stack[1];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_cdiv_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 88;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L10: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L11: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L12: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[3];
L13: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L14: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L15: // CALL_SUB_MULNUM_DOUBLE
  // SPVM::Util->complexd
  {
    if (SUB_ID_SPVM__Util__complexd < 0) {
      SUB_ID_SPVM__Util__complexd = env->get_sub_id(env, "SPVM::Util", "complexd", "SPVM::Complex_2d(double,double)");
      if (SUB_ID_SPVM__Util__complexd < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util complexd");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__complexd;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[4] = *(double*)&stack[0];
      double_vars[5] = *(double*)&stack[1];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_cdiv_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 89;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L17: // COMPLEX_DIVIDE_DOUBLE
  {
    double _Complex x_in1 = double_vars[2] + double_vars[3]  * _Complex_I ;
    double _Complex x_in2 = double_vars[4] + double_vars[5]  * _Complex_I ;
    double _Complex x_out = x_in1 / x_in2;
    double_vars[0] = creal(x_out);
    double_vars[1] = cimag(x_out);
  }
L18: // MULNUM_GET_FIELD_DOUBLE
  double_vars[6] = double_vars[0];
L19: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[7] = *(double*)&stack[0];
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_cdiv_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 92;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L21: // EQ_DOUBLE
  int_vars[0] = (double_vars[6] == double_vars[7]);
L22: // BOOL_INT
  int_vars[0] = int_vars[0];
L23: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L36; }
L24: // MULNUM_GET_FIELD_DOUBLE
  double_vars[6] = double_vars[1];
L25: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L26: // CONVERT_INT_TO_DOUBLE
  double_vars[7] = (double)int_vars[2];
L27: // EQ_DOUBLE
  int_vars[0] = (double_vars[6] == double_vars[7]);
L28: // BOOL_INT
  int_vars[0] = int_vars[0];
L29: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L33; }
L30: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L31: // BOOL_INT
  int_vars[0] = int_vars[2];
L32: // GOTO
  goto L35;
L33: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L34: // BOOL_INT
  int_vars[0] = int_vars[3];
L35: // GOTO
  goto L38;
L36: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L37: // BOOL_INT
  int_vars[0] = int_vars[4];
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L43; }
L40: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L47;
L42: // GOTO
  goto L43;
L43: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L47;
L45: // INIT_INT
  int_vars[6] = 0;
L46: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L47;
L47: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Complex__test_cdivf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[4];
  float float_vars[7];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.25;
L2: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.5;
L3: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L4: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L5: // CALL_SUB_MULNUM_FLOAT
  // SPVM::Util->complexf
  {
    if (SUB_ID_SPVM__Util__complexf < 0) {
      SUB_ID_SPVM__Util__complexf = env->get_sub_id(env, "SPVM::Util", "complexf", "SPVM::Complex_2f(float,float)");
      if (SUB_ID_SPVM__Util__complexf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util complexf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__complexf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
      float_vars[3] = *(float*)&stack[1];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_cdivf";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 169;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L7: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L8: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.125;
L9: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L10: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L11: // CALL_SUB_MULNUM_FLOAT
  // SPVM::Util->complexf
  {
    if (SUB_ID_SPVM__Util__complexf < 0) {
      SUB_ID_SPVM__Util__complexf = env->get_sub_id(env, "SPVM::Util", "complexf", "SPVM::Complex_2f(float,float)");
      if (SUB_ID_SPVM__Util__complexf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util complexf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__complexf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[4] = *(float*)&stack[0];
      float_vars[5] = *(float*)&stack[1];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_cdivf";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 170;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L13: // COMPLEX_DIVIDE_FLOAT
  {
    float _Complex x_in1 = float_vars[2] + float_vars[3]  * _Complex_I ;
    float _Complex x_in2 = float_vars[4] + float_vars[5]  * _Complex_I ;
    float _Complex x_out = x_in1 / x_in2;
    float_vars[0] = creal(x_out);
    float_vars[1] = cimag(x_out);
  }
L14: // MULNUM_GET_FIELD_FLOAT
  float_vars[6] = float_vars[0];
L15: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[6];
L16: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.70587999999999995;
L17: // SUBTRACT_DOUBLE
  double_vars[2] = double_vars[0] - double_vars[1];
L18: // MOVE_CONSTANT_DOUBLE
  double_vars[3] = 1.0000000000000001e-05;
L19: // LT_DOUBLE
  int_vars[0] = (double_vars[2] < double_vars[3]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L36; }
L22: // MULNUM_GET_FIELD_FLOAT
  float_vars[6] = float_vars[1];
L23: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[6];
L24: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.82352000000000003;
L25: // SUBTRACT_DOUBLE
  double_vars[2] = double_vars[0] - double_vars[1];
L26: // MOVE_CONSTANT_DOUBLE
  double_vars[3] = 1.0000000000000001e-05;
L27: // LT_DOUBLE
  int_vars[0] = (double_vars[2] < double_vars[3]);
L28: // BOOL_INT
  int_vars[0] = int_vars[0];
L29: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L33; }
L30: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L31: // BOOL_INT
  int_vars[0] = int_vars[2];
L32: // GOTO
  goto L35;
L33: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L34: // BOOL_INT
  int_vars[0] = int_vars[3];
L35: // GOTO
  goto L38;
L36: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L37: // BOOL_INT
  int_vars[0] = int_vars[4];
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L43; }
L40: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L47;
L42: // GOTO
  goto L43;
L43: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L47;
L45: // INIT_INT
  int_vars[6] = 0;
L46: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L47;
L47: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Complex__test_cdivf_min(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[8];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_cdivf_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 181;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L3: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L4: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[1];
L5: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L6: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L7: // CALL_SUB_MULNUM_FLOAT
  // SPVM::Util->complexf
  {
    if (SUB_ID_SPVM__Util__complexf < 0) {
      SUB_ID_SPVM__Util__complexf = env->get_sub_id(env, "SPVM::Util", "complexf", "SPVM::Complex_2f(float,float)");
      if (SUB_ID_SPVM__Util__complexf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util complexf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__complexf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
      float_vars[3] = *(float*)&stack[1];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_cdivf_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 181;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L10: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L11: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L12: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[3];
L13: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L14: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L15: // CALL_SUB_MULNUM_FLOAT
  // SPVM::Util->complexf
  {
    if (SUB_ID_SPVM__Util__complexf < 0) {
      SUB_ID_SPVM__Util__complexf = env->get_sub_id(env, "SPVM::Util", "complexf", "SPVM::Complex_2f(float,float)");
      if (SUB_ID_SPVM__Util__complexf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util complexf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__complexf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[4] = *(float*)&stack[0];
      float_vars[5] = *(float*)&stack[1];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_cdivf_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 182;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L17: // COMPLEX_DIVIDE_FLOAT
  {
    float _Complex x_in1 = float_vars[2] + float_vars[3]  * _Complex_I ;
    float _Complex x_in2 = float_vars[4] + float_vars[5]  * _Complex_I ;
    float _Complex x_out = x_in1 / x_in2;
    float_vars[0] = creal(x_out);
    float_vars[1] = cimag(x_out);
  }
L18: // MULNUM_GET_FIELD_FLOAT
  float_vars[6] = float_vars[0];
L19: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[7] = *(float*)&stack[0];
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_cdivf_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 185;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L21: // EQ_FLOAT
  int_vars[0] = (float_vars[6] == float_vars[7]);
L22: // BOOL_INT
  int_vars[0] = int_vars[0];
L23: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L36; }
L24: // MULNUM_GET_FIELD_FLOAT
  float_vars[6] = float_vars[1];
L25: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L26: // CONVERT_INT_TO_FLOAT
  float_vars[7] = (float)int_vars[2];
L27: // EQ_FLOAT
  int_vars[0] = (float_vars[6] == float_vars[7]);
L28: // BOOL_INT
  int_vars[0] = int_vars[0];
L29: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L33; }
L30: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L31: // BOOL_INT
  int_vars[0] = int_vars[2];
L32: // GOTO
  goto L35;
L33: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L34: // BOOL_INT
  int_vars[0] = int_vars[3];
L35: // GOTO
  goto L38;
L36: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L37: // BOOL_INT
  int_vars[0] = int_vars[4];
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L43; }
L40: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L47;
L42: // GOTO
  goto L43;
L43: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L47;
L45: // INIT_INT
  int_vars[6] = 0;
L46: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L47;
L47: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Complex__test_cmul(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[8];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.25;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.5;
L3: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L4: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L5: // CALL_SUB_MULNUM_DOUBLE
  // SPVM::Util->complexd
  {
    if (SUB_ID_SPVM__Util__complexd < 0) {
      SUB_ID_SPVM__Util__complexd = env->get_sub_id(env, "SPVM::Util", "complexd", "SPVM::Complex_2d(double,double)");
      if (SUB_ID_SPVM__Util__complexd < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util complexd");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__complexd;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
      double_vars[3] = *(double*)&stack[1];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_cmul";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 53;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L41;
  }
L7: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.5;
L8: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.125;
L9: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L10: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L11: // CALL_SUB_MULNUM_DOUBLE
  // SPVM::Util->complexd
  {
    if (SUB_ID_SPVM__Util__complexd < 0) {
      SUB_ID_SPVM__Util__complexd = env->get_sub_id(env, "SPVM::Util", "complexd", "SPVM::Complex_2d(double,double)");
      if (SUB_ID_SPVM__Util__complexd < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util complexd");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__complexd;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[4] = *(double*)&stack[0];
      double_vars[5] = *(double*)&stack[1];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_cmul";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 54;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L41;
  }
L13: // COMPLEX_MULTIPLY_DOUBLE
  {
    double _Complex x_in1 = double_vars[2] + double_vars[3]  * _Complex_I ;
    double _Complex x_in2 = double_vars[4] + double_vars[5]  * _Complex_I ;
    double _Complex x_out = x_in1 * x_in2;
    double_vars[0] = creal(x_out);
    double_vars[1] = cimag(x_out);
  }
L14: // MULNUM_GET_FIELD_DOUBLE
  double_vars[6] = double_vars[0];
L15: // MOVE_CONSTANT_DOUBLE
  double_vars[7] = 0.0625;
L16: // EQ_DOUBLE
  int_vars[0] = (double_vars[6] == double_vars[7]);
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L30; }
L19: // MULNUM_GET_FIELD_DOUBLE
  double_vars[6] = double_vars[1];
L20: // MOVE_CONSTANT_DOUBLE
  double_vars[7] = 0.28125;
L21: // EQ_DOUBLE
  int_vars[0] = (double_vars[6] == double_vars[7]);
L22: // BOOL_INT
  int_vars[0] = int_vars[0];
L23: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L27; }
L24: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L25: // BOOL_INT
  int_vars[0] = int_vars[2];
L26: // GOTO
  goto L29;
L27: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L28: // BOOL_INT
  int_vars[0] = int_vars[3];
L29: // GOTO
  goto L32;
L30: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L31: // BOOL_INT
  int_vars[0] = int_vars[4];
L32: // BOOL_INT
  int_vars[0] = int_vars[0];
L33: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L37; }
L34: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L35: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L41;
L36: // GOTO
  goto L37;
L37: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L38: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L41;
L39: // INIT_INT
  int_vars[6] = 0;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L41;
L41: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Complex__test_cmul_min(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[8];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_cmul_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 64;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L3: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L4: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[1];
L5: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L6: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L7: // CALL_SUB_MULNUM_DOUBLE
  // SPVM::Util->complexd
  {
    if (SUB_ID_SPVM__Util__complexd < 0) {
      SUB_ID_SPVM__Util__complexd = env->get_sub_id(env, "SPVM::Util", "complexd", "SPVM::Complex_2d(double,double)");
      if (SUB_ID_SPVM__Util__complexd < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util complexd");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__complexd;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
      double_vars[3] = *(double*)&stack[1];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_cmul_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 64;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L10: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L11: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L12: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[3];
L13: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L14: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L15: // CALL_SUB_MULNUM_DOUBLE
  // SPVM::Util->complexd
  {
    if (SUB_ID_SPVM__Util__complexd < 0) {
      SUB_ID_SPVM__Util__complexd = env->get_sub_id(env, "SPVM::Util", "complexd", "SPVM::Complex_2d(double,double)");
      if (SUB_ID_SPVM__Util__complexd < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util complexd");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__complexd;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[4] = *(double*)&stack[0];
      double_vars[5] = *(double*)&stack[1];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_cmul_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 65;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L17: // COMPLEX_MULTIPLY_DOUBLE
  {
    double _Complex x_in1 = double_vars[2] + double_vars[3]  * _Complex_I ;
    double _Complex x_in2 = double_vars[4] + double_vars[5]  * _Complex_I ;
    double _Complex x_out = x_in1 * x_in2;
    double_vars[0] = creal(x_out);
    double_vars[1] = cimag(x_out);
  }
L18: // MULNUM_GET_FIELD_DOUBLE
  double_vars[6] = double_vars[0];
L19: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[7] = *(double*)&stack[0];
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_cmul_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 68;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L21: // EQ_DOUBLE
  int_vars[0] = (double_vars[6] == double_vars[7]);
L22: // BOOL_INT
  int_vars[0] = int_vars[0];
L23: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L36; }
L24: // MULNUM_GET_FIELD_DOUBLE
  double_vars[6] = double_vars[1];
L25: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[7] = *(double*)&stack[0];
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_cmul_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 68;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L27: // EQ_DOUBLE
  int_vars[0] = (double_vars[6] == double_vars[7]);
L28: // BOOL_INT
  int_vars[0] = int_vars[0];
L29: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L33; }
L30: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L31: // BOOL_INT
  int_vars[0] = int_vars[2];
L32: // GOTO
  goto L35;
L33: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L34: // BOOL_INT
  int_vars[0] = int_vars[3];
L35: // GOTO
  goto L38;
L36: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L37: // BOOL_INT
  int_vars[0] = int_vars[4];
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L43; }
L40: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L47;
L42: // GOTO
  goto L43;
L43: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L47;
L45: // INIT_INT
  int_vars[6] = 0;
L46: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L47;
L47: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Complex__test_cmulf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  float float_vars[7];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.25;
L2: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.5;
L3: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L4: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L5: // CALL_SUB_MULNUM_FLOAT
  // SPVM::Util->complexf
  {
    if (SUB_ID_SPVM__Util__complexf < 0) {
      SUB_ID_SPVM__Util__complexf = env->get_sub_id(env, "SPVM::Util", "complexf", "SPVM::Complex_2f(float,float)");
      if (SUB_ID_SPVM__Util__complexf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util complexf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__complexf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
      float_vars[3] = *(float*)&stack[1];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_cmulf";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 146;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L7: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L8: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.125;
L9: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L10: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L11: // CALL_SUB_MULNUM_FLOAT
  // SPVM::Util->complexf
  {
    if (SUB_ID_SPVM__Util__complexf < 0) {
      SUB_ID_SPVM__Util__complexf = env->get_sub_id(env, "SPVM::Util", "complexf", "SPVM::Complex_2f(float,float)");
      if (SUB_ID_SPVM__Util__complexf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util complexf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__complexf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[4] = *(float*)&stack[0];
      float_vars[5] = *(float*)&stack[1];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_cmulf";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 147;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L13: // COMPLEX_MULTIPLY_FLOAT
  {
    float _Complex x_in1 = float_vars[2] + float_vars[3]  * _Complex_I ;
    float _Complex x_in2 = float_vars[4] + float_vars[5]  * _Complex_I ;
    float _Complex x_out = x_in1 * x_in2;
    float_vars[0] = creal(x_out);
    float_vars[1] = cimag(x_out);
  }
L14: // MULNUM_GET_FIELD_FLOAT
  float_vars[6] = float_vars[0];
L15: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[6];
L16: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.0625;
L17: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L32; }
L20: // MULNUM_GET_FIELD_FLOAT
  float_vars[6] = float_vars[1];
L21: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[6];
L22: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.28125;
L23: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L27: // BOOL_INT
  int_vars[0] = int_vars[2];
L28: // GOTO
  goto L31;
L29: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L30: // BOOL_INT
  int_vars[0] = int_vars[3];
L31: // GOTO
  goto L34;
L32: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L33: // BOOL_INT
  int_vars[0] = int_vars[4];
L34: // BOOL_INT
  int_vars[0] = int_vars[0];
L35: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L39; }
L36: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L37: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L43;
L38: // GOTO
  goto L39;
L39: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L43;
L41: // INIT_INT
  int_vars[6] = 0;
L42: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L43;
L43: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Complex__test_cmulf_min(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[8];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_cmulf_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 157;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L3: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L4: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[1];
L5: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L6: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L7: // CALL_SUB_MULNUM_FLOAT
  // SPVM::Util->complexf
  {
    if (SUB_ID_SPVM__Util__complexf < 0) {
      SUB_ID_SPVM__Util__complexf = env->get_sub_id(env, "SPVM::Util", "complexf", "SPVM::Complex_2f(float,float)");
      if (SUB_ID_SPVM__Util__complexf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util complexf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__complexf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
      float_vars[3] = *(float*)&stack[1];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_cmulf_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 157;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L10: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L11: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L12: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[3];
L13: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L14: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L15: // CALL_SUB_MULNUM_FLOAT
  // SPVM::Util->complexf
  {
    if (SUB_ID_SPVM__Util__complexf < 0) {
      SUB_ID_SPVM__Util__complexf = env->get_sub_id(env, "SPVM::Util", "complexf", "SPVM::Complex_2f(float,float)");
      if (SUB_ID_SPVM__Util__complexf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util complexf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__complexf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[4] = *(float*)&stack[0];
      float_vars[5] = *(float*)&stack[1];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_cmulf_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 158;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L17: // COMPLEX_MULTIPLY_FLOAT
  {
    float _Complex x_in1 = float_vars[2] + float_vars[3]  * _Complex_I ;
    float _Complex x_in2 = float_vars[4] + float_vars[5]  * _Complex_I ;
    float _Complex x_out = x_in1 * x_in2;
    float_vars[0] = creal(x_out);
    float_vars[1] = cimag(x_out);
  }
L18: // MULNUM_GET_FIELD_FLOAT
  float_vars[6] = float_vars[0];
L19: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[7] = *(float*)&stack[0];
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_cmulf_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 161;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L21: // EQ_FLOAT
  int_vars[0] = (float_vars[6] == float_vars[7]);
L22: // BOOL_INT
  int_vars[0] = int_vars[0];
L23: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L36; }
L24: // MULNUM_GET_FIELD_FLOAT
  float_vars[6] = float_vars[1];
L25: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[7] = *(float*)&stack[0];
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_cmulf_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 161;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L27: // EQ_FLOAT
  int_vars[0] = (float_vars[6] == float_vars[7]);
L28: // BOOL_INT
  int_vars[0] = int_vars[0];
L29: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L33; }
L30: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L31: // BOOL_INT
  int_vars[0] = int_vars[2];
L32: // GOTO
  goto L35;
L33: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L34: // BOOL_INT
  int_vars[0] = int_vars[3];
L35: // GOTO
  goto L38;
L36: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L37: // BOOL_INT
  int_vars[0] = int_vars[4];
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L43; }
L40: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L47;
L42: // GOTO
  goto L43;
L43: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L47;
L45: // INIT_INT
  int_vars[6] = 0;
L46: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L47;
L47: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Complex__test_csub(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[8];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.25;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.5;
L3: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L4: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L5: // CALL_SUB_MULNUM_DOUBLE
  // SPVM::Util->complexd
  {
    if (SUB_ID_SPVM__Util__complexd < 0) {
      SUB_ID_SPVM__Util__complexd = env->get_sub_id(env, "SPVM::Util", "complexd", "SPVM::Complex_2d(double,double)");
      if (SUB_ID_SPVM__Util__complexd < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util complexd");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__complexd;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
      double_vars[3] = *(double*)&stack[1];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_csub";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 30;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L41;
  }
L7: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.5;
L8: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.125;
L9: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L10: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L11: // CALL_SUB_MULNUM_DOUBLE
  // SPVM::Util->complexd
  {
    if (SUB_ID_SPVM__Util__complexd < 0) {
      SUB_ID_SPVM__Util__complexd = env->get_sub_id(env, "SPVM::Util", "complexd", "SPVM::Complex_2d(double,double)");
      if (SUB_ID_SPVM__Util__complexd < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util complexd");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__complexd;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[4] = *(double*)&stack[0];
      double_vars[5] = *(double*)&stack[1];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_csub";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 31;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L41;
  }
L13: // COMPLEX_SUBTRACT_DOUBLE
  {
    double _Complex x_in1 = double_vars[2] + double_vars[3]  * _Complex_I ;
    double _Complex x_in2 = double_vars[4] + double_vars[5]  * _Complex_I ;
    double _Complex x_out = x_in1 - x_in2;
    double_vars[0] = creal(x_out);
    double_vars[1] = cimag(x_out);
  }
L14: // MULNUM_GET_FIELD_DOUBLE
  double_vars[6] = double_vars[0];
L15: // MOVE_CONSTANT_DOUBLE
  double_vars[7] = -0.25;
L16: // EQ_DOUBLE
  int_vars[0] = (double_vars[6] == double_vars[7]);
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L30; }
L19: // MULNUM_GET_FIELD_DOUBLE
  double_vars[6] = double_vars[1];
L20: // MOVE_CONSTANT_DOUBLE
  double_vars[7] = 0.375;
L21: // EQ_DOUBLE
  int_vars[0] = (double_vars[6] == double_vars[7]);
L22: // BOOL_INT
  int_vars[0] = int_vars[0];
L23: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L27; }
L24: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L25: // BOOL_INT
  int_vars[0] = int_vars[2];
L26: // GOTO
  goto L29;
L27: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L28: // BOOL_INT
  int_vars[0] = int_vars[3];
L29: // GOTO
  goto L32;
L30: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L31: // BOOL_INT
  int_vars[0] = int_vars[4];
L32: // BOOL_INT
  int_vars[0] = int_vars[0];
L33: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L37; }
L34: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L35: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L41;
L36: // GOTO
  goto L37;
L37: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L38: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L41;
L39: // INIT_INT
  int_vars[6] = 0;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L41;
L41: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Complex__test_csub_min(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[8];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_csub_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 41;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L3: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_csub_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 41;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L5: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L6: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L7: // CALL_SUB_MULNUM_DOUBLE
  // SPVM::Util->complexd
  {
    if (SUB_ID_SPVM__Util__complexd < 0) {
      SUB_ID_SPVM__Util__complexd = env->get_sub_id(env, "SPVM::Util", "complexd", "SPVM::Complex_2d(double,double)");
      if (SUB_ID_SPVM__Util__complexd < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util complexd");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__complexd;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
      double_vars[3] = *(double*)&stack[1];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_csub_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 41;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L11: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L12: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[3];
L13: // PUSH_ARG_DOUBLE
  *(double*)&stack[0] = double_vars[0];
L14: // PUSH_ARG_DOUBLE
  *(double*)&stack[1] = double_vars[1];
L15: // CALL_SUB_MULNUM_DOUBLE
  // SPVM::Util->complexd
  {
    if (SUB_ID_SPVM__Util__complexd < 0) {
      SUB_ID_SPVM__Util__complexd = env->get_sub_id(env, "SPVM::Util", "complexd", "SPVM::Complex_2d(double,double)");
      if (SUB_ID_SPVM__Util__complexd < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util complexd");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__complexd;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[4] = *(double*)&stack[0];
      double_vars[5] = *(double*)&stack[1];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_csub_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 42;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L17: // COMPLEX_SUBTRACT_DOUBLE
  {
    double _Complex x_in1 = double_vars[2] + double_vars[3]  * _Complex_I ;
    double _Complex x_in2 = double_vars[4] + double_vars[5]  * _Complex_I ;
    double _Complex x_out = x_in1 - x_in2;
    double_vars[0] = creal(x_out);
    double_vars[1] = cimag(x_out);
  }
L18: // MULNUM_GET_FIELD_DOUBLE
  double_vars[6] = double_vars[0];
L19: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[7] = *(double*)&stack[0];
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_csub_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 45;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L21: // EQ_DOUBLE
  int_vars[0] = (double_vars[6] == double_vars[7]);
L22: // BOOL_INT
  int_vars[0] = int_vars[0];
L23: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L36; }
L24: // MULNUM_GET_FIELD_DOUBLE
  double_vars[6] = double_vars[1];
L25: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[7] = *(double*)&stack[0];
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_csub_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 45;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L27: // EQ_DOUBLE
  int_vars[0] = (double_vars[6] == double_vars[7]);
L28: // BOOL_INT
  int_vars[0] = int_vars[0];
L29: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L33; }
L30: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L31: // BOOL_INT
  int_vars[0] = int_vars[2];
L32: // GOTO
  goto L35;
L33: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L34: // BOOL_INT
  int_vars[0] = int_vars[3];
L35: // GOTO
  goto L38;
L36: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L37: // BOOL_INT
  int_vars[0] = int_vars[4];
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L43; }
L40: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L47;
L42: // GOTO
  goto L43;
L43: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L47;
L45: // INIT_INT
  int_vars[6] = 0;
L46: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L47;
L47: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Complex__test_csubf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  float float_vars[7];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.25;
L2: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.5;
L3: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L4: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L5: // CALL_SUB_MULNUM_FLOAT
  // SPVM::Util->complexf
  {
    if (SUB_ID_SPVM__Util__complexf < 0) {
      SUB_ID_SPVM__Util__complexf = env->get_sub_id(env, "SPVM::Util", "complexf", "SPVM::Complex_2f(float,float)");
      if (SUB_ID_SPVM__Util__complexf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util complexf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__complexf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
      float_vars[3] = *(float*)&stack[1];
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_csubf";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 123;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L7: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L8: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 0.125;
L9: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L10: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L11: // CALL_SUB_MULNUM_FLOAT
  // SPVM::Util->complexf
  {
    if (SUB_ID_SPVM__Util__complexf < 0) {
      SUB_ID_SPVM__Util__complexf = env->get_sub_id(env, "SPVM::Util", "complexf", "SPVM::Complex_2f(float,float)");
      if (SUB_ID_SPVM__Util__complexf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util complexf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__complexf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[4] = *(float*)&stack[0];
      float_vars[5] = *(float*)&stack[1];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_csubf";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 124;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L43;
  }
L13: // COMPLEX_SUBTRACT_FLOAT
  {
    float _Complex x_in1 = float_vars[2] + float_vars[3]  * _Complex_I ;
    float _Complex x_in2 = float_vars[4] + float_vars[5]  * _Complex_I ;
    float _Complex x_out = x_in1 - x_in2;
    float_vars[0] = creal(x_out);
    float_vars[1] = cimag(x_out);
  }
L14: // MULNUM_GET_FIELD_FLOAT
  float_vars[6] = float_vars[0];
L15: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[6];
L16: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = -0.25;
L17: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L18: // BOOL_INT
  int_vars[0] = int_vars[0];
L19: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L32; }
L20: // MULNUM_GET_FIELD_FLOAT
  float_vars[6] = float_vars[1];
L21: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[6];
L22: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.375;
L23: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L27: // BOOL_INT
  int_vars[0] = int_vars[2];
L28: // GOTO
  goto L31;
L29: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L30: // BOOL_INT
  int_vars[0] = int_vars[3];
L31: // GOTO
  goto L34;
L32: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L33: // BOOL_INT
  int_vars[0] = int_vars[4];
L34: // BOOL_INT
  int_vars[0] = int_vars[0];
L35: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L39; }
L36: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L37: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L43;
L38: // GOTO
  goto L39;
L39: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L43;
L41: // INIT_INT
  int_vars[6] = 0;
L42: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L43;
L43: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Complex__test_csubf_min(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[8];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_csubf_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 134;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L3: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_csubf_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 134;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L5: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L6: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L7: // CALL_SUB_MULNUM_FLOAT
  // SPVM::Util->complexf
  {
    if (SUB_ID_SPVM__Util__complexf < 0) {
      SUB_ID_SPVM__Util__complexf = env->get_sub_id(env, "SPVM::Util", "complexf", "SPVM::Complex_2f(float,float)");
      if (SUB_ID_SPVM__Util__complexf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util complexf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__complexf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
      float_vars[3] = *(float*)&stack[1];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_csubf_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 134;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L11: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L12: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[3];
L13: // PUSH_ARG_FLOAT
  *(float*)&stack[0] = float_vars[0];
L14: // PUSH_ARG_FLOAT
  *(float*)&stack[1] = float_vars[1];
L15: // CALL_SUB_MULNUM_FLOAT
  // SPVM::Util->complexf
  {
    if (SUB_ID_SPVM__Util__complexf < 0) {
      SUB_ID_SPVM__Util__complexf = env->get_sub_id(env, "SPVM::Util", "complexf", "SPVM::Complex_2f(float,float)");
      if (SUB_ID_SPVM__Util__complexf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util complexf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__complexf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[4] = *(float*)&stack[0];
      float_vars[5] = *(float*)&stack[1];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_csubf_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 135;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L17: // COMPLEX_SUBTRACT_FLOAT
  {
    float _Complex x_in1 = float_vars[2] + float_vars[3]  * _Complex_I ;
    float _Complex x_in2 = float_vars[4] + float_vars[5]  * _Complex_I ;
    float _Complex x_out = x_in1 - x_in2;
    float_vars[0] = creal(x_out);
    float_vars[1] = cimag(x_out);
  }
L18: // MULNUM_GET_FIELD_FLOAT
  float_vars[6] = float_vars[0];
L19: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[7] = *(float*)&stack[0];
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_csubf_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 138;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L21: // EQ_FLOAT
  int_vars[0] = (float_vars[6] == float_vars[7]);
L22: // BOOL_INT
  int_vars[0] = int_vars[0];
L23: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L36; }
L24: // MULNUM_GET_FIELD_FLOAT
  float_vars[6] = float_vars[1];
L25: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[7] = *(float*)&stack[0];
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Complex";
    const char* sub_name = "test_csubf_min";
    const char* file = "TestCase/Complex.spvm";
    int32_t line = 138;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L27: // EQ_FLOAT
  int_vars[0] = (float_vars[6] == float_vars[7]);
L28: // BOOL_INT
  int_vars[0] = int_vars[0];
L29: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L33; }
L30: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L31: // BOOL_INT
  int_vars[0] = int_vars[2];
L32: // GOTO
  goto L35;
L33: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L34: // BOOL_INT
  int_vars[0] = int_vars[3];
L35: // GOTO
  goto L38;
L36: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L37: // BOOL_INT
  int_vars[0] = int_vars[4];
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L43; }
L40: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L47;
L42: // GOTO
  goto L43;
L43: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L47;
L45: // INIT_INT
  int_vars[6] = 0;
L46: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L47;
L47: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


