#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
static int32_t FIELD_ID_SPVM__Int__val = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__Int__val = -1;
// Sub id declarations
static int32_t SUB_ID_SPVM__Int__val = - 1;
// Basic type id declarations
static int32_t BASIC_TYPE_ID_SPVM__Int = -1;
// Function Declarations
// [SIG]int(self,object,object)
int32_t SPPRECOMPILE__anon3__(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__anon3__(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[5] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[6];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }
  object_vars[1] = *(void**)&stack[1];
  if (object_vars[1] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[1]); }
  object_vars[2] = *(void**)&stack[2];
  if (object_vars[2] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[2]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L5: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Int < 0) {
      BASIC_TYPE_ID_SPVM__Int = env->get_basic_type_id(env, "SPVM::Int");
      if (BASIC_TYPE_ID_SPVM__Int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Int;
    int32_t check_type_dimension = 0;
    void* object = object_vars[1];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object_vars[1]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "anon3";
    const char* sub_name = "";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 448;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L8: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Int < 0) {
      BASIC_TYPE_ID_SPVM__Int = env->get_basic_type_id(env, "SPVM::Int");
      if (BASIC_TYPE_ID_SPVM__Int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Int;
    int32_t check_type_dimension = 0;
    void* object = object_vars[2];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], object_vars[2]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "anon3";
    const char* sub_name = "";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 449;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L10: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Int__val < 0, 0)) {
      FIELD_ID_SPVM__Int__val = env->get_field_id(env, "SPVM::Int", "val", "int");
      if (FIELD_ID_SPVM__Int__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Int val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Int__val = env->get_field_offset(env, FIELD_ID_SPVM__Int__val);
    };
    void* object = object_vars[3];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Int__val);
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "anon3";
    const char* sub_name = "";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 450;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L12: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Int__val < 0, 0)) {
      FIELD_ID_SPVM__Int__val = env->get_field_id(env, "SPVM::Int", "val", "int");
      if (FIELD_ID_SPVM__Int__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Int val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Int__val = env->get_field_offset(env, FIELD_ID_SPVM__Int__val);
    };
    void* object = object_vars[4];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[3] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Int__val);
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "anon3";
    const char* sub_name = "";
    const char* file = "TestCase/Lib/SPVM/Hash.spvm";
    int32_t line = 450;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L14: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_NE_ZERO
  if (int_vars[0]) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L19: // GOTO
  goto L20;
L20: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L24;
L22: // INIT_INT
  int_vars[6] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L24;
L24: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L25: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


