#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
// Sub id declarations
static int32_t SUB_ID_SPVM__Util__INT8_MAX = - 1;
static int32_t SUB_ID_SPVM__Util__DBL_MAX = - 1;
static int32_t SUB_ID_SPVM__Util__FLT_MAX = - 1;
static int32_t SUB_ID_SPVM__Util__INT32_MAX = - 1;
static int32_t SUB_ID_SPVM__Util__INT64_MAX = - 1;
static int32_t SUB_ID_SPVM__Util__INT16_MAX = - 1;
// Basic type id declarations
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__UnaryMinus__unary_minus_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__UnaryMinus__unary_minus_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__UnaryMinus__unary_minus_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__UnaryMinus__unary_minus_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__UnaryMinus__unary_minus_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__UnaryMinus__unary_minus_short(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__UnaryMinus__unary_minus_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::UnaryMinus";
    const char* sub_name = "unary_minus_byte";
    const char* file = "TestCase/UnaryMinus.spvm";
    int32_t line = 5;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L3: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L4: // CONVERT_BYTE_TO_INT
  int_vars[1] = (int32_t)byte_vars[1];
L5: // NEGATE_INT
  int_vars[2] = -int_vars[1];
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L7: // BOOL_INT
  int_vars[0] = int_vars[3];
L8: // MOVE_INT
  int_vars[0] = int_vars[0];
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_NE_ZERO
  if (int_vars[0]) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L28;
L13: // GOTO
  goto L14;
L14: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::UnaryMinus";
    const char* sub_name = "unary_minus_byte";
    const char* file = "TestCase/UnaryMinus.spvm";
    int32_t line = 11;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L16: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L17: // NEGATE_INT
  int_vars[6] = -int_vars[5];
L18: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L19: // BOOL_INT
  int_vars[0] = int_vars[0];
L20: // IF_NE_ZERO
  if (int_vars[0]) { goto L24; }
L21: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L28;
L23: // GOTO
  goto L24;
L24: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L28;
L26: // INIT_INT
  int_vars[7] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L28;
L28: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__UnaryMinus__unary_minus_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::UnaryMinus";
    const char* sub_name = "unary_minus_double";
    const char* file = "TestCase/UnaryMinus.spvm";
    int32_t line = 74;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L3: // NEGATE_DOUBLE
  double_vars[1] = -double_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L5: // BOOL_INT
  int_vars[0] = int_vars[2];
L6: // MOVE_INT
  int_vars[0] = int_vars[0];
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_NE_ZERO
  if (int_vars[0]) { goto L12; }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L11: // GOTO
  goto L12;
L12: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::UnaryMinus";
    const char* sub_name = "unary_minus_double";
    const char* file = "TestCase/UnaryMinus.spvm";
    int32_t line = 80;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L14: // NEGATE_DOUBLE
  double_vars[2] = -double_vars[0];
L15: // EQ_DOUBLE
  int_vars[0] = (double_vars[1] == double_vars[2]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L20: // GOTO
  goto L21;
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L25;
L23: // INIT_INT
  int_vars[6] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L25;
L25: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__UnaryMinus__unary_minus_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::UnaryMinus";
    const char* sub_name = "unary_minus_float";
    const char* file = "TestCase/UnaryMinus.spvm";
    int32_t line = 61;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L3: // NEGATE_FLOAT
  float_vars[1] = -float_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L5: // BOOL_INT
  int_vars[0] = int_vars[2];
L6: // MOVE_INT
  int_vars[0] = int_vars[0];
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_NE_ZERO
  if (int_vars[0]) { goto L12; }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L11: // GOTO
  goto L12;
L12: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::UnaryMinus";
    const char* sub_name = "unary_minus_float";
    const char* file = "TestCase/UnaryMinus.spvm";
    int32_t line = 67;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L14: // NEGATE_FLOAT
  float_vars[2] = -float_vars[0];
L15: // EQ_FLOAT
  int_vars[0] = (float_vars[1] == float_vars[2]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L20: // GOTO
  goto L21;
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L25;
L23: // INIT_INT
  int_vars[6] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L25;
L25: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__UnaryMinus__unary_minus_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::UnaryMinus";
    const char* sub_name = "unary_minus_int";
    const char* file = "TestCase/UnaryMinus.spvm";
    int32_t line = 33;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L3: // NEGATE_INT
  int_vars[2] = -int_vars[1];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L5: // BOOL_INT
  int_vars[0] = int_vars[3];
L6: // MOVE_INT
  int_vars[0] = int_vars[0];
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_NE_ZERO
  if (int_vars[0]) { goto L12; }
L9: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L25;
L11: // GOTO
  goto L12;
L12: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::UnaryMinus";
    const char* sub_name = "unary_minus_int";
    const char* file = "TestCase/UnaryMinus.spvm";
    int32_t line = 39;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L14: // NEGATE_INT
  int_vars[6] = -int_vars[5];
L15: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L25;
L20: // GOTO
  goto L21;
L21: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L25;
L23: // INIT_INT
  int_vars[7] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L25;
L25: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__UnaryMinus__unary_minus_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::UnaryMinus";
    const char* sub_name = "unary_minus_long";
    const char* file = "TestCase/UnaryMinus.spvm";
    int32_t line = 47;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L3: // NEGATE_LONG
  long_vars[1] = -long_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L5: // BOOL_INT
  int_vars[0] = int_vars[2];
L6: // MOVE_INT
  int_vars[0] = int_vars[0];
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_NE_ZERO
  if (int_vars[0]) { goto L12; }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L11: // GOTO
  goto L12;
L12: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::UnaryMinus";
    const char* sub_name = "unary_minus_long";
    const char* file = "TestCase/UnaryMinus.spvm";
    int32_t line = 53;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L25;
  }
L14: // NEGATE_LONG
  long_vars[2] = -long_vars[0];
L15: // EQ_LONG
  int_vars[0] = (long_vars[1] == long_vars[2]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L25;
L20: // GOTO
  goto L21;
L21: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L25;
L23: // INIT_INT
  int_vars[6] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L25;
L25: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__UnaryMinus__unary_minus_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::UnaryMinus";
    const char* sub_name = "unary_minus_short";
    const char* file = "TestCase/UnaryMinus.spvm";
    int32_t line = 19;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L3: // MOVE_SHORT
  short_vars[1] = short_vars[0];
L4: // CONVERT_SHORT_TO_INT
  int_vars[1] = (int32_t)short_vars[1];
L5: // NEGATE_INT
  int_vars[2] = -int_vars[1];
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L7: // BOOL_INT
  int_vars[0] = int_vars[3];
L8: // MOVE_INT
  int_vars[0] = int_vars[0];
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_NE_ZERO
  if (int_vars[0]) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L28;
L13: // GOTO
  goto L14;
L14: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MAX
  {
    if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
      SUB_ID_SPVM__Util__INT16_MAX = env->get_sub_id(env, "SPVM::Util", "INT16_MAX", "short()");
      if (SUB_ID_SPVM__Util__INT16_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[0] = *(int16_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::UnaryMinus";
    const char* sub_name = "unary_minus_short";
    const char* file = "TestCase/UnaryMinus.spvm";
    int32_t line = 25;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L16: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[0];
L17: // NEGATE_INT
  int_vars[6] = -int_vars[5];
L18: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[6]);
L19: // BOOL_INT
  int_vars[0] = int_vars[0];
L20: // IF_NE_ZERO
  if (int_vars[0]) { goto L24; }
L21: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L28;
L23: // GOTO
  goto L24;
L24: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L28;
L26: // INIT_INT
  int_vars[7] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L28;
L28: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


