#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
static int32_t VAR_PACKAGE_VAR_ID_TestCase__LexicalVar__VAR_PREC = -1;
// Field id and index declarations
static int32_t FIELD_ID_anon0__var = -1;
static int32_t FIELD_BYTE_OFFSET_anon0__var = -1;
// Sub id declarations
static int32_t SUB_ID_anon0__ = - 1;
// Basic type id declarations
static int32_t BASIC_TYPE_ID_anon0 = -1;
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__LexicalVar__lexical_var_high_precidence_than_capture_var(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__LexicalVar__lexical_var_high_precidence_than_package_var(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__LexicalVar__lexical_var_upper_case(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__LexicalVar__var_brace(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__LexicalVar__lexical_var_high_precidence_than_capture_var(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 13;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_anon0 < 0) {
      BASIC_TYPE_ID_anon0 = env->get_basic_type_id(env, "anon0");
      if (BASIC_TYPE_ID_anon0 < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found anon0");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_anon0;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L4: // SET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_anon0__var < 0, 0)) {
      FIELD_ID_anon0__var = env->get_field_id(env, "anon0", "var", "int");
      if (FIELD_ID_anon0__var < 0) {
        void* exception = env->new_string_raw(env, "Field not found anon0 var");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_anon0__var = env->get_field_offset(env, FIELD_ID_anon0__var);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_anon0__var) = int_vars[1];
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::LexicalVar";
    const char* sub_name = "lexical_var_high_precidence_than_capture_var";
    const char* file = "TestCase/LexicalVar.spvm";
    int32_t line = 45;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L8: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L9: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L10: // CALL_SUB_INT
  // anon0->
  {
    if (SUB_ID_anon0__ < 0) {
      SUB_ID_anon0__ = env->get_sub_id(env, "anon0", "", "int(self)");
      if (SUB_ID_anon0__ < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found anon0 ");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_anon0__;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::LexicalVar";
    const char* sub_name = "lexical_var_high_precidence_than_capture_var";
    const char* file = "TestCase/LexicalVar.spvm";
    int32_t line = 52;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L12: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L13: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_NE_ZERO
  if (int_vars[0]) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L23;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L23;
L21: // INIT_INT
  int_vars[7] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L23;
L23: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__LexicalVar__lexical_var_high_precidence_than_package_var(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L3: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[3]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_NE_ZERO
  if (int_vars[0]) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L13;
L8: // GOTO
  goto L9;
L9: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L13;
L11: // INIT_INT
  int_vars[7] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__LexicalVar__lexical_var_upper_case(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L3: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[3]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_NE_ZERO
  if (int_vars[0]) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L13;
L8: // GOTO
  goto L9;
L9: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L13;
L11: // INIT_INT
  int_vars[7] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__LexicalVar__var_brace(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 5;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 5;
L3: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[3]);
L4: // BOOL_INT
  int_vars[0] = int_vars[0];
L5: // IF_NE_ZERO
  if (int_vars[0]) { goto L9; }
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L7: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L13;
L8: // GOTO
  goto L9;
L9: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L13;
L11: // INIT_INT
  int_vars[7] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L13;
L13: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


