#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
// Sub id declarations
// Basic type id declarations
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__BitNot__bit_not_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__BitNot__bit_not_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__BitNot__bit_not_int_theory(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__BitNot__bit_not_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__BitNot__bit_not_short(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__BitNot__bit_not_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 255;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L4: // BIT_OMPLEMENT_INT
  int_vars[3] = ~int_vars[2];
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // BOOL_INT
  int_vars[0] = int_vars[2];
L7: // MOVE_INT
  int_vars[0] = int_vars[0];
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_NE_ZERO
  if (int_vars[0]) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L12: // GOTO
  goto L13;
L13: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L14: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[5]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_NE_ZERO
  if (int_vars[0]) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L19: // GOTO
  goto L20;
L20: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L24;
L22: // INIT_INT
  int_vars[7] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L24;
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__BitNot__bit_not_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = -1;
L2: // BIT_OMPLEMENT_INT
  int_vars[2] = ~int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L4: // BOOL_INT
  int_vars[0] = int_vars[3];
L5: // MOVE_INT
  int_vars[0] = int_vars[0];
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_NE_ZERO
  if (int_vars[0]) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L22;
L10: // GOTO
  goto L11;
L11: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L12: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[5]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_NE_ZERO
  if (int_vars[0]) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L22;
L17: // GOTO
  goto L18;
L18: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L22;
L20: // INIT_INT
  int_vars[7] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L22;
L22: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__BitNot__bit_not_int_theory(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 28475212;
L2: // BIT_OMPLEMENT_INT
  int_vars[3] = ~int_vars[1];
L3: // NEGATE_INT
  int_vars[4] = -int_vars[1];
L4: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L5: // SUBTRACT_INT
  int_vars[6] = int_vars[4] - int_vars[5];
L6: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[6]);
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_NE_ZERO
  if (int_vars[0]) { goto L12; }
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L16;
L11: // GOTO
  goto L12;
L12: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L16;
L14: // INIT_INT
  int_vars[8] = 0;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L16;
L16: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__BitNot__bit_not_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = -1LL;
L2: // BIT_NOT_LONG
  long_vars[1] = ~long_vars[0];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L4: // BOOL_INT
  int_vars[0] = int_vars[2];
L5: // MOVE_INT
  int_vars[0] = int_vars[0];
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_NE_ZERO
  if (int_vars[0]) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L22;
L10: // GOTO
  goto L11;
L11: // MOVE_CONSTANT_LONG
  long_vars[0] = 0LL;
L12: // EQ_LONG
  int_vars[0] = (long_vars[1] == long_vars[0]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_NE_ZERO
  if (int_vars[0]) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L22;
L17: // GOTO
  goto L18;
L18: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L22;
L20: // INIT_INT
  int_vars[6] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L22;
L22: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__BitNot__bit_not_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 65535;
L2: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[1];
L3: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L4: // BIT_OMPLEMENT_INT
  int_vars[3] = ~int_vars[2];
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // BOOL_INT
  int_vars[0] = int_vars[2];
L7: // MOVE_INT
  int_vars[0] = int_vars[0];
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_NE_ZERO
  if (int_vars[0]) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L12: // GOTO
  goto L13;
L13: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L14: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[5]);
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_NE_ZERO
  if (int_vars[0]) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L19: // GOTO
  goto L20;
L20: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L24;
L22: // INIT_INT
  int_vars[7] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L24;
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


