###############################################################################
#
# Tests the output of Excel::Writer::XLSX against Excel generated files.
#
# reverse(''), October 2011, John McNamara, jmcnamara@cpan.org
#

use lib 't/lib';
use TestFunctions qw(_compare_xlsx_files _is_deep_diff);
use strict;
use warnings;

use Test::More tests => 1;

###############################################################################
#
# Tests setup.
#
my $filename     = 'cond_format03.xlsx';
my $dir          = 't/regression/';
my $got_filename = $dir . $filename;
my $exp_filename = $dir . 'xlsx_files/' . $filename;

my $ignore_members  = [];
my $ignore_elements = { 'xl/workbook.xml' => ['<workbookView'], };


###############################################################################
#
# Test the creation of a simple Excel::Writer::XLSX file with conditional
# formatting.
#
use Excel::Writer::XLSX;

my $workbook  = Excel::Writer::XLSX->new( $got_filename );
my $worksheet = $workbook->add_worksheet();

# We manually set the indices to get the same order as the target file.
my $format1 = $workbook->add_format( font_strikeout => 1, dxf_index => 1 );
my $format2 = $workbook->add_format( underline      => 1, dxf_index => 0 );

$worksheet->write( 'A1', 10 );
$worksheet->write( 'A2', 20 );
$worksheet->write( 'A3', 30 );
$worksheet->write( 'A4', 40 );

$worksheet->conditional_formatting( 'A1',
    {
        type     => 'cell',
        format   => $format1,
        criteria => 'between',
        minimum  => 2,
        maximum  => 6,
    }
);

$worksheet->conditional_formatting( 'A1',
    {
        type     => 'cell',
        format   => $format2,
        criteria => 'greater than',
        value  => 1,
    }
);


$workbook->close();


###############################################################################
#
# Compare the generated and existing Excel files.
#

my ( $got, $expected, $caption ) = _compare_xlsx_files(

    $got_filename,
    $exp_filename,
    $ignore_members,
    $ignore_elements,
);

_is_deep_diff( $got, $expected, $caption );


###############################################################################
#
# Cleanup.
#
unlink $got_filename;

__END__



