#########1 Test File for Spreadsheet::XLSX::Reader::LibXML  6#########7#########8#########9

my ( $lib, $test_file );
BEGIN{
	$ENV{PERL_TYPE_TINY_XS} = 0;
	my	$start_deeper = 1;
	$lib		= 'lib';
	$test_file	= 't/test_files/';
	for my $next ( <*> ){
		if( ($next eq 't') and -d $next ){
			$start_deeper = 0;
			last;
		}
	}
	if( $start_deeper ){
		$lib		= '../../../../' . $lib;
		$test_file	= '../../../test_files/'
	}
}
$| = 1;

use	Test::Most tests => 36;
use	Test::Moose;
use Data::Dumper;
use	lib	$lib,
	;
$test_file = ( @ARGV ) ? $ARGV[0] : $test_file;
my	$test_ref = {
		alt_default =>{
			get_values_only			=> 1,
			counting_from_zero		=> 0,
			is_empty_the_end		=> 1,
		},
		just_the_data =>{
			counting_from_zero   	=> 0,
			get_values_only       	=> 1,
			is_empty_the_end      	=> 1,
			get_group_return_type 	=> 'value',
			get_cache_positions   	=> 1,
			_starts_at_the_edge		=> 0,
		},
		like_ParseExcel =>{
			counting_from_zero		=> 1,
			get_cache_positions		=> 1,
			get_group_return_type	=> 'instance',
		},
		'just_the_data~|~like_ParseExcel' =>{
			get_values_only       	=> 1,
			is_empty_the_end      	=> 1,
			_starts_at_the_edge		=> 0,
			counting_from_zero		=> 1,
			get_cache_positions		=> 1,
			get_group_return_type	=> 'instance',
		},
	};
		
is 			eval 'use Spreadsheet::XLSX::Reader::LibXML "like_ParseExcel"', undef,
						'Attempt to load a bad import flag';
like 		$@, qr/Passed attribute default flag -like_ParseExcel- does not comply with the correct format/,		
						'.. and test for the correct error message';
			for my $good_flag ( keys %$test_ref ){
lives_ok{		delete $INC{'Spreadsheet::XLSX::Reader::LibXML'}; }
						'Remove the last load of Spreadsheet::XLSX::Reader::LibXML';
				my $eval_string = 'use Spreadsheet::XLSX::Reader::LibXML qw( :' . join( ' :', split( /~\|~/, $good_flag ) ) . ");\n";
				
is 				eval $eval_string, undef,
						"Attempt to load the package with the flag(s): $good_flag";
is 				$@, '',		
						'.. and check that it succeded';
				my $instance;
lives_ok{		$instance = Spreadsheet::XLSX::Reader::LibXML->new }
						"Build an instance of Spreadsheet::XLSX::Reader::LibXML for testing";
				for my $method ( keys %{$test_ref->{$good_flag}} ){
is					$instance->$method, $test_ref->{$good_flag}->{$method},
						"check that setting the flag -$good_flag- returns the method -$method- value: $test_ref->{$good_flag}->{$method}";
				}
			}
explain 								"...Test Done";
done_testing();