#!/usr/bin/perl

use 5.006;
use strict;
use warnings FATAL => 'all';
use ExtUtils::MakeMaker;

WriteMakefile(
    NAME               => 'Map::Tube::Plugin::FuzzyFind',
    AUTHOR             => q{Gisbert W. Selke <gws@cpan.org>},
    VERSION_FROM       => 'lib/Map/Tube/Plugin/FuzzyFind.pm',
    ABSTRACT_FROM      => 'lib/Map/Tube/Plugin/FuzzyFind.pm',
    LICENSE            => 'artistic_2',
    PL_FILES           => {},
    MIN_PERL_VERSION   => 5.006,
    CONFIGURE_REQUIRES => { 'ExtUtils::MakeMaker' => 0, },
    BUILD_REQUIRES     => {
                            'Test::More'        => 0.82,
                            'Map::Tube::London' => 0.51,
                          },
    PREREQ_PM          => { 'Moo'               => 0,   },
    PREREQ_PM          => {
                            'Map::Tube'         => 2.72,
                            'Moo::Role'         => 0,
                            'namespace::clean'  => 0,
                            'Text::Levenshtein' => 0,
                            'Try::Tiny'         => 0,
                          },
    dist  => { COMPRESS => 'gzip -9f', SUFFIX => 'gz', },
    clean => { FILES => 'Map-Tube-Plugin-FuzzyFind-*' },
    (eval { ExtUtils::MakeMaker->VERSION(6.46) } ? (META_MERGE => {
            'meta-spec' => { version => 2 },
            'provides'  => {
                             'Map::Tube::Plugin::FuzzyFind' => { file => 'lib/Map/Tube/Plugin/FuzzyFind.pm', version => '0.01' },
                           },
          })
     : ()
    ),
);
