package Net::Webdav::Constants ;

use Exporter ;

@ISA = qw(Exporter) ;
@EXPORT = qw{DAV_BASIC_H DAV_DEPTH_INFINITE DAV_DEPTH_ONE DAV_DEPTH_ZERO DAV_ELM_207_UNUSED DAV_ELM_207_first DAV_ELM_href DAV_ELM_multistatus DAV_ELM_prop DAV_ELM_propstat DAV_ELM_response DAV_ELM_responsedescription DAV_ELM_status DAV_LOCKS_H DAV_PROPS_H DAV_TIMEOUT_INFINITE DAV_TIMEOUT_INVALID HIP_ELM_UNUSED HIP_ELM_root HIP_ELM_unknown HIP_XML_CDATA HIP_XML_COLLECT HIP_XML_DECLINE HIP_XML_H HIP_XML_INVALID HIP_XML_MIXED HIP_XML_UTF8DECODE HIP_XML_VALID HTTP_AUTH HTTP_AUTHPROXY HTTP_BASIC_H HTTP_CONNECT HTTP_ERROR HTTP_FAILED HTTP_LOOKUP HTTP_OK HTTP_PORT HTTP_PROXYAUTH HTTP_QUOTES HTTP_REDIRECT HTTP_REDIRECT_H HTTP_REQUEST_H HTTP_RETRY HTTP_SERVERAUTH HTTP_TIMEOUT HTTP_UTILS_H HTTP_WHITESPACE} ;

use constant DAV_BASIC_H =>  ;
use constant DAV_DEPTH_INFINITE => (2)  ;
use constant DAV_DEPTH_ONE => (1)  ;
use constant DAV_DEPTH_ZERO => (0)  ;
use constant DAV_ELM_207_UNUSED => (HIP_ELM_UNUSED + 100)  ;
use constant DAV_ELM_207_first => (HIP_ELM_UNUSED)  ;
use constant DAV_ELM_href => (DAV_ELM_207_first + 3)  ;
use constant DAV_ELM_multistatus => (DAV_ELM_207_first)  ;
use constant DAV_ELM_prop => (DAV_ELM_207_first + 5)  ;
use constant DAV_ELM_propstat => (DAV_ELM_207_first + 4)  ;
use constant DAV_ELM_response => (DAV_ELM_207_first + 1)  ;
use constant DAV_ELM_responsedescription => (DAV_ELM_207_first + 2)  ;
use constant DAV_ELM_status => (DAV_ELM_207_first + 6)  ;
use constant DAV_LOCKS_H =>  ;
use constant DAV_PROPS_H =>  ;
use constant DAV_TIMEOUT_INFINITE => -1  ;
use constant DAV_TIMEOUT_INVALID => -2  ;
use constant HIP_ELM_UNUSED => (100)  ;
use constant HIP_ELM_root => 0  ;
use constant HIP_ELM_unknown => -1  ;
use constant HIP_XML_CDATA => (1<<1)  ;
use constant HIP_XML_COLLECT => ((1<<2) | HIP_XML_CDATA)  ;
use constant HIP_XML_DECLINE => (-2)  ;
use constant HIP_XML_H =>  ;
use constant HIP_XML_INVALID => (-1)  ;
use constant HIP_XML_MIXED => (1<<4)  ;
use constant HIP_XML_UTF8DECODE => (1<<3)  ;
use constant HIP_XML_VALID => (0)  ;
use constant HTTP_AUTH => (4)  ;
use constant HTTP_AUTHPROXY => (5)  ;
use constant HTTP_BASIC_H =>  ;
use constant HTTP_CONNECT => (8)  ;
use constant HTTP_ERROR => (1)  ;
use constant HTTP_FAILED => (10)  ;
use constant HTTP_LOOKUP => (3)  ;
use constant HTTP_OK => (0)  ;
use constant HTTP_PORT => 80  ;
use constant HTTP_PROXYAUTH => (7)  ;
use constant HTTP_QUOTES => "\"'"  ;
use constant HTTP_REDIRECT => (12)  ;
use constant HTTP_REDIRECT_H =>  ;
use constant HTTP_REQUEST_H =>  ;
use constant HTTP_RETRY => (11)  ;
use constant HTTP_SERVERAUTH => (6)  ;
use constant HTTP_TIMEOUT => (9)  ;
use constant HTTP_UTILS_H =>  ;
use constant HTTP_WHITESPACE => " \r\n\t"  ;
