use strict;
use warnings;
BEGIN{ $INC{'Module/Install/ExtraTests.pm'} = 1 } # M::I::ExtraTests considered harmful!
use inc::Module::Install;
use Module::Install::XSUtil 0.24;
use Module::Install::AuthorTests;

all_from 'lib/Text/Xslate.pm';

requires 'Any::Moose' => '0.13';

# XXX we don't handle Moose stuff here
requires 'Mouse'                => '0.61';
requires 'MouseX::Getopt'       => '0.2601';
requires 'parent'               => '0.221';
requires 'Scalar::Util'         => '1.23';

test_requires 'Test::More' => 0.88; # done_testing()
test_requires 'Test::Requires';
#test_requires 'Test::LeakTrace';

install_script 'xslate';

tests_recursive;
author_tests 'xt';

my $want_xs = want_xs();
if($want_xs) {
    use_ppport 3.19;
    cc_warnings;

    build_requires 'ExtUtils::ParseXS' => 2.2205;

    cc_src_paths qw(xs);
}

auto_set_repository() if -d '.git';

system "$^X tool/opcode.pl xs/Text-Xslate.xs >xslate_ops.h";
system "$^X tool/opcode_for_pp.pl xs/Text-Xslate.xs > lib/Text/Xslate/PP/Const.pm";

postamble <<'M';
# xslate_ops.h is automatically generated by xs/Text-Xslate.xs
xslate_ops.h :: xs/Text-Xslate.xs tool/opcode.pl
	$(PERLRUNINST) tool/opcode.pl xs/Text-Xslate.xs >xslate_ops.h

lib/Text/Xslate/PP/Const.pm :: xs/Text-Xslate.xs tool/opcode_for_pp.pl
	$(PERLRUNINST) tool/opcode_for_pp.pl xs/Text-Xslate.xs > lib/Text/Xslate/PP/Const.pm
M

if($want_xs) {
    # repeat testing for pure Perl mode
    # see also ExtUtils::MM_Any::test_via_harness()

    # test_pp
    my $t_pp =  q{$(FULLPERLRUN) -MExtUtils::Command::MM -e}
               .q{ "do 'tool/force-pp.pl'; test_harness($(TEST_VERBOSE), '$(INST_LIB)', '$(INST_ARCHLIB)')"}
               .q{ $(TEST_FILES)} . "\n";
    postamble qq{test_pp :: pure_all\n}
            . qq{\t} . $t_pp;

    # test_pp_opcode
    $t_pp =  q{$(FULLPERLRUN) -MExtUtils::Command::MM -e}
               .q{ "\$$ENV{XSLATE}='pp=opcode'; test_harness($(TEST_VERBOSE), '$(INST_LIB)', '$(INST_ARCHLIB)')"}
               .q{ $(TEST_FILES)} . "\n";
    postamble qq{test_pp_opcode :: pure_all\n}
            . qq{\t} . $t_pp;

    # test_pp_booster
    $t_pp =  q{$(FULLPERLRUN) -MExtUtils::Command::MM -e}
               .q{ "\$$ENV{XSLATE}='pp=booster'; test_harness($(TEST_VERBOSE), '$(INST_LIB)', '$(INST_ARCHLIB)')"}
               .q{ $(TEST_FILES)} . "\n";
    postamble qq{test_pp_booster :: pure_all\n}
            . qq{\t} . $t_pp;

    if(!$ENV{RELEASE_TESTING}) {
        postamble qq{test_dynamic :: test_pp\n\n};
    }
    else {
        postamble qq{test_dynamic :: test_pp_opcode test_pp_booster\n\n}
    }
}

clean_files qw(
    Text-Xslate-*
    nytprof *.out
    cover_db
);

WriteAll(check_nmake => 0);

