
use Test::More;
require Test::CheckChanges;

$Test::CheckChanges::test = bless {}, 'Dummy';
our $x = $Test::CheckChanges::test;

our @q = (
qr/No 'Changes' file found/,
qr/No way to determine version/,
);

our $count = 0;
{
    package Dummy;
    sub plan {
	print "1..3\n";
    };
    sub ok {
	shift;
	if (my $x = shift) {
	    print "not ok 1 @_\n";
	} else {
	    print "ok 1 @_\n";
	}
    }; 
    sub diag {
	shift;
	my $x = shift;
	if ($x =~ $q[$count]) {
	    print sprintf("ok %s - $x\n", ++$count+1);;
        } else {
	    print sprintf("not ok %s - $x\n", ++$count+1);;
	}
    }; 
}


Test::CheckChanges::ok_changes(
    base => 'examples/missing',
);

while ($count < 2) {
    print sprintf("not ok %s\n", ++$count+1);;
}
