package Test2::Harness::UI::Controller::Runs;
use strict;
use warnings;

our $VERSION = '0.000036';

use Data::GUID;
use Test2::Harness::UI::Response qw/resp error/;
use Test2::Harness::Util::JSON qw/encode_json decode_json/;

use parent 'Test2::Harness::UI::Controller';
use Test2::Harness::UI::Util::HashBase;

sub title { 'Runs' }

sub handle {
    my $self = shift;
    my ($route) = @_;

    my $req = $self->{+REQUEST};
    my $res = resp(200);
    my $user = $req->user;
    my $schema = $self->{+CONFIG}->schema;

    die error(404 => 'Missing route') unless $route;

    my $page = $route->{page} || 1;
    my $size = $route->{size} || 100;
    my $after = $route->{after};

    my $p = $req->parameters;

    my $a = {order_by => { -desc => [qw/run_ord/]}};

    my $runs;
    if ($after && $page == 1) {
        $runs = $schema->resultset('Run')->search({run_ord => {'>' => $after}}, {order_by => { -desc => 'run_ord'}});
    }
    else {
        $runs = $schema->resultset('Run')->search(undef, {page => $page, rows => $size, order_by => { -desc => 'run_ord'}});
    }

    $res->stream(
        env          => $req->env,
        content_type => 'application/x-jsonl',
        resultset    => $runs,
    );

    return $res;
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Test2::Harness::UI::Controller::Runs

=head1 DESCRIPTION

=head1 SYNOPSIS

TODO

=head1 SOURCE

The source code repository for Test2-Harness-UI can be found at
F<http://github.com/Test-More/Test2-Harness-UI/>.

=head1 MAINTAINERS

=over 4

=item Chad Granum E<lt>exodist@cpan.orgE<gt>

=back

=head1 AUTHORS

=over 4

=item Chad Granum E<lt>exodist@cpan.orgE<gt>

=back

=head1 COPYRIGHT

Copyright 2019 Chad Granum E<lt>exodist7@gmail.comE<gt>.

This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

See F<http://dev.perl.org/licenses/>

=cut
