package Test2::Essentials;
use strict;
use warnings;

our $VERSION = 0.000001;

{
    package Test2::Essential;

    package Test2::Bundle;
    package Test2::Bundle::Classic;
    package Test2::Bundle::Enhanced;
    package Test2::Bundle::Extra;

    package Test2::Compare;
    package Test2::Compare::Array;
    package Test2::Compare::Custom;
    package Test2::Compare::Event;
    package Test2::Compare::EventMeta;
    package Test2::Compare::Hash;
    package Test2::Compare::Meta;
    package Test2::Compare::Number;
    package Test2::Compare::Object;
    package Test2::Compare::Pattern;
    package Test2::Compare::Ref;
    package Test2::Compare::Regex;
    package Test2::Compare::Scalar;
    package Test2::Compare::Set;
    package Test2::Compare::String;
    package Test2::Compare::Undef;
    package Test2::Compare::Value;
    package Test2::Compare::Wildcard;

    package Test2::Plugin;
    package Test2::Plugin::BailOnFail;
    package Test2::Plugin::Class;
    package Test2::Plugin::DieOnFail;
    package Test2::Plugin::ExitSummary;
    package Test2::Plugin::SRand;
    package Test2::Plugin::TAP;
    package Test2::Plugin::UTF8;

    package Test2::Tool;
    package Test2::Tool::AuthorTest;
    package Test2::Tool::CanFork;
    package Test2::Tool::CanThread;
    package Test2::Tool::Capabilities;
    package Test2::Tool::Capture;
    package Test2::Tool::Class;
    package Test2::Tool::Compare;
    package Test2::Tool::Context;
    package Test2::Tool::Core;
    package Test2::Tool::Defer;
    package Test2::Tool::Grab;
    package Test2::Tool::Intercept;
    package Test2::Tool::Mock;
    package Test2::Tool::SkipWithout;
    package Test2::Tool::Spec;
    package Test2::Tool::Subtest;

    package Test2::Mock;

    package Test2::Util::Delta;
    package Test2::Util::Table::LineBreak;
    package Test2::Util::Table;

    package Test2::Workflow;
    package Test2::Workflow::Meta;
    package Test2::Workflow::Runner;
    package Test2::Workflow::Task;
    package Test2::Workflow::Unit;
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Test2::Essentials - Essential tools build on top of Test2.

=head1 DESCRIPTION

Right now this is just a stub. I am reserving namespaces that have yet to be
ported over from Test::Stream. These are not namespaces I will potentially use,
they are namespaces that are already more or less written, but need to be
ported.

I am doing this because Shadowcat MST told me I should, and I agree.

=head1 SOURCE

The source code repository for Test::Stream can be found at
F<http://github.com/Test-More/Test2-Essentials/>.

=head1 MAINTAINERS

=over 4

=item Chad Granum E<lt>exodist@cpan.orgE<gt>

=back

=head1 AUTHORS

=over 4

=item Chad Granum E<lt>exodist@cpan.orgE<gt>

=back

=head1 COPYRIGHT

Copyright 2015 Chad Granum E<lt>exodist7@gmail.comE<gt>.

This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

See F<http://dev.perl.org/licenses/>

=cut
