use strict;
use warnings;
use threads;

use DBI;
my $dbh = DBI->connect("dbi:SQLite::memory:","","");

my $sth = $dbh->prepare('CREATE TABLE foo(name text PRIMARY KEY)');
$sth->execute || die "Failed to execute A";

$sth = $dbh->prepare('INSERT INTO foo(name) values("bob")');
$sth->execute || die "Failed 2";

my $pid = fork;
die "no fork" unless defined $pid;

unless($pid) {
    $sth = $dbh->prepare('INSERT INTO foo(name) values("foo")');
    $sth->execute || die "Failed 3";

    $sth = $dbh->prepare('INSERT INTO foo(name) values("bar")');
    $sth->execute || die "Failed 4";

$sth = $dbh->prepare('select * from foo');
$sth->execute || die "Failed 5";
while (my $row = $sth->fetchrow_hashref) {
    use Data::Dumper;
    print Dumper($row);
}

    exit 0;
}

sleep 3;

print "\n\n\n";

$sth = $dbh->prepare('select * from foo');
$sth->execute || die "Failed 5";
while (my $row = $sth->fetchrow_hashref) {
    use Data::Dumper;
    print Dumper($row);
}

waitpid($pid, 0);
exit 0;
