use strict;
use warnings;

use Test::More;

use IO::Socket::INET;

my $ok = ok(
    eval { defined PF_INET and socket(my $tmp, PF_INET, SOCK_STREAM, 0); 1 },
    "INET Sockets appear to be supported"
);

diag "INET check: $ok | $^O";
diag "INET check: $ok | $^O";
diag "INET check: $ok | $^O";

my $listen = IO::Socket::INET->new(
    Listen => 1,
) || die "Could not open socket!";

my $port = $listen->sockport;

# Server
if (my $pid = fork) {
    local $SIG{ALRM} = sub { ok(0, "Got Message"); diag "Timeout!"; die };

    eval {
        alarm 5;
        my $client = $listen->accept;
        chomp(my $got = <$client>);
        is($got, 'Hello!', "Got message");
        alarm 0;
    };

    waitpid($pid, 0);
    done_testing;
    exit 0
}
else {
    close($listen);

    my $socket = IO::Socket::INET->new(PeerHost => 'localhost', PeerPort => $port) || die "Could not connect!";
    print $socket "Hello!\n";

    exit 0;
}
