#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.10';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfoK5',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type1',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag9050',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940e',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::plus',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 84 => 0x69 },
	'about' => { 358 => 'about' },
	'abspeakaudiofilepath' => { 364 => 'absPeakAudioFilePath' },
	'accelerationtracking' => { 65 => 0x518 },
	'accessorytype' => { 246 => 0x53 },
	'actionadvised' => { 100 => 0x2a },
	'activearea' => { 92 => 0xc68d },
	'actived-lighting' => { 177 => 0x22, 208 => 0x24 },
	'actived-lightingmode' => { 208 => 0x25 },
	'addaspectratioinfo' => { 65 => 0x80e },
	'additionalmodelinformation' => { 351 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 65 => 0x80f, 66 => 0x11, 67 => 0x13, 70 => 0x14 },
	'address' => { 127 => 'Address' },
	'adjustmentmode' => { 302 => 0x15 },
	'adobe' => { 93 => 'Adobe' },
	'adultcontentwarning' => { 354 => 'AdultContentWarning', 357 => 'adultContentWarning' },
	'advancedraw' => { 210 => 0x76a43203 },
	'advancedscenetype' => { 246 => 0x3d },
	'advisory' => { 362 => 'Advisory' },
	'ae_iso' => { 251 => 0x2, 252 => 0x4, 253 => 0x12 },
	'aeaperture' => { 251 => 0x1, 252 => 0x3, 253 => 0x11 },
	'aebautocancel' => { 65 => 0x104 },
	'aebbracketvalue' => { 59 => 0x11 },
	'aebsequence' => { 65 => 0x105 },
	'aebsequenceautocancel' => { 63 => 0x9, 64 => 0x9, 66 => 0x8, 67 => 0x9, 70 => 0x9, 71 => 0x7 },
	'aebshotcount' => { 65 => 0x106 },
	'aebxv' => { 251 => 0x4, 252 => 0x6 },
	'aeerror' => { 252 => 0x8 },
	'aeexposuretime' => { 251 => 0x0, 252 => 0x2, 253 => 0x10 },
	'aelbutton' => { 147 => 0x45 },
	'aelexposureindicator' => { 147 => 0x51 },
	'aelock' => { 147 => 0x5b, 218 => '4.2', 224 => '4.2', 227 => 0x201, 277 => 0x48, 307 => 0x86 },
	'aelockbutton' => { 217 => '16.1', 218 => '4.1', 219 => '15.1', 220 => '16.1', 221 => '16.1', 222 => '30.1', 223 => '16.1', 224 => '4.1', 226 => '17.1' },
	'aelockbuttonplusdials' => { 217 => '16.2', 222 => '32.1' },
	'aelockformb-d80' => { 226 => '3.1' },
	'aemaxaperture' => { 251 => 0x9, 252 => 0x10, 253 => 0x1c },
	'aemaxaperture2' => { 251 => 0xa, 252 => 0x11, 253 => 0x1d },
	'aemeteringmode' => { 251 => 0xc },
	'aemeteringsegments' => { 150 => 0x628, 277 => 0x209 },
	'aemicroadjustment' => { 65 => 0x111 },
	'aeminaperture' => { 251 => 0xb, 252 => 0x12, 253 => 0x1e },
	'aeminexposuretime' => { 251 => 0x5, 252 => 0x13, 253 => 0x1f },
	'aeprogrammode' => { 251 => 0x6 },
	'aesetting' => { 26 => 0x21 },
	'aexv' => { 251 => 0x3, 252 => 0x5 },
	'af-cpriorityselection' => { 217 => '1.1', 220 => '0.1', 221 => '0.1', 222 => '1.1', 223 => '0.1' },
	'af-onformb-d10' => { 217 => '3.3', 222 => '3.2' },
	'af-onformb-d11' => { 223 => '2.2' },
	'af-spriorityselection' => { 217 => '1.2', 222 => '1.2', 223 => '0.2' },
	'afactivation' => { 217 => '2.1', 222 => '2.1' },
	'afadjustment' => { 277 => 0x72 },
	'afandmeteringbuttons' => { 65 => 0x701 },
	'afaperture' => { 173 => 0x5, 174 => 0x5 },
	'afareaheight' => { 155 => 0x1a },
	'afareaillumination' => { 147 => 0x4b, 224 => '15.3' },
	'afareamode' => { 143 => 0x33, 147 => 0xe, 154 => 0x0, 155 => 0x5, 246 => 0xf, 305 => 0x11, 306 => 0x10, 307 => 0x24, 316 => 0xb043, 323 => 0x17, 327 => 0xa },
	'afareamodesetting' => { 218 => '11.1', 219 => '0.1', 224 => '16.1', 226 => '2.1', 316 => 0x201c },
	'afareas' => { 227 => 0x304 },
	'afareawidth' => { 155 => 0x18 },
	'afareaxposition' => { 155 => 0x14 },
	'afareayposition' => { 155 => 0x16 },
	'afassist' => { 63 => 0x5, 71 => 0x5, 147 => 0x48, 217 => '2.5', 218 => '0.2', 219 => '0.2', 220 => '1.1', 221 => '1.1', 222 => '2.4', 223 => '1.4', 224 => '0.2', 226 => '2.3' },
	'afassistbeam' => { 65 => 0x50e, 66 => 0x4, 67 => 0x5, 68 => 0x4, 69 => 0x4, 70 => 0x5 },
	'afassistlamp' => { 246 => 0x31 },
	'afbuttonpressed' => { 307 => 0x83 },
	'afdefocus' => { 254 => 0x6 },
	'afduringliveview' => { 65 => 0x511 },
	'affinea' => { 336 => 'AffineA' },
	'affineb' => { 336 => 'AffineB' },
	'affinec' => { 336 => 'AffineC' },
	'affined' => { 336 => 'AffineD' },
	'affinetune' => { 156 => 0x0, 227 => 0x306 },
	'affinetuneadj' => { 156 => 0x2, 185 => 0x2d1, 186 => 0x2dc, 227 => 0x307 },
	'affinetuneindex' => { 156 => 0x1 },
	'affinex' => { 336 => 'AffineX' },
	'affiney' => { 336 => 'AffineY' },
	'afilluminator' => { 305 => 0x29, 316 => 0xb044 },
	'afimageheight' => { 155 => 0x12 },
	'afimagewidth' => { 155 => 0x10 },
	'afintegrationtime' => { 254 => 0x7 },
	'afmicroadj' => { 327 => 0x17d },
	'afmicroadjmode' => { 1 => 0x1, 304 => 0x131 },
	'afmicroadjregisteredlenses' => { 304 => '305.1' },
	'afmicroadjustment' => { 65 => 0x507 },
	'afmicroadjvalue' => { 1 => 0x2, 304 => 0x130 },
	'afmode' => { 88 => 0x3009, 143 => 0x16, 302 => 0x5 },
	'afonaelockbuttonswitch' => { 65 => 0x702 },
	'afonbutton' => { 217 => '3.1' },
	'afpoint' => { 26 => 0x13, 87 => 0x18, 143 => 0x15, 154 => 0x1, 230 => 0x308, 302 => 0x1f, 303 => 0x20, 327 => 0x7 },
	'afpointactivationarea' => { 64 => 0x11, 70 => 0x11 },
	'afpointareaexpansion' => { 65 => 0x508 },
	'afpointatshutterrelease' => { 327 => 0x9 },
	'afpointautoselection' => { 65 => 0x50b },
	'afpointbrightness' => { 65 => 0x50d, 217 => '2.4' },
	'afpointdisplayduringfocus' => { 65 => 0x50c },
	'afpointillumination' => { 64 => 0xa, 217 => '2.3', 222 => '2.3', 223 => '1.3', 226 => '2.4' },
	'afpointinfocus' => { 327 => 0x8 },
	'afpointmode' => { 258 => 0x3 },
	'afpointposition' => { 88 => 0x2021, 246 => 0x4d },
	'afpointregistration' => { 63 => 0x7 },
	'afpoints' => { 146 => 0x10 },
	'afpointselected' => { 147 => 0xd, 227 => 0x305, 277 => 0xe, 303 => 0x1c, 305 => 0x12, 306 => 0x11, 316 => 0x201e },
	'afpointselected2' => { 258 => 0x4 },
	'afpointselection' => { 64 => 0xb, 217 => '1.3', 222 => '1.3' },
	'afpointselectionmethod' => { 65 => 0x50f, 66 => 0xc, 67 => 0xd, 70 => 0xd },
	'afpointsinfocus' => { 59 => 0xe, 154 => 0x2, 254 => 0xb, 277 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 16 => 0x38 },
	'afpointspotmetering' => { 64 => 0xd },
	'afpointsselected' => { 326 => 0x4 },
	'afpointsunknown1' => { 254 => 0x0 },
	'afpointsunknown2' => { 254 => 0x2 },
	'afpointsused' => { 155 => 0x8 },
	'afpredictor' => { 254 => 0x4 },
	'afresponse' => { 177 => 0xad },
	'afresult' => { 232 => 0x1038 },
	'afsearch' => { 227 => 0x303 },
	'afsensoractive' => { 143 => 0x1 },
	'afstatusactivesensor' => { 143 => 0x2 },
	'afstatusbottom' => { 143 => 0x8 },
	'afstatusbottom-left' => { 143 => 0x12 },
	'afstatusbottom-right' => { 143 => 0x6 },
	'afstatuscenterhorizontal' => { 143 => 0x2f },
	'afstatuscentervertical' => { 143 => 0xc },
	'afstatusleft' => { 143 => 0x2d },
	'afstatusmiddlehorizontal' => { 143 => 0xa },
	'afstatusright' => { 143 => 0x31 },
	'afstatustop' => { 143 => 0xe },
	'afstatustop-left' => { 143 => 0x10 },
	'afstatustop-right' => { 143 => 0x4 },
	'afwithshutter' => { 305 => 0x2a },
	'aggregationtype' => { 355 => 'aggregationType' },
	'agreement' => { 357 => 'agreement' },
	'aiservocontinuousshooting' => { 64 => 0x15 },
	'aiservofirstimagepriority' => { 65 => 0x519 },
	'aiservoimagepriority' => { 65 => 0x503 },
	'aiservosecondimagepriority' => { 65 => 0x51a },
	'aiservotrackingmethod' => { 65 => 0x504 },
	'aiservotrackingsensitivity' => { 64 => 0x14, 65 => 0x502 },
	'album' => { 364 => 'album' },
	'alreadyapplied' => { 342 => 'AlreadyApplied' },
	'alternatetitle' => { 355 => 'alternateTitle' },
	'alttapename' => { 364 => 'altTapeName' },
	'alttimecode' => { 364 => 'altTimecode' },
	'alttimecodetimeformat' => { 364 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 364 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 364 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 2 => 0x1 },
	'ambienttemperature' => { 290 => 0x14, 323 => 0x4 },
	'ambienttemperaturefahrenheit' => { 290 => 0x13 },
	'analogbalance' => { 92 => 0xc627 },
	'angleadj' => { 84 => 0x8b },
	'angleinforoll' => { 338 => 'AngleInfoRoll' },
	'anti-blur' => { 316 => 0xb04b },
	'antialiasstrength' => { 92 => 0xc632 },
	'aperturerange' => { 65 => 0x10d },
	'apertureringuse' => { 258 => '1.4' },
	'aperturesetting' => { 147 => 0x7, 305 => 0x30, 306 => 0x29, 307 => 0x1 },
	'aperturevalue' => { 74 => 0x2, 92 => 0x9202, 232 => 0x1002, 346 => 'ApertureValue' },
	'applekeywords' => { 236 => 'AAPL:Keywords' },
	'applicationnotes' => { 92 => 0x2bc, 250 => 0x2bc },
	'applicationrecordversion' => { 100 => 0x0 },
	'applyshootingmeteringmode' => { 65 => 0x10e },
	'approved' => { 347 => 'Approved' },
	'approvedby' => { 347 => 'ApprovedBy' },
	'approximatefnumber' => { 242 => 0x313, 248 => 0x3406 },
	'approximatefocusdistance' => { 339 => 'ApproximateFocusDistance' },
	'armidentifier' => { 101 => 0x78 },
	'armversion' => { 101 => 0x7a },
	'artfilter' => { 227 => 0x529 },
	'artfiltereffect' => { 227 => 0x52f },
	'artist' => { 92 => 0x13b, 238 => 'Artist', 277 => 0x22e, 360 => 'Artist', 364 => 'artist' },
	'artmode' => { 88 => 0x301b },
	'artmodeparameters' => { 88 => 0x310b },
	'artworkcopyrightnotice' => { 351 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcreator' => { 351 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkdatecreated' => { 351 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworkorobject' => { 351 => 'ArtworkOrObject' },
	'artworksource' => { 351 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 351 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworktitle' => { 351 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 231 => 0x1113 },
	'aspectratio' => { 3 => 0x0, 231 => 0x1112, 277 => 0x80, 305 => 0x55, 306 => 0x55, 307 => 0xa },
	'asshoticcprofile' => { 92 => 0xc68f },
	'asshotneutral' => { 92 => 0xc628 },
	'asshotpreprofilematrix' => { 92 => 0xc690 },
	'asshotprofilename' => { 92 => 0xc6f6 },
	'asshotwhitexy' => { 92 => 0xc629 },
	'assignbktbutton' => { 217 => '4.2' },
	'assignfuncbutton' => { 65 => 0x70b },
	'assistbuttonfunction' => { 63 => 0xd },
	'attributionname' => { 340 => 'attributionName' },
	'attributionurl' => { 340 => 'attributionURL' },
	'audio' => { 246 => 0x20 },
	'audiobitrate' => { 51 => 0x6c },
	'audiochannels' => { 51 => 0x70 },
	'audiochanneltype' => { 364 => 'audioChannelType' },
	'audiocompression' => { 121 => 'Compression' },
	'audiocompressor' => { 364 => 'audioCompressor' },
	'audioduration' => { 100 => 0x99 },
	'audiomoddate' => { 364 => 'audioModDate' },
	'audiooutcue' => { 100 => 0x9a },
	'audiosamplerate' => { 51 => 0x6e, 364 => 'audioSampleRate' },
	'audiosampletype' => { 364 => 'audioSampleType' },
	'audiosamplingrate' => { 100 => 0x97 },
	'audiosamplingresolution' => { 100 => 0x98 },
	'audiotype' => { 100 => 0x96 },
	'author' => { 123 => 'Author', 236 => 'Author', 238 => 'Author', 289 => 'Author', 337 => 'author', 352 => 'Author', 362 => 'Author' },
	'authorsposition' => { 353 => 'AuthorsPosition' },
	'autoaperture' => { 268 => '0.1' },
	'autobracket' => { 302 => 0x19 },
	'autobracketing' => { 97 => 0x1100, 277 => 0x18 },
	'autobracketingmode' => { 225 => '12.3' },
	'autobracketingset' => { 225 => '12.1' },
	'autobracketmodem' => { 217 => '21.2', 222 => '26.2' },
	'autobracketorder' => { 147 => 0x43, 217 => '21.3', 222 => '26.3', 223 => '12.2', 224 => '2.2', 225 => '12.2', 226 => '13.2' },
	'autobracketset' => { 217 => '21.1', 219 => '11.1', 220 => '12.1', 221 => '12.1', 222 => '26.1', 223 => '12.1', 224 => '2.1', 226 => '13.1' },
	'autobrightness' => { 342 => 'AutoBrightness' },
	'autocontrast' => { 342 => 'AutoContrast' },
	'autodistortioncontrol' => { 163 => 0x4 },
	'autodynamicrange' => { 97 => 0x140b },
	'autoexposure' => { 342 => 'AutoExposure' },
	'autoexposurebracketing' => { 59 => 0x10 },
	'autofocus' => { 230 => 0x209 },
	'autofp' => { 224 => '7.3', 226 => '31.4' },
	'autoiso' => { 59 => 0x1, 88 => 0x3008, 218 => '1.1', 224 => '1.1' },
	'autoisomax' => { 218 => '1.2', 224 => '1.2' },
	'autoisominshutterspeed' => { 218 => '1.3', 224 => '1.3' },
	'autolateralca' => { 342 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 13 => 0xbe, 14 => 0xbf, 17 => 0xbf, 47 => 0x2, 65 => 0x204, 84 => 0x6f },
	'autolightingoptimizeron' => { 84 => 0x6e },
	'autoportraitframed' => { 316 => 0x2016 },
	'autoredeye' => { 210 => 0xfe28a44f },
	'autorotate' => { 59 => 0x1b },
	'autoshadows' => { 342 => 'AutoShadows' },
	'auxiliarylens' => { 177 => 0x82 },
	'avaperturesetting' => { 258 => 0x13 },
	'averagelv' => { 150 => 0x38 },
	'avsettingwithoutlens' => { 65 => 0x707 },
	'azimuth' => { 131 => 'Azimuth' },
	'babyage' => { 246 => [0x8010,0x33] },
	'babyname' => { 246 => 0x66 },
	'backgroundalpha' => { 359 => 'bgalpha' },
	'baseexposurecompensation' => { 258 => 0x15 },
	'baseiso' => { 59 => 0x2, 78 => 0x101c, 248 => 0x312a },
	'baselineexposure' => { 92 => 0xc62a },
	'baselineexposureoffset' => { 92 => 0xc7a5 },
	'baselinenoise' => { 92 => 0xc62b },
	'baselinesharpness' => { 92 => 0xc62c },
	'baseurl' => { 362 => 'BaseURL' },
	'batterylevel' => { 305 => 0x51, 309 => 0xc, 310 => 0x4, 311 => 0x4, 325 => 0x7 },
	'batteryorder' => { 217 => '12.5', 222 => '13.2', 223 => '2.1' },
	'batterystate' => { 147 => 0x60, 311 => 0x14 },
	'batterytemperature' => { 309 => 0x1, 311 => 0x2 },
	'batteryunknown' => { 309 => 0x2, 311 => 0x0 },
	'batteryvoltage' => { 290 => 0x2a, 309 => 0x8 },
	'batteryvoltage1' => { 311 => 0x6 },
	'batteryvoltage2' => { 311 => 0x8 },
	'bayergreensplit' => { 92 => 0xc62d },
	'bayerpattern' => { 105 => 0xf902, 151 => 0x17 },
	'beatspliceparams' => { 364 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 364 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 364 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 364 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 364 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 364 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 217 => '13.1', 218 => '0.1', 219 => '2.1', 220 => '3.1', 221 => '3.1', 222 => '10.1', 224 => '0.1', 226 => '4.1' },
	'beeppitch' => { 223 => '3.1' },
	'beepvolume' => { 223 => '4.5' },
	'bestqualityscale' => { 92 => 0xc65c },
	'bestshotmode' => { 88 => 0x3007 },
	'bitdepth' => { 128 => 'BitDepth', 151 => 0x11, 182 => 0x41 },
	'bitspercomponent' => { 102 => 0x87 },
	'bitspersample' => { 92 => 0x102, 360 => 'BitsPerSample' },
	'blacklevel' => { 92 => 0xc61a, 232 => 0x1012 },
	'blacklevel2' => { 231 => 0x600, 235 => 0x600 },
	'blackleveldeltah' => { 92 => 0xc61b },
	'blackleveldeltav' => { 92 => 0xc61c },
	'blacklevelrepeatdim' => { 92 => 0xc619 },
	'blackpoint' => { 277 => 0x200 },
	'blacks2012' => { 342 => 'Blacks2012' },
	'bleachbypasstoning' => { 277 => 0x7f },
	'bluebalance' => { 162 => 0x271, 232 => 0x1018, 250 => 0x12, 277 => 0x1b },
	'bluecurvelimits' => { 83 => 0x1fe },
	'bluecurvepoints' => { 83 => 0x1d4 },
	'bluehue' => { 342 => 'BlueHue' },
	'bluesaturation' => { 342 => 'BlueSaturation' },
	'blurcontrol' => { 277 => 0x82 },
	'blurwarning' => { 97 => 0x1300 },
	'bodybatteryadload' => { 256 => 0x3 },
	'bodybatteryadnoload' => { 256 => 0x2 },
	'bodybatterystate' => { 256 => '1.1' },
	'bodybatteryvoltage1' => { 256 => 0x2 },
	'bodybatteryvoltage2' => { 256 => 0x4 },
	'bodybatteryvoltage3' => { 256 => 0x6 },
	'bodybatteryvoltage4' => { 256 => 0x8 },
	'bodyfirmware' => { 295 => 0x0 },
	'bodyfirmwareversion' => { 228 => 0x104, 229 => 0x100, 232 => 0x104 },
	'bodyserialnumber' => { 295 => 0x10 },
	'bracketmode' => { 43 => 0x3 },
	'bracketsequence' => { 88 => 0x301d },
	'bracketshotnumber' => { 43 => 0x5, 258 => 0x9, 315 => 0x2b },
	'bracketshotnumber2' => { 315 => 0x2d },
	'bracketstep' => { 144 => 0xe },
	'bracketvalue' => { 43 => 0x4 },
	'brightness' => { 92 => 0xfe53, 122 => 'Brightness', 144 => 0x2c, 179 => 0x34, 290 => 0x25, 305 => 0x22, 316 => 0x2007, 342 => 'Brightness' },
	'brightnessadj' => { 83 => 0x114, 203 => 0x0, 213 => 0x2d, 328 => 0x8018 },
	'brightnessvalue' => { 92 => 0x9203, 150 => [0x691,0x49c3], 232 => 0x1003, 346 => 'BrightnessValue' },
	'bulbduration' => { 59 => 0x18 },
	'burstmode' => { 108 => 0xa, 246 => 0x2a },
	'burstmode2' => { 108 => 0x18 },
	'burstshot' => { 302 => 0x34 },
	'buttonfunctioncontroloff' => { 65 => 0x70a },
	'bwfilter' => { 144 => 0x2a, 152 => 0x39 },
	'bwmode' => { 232 => 0x203 },
	'by-line' => { 100 => 0x50 },
	'by-linetitle' => { 100 => 0x55 },
	'bytecount' => { 355 => 'byteCount' },
	'calibration' => { 302 => [0x24,0x30] },
	'calibrationilluminant1' => { 92 => 0xc65a },
	'calibrationilluminant2' => { 92 => 0xc65b },
	'cameraangle' => { 364 => 'cameraAngle' },
	'cameracalibration1' => { 92 => 0xc623 },
	'cameracalibration2' => { 92 => 0xc624 },
	'cameracalibrationsig' => { 92 => 0xc6f3 },
	'cameracolorcalibration01' => { 28 => 0x0, 34 => 0xba },
	'cameracolorcalibration02' => { 28 => 0x4, 34 => 0xbf },
	'cameracolorcalibration03' => { 28 => 0x8, 34 => 0xc4 },
	'cameracolorcalibration04' => { 28 => 0xc, 34 => 0xc9 },
	'cameracolorcalibration05' => { 28 => 0x10, 34 => 0xce },
	'cameracolorcalibration06' => { 28 => 0x14, 34 => 0xd3 },
	'cameracolorcalibration07' => { 28 => 0x18, 34 => 0xd8 },
	'cameracolorcalibration08' => { 28 => 0x1c, 34 => 0xdd },
	'cameracolorcalibration09' => { 28 => 0x20, 34 => 0xe2 },
	'cameracolorcalibration10' => { 28 => 0x24, 34 => 0xe7 },
	'cameracolorcalibration11' => { 28 => 0x28, 34 => 0xec },
	'cameracolorcalibration12' => { 28 => 0x2c, 34 => 0xf1 },
	'cameracolorcalibration13' => { 28 => 0x30, 34 => 0xf6 },
	'cameracolorcalibration14' => { 28 => 0x34, 34 => 0xfb },
	'cameracolorcalibration15' => { 28 => 0x38, 34 => 0x100 },
	'cameraid' => { 232 => 0x209, 301 => 0x209 },
	'cameraiso' => { 26 => 0x10 },
	'cameralabel' => { 92 => 0xc7a1, 364 => 'cameraLabel' },
	'cameramodel' => { 364 => 'cameraModel' },
	'cameramove' => { 364 => 'cameraMove' },
	'cameraorientation' => { 4 => 0x30, 6 => 0x7d, 8 => 0x30, 10 => 0x35, 11 => 0x30, 12 => 0x30, 13 => 0x31, 14 => 0x31, 15 => 0x35, 16 => 0x27, 17 => 0x31, 18 => 0x7d, 19 => 0x38, 20 => 0x36, 21 => 0x7d, 22 => 0x35, 279 => 0x1, 311 => 0x18, 321 => 0x28, 322 => 0x24 },
	'cameraowner' => { 109 => 0xc353 },
	'cameraparameters' => { 232 => 0x2050 },
	'cameraprofile' => { 342 => 'CameraProfile' },
	'cameraprofiledigest' => { 342 => 'CameraProfileDigest' },
	'cameraserialnumber' => { 92 => 0xc62f, 142 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 227 => 0x0 },
	'cameratemperature' => { 4 => 0x18, 6 => 0x1b, 8 => 0x18, 10 => 0x19, 11 => 0x18, 12 => 0x18, 13 => 0x19, 14 => 0x19, 15 => 0x19, 16 => 0x17, 17 => 0x19, 18 => 0x1b, 19 => 0x19, 20 => 0x19, 21 => 0x1b, 22 => 0x19, 23 => [0x87,0x91], 24 => [0x99,0x9f,0xa4,0xa8,0x105], 25 => [0x64,0x1d2,0x1f7,0x1fa,0x208,0x20c,0x47,0x53,0x5b,0x5c], 59 => 0xc, 242 => 0x320, 248 => 0x3402, 277 => 0x47, 299 => 0x43, 324 => 0x5 },
	'cameratemperature2' => { 280 => 0xc },
	'cameratemperature3' => { 280 => 0xe },
	'cameratemperature4' => { 280 => 0x14 },
	'cameratemperature5' => { 280 => 0x16 },
	'cameratype' => { 59 => 0x1a, 232 => 0x207 },
	'cameratype2' => { 228 => 0x100 },
	'canonexposuremode' => { 26 => 0x14 },
	'canonfiledescription' => { 78 => 0x805 },
	'canonfilelength' => { 48 => 0xe },
	'canonfirmwareversion' => { 48 => 0x7, 78 => 0x80b },
	'canonflashinfo' => { 78 => 0x1028 },
	'canonflashmode' => { 26 => 0x4 },
	'canonimagesize' => { 7 => 0x39, 26 => 0xa },
	'canonimagetype' => { 48 => 0x6, 78 => 0x815 },
	'canonmodelid' => { 48 => 0x10, 78 => 0x1834 },
	'canonvrd' => { 93 => 'CanonVRD' },
	'caption' => { 337 => 'caption' },
	'caption-abstract' => { 100 => 0x78 },
	'captionsauthornames' => { 345 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 345 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 353 => 'CaptionWriter' },
	'captureframerate' => { 88 => 0x4001 },
	'capturesoftware' => { 332 => 'CaptureSoftware' },
	'cardshutterlock' => { 147 => 0x49 },
	'casioimagesize' => { 88 => 0x9 },
	'catalogsets' => { 100 => 0xff, 331 => 'CatalogSets', 335 => 'CatalogSets' },
	'categories' => { 48 => 0x23, 337 => 'categories' },
	'category' => { 100 => 0xf, 353 => 'Category' },
	'ccdboardversion' => { 242 => 0x331 },
	'ccdscanmode' => { 232 => 0x1039 },
	'ccdsensitivity' => { 200 => 0x6 },
	'ccdversion' => { 242 => 0x330 },
	'cellglobalid' => { 341 => 'cgi' },
	'celllength' => { 92 => 0x109 },
	'cellr' => { 341 => 'r' },
	'celltowerid' => { 341 => 'cellid' },
	'cellwidth' => { 92 => 0x108 },
	'centerafarea' => { 224 => '15.1' },
	'centerfocuspoint' => { 226 => '2.2' },
	'centerweightedareasize' => { 217 => '7.1', 222 => '5.1', 223 => '7.1', 224 => '6.3', 226 => '8.1' },
	'certificate' => { 368 => 'Certificate' },
	'cfapattern' => { 92 => 0xa302, 346 => 'CFAPattern' },
	'cfapattern2' => { 92 => 0x828e },
	'cfapatterncolumns' => { 346 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 346 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 346 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 92 => 0x828d },
	'channel' => { 355 => 'channel' },
	'channels' => { 121 => 'Channels' },
	'checkmark' => { 83 => 0x26a },
	'checkmark2' => { 84 => 0x8e },
	'childfontfiles' => { 369 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 217 => '10.3' },
	'chromablurradius' => { 92 => 0xc631 },
	'chromaticaberration' => { 84 => 0x66 },
	'chromaticaberrationb' => { 342 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 84 => 0x6b },
	'chromaticaberrationcorr' => { 61 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 267 => 0x1 },
	'chromaticaberrationon' => { 84 => 0x62 },
	'chromaticaberrationr' => { 342 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 84 => 0x6a },
	'chromaticaberrationsetting' => { 62 => 0x6 },
	'chrominancenoisereduction' => { 84 => 0x5e, 302 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 84 => 0x60 },
	'city' => { 100 => 0x5a, 127 => 'City', 246 => 0x6d, 353 => 'City' },
	'clarity' => { 342 => 'Clarity' },
	'clarity2012' => { 342 => 'Clarity2012' },
	'classifystate' => { 100 => 0xe1 },
	'client' => { 364 => 'client' },
	'clientname' => { 347 => 'ClientName' },
	'clmodeshootingspeed' => { 217 => '10.2', 222 => '11.2', 223 => '10.2', 226 => '11.1' },
	'cmcontrast' => { 235 => 0x2022 },
	'cmexposurecompensation' => { 235 => 0x2000 },
	'cmhue' => { 235 => 0x2021 },
	'cmsaturation' => { 235 => 0x2020 },
	'cmsharpness' => { 235 => 0x2023 },
	'cmwhitebalance' => { 235 => 0x2001 },
	'cmwhitebalancecomp' => { 235 => 0x2002 },
	'cmwhitebalancegraypoint' => { 235 => 0x2010 },
	'codec' => { 135 => 'Codec' },
	'codedcharacterset' => { 101 => 0x5a },
	'collectionname' => { 136 => [\'Collections','CollectionsCollectionName'] },
	'collections' => { 136 => 'Collections' },
	'collectionuri' => { 136 => [\'Collections','CollectionsCollectionURI'] },
	'coloraberrationcontrol' => { 210 => 0xc89224b },
	'coloradjustment' => { 302 => 0x14 },
	'coloradjustmentmode' => { 301 => 0x210 },
	'coloranta' => { 369 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 369 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 369 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 369 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 369 => [\'Colorants','ColorantsCyan'] },
	'colorantgreen' => { 369 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 369 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 369 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 369 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 369 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 369 => 'Colorants' },
	'colorantswatchname' => { 369 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 369 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 369 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 369 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 122 => 'ColorBalance' },
	'colorbalanceadj' => { 210 => 0x76a43202 },
	'colorbalanceblue' => { 144 => 0x1e },
	'colorbalancegreen' => { 144 => 0x1d },
	'colorbalancered' => { 144 => 0x1c },
	'colorblur' => { 84 => 0x65 },
	'colorbooster' => { 210 => 0x5f0e7d23 },
	'colorboostlevel' => { 204 => 0x1 },
	'colorboosttype' => { 204 => 0x0 },
	'colorclass' => { 284 => 0xde, 285 => 'ColorClass' },
	'colorcompensationfilter' => { 147 => [0x3a,0x5f], 149 => 0x111, 316 => 0xb022 },
	'colorcompensationfilterset' => { 305 => 0xd, 306 => 0xc, 307 => 0x18, 317 => 0xf },
	'colorcontrol' => { 232 => 0x102b },
	'colorcorrection' => { 328 => 0x8015 },
	'colordataversion' => { 32 => 0x0, 33 => 0x0, 35 => 0x0, 36 => 0x0 },
	'coloreffect' => { 246 => 0x28 },
	'colorfilter' => { 87 => 0x17, 88 => 0x3017, 144 => 0x29, 152 => [0x38,0x4d,0x4f], 282 => 0x17 },
	'colorgain' => { 182 => 0x51 },
	'colorhue' => { 177 => 0x8d },
	'colorimetricreference' => { 92 => 0xc6bf },
	'colorlabel' => { 345 => 'ColorLabel' },
	'colormatrix' => { 231 => 0x200, 232 => 0x1011, 299 => 0xa030 },
	'colormatrix1' => { 92 => 0xc621 },
	'colormatrix2' => { 92 => 0xc622, 235 => 0x200 },
	'colormatrixa' => { 277 => 0x203 },
	'colormatrixadobergb' => { 299 => 0xa032 },
	'colormatrixb' => { 277 => 0x204 },
	'colormatrixnumber' => { 232 => 0x1019 },
	'colormatrixsrgb' => { 299 => 0xa031 },
	'colormode' => { 88 => 0x3015, 97 => 0x1210, 108 => 0x66, 144 => 0x28, 147 => 0x16, 149 => 0x101, 150 => 0x36, 152 => 0x7, 177 => 0x3, 200 => 0x4, 246 => 0x32, 302 => 0x2c, 316 => 0xb029, 353 => 'ColorMode' },
	'colormoirereduction' => { 211 => 0x15 },
	'colormoirereductionmode' => { 211 => 0x5 },
	'colornoisereduction' => { 328 => 0x8029, 342 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 342 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 211 => 0x18 },
	'colornoisereductionsharpness' => { 211 => 0x1c },
	'colorplanes' => { 96 => 0x2 },
	'colorprofile' => { 144 => 0x33 },
	'colorrepresentation' => { 102 => 0x3c },
	'colorsequence' => { 102 => 0x41 },
	'colorspace' => { 37 => 0x3, 48 => 0xb4, 78 => 0x10b4, 92 => 0xa001, 128 => 'ColorSpace', 145 => 0x2f, 146 => 0x25, 147 => 0x17, 177 => 0x1e, 227 => 0x507, 277 => 0x37, 299 => 0xa011, 302 => 0xb, 305 => 0x1b, 306 => 0x83, 307 => 0xe, 317 => 0x6, 346 => 'ColorSpace' },
	'colortempasshot' => { 29 => 0x4, 30 => 0x1d, 31 => 0x26, 32 => 0x43, 35 => 0x43, 36 => 0x43 },
	'colortempauto' => { 29 => 0x9, 30 => 0x22, 31 => 0x1c, 32 => 0x48, 35 => 0x48, 36 => 0x48 },
	'colortempcloudy' => { 29 => 0x22, 30 => 0x31, 31 => 0x35, 32 => 0x5c, 35 => 0x75, 36 => 0x75, 277 => 0x55 },
	'colortempcustom' => { 32 => 0x84 },
	'colortempcustom1' => { 30 => 0x45 },
	'colortempcustom2' => { 30 => 0x4a },
	'colortempdaylight' => { 29 => 0x18, 30 => 0x27, 31 => 0x2b, 32 => 0x52, 35 => 0x6b, 36 => 0x6b, 277 => 0x53 },
	'colortemperature' => { 4 => 0x73, 5 => [0x48,0x4e], 6 => 0xc0, 7 => 0x37, 8 => 0x62, 9 => 0x37, 10 => 0x7c, 11 => 0x73, 12 => 0x73, 13 => 0x77, 14 => 0x73, 15 => 0x7c, 16 => 0x58, 17 => 0x73, 18 => 0xc0, 19 => 0x7f, 20 => 0x7d, 21 => 0xc0, 22 => 0x7b, 48 => 0xae, 57 => 0x9, 78 => 0x10ae, 97 => 0x1005, 106 => 0x846, 122 => 'ColorTemperature', 145 => [0x6e,0x49], 146 => 0x3f, 147 => [0x39,0x5e], 149 => 0x10b, 152 => [0x3c,0x4c,0x4e], 242 => 0x321, 277 => 0x50, 316 => 0xb021, 342 => 'Temperature' },
	'colortemperatureadj' => { 328 => 0x8013 },
	'colortemperaturebg' => { 232 => 0x1013 },
	'colortemperaturerg' => { 232 => 0x1014 },
	'colortemperaturesetting' => { 147 => 0x25, 305 => 0xc, 306 => 0xb, 307 => 0x17, 317 => 0xe },
	'colortempflash' => { 29 => 0x36, 30 => 0x40, 31 => 0x49, 32 => 0x70, 35 => 0x89, 36 => 0x89, 277 => 0x5a },
	'colortempflashdata' => { 32 => 0x24a },
	'colortempfluorescent' => { 29 => 0x2c, 30 => 0x3b, 31 => 0x3f, 32 => 0x66, 35 => 0x7f, 36 => 0x7f },
	'colortempfluorescentd' => { 277 => 0x57 },
	'colortempfluorescentn' => { 277 => 0x58 },
	'colortempfluorescentw' => { 277 => 0x59 },
	'colortempkelvin' => { 29 => 0x31, 31 => 0x44, 32 => 0x6b, 35 => 0x84, 36 => 0x84, 246 => 0x44 },
	'colortempmeasured' => { 29 => 0xe, 32 => 0x4d, 35 => 0x4d, 36 => 0x4d },
	'colortemppc1' => { 31 => 0x94, 32 => 0x75 },
	'colortemppc2' => { 31 => 0x99, 32 => 0x7a },
	'colortemppc3' => { 31 => 0x9e, 32 => 0x7f },
	'colortempshade' => { 29 => 0x1d, 30 => 0x2c, 31 => 0x30, 32 => 0x57, 35 => 0x70, 36 => 0x70, 277 => 0x54 },
	'colortemptungsten' => { 29 => 0x27, 30 => 0x36, 31 => 0x3a, 32 => 0x61, 35 => 0x7a, 36 => 0x7a, 277 => 0x56 },
	'colortempunknown' => { 29 => 0x13, 31 => 0x21, 35 => 0x52, 36 => 0x52 },
	'colortempunknown10' => { 29 => 0x63, 31 => 0x76, 35 => 0xa2, 36 => 0xa2 },
	'colortempunknown11' => { 29 => 0x68, 31 => 0x7b, 35 => 0xa7, 36 => 0xa7 },
	'colortempunknown12' => { 29 => 0x6d, 31 => 0x80, 35 => 0xac, 36 => 0xac },
	'colortempunknown13' => { 29 => 0x72, 31 => 0x85, 35 => 0xb1, 36 => 0xb1 },
	'colortempunknown14' => { 31 => 0x8a, 35 => 0xb6, 36 => 0xb6 },
	'colortempunknown15' => { 31 => 0x8f, 35 => 0xbb, 36 => 0xbb },
	'colortempunknown16' => { 31 => 0xa3, 36 => 0xc0 },
	'colortempunknown17' => { 36 => 0xc5 },
	'colortempunknown18' => { 36 => 0xca },
	'colortempunknown19' => { 36 => 0xcf },
	'colortempunknown2' => { 29 => 0x3b, 31 => 0x4e, 35 => 0x57, 36 => 0x57 },
	'colortempunknown20' => { 36 => 0xd4 },
	'colortempunknown3' => { 29 => 0x40, 31 => 0x53, 35 => 0x5c, 36 => 0x5c },
	'colortempunknown4' => { 29 => 0x45, 31 => 0x58, 35 => 0x61, 36 => 0x61 },
	'colortempunknown5' => { 29 => 0x4a, 31 => 0x5d, 35 => 0x66, 36 => 0x66 },
	'colortempunknown6' => { 29 => 0x4f, 31 => 0x62, 35 => 0x8e, 36 => 0x8e },
	'colortempunknown7' => { 29 => 0x54, 31 => 0x67, 35 => 0x93, 36 => 0x93 },
	'colortempunknown8' => { 29 => 0x59, 31 => 0x6c, 35 => 0x98, 36 => 0x98 },
	'colortempunknown9' => { 29 => 0x5e, 31 => 0x71, 35 => 0x9d, 36 => 0x9d },
	'colortone' => { 7 => 0x6f, 9 => 0x77, 26 => 0x2a, 37 => 0x2 },
	'colortoneadj' => { 83 => 0x11e },
	'colortonefaithful' => { 16 => 0x107, 53 => 0x6c, 54 => 0x6c },
	'colortonelandscape' => { 16 => 0x105, 53 => 0x3c, 54 => 0x3c },
	'colortonemonochrome' => { 53 => 0x84, 54 => 0x84 },
	'colortoneneutral' => { 16 => 0x106, 53 => 0x54, 54 => 0x54 },
	'colortoneportrait' => { 16 => 0x104, 53 => 0x24, 54 => 0x24 },
	'colortonestandard' => { 16 => 0x103, 53 => 0xc, 54 => 0xc },
	'colortoneunknown' => { 54 => 0x9c },
	'colortoneuserdef1' => { 16 => 0x109, 53 => 0x9c, 54 => 0xb4 },
	'colortoneuserdef2' => { 16 => 0x10a, 53 => 0xb4, 54 => 0xcc },
	'colortoneuserdef3' => { 16 => 0x10b, 53 => 0xcc, 54 => 0xe4 },
	'commanddials' => { 224 => '5.1' },
	'commanddialsaperturesetting' => { 217 => '17.3', 222 => '33.3', 223 => '17.3' },
	'commanddialschangemainsub' => { 217 => '17.2', 222 => '33.2', 223 => '17.2' },
	'commanddialsmenuandplayback' => { 217 => '17.4', 222 => '33.4', 223 => '17.4' },
	'commanddialsreverserotation' => { 217 => '17.1', 219 => '16.2', 220 => '17.2', 222 => '33.1', 223 => '17.1', 226 => '18.1' },
	'commanderchannel' => { 224 => '10.2', 225 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 224 => '13.1', 225 => '31.1' },
	'commandergroupa_ttlcomp' => { 226 => '32.1' },
	'commandergroupamanualoutput' => { 224 => '13.2', 225 => '28.2' },
	'commandergroupamode' => { 224 => '11.2', 225 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 224 => '14.1', 225 => '32.1' },
	'commandergroupb_ttlcomp' => { 226 => '33.1' },
	'commandergroupbmanualoutput' => { 224 => '14.2', 225 => '29.2' },
	'commandergroupbmode' => { 224 => '11.3', 225 => '29.1' },
	'commanderinternalflash' => { 224 => '11.1', 225 => '27.1' },
	'commanderinternalmanualoutput' => { 224 => '12.2', 225 => '27.2' },
	'commanderinternalttlchannel' => { 222 => '18.2' },
	'commanderinternalttlcomp' => { 224 => '12.1', 225 => '30.2', 226 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 222 => '20.1', 223 => '26.1' },
	'commanderinternalttlcompgroupa' => { 222 => '21.1', 223 => '27.1' },
	'commanderinternalttlcompgroupb' => { 222 => '22.1', 223 => '28.1' },
	'comment' => { 0 => 0x2, 93 => 'Comment', 123 => 'Comment', 238 => 'Comment' },
	'complianceprofile' => { 355 => 'complianceProfile' },
	'componentsconfiguration' => { 92 => 0x9101, 128 => 'Components', 346 => 'ComponentsConfiguration' },
	'componentversion' => { 78 => 0x80c },
	'composer' => { 364 => 'composer' },
	'compositionadjust' => { 276 => '0.1' },
	'compositionadjustrotation' => { 276 => 0x7 },
	'compositionadjustx' => { 276 => 0x5 },
	'compositionadjusty' => { 276 => 0x6 },
	'compressedbitsperpixel' => { 92 => 0x9102, 346 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 149 => 0x40, 232 => 0x40 },
	'compression' => { 92 => 0x103, 360 => 'Compression' },
	'compressionfactor' => { 227 => 0x50d },
	'compressionratio' => { 128 => 'Compression', 232 => 0x1034 },
	'confidencelevel' => { 338 => 'ConfidenceLevel' },
	'constrainedcropheight' => { 83 => 0x266, 284 => 0xd6 },
	'constrainedcropwidth' => { 83 => 0x262, 284 => 0xd5 },
	'contact' => { 100 => 0x76 },
	'contentlocationcode' => { 100 => 0x1a },
	'contentlocationname' => { 100 => 0x1b },
	'continuousbracketing' => { 147 => 0x20 },
	'continuousdrive' => { 26 => 0x5 },
	'continuousshootingspeed' => { 65 => 0x610 },
	'continuousshotlimit' => { 65 => 0x611 },
	'contrast' => { 7 => 0x73, 9 => 0x75, 26 => 0xd, 87 => 0xc, 88 => [0x3012,0x20], 92 => [0xa408,0xfe54], 97 => [0x1004,0x1006], 122 => 'Contrast', 144 => 0x20, 145 => 0x31, 146 => 0x27, 147 => 0x19, 152 => 0x2, 179 => 0x33, 232 => 0x1029, 246 => 0x39, 248 => 0x300a, 277 => 0x20, 282 => 0xc, 290 => 0x24, 302 => 0xd, 305 => 0x1d, 306 => 0x1a, 316 => 0x2004, 342 => 'Contrast', 346 => 'Contrast' },
	'contrast2012' => { 342 => 'Contrast2012' },
	'contrastadj' => { 83 => 0x115, 213 => 0x2c, 328 => 0x8017 },
	'contrastcurve' => { 177 => 0x8c },
	'contrastdetectaf' => { 155 => 0x4 },
	'contrastdetectafarea' => { 277 => 0x231 },
	'contrastdetectafinfocus' => { 155 => 0x1c },
	'contrastfaithful' => { 16 => 0xec, 53 => 0x60, 54 => 0x60 },
	'contrasthighlight' => { 277 => 0x6d },
	'contrasthighlightshadowadj' => { 277 => 0x6f },
	'contrastlandscape' => { 16 => 0xea, 53 => 0x30, 54 => 0x30 },
	'contrastmode' => { 246 => 0x2c },
	'contrastmonochrome' => { 16 => 0xed, 53 => 0x78, 54 => 0x78 },
	'contrastneutral' => { 16 => 0xeb, 53 => 0x48, 54 => 0x48 },
	'contrastportrait' => { 16 => 0xe9, 53 => 0x18, 54 => 0x18 },
	'contrastsetting' => { 227 => 0x505, 235 => 0x1012, 307 => 0x10, 317 => 0x8 },
	'contrastshadow' => { 277 => 0x6e },
	'contraststandard' => { 16 => 0xe8, 53 => 0x0, 54 => 0x0 },
	'contrastunknown' => { 54 => 0x90 },
	'contrastuserdef1' => { 16 => 0xee, 53 => 0x90, 54 => 0xa8 },
	'contrastuserdef2' => { 16 => 0xef, 53 => 0xa8, 54 => 0xc0 },
	'contrastuserdef3' => { 16 => 0xf0, 53 => 0xc0, 54 => 0xd8 },
	'contributedmedia' => { 364 => 'contributedMedia' },
	'contributedmediaduration' => { 364 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 364 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 364 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 364 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 364 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 364 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 364 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 364 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 364 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 364 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 343 => 'contributor' },
	'contributors' => { 123 => 'Contributors' },
	'controldialset' => { 147 => 0x46 },
	'controlledvocabularyterm' => { 351 => 'CVterm' },
	'controllerboardversion' => { 242 => 0x332 },
	'controlmode' => { 59 => 0x12 },
	'conversionlens' => { 228 => 0x403, 246 => 0x35 },
	'converter' => { 92 => 0xfe4d, 200 => 0xb, 342 => 'Converter' },
	'converttograyscale' => { 342 => 'ConvertToGrayscale' },
	'copyright' => { 0 => 0x3, 92 => 0x8298, 123 => 'Copyright', 238 => 'Copyright', 277 => 0x22f, 289 => 'Copyright', 352 => 'Copyright', 355 => 'copyright', 357 => 'copyright', 360 => 'Copyright', 364 => 'copyright' },
	'copyrightflag' => { 287 => 0x40a },
	'copyrightnotice' => { 100 => 0x74 },
	'copyrightowner' => { 354 => 'CopyrightOwner' },
	'copyrightownerid' => { 354 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 354 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 354 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 354 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 354 => 'CopyrightStatus' },
	'coringfilter' => { 231 => 0x310, 232 => 0x102d, 235 => 0x310 },
	'coringvalues' => { 231 => 0x311, 235 => 0x311 },
	'corporateentity' => { 355 => 'corporateEntity' },
	'country' => { 127 => 'Country', 246 => 0x69, 353 => 'Country' },
	'country-primarylocationcode' => { 100 => 0x64 },
	'country-primarylocationname' => { 100 => 0x65 },
	'countrycode' => { 176 => 0x5, 285 => 'CountryCode', 350 => 'CountryCode' },
	'coverage' => { 343 => 'coverage' },
	'coverdate' => { 355 => 'coverDate' },
	'coverdisplaydate' => { 355 => 'coverDisplayDate' },
	'cpufirmwareversion' => { 277 => 0x28 },
	'crc32' => { 344 => 'crc32' },
	'createdate' => { 92 => 0x9004, 123 => 'CreateDate', 236 => 'CreationDate', 238 => 'create-date', 289 => 'CreationDate', 362 => 'CreateDate' },
	'creationdate' => { 352 => 'CreationDate', 355 => 'creationDate' },
	'creationtime' => { 238 => 'Creation Time' },
	'creativestyle' => { 305 => 0x1a, 306 => 0x18, 315 => 0x41, 316 => 0xb020 },
	'creativestylesetting' => { 307 => 0xf, 317 => 0x7 },
	'creativestylewaschanged' => { 328 => 0x8001 },
	'creator' => { 236 => 'Creator', 289 => 'Creator', 343 => 'creator', 352 => 'Creator' },
	'creatoraddress' => { 350 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorcity' => { 350 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 350 => 'CreatorContactInfo' },
	'creatorcountry' => { 350 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatorpostalcode' => { 350 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 350 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatortool' => { 362 => 'CreatorTool' },
	'creatorworkemail' => { 350 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 350 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 350 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 100 => 0x6e, 353 => 'Credit' },
	'creditline' => { 357 => 'creditLine' },
	'creditlinereq' => { 367 => 'CreditLineReq' },
	'creditlinerequired' => { 354 => 'CreditLineRequired' },
	'cropactive' => { 83 => 0x244 },
	'cropangle' => { 342 => 'CropAngle' },
	'cropaspectratio' => { 83 => 0x260 },
	'cropbottom' => { 96 => 0x9, 205 => 0x36, 284 => 0xdc, 342 => 'CropBottom' },
	'cropbottommargin' => { 39 => 0x3 },
	'cropcircleactive' => { 84 => 0xd6 },
	'cropcircleradius' => { 84 => 0xd9 },
	'cropcirclex' => { 84 => 0xd7 },
	'cropcircley' => { 84 => 0xd8 },
	'cropconstraintowarp' => { 342 => 'CropConstrainToWarp' },
	'croph' => { 336 => 'CropH' },
	'cropheight' => { 83 => 0x24c, 231 => 0x615, 235 => 0x615, 342 => 'CropHeight' },
	'crophispeed' => { 177 => 0x1b },
	'cropleft' => { 83 => 0x246, 96 => 0x6, 205 => 0x1e, 231 => 0x612, 235 => 0x612, 284 => 0xd9, 342 => 'CropLeft' },
	'cropleftmargin' => { 39 => 0x0 },
	'cropoutputheight' => { 205 => 0xce },
	'cropoutputheightinches' => { 205 => 0x96 },
	'cropoutputpixels' => { 205 => 0xd6 },
	'cropoutputresolution' => { 205 => 0xb6 },
	'cropoutputscale' => { 205 => 0xbe },
	'cropoutputwidth' => { 205 => 0xc6 },
	'cropoutputwidthinches' => { 205 => 0x8e },
	'croppedareaimageheightpixels' => { 332 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 332 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 332 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 332 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 3 => 0x2 },
	'croppedimageleft' => { 3 => 0x3 },
	'croppedimagetop' => { 3 => 0x4 },
	'croppedimagewidth' => { 3 => 0x1 },
	'cropright' => { 96 => 0x8, 205 => 0x2e, 284 => 0xdb, 342 => 'CropRight' },
	'croprightmargin' => { 39 => 0x1 },
	'croprotation' => { 96 => 0xb },
	'cropscaledresolution' => { 205 => 0x9e },
	'cropsourceresolution' => { 205 => 0xae },
	'croptop' => { 83 => 0x248, 96 => 0x7, 205 => 0x26, 231 => 0x613, 235 => 0x613, 284 => 0xda, 342 => 'CropTop' },
	'croptopmargin' => { 39 => 0x2 },
	'cropunit' => { 342 => 'CropUnit' },
	'cropunits' => { 342 => 'CropUnits' },
	'cropw' => { 336 => 'CropW' },
	'cropwidth' => { 83 => 0x24a, 231 => 0x614, 235 => 0x614, 342 => 'CropWidth' },
	'cropx' => { 336 => 'CropX' },
	'cropy' => { 336 => 'CropY' },
	'crossprocess' => { 277 => 0x7b },
	'crossprocessparams' => { 277 => 0x235 },
	'currenticcprofile' => { 92 => 0xc691 },
	'currentpreprofilematrix' => { 92 => 0xc692 },
	'currentversion' => { 328 => 0xd000 },
	'curve0x' => { 336 => 'Curve0x' },
	'curve0y' => { 336 => 'Curve0y' },
	'curve1x' => { 336 => 'Curve1x' },
	'curve1y' => { 336 => 'Curve1y' },
	'curve2x' => { 336 => 'Curve2x' },
	'curve2y' => { 336 => 'Curve2y' },
	'curve3x' => { 336 => 'Curve3x' },
	'curve3y' => { 336 => 'Curve3y' },
	'curve4x' => { 336 => 'Curve4x' },
	'curve4y' => { 336 => 'Curve4y' },
	'curves' => { 210 => 0x76a43201 },
	'custom1' => { 354 => 'Custom1' },
	'custom10' => { 354 => 'Custom10' },
	'custom2' => { 354 => 'Custom2' },
	'custom3' => { 354 => 'Custom3' },
	'custom4' => { 354 => 'Custom4' },
	'custom5' => { 354 => 'Custom5' },
	'custom6' => { 354 => 'Custom6' },
	'custom7' => { 354 => 'Custom7' },
	'custom8' => { 354 => 'Custom8' },
	'custom9' => { 354 => 'Custom9' },
	'customcontrast' => { 84 => 0x4e },
	'customcontrols' => { 65 => 0x70c },
	'customdefaultunsharpfineness' => { 84 => 0xbe },
	'customdefaultunsharpstrength' => { 84 => 0xbc },
	'customdefaultunsharpthreshold' => { 84 => 0xc0 },
	'customlinear' => { 84 => 0x4f },
	'customoutputhighlightpoint' => { 84 => 0x53 },
	'customoutputshadowpoint' => { 84 => 0x54 },
	'custompicturestylefilename' => { 48 => 0x4010 },
	'customrawhighlight' => { 84 => 0x7c },
	'customrawhighlightpoint' => { 84 => 0x51 },
	'customrawshadow' => { 84 => 0x85 },
	'customrawshadowpoint' => { 84 => 0x52 },
	'customrendered' => { 92 => 0xa401, 346 => 'CustomRendered' },
	'customsaturation' => { 227 => 0x503 },
	'customsettingsalldefault' => { 217 => '0.2', 222 => '0.2' },
	'customsettingsbank' => { 217 => '0.1', 222 => '0.1' },
	'customsharpness' => { 84 => 0x50 },
	'customunsharpmaskfineness' => { 84 => 0xb8 },
	'customunsharpmaskstrength' => { 84 => 0xb6 },
	'customunsharpmaskthreshold' => { 84 => 0xba },
	'customwb_rblevels' => { 317 => 0x1a },
	'customwb_rgblevels' => { 307 => 0x19 },
	'customwbbluelevel' => { 147 => 0x36 },
	'customwberror' => { 147 => 0x37 },
	'customwbgreenlevel' => { 147 => 0x35 },
	'customwbredlevel' => { 147 => 0x34 },
	'customwbsetting' => { 147 => 0x26 },
	'd-lightinghq' => { 210 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 206 => 0x2 },
	'd-lightinghqhighlight' => { 206 => 0x1 },
	'd-lightinghqselected' => { 210 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 206 => 0x0 },
	'd-lightinghs' => { 210 => 0xce5554aa },
	'd-lightinghsadjustment' => { 207 => 0x0 },
	'd-lightinghscolorboost' => { 207 => 0x1 },
	'd-rangeoptimizerhighlight' => { 328 => 0x8024 },
	'd-rangeoptimizermode' => { 328 => 0x8022 },
	'd-rangeoptimizershadow' => { 328 => 0x802d },
	'd-rangeoptimizervalue' => { 328 => 0x8023 },
	'datacompressionmethod' => { 102 => 0x6e },
	'dataimprint' => { 144 => 0x34 },
	'date' => { 277 => 0x6, 343 => 'date' },
	'dateacquired' => { 142 => 'DateAcquired' },
	'datecreated' => { 100 => 0x37, 353 => 'DateCreated' },
	'datedisplayformat' => { 202 => 0x3 },
	'dateidentified' => { 91 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 219 => '4.2' },
	'daterecieved' => { 355 => 'dateRecieved' },
	'datesent' => { 101 => 0x46 },
	'datestampmode' => { 48 => 0x1c },
	'datetime' => { 337 => 'datetime', 360 => 'DateTime' },
	'datetimedigitized' => { 346 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 81 => 0x0, 92 => 0x9003, 120 => 0x14, 123 => 'OriginalDate', 290 => 0xb, 346 => 'DateTimeOriginal' },
	'datetimestamp' => { 108 => 0x64 },
	'daylightsavings' => { 60 => 0x3, 202 => 0x2 },
	'dccontinent' => { 91 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 91 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 91 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 91 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 91 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 91 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 91 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 91 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 91 => 'Event' },
	'dcfootprintspatialfit' => { 91 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 91 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 91 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 91 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 91 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceprotocol' => { 91 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 91 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 91 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 91 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 91 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 91 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 91 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 91 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 91 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 91 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 91 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 91 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 91 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 91 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 91 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 91 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 91 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 91 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 91 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 91 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 91 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 91 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 91 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 91 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 91 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 91 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 91 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 91 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 91 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 91 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcwaterbody' => { 91 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 131 => 'Declination' },
	'decposition' => { 144 => 0x32 },
	'defaultblackrender' => { 92 => 0xc7a6 },
	'defaultcroporigin' => { 92 => 0xc61f },
	'defaultcropsize' => { 92 => 0xc620 },
	'defaulteraseoption' => { 65 => 0x813 },
	'defaultscale' => { 92 => 0xc61e },
	'defaultusercrop' => { 92 => 0xc7b5 },
	'defringe' => { 342 => 'Defringe' },
	'defringegreenamount' => { 342 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 342 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 342 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 342 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 342 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 342 => 'DefringePurpleHueLo' },
	'deletedimagecount' => { 177 => 0xa6, 183 => 0x6e },
	'deprecatedon' => { 340 => 'deprecatedOn' },
	'derivedfrom' => { 365 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 365 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 365 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 365 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 365 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 365 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 365 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfrommanager' => { 365 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 365 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 365 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 365 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 365 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 365 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 365 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromrenditionclass' => { 365 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 365 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 365 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 365 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 238 => 'Description', 343 => 'description', 362 => 'Description' },
	'destination' => { 101 => 0x5 },
	'destinationcity' => { 277 => 0x24, 281 => 0x3 },
	'destinationcitycode' => { 282 => 0x1001 },
	'destinationdst' => { 277 => 0x26, 281 => '0.3' },
	'developmentdynamicrange' => { 97 => 0x1403 },
	'devicesettingdescription' => { 346 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 346 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 346 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 346 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'dialdirectiontvav' => { 65 => 0x706 },
	'digitalcreationdate' => { 100 => 0x3e },
	'digitalcreationtime' => { 100 => 0x3f },
	'digitaldeehighlightadj' => { 182 => 0x202 },
	'digitaldeeshadowadj' => { 182 => 0x200 },
	'digitaldeethreshold' => { 182 => 0x201 },
	'digitalfilter' => { 302 => 0x59 },
	'digitalfilter01' => { 264 => 0x5 },
	'digitalfilter02' => { 264 => 0x16 },
	'digitalfilter03' => { 264 => 0x27 },
	'digitalfilter04' => { 264 => 0x38 },
	'digitalfilter05' => { 264 => 0x49 },
	'digitalfilter06' => { 264 => 0x5a },
	'digitalfilter07' => { 264 => 0x6b },
	'digitalfilter08' => { 264 => 0x7c },
	'digitalfilter09' => { 264 => 0x8d },
	'digitalfilter10' => { 264 => 0x9e },
	'digitalfilter11' => { 264 => 0xaf },
	'digitalfilter12' => { 264 => 0xc0 },
	'digitalfilter13' => { 264 => 0xd1 },
	'digitalfilter14' => { 264 => 0xe2 },
	'digitalfilter15' => { 264 => 0xf3 },
	'digitalfilter16' => { 264 => 0x104 },
	'digitalfilter17' => { 264 => 0x115 },
	'digitalfilter18' => { 264 => 0x126 },
	'digitalfilter19' => { 264 => 0x137 },
	'digitalfilter20' => { 264 => 0x148 },
	'digitalgain' => { 57 => 0xb },
	'digitalgem' => { 169 => 0x0 },
	'digitalice' => { 182 => 0x100 },
	'digitalimageguid' => { 351 => 'DigImageGUID' },
	'digitalroc' => { 181 => 0x0 },
	'digitalsourcefiletype' => { 351 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 351 => 'DigitalSourceType' },
	'digitalzoom' => { 26 => 0xc, 87 => 0xa, 108 => 0x68, 122 => 'DigitalZoom', 144 => 0xc, 177 => 0x86, 200 => 0xa, 232 => 0x204, 277 => 0x1e, 282 => 0xa, 301 => 0x204 },
	'digitalzoomon' => { 301 => 0x21b },
	'digitalzoomratio' => { 92 => 0xa404, 346 => 'DigitalZoomRatio' },
	'director' => { 364 => 'director' },
	'directorphotography' => { 364 => 'directorPhotography' },
	'directory' => { 93 => 'Directory' },
	'directoryindex' => { 4 => 0x137, 6 => 0x2dc, 8 => 0x17e, 10 => 0x238, 11 => 0x13f, 12 => 0x133, 13 => 0x1df, 14 => 0x1a7, 15 => 0x1f0, 16 => 0xcc, 17 => 0x1c7, 18 => 0x298, 19 => 0x1e7, 20 => 0x1e5, 21 => 0x27c, 22 => 0x1f7 },
	'directoryindex2' => { 18 => 0x29c },
	'directorynumber' => { 165 => 0x6 },
	'disclaimer' => { 238 => 'Disclaimer' },
	'displayallafpoints' => { 65 => 0x514 },
	'displayaperture' => { 26 => 0x23 },
	'displayedunitsx' => { 288 => 0x2 },
	'displayedunitsy' => { 288 => 0x6 },
	'distance1' => { 108 => 0x28 },
	'distance2' => { 108 => 0x2c },
	'distance3' => { 108 => 0x30 },
	'distance4' => { 108 => 0x34 },
	'distortioncontrol' => { 183 => 0x10 },
	'distortioncorrection' => { 84 => 0x67, 227 => 0x50b, 249 => '7.1', 267 => 0x0, 316 => 0x2013 },
	'distortioncorrection2' => { 231 => 0x1011 },
	'distortioncorrectionon' => { 84 => 0x63 },
	'distortionn' => { 249 => 0xc },
	'distortionparam02' => { 249 => 0x2 },
	'distortionparam04' => { 249 => 0x4 },
	'distortionparam08' => { 249 => 0x8 },
	'distortionparam09' => { 249 => 0x9 },
	'distortionparam11' => { 249 => 0xb },
	'distortionscale' => { 249 => 0x5 },
	'distributor' => { 355 => 'distributor' },
	'dloon' => { 84 => 0xdc },
	'dlosetting' => { 84 => 0xdd },
	'dlosettingapplied' => { 84 => 0xe4 },
	'dloshootingdistance' => { 84 => 0xde },
	'dloversion' => { 84 => 0xe5 },
	'dmcomment' => { 364 => 'comment' },
	'dngbackwardversion' => { 92 => 0xc613 },
	'dnglensinfo' => { 92 => 0xc630 },
	'dngversion' => { 92 => 0xc612 },
	'document' => { 238 => 'Document' },
	'documentancestorid' => { 353 => [\'DocumentAncestors','DocumentAncestorsAncestorID'] },
	'documentancestors' => { 353 => 'DocumentAncestors' },
	'documenthistory' => { 100 => 0xe7 },
	'documentid' => { 365 => 'DocumentID' },
	'documentname' => { 92 => 0x10d },
	'documentnotes' => { 100 => 0xe6 },
	'doi' => { 355 => 'doi' },
	'dotrange' => { 92 => 0x150 },
	'dpp' => { 337 => 'dpp' },
	'drivemode' => { 88 => 0x3103, 144 => 0x6, 147 => 0x1e, 150 => 0xe, 227 => 0x600, 277 => 0x34, 302 => 0x3, 305 => 0x4, 306 => 0x7e, 307 => 0x34 },
	'drivemode2' => { 147 => 0xa, 258 => 0x7, 315 => 0xe, 317 => 0x1 },
	'drivemodesetting' => { 307 => 0x4 },
	'dspfirmwareversion' => { 277 => 0x27 },
	'duration' => { 51 => 0x6a, 121 => 'Duration', 135 => 'Duration', 364 => 'duration' },
	'durationscale' => { 364 => [\'duration','durationScale'] },
	'durationvalue' => { 364 => [\'duration','durationValue'] },
	'dustremovaldata' => { 48 => 0x97 },
	'dynamicafarea' => { 217 => '1.4', 222 => '1.4' },
	'dynamicrange' => { 97 => 0x1400 },
	'dynamicrangeexpansion' => { 277 => 0x69 },
	'dynamicrangemax' => { 83 => 0x7c },
	'dynamicrangemin' => { 83 => 0x7a },
	'dynamicrangeoptimizer' => { 147 => 0x15, 316 => [0xb025,0xb04f] },
	'dynamicrangeoptimizerbracket' => { 315 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 305 => 0x19, 306 => 0x17, 307 => 0xd, 317 => 0x5 },
	'dynamicrangeoptimizermode' => { 150 => 0x15, 305 => 0x18, 306 => 0x16, 315 => 0x15 },
	'dynamicrangeoptimizersetting' => { 147 => 0x27, 307 => 0xc, 317 => 0x4 },
	'dynamicrangesetting' => { 97 => 0x1402 },
	'e-dialinprogram' => { 258 => '1.3' },
	'earliestageorloweststage' => { 91 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 91 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 91 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 91 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 91 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'easyexposurecomp' => { 226 => '6.1' },
	'easyexposurecompensation' => { 217 => '6.4', 222 => '4.4', 223 => '5.2' },
	'easymode' => { 26 => 0xb },
	'edgenoisereduction' => { 211 => 0x4, 328 => 0x8028 },
	'edition' => { 355 => 'edition' },
	'editorialupdate' => { 100 => 0x8 },
	'editstatus' => { 100 => 0x7, 285 => 'EditStatus' },
	'editversionname' => { 210 => 0x3d136244 },
	'effectivelv' => { 277 => 0x2d },
	'effectivemaxaperture' => { 173 => 0x12, 174 => 0x13 },
	'eissn' => { 355 => 'eIssn' },
	'elevation' => { 131 => 'Elevation' },
	'email' => { 123 => 'EMail' },
	'embargodate' => { 355 => 'embargoDate', 357 => 'embargoDate' },
	'emissivity' => { 94 => 0x3 },
	'encryptionkey' => { 299 => 0xa020 },
	'endingpage' => { 355 => 'endingPage' },
	'enduser' => { 354 => 'EndUser' },
	'enduserid' => { 354 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 354 => [\'EndUser','EndUserEndUserName'] },
	'engineer' => { 364 => 'engineer' },
	'enhancedarktones' => { 203 => 0x8 },
	'enhancement' => { 87 => 0x16, 88 => 0x3016 },
	'enhancer' => { 231 => 0x300 },
	'enhancervalues' => { 231 => 0x301 },
	'envelopenumber' => { 101 => 0x28 },
	'envelopepriority' => { 101 => 0x3c },
	'enveloperecordversion' => { 101 => 0x0 },
	'epsonimageheight' => { 232 => 0x20c },
	'epsonimagewidth' => { 232 => 0x20b },
	'epsonsoftware' => { 232 => 0x20d },
	'equipmentinstitution' => { 330 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 330 => 'EquipmentManufacturer' },
	'equipmentversion' => { 228 => 0x0 },
	'ettlii' => { 65 => 0x304, 66 => 0xd, 67 => 0xe, 68 => 0x7, 69 => 0x7, 70 => 0xe },
	'event' => { 335 => 'Event', 351 => 'Event', 355 => 'event' },
	'eventday' => { 91 => [\'Event','EventDay'] },
	'eventearliestdate' => { 91 => [\'Event','EventEarliestDate'] },
	'eventenddayofyear' => { 91 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 91 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 91 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 91 => [\'Event','EventHabitat'] },
	'eventid' => { 91 => [\'Event','EventEventID'] },
	'eventlatestdate' => { 91 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 91 => [\'Event','EventMonth'] },
	'eventnumber' => { 290 => 0x9 },
	'eventremarks' => { 91 => [\'Event','EventEventRemarks'] },
	'eventsamplingeffort' => { 91 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 91 => [\'Event','EventSamplingProtocol'] },
	'eventstartdayofyear' => { 91 => [\'Event','EventStartDayOfYear'] },
	'eventtime' => { 91 => [\'Event','EventEventTime'] },
	'eventverbatimeventdate' => { 91 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 91 => [\'Event','EventYear'] },
	'evsteps' => { 258 => '1.2', 260 => 0x0 },
	'evstepsize' => { 219 => '5.1', 220 => '6.1', 221 => '6.1', 224 => '0.7' },
	'exclusivityenddate' => { 357 => 'exclusivityEndDate' },
	'excursiontolerance' => { 102 => 0x82 },
	'exif' => { 93 => 'EXIF' },
	'exifbyteorder' => { 93 => 'ExifByteOrder' },
	'exifcamerainfo' => { 100 => 0xe8 },
	'exifimageheight' => { 92 => 0xa003, 346 => 'PixelYDimension' },
	'exifimagewidth' => { 92 => 0xa002, 346 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 93 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 92 => 0x9000, 346 => 'ExifVersion' },
	'exitpupilposition' => { 173 => 0x4, 174 => 0x4 },
	'expirationdate' => { 100 => 0x25, 355 => 'expirationDate', 357 => 'expirationDate' },
	'expirationtime' => { 100 => 0x26 },
	'exposure' => { 92 => 0xfe51, 342 => 'Exposure' },
	'exposure2012' => { 342 => 'Exposure2012' },
	'exposureadj' => { 208 => 0x0 },
	'exposureadj2' => { 208 => 0x12 },
	'exposureadjust' => { 302 => 0xc },
	'exposurebracketingindicatorlast' => { 147 => 0x52 },
	'exposurebracketshotnumber' => { 150 => 0x2d, 315 => 0x2f },
	'exposurebracketstepsize' => { 258 => 0x8 },
	'exposurebracketvalue' => { 177 => 0x19 },
	'exposurecompensation' => { 59 => 0x6, 74 => 0x0, 92 => 0x9204, 108 => 0x24, 122 => 'ExposureComp', 144 => 0xd, 145 => 0x53, 146 => 0x1e, 150 => 0x49c0, 232 => 0x1006, 277 => 0x16, 299 => 0xa013, 302 => [0xc,0x35,0x4d], 346 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 317 => 0x2a },
	'exposurecompensationmode' => { 147 => 0x47, 150 => 0x2a },
	'exposurecompensationset' => { 307 => 0x3, 317 => 0x1e },
	'exposurecompensationsetting' => { 147 => 0x1 },
	'exposurecompstepsize' => { 217 => '6.3', 222 => '4.3' },
	'exposurecontrolstep' => { 223 => '6.1' },
	'exposurecontrolstepsize' => { 217 => '6.2', 222 => '4.2', 226 => '7.1' },
	'exposuredelaymode' => { 217 => '10.1', 219 => '9.1', 220 => '10.1', 221 => '10.1', 222 => '10.4', 223 => '10.1', 224 => '6.4', 226 => '11.2' },
	'exposuredifference' => { 177 => 0xe },
	'exposureindex' => { 92 => 0xa215, 346 => 'ExposureIndex' },
	'exposureindicator' => { 147 => 0x50 },
	'exposurelevelincrements' => { 63 => 0x6, 64 => 0x6, 65 => 0x101, 66 => 0x5, 67 => 0x6, 68 => 0x5, 69 => 0x5, 70 => 0x6, 71 => 0x4, 305 => 0x58, 306 => 0x58 },
	'exposurelockused' => { 332 => 'ExposureLockUsed' },
	'exposuremode' => { 92 => 0xa402, 122 => 'ExposureMode', 144 => 0x1, 145 => 0xa, 146 => 0x0, 147 => 0x0, 150 => 0x34, 227 => 0x200, 244 => 0x40d, 302 => 0x8, 316 => 0xb041, 346 => 'ExposureMode' },
	'exposuremodeinmanual' => { 65 => 0x10b },
	'exposureprogram' => { 92 => 0x8822, 305 => 0x3c, 306 => 0x3c, 307 => 0x5, 311 => 0x14, 315 => 0x3f, 317 => 0x2, 327 => 0x17e, 346 => 'ExposureProgram' },
	'exposureshift' => { 227 => 0x203 },
	'exposuretime' => { 4 => 0x4, 5 => 0x4, 6 => 0x4, 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x6, 24 => 0x7, 59 => 0x16, 92 => 0x829a, 105 => 0xfd05, 108 => 0x20, 110 => 0xfa24, 112 => 0xf104, 115 => 0x12, 117 => 0x38, 120 => 0x10, 122 => 'ExposureTime', 144 => 0x9, 145 => 0x35, 146 => 0x48, 147 => 0x8, 150 => 0x49b8, 277 => 0x12, 299 => 0xa018, 302 => [0x32,0x4a], 305 => 0x0, 306 => 0x0, 317 => 0x27, 346 => 'ExposureTime' },
	'exposuretime2' => { 302 => [0x33,0x4b] },
	'exposuretuning' => { 177 => 0x1c },
	'exposurevalue' => { 106 => 0x3 },
	'exposurewarning' => { 97 => 0x1302 },
	'exrauto' => { 97 => 0x1033 },
	'exrmode' => { 97 => 0x1034 },
	'extendedwbdetect' => { 227 => 0x902 },
	'extender' => { 228 => 0x301 },
	'extenderfirmwareversion' => { 228 => 0x304 },
	'extendermagnification' => { 124 => 'Magnification' },
	'extendermake' => { 124 => 'Make' },
	'extendermodel' => { 124 => 'Model', 228 => 0x303 },
	'extenderserialnumber' => { 124 => 'SerialNumber', 228 => 0x302 },
	'externalflash' => { 230 => 0x1201 },
	'externalflashae1' => { 232 => 0x101f },
	'externalflashae1_0' => { 232 => 0x101b },
	'externalflashae2' => { 232 => 0x1020 },
	'externalflashae2_0' => { 232 => 0x101c },
	'externalflashbounce' => { 230 => 0x1204, 232 => 0x1026, 265 => 0x1a },
	'externalflashcompensation' => { 168 => 0x1b },
	'externalflashexposurecomp' => { 177 => 0x17, 265 => 0x19 },
	'externalflashfirmware' => { 166 => 0x6, 167 => 0x6, 168 => 0x6 },
	'externalflashflags' => { 166 => 0x8, 167 => 0x8, 168 => 0x8 },
	'externalflashguidenumber' => { 230 => 0x1203, 265 => '24.1' },
	'externalflashgvalue' => { 232 => 0x1025 },
	'externalflashmode' => { 232 => 0x1028, 265 => 0x2 },
	'externalflashzoom' => { 230 => 0x1205, 232 => 0x1027 },
	'externalsensorbrightnessvalue' => { 242 => 0x311, 248 => 0x3408 },
	'extrainfoversion' => { 309 => 0x1a },
	'eyestartaf' => { 147 => 0x40 },
	'face10position' => { 85 => 0x3f4, 86 => 0x1ec, 164 => 0x28, 262 => 0x12 },
	'face10size' => { 263 => 0x12 },
	'face11position' => { 164 => 0x2c, 262 => 0x14 },
	'face11size' => { 263 => 0x14 },
	'face12position' => { 164 => 0x30, 262 => 0x16 },
	'face12size' => { 263 => 0x16 },
	'face13position' => { 262 => 0x18 },
	'face13size' => { 263 => 0x18 },
	'face14position' => { 262 => 0x1a },
	'face14size' => { 263 => 0x1a },
	'face15position' => { 262 => 0x1c },
	'face15size' => { 263 => 0x1c },
	'face16position' => { 262 => 0x1e },
	'face16size' => { 263 => 0x1e },
	'face17position' => { 262 => 0x20 },
	'face17size' => { 263 => 0x20 },
	'face18position' => { 262 => 0x22 },
	'face18size' => { 263 => 0x22 },
	'face19position' => { 262 => 0x24 },
	'face19size' => { 263 => 0x24 },
	'face1position' => { 40 => 0x8, 85 => 0xd, 86 => 0x18, 164 => 0x4, 240 => 0x1, 262 => 0x0, 291 => 0xbc, 312 => 0x1, 313 => 0x0, 314 => 0x0 },
	'face1size' => { 263 => 0x0 },
	'face20position' => { 262 => 0x26 },
	'face20size' => { 263 => 0x26 },
	'face21position' => { 262 => 0x28 },
	'face21size' => { 263 => 0x28 },
	'face22position' => { 262 => 0x2a },
	'face22size' => { 263 => 0x2a },
	'face23position' => { 262 => 0x2c },
	'face23size' => { 263 => 0x2c },
	'face24position' => { 262 => 0x2e },
	'face24size' => { 263 => 0x2e },
	'face25position' => { 262 => 0x30 },
	'face25size' => { 263 => 0x30 },
	'face26position' => { 262 => 0x32 },
	'face26size' => { 263 => 0x32 },
	'face27position' => { 262 => 0x34 },
	'face27size' => { 263 => 0x34 },
	'face28position' => { 262 => 0x36 },
	'face28size' => { 263 => 0x36 },
	'face29position' => { 262 => 0x38 },
	'face29size' => { 263 => 0x38 },
	'face2position' => { 40 => 0xa, 85 => 0x7c, 86 => 0x4c, 164 => 0x8, 240 => 0x5, 262 => 0x2, 291 => 0xc8, 312 => 0x6, 313 => 0x20, 314 => 0x25 },
	'face2size' => { 263 => 0x2 },
	'face30position' => { 262 => 0x3a },
	'face30size' => { 263 => 0x3a },
	'face31position' => { 262 => 0x3c },
	'face31size' => { 263 => 0x3c },
	'face32position' => { 262 => 0x3e },
	'face32size' => { 263 => 0x3e },
	'face3position' => { 40 => 0xc, 85 => 0xeb, 86 => 0x80, 164 => 0xc, 240 => 0x9, 262 => 0x4, 291 => 0xd4, 312 => 0xb, 313 => 0x40, 314 => 0x4a },
	'face3size' => { 263 => 0x4 },
	'face4position' => { 40 => 0xe, 85 => 0x15a, 86 => 0xb4, 164 => 0x10, 240 => 0xd, 262 => 0x6, 291 => 0xe0, 312 => 0x10, 313 => 0x60, 314 => 0x6f },
	'face4size' => { 263 => 0x6 },
	'face5position' => { 40 => 0x10, 85 => 0x1c9, 86 => 0xe8, 164 => 0x14, 240 => 0x11, 262 => 0x8, 291 => 0xec, 312 => 0x15, 313 => 0x80, 314 => 0x94 },
	'face5size' => { 263 => 0x8 },
	'face6position' => { 40 => 0x12, 85 => 0x238, 86 => 0x11c, 164 => 0x18, 262 => 0xa, 291 => 0xf8, 312 => 0x1a, 313 => 0xa0, 314 => 0xb9 },
	'face6size' => { 263 => 0xa },
	'face7position' => { 40 => 0x14, 85 => 0x2a7, 86 => 0x150, 164 => 0x1c, 262 => 0xc, 291 => 0x104, 312 => 0x1f, 313 => 0xc0, 314 => 0xde },
	'face7size' => { 263 => 0xc },
	'face8position' => { 40 => 0x16, 85 => 0x316, 86 => 0x184, 164 => 0x20, 262 => 0xe, 291 => 0x110, 312 => 0x24, 313 => 0xe0, 314 => 0x103 },
	'face8size' => { 263 => 0xe },
	'face9position' => { 40 => 0x18, 85 => 0x385, 86 => 0x1b8, 164 => 0x24, 262 => 0x10 },
	'face9size' => { 263 => 0x10 },
	'facedetect' => { 277 => 0x76 },
	'facedetectarea' => { 231 => 0x1201 },
	'facedetectframecrop' => { 231 => 0x1207 },
	'facedetectframesize' => { 40 => 0x3, 85 => 0x1, 86 => 0x4, 164 => 0x1, 231 => 0x1203, 277 => 0x77, 291 => 0xb6 },
	'facedetection' => { 307 => 0x30, 317 => 0x19 },
	'faceid' => { 338 => 'FaceID' },
	'faceinfounknown' => { 88 => 0x2089 },
	'faceorientation' => { 86 => 0x8 },
	'faceposition' => { 261 => 0x2, 300 => 0x4 },
	'facepositions' => { 97 => 0x4103 },
	'facesdetected' => { 40 => 0x2, 41 => 0x2, 42 => 0x3, 85 => 0x0, 86 => 0x2, 88 => 0x211c, 97 => 0x4100, 164 => 0x3, 231 => 0x1200, 246 => 0x3f, 261 => 0x0, 291 => 0xb5, 300 => 0x0, 312 => 0x0, 319 => 0x30 },
	'facesrecognized' => { 241 => 0x0 },
	'facewidth' => { 41 => 0x1 },
	'faithfuloutputhighlightpoint' => { 84 => 0x38 },
	'faithfuloutputshadowpoint' => { 84 => 0x39 },
	'faithfulrawcolortone' => { 84 => 0x31 },
	'faithfulrawcontrast' => { 84 => 0x33 },
	'faithfulrawhighlight' => { 84 => 0x79 },
	'faithfulrawhighlightpoint' => { 84 => 0x36 },
	'faithfulrawlinear' => { 84 => 0x34 },
	'faithfulrawsaturation' => { 84 => 0x32 },
	'faithfulrawshadow' => { 84 => 0x82 },
	'faithfulrawshadowpoint' => { 84 => 0x37 },
	'faithfulrawsharpness' => { 84 => 0x35 },
	'faithfulunsharpmaskfineness' => { 84 => 0xac },
	'faithfulunsharpmaskstrength' => { 84 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 84 => 0xae },
	'femicroadjustment' => { 65 => 0x110 },
	'ffid' => { 344 => 'ffid' },
	'fieldcount' => { 232 => 0x103f },
	'filecreatedate' => { 93 => 'FileCreateDate' },
	'filedatarate' => { 364 => 'fileDataRate' },
	'fileformat' => { 76 => 0x0, 101 => 0x14, 302 => [0x22,0x26], 316 => 0xb000 },
	'fileindex' => { 4 => 0x143, 6 => 0x2d0, 8 => 0x172, 10 => 0x22c, 11 => 0x133, 12 => 0x13f, 13 => 0x1d3, 14 => 0x19b, 15 => 0x1e4, 16 => 0xd0, 17 => 0x1bb, 18 => 0x28c, 19 => 0x1db, 20 => 0x1d9, 21 => 0x270, 22 => 0x1eb, 247 => 0x0 },
	'fileindex2' => { 18 => 0x290 },
	'filemodifydate' => { 93 => 'FileModifyDate' },
	'filename' => { 93 => 'FileName' },
	'filenameasdelivered' => { 354 => 'FileNameAsDelivered' },
	'filenumber' => { 43 => 0x1, 48 => 0x8, 78 => 0x1817, 89 => 'FileNumber', 165 => 0x8 },
	'filenumbermemory' => { 144 => 0x1a },
	'filenumbersequence' => { 217 => '12.2', 219 => '3.1', 220 => '4.1', 221 => '4.1', 222 => '11.1', 223 => '4.3', 226 => '5.2' },
	'filesource' => { 92 => 0xa300, 97 => 0x8000, 346 => 'FileSource' },
	'fileversion' => { 101 => 0x16 },
	'fillflashautoreduction' => { 63 => 0xe, 64 => 0xe, 71 => 0xa },
	'filllight' => { 342 => 'FillLight' },
	'fillorder' => { 92 => 0x10a },
	'filmmode' => { 97 => 0x1401, 244 => 0x412, 246 => 0x42 },
	'filmtype' => { 182 => 0x2 },
	'filtereffect' => { 43 => 0xe, 179 => 0x37 },
	'filtereffectfaithful' => { 53 => 0x70, 54 => 0x70 },
	'filtereffectlandscape' => { 53 => 0x40, 54 => 0x40 },
	'filtereffectmonochrome' => { 16 => 0xff, 53 => 0x88, 54 => 0x88 },
	'filtereffectneutral' => { 53 => 0x58, 54 => 0x58 },
	'filtereffectportrait' => { 53 => 0x28, 54 => 0x28 },
	'filtereffectstandard' => { 53 => 0x10, 54 => 0x10 },
	'filtereffectunknown' => { 54 => 0xa0 },
	'filtereffectuserdef1' => { 53 => 0xa0, 54 => 0xb8 },
	'filtereffectuserdef2' => { 53 => 0xb8, 54 => 0xd0 },
	'filtereffectuserdef3' => { 53 => 0xd0, 54 => 0xe8 },
	'finderdisplayduringexposure' => { 64 => 0x1 },
	'finesharpness' => { 277 => 0x70 },
	'finetuneoptcenterweighted' => { 217 => '7.2', 226 => '9.1' },
	'finetuneoptmatrixmetering' => { 217 => '8.1', 222 => '6.1', 226 => '8.2' },
	'finetuneoptspotmetering' => { 217 => '8.2', 222 => '6.2', 226 => '9.2' },
	'firmware' => { 232 => 0x405, 302 => [0x17,0x3b,0x57], 339 => 'Firmware' },
	'firmwaredate' => { 87 => 0x15, 88 => 0x2001, 290 => 0x4 },
	'firmwareid' => { 151 => 0x0 },
	'firmwarename' => { 299 => 0xa001 },
	'firmwarerevision' => { 16 => 0xa4, 48 => 0x1e, 292 => 0x0 },
	'firmwarerevision2' => { 292 => 0xc },
	'firmwareversion' => { 4 => 0x10b, 8 => 0x136, 11 => 0xff, 12 => 0x107, 106 => 0xce5, 120 => 0x57, 122 => 'FirmwareVersion', 246 => 0x2, 248 => 0x3109, 277 => 0x230, 294 => 0x2 },
	'firstphotodate' => { 332 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 354 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 100 => 0x16 },
	'flash' => { 89 => 'Flash', 92 => 0x9209, 145 => 0x1f, 146 => 0x15, 346 => 'Flash' },
	'flashaction' => { 307 => [0x87,0x287] },
	'flashaction2' => { 317 => 0x30 },
	'flashactivity' => { 26 => 0x1c },
	'flashbatterylevel' => { 32 => 0x249 },
	'flashbias' => { 246 => 0x24 },
	'flashbits' => { 26 => 0x1d },
	'flashbuttonfunction' => { 65 => 0x70e },
	'flashchargelevel' => { 232 => 0x1010 },
	'flashcolorfilter' => { 168 => 0x10 },
	'flashcommandermode' => { 166 => '9.1', 167 => '9.1', 168 => '9.1' },
	'flashcompensation' => { 166 => 0xa, 167 => 0xa, 168 => 0xa, 339 => 'FlashCompensation' },
	'flashcontrol' => { 307 => 0x21 },
	'flashcontrolbuilt-in' => { 222 => '16.1', 223 => '23.1', 225 => '23.1' },
	'flashcontrolmode' => { 166 => '9.2', 167 => '9.2', 168 => '9.2', 227 => 0x404 },
	'flashcurtain' => { 246 => 0x48 },
	'flashdefault' => { 147 => 0x42 },
	'flashdevice' => { 232 => 0x1005 },
	'flashdistance' => { 88 => 0x2034 },
	'flashenergy' => { 92 => 0xa20b, 346 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 177 => 0x18 },
	'flashexposurecomp' => { 59 => 0xf, 97 => 0x1011, 125 => 'ExposureComp', 144 => 0x23, 149 => 0x104, 150 => 0x49c1, 177 => 0x12, 227 => 0x401, 232 => 0x1023, 277 => 0x4d, 302 => [0x3a,0x56], 316 => 0x104 },
	'flashexposurecomp2' => { 198 => 0x4d2 },
	'flashexposurecomp3' => { 168 => 0x1d },
	'flashexposurecomp4' => { 168 => 0x27 },
	'flashexposurecompset' => { 147 => 0x10, 251 => 0xe, 307 => 0x23, 317 => 0x1f },
	'flashexposurecompset2' => { 317 => 0x2c },
	'flashexposureindicator' => { 147 => 0x54 },
	'flashexposureindicatorlast' => { 147 => 0x56 },
	'flashexposureindicatornext' => { 147 => 0x55 },
	'flashexposurelock' => { 43 => 0x19 },
	'flashfired' => { 108 => 0x5d, 125 => 'Fired', 144 => 0x14, 197 => '590.3', 246 => 0x8007, 346 => [\'Flash','FlashFired'] },
	'flashfiring' => { 65 => 0x306, 66 => 0x6, 67 => 0x7, 70 => 0x7 },
	'flashfirmwareversion' => { 228 => 0x1002 },
	'flashfocallength' => { 166 => 0xb, 167 => 0xc, 168 => 0xc },
	'flashfunction' => { 150 => 0x31, 346 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 166 => 0xe, 167 => 0xf, 168 => 0xf },
	'flashgroupacompensation' => { 166 => 0x11, 167 => 0x12, 168 => 0x13 },
	'flashgroupacontrolmode' => { 166 => 0xf, 167 => '16.1', 168 => '17.1' },
	'flashgroupaoutput' => { 166 => 0x11, 167 => 0x12, 168 => 0x13 },
	'flashgroupbcompensation' => { 166 => 0x12, 167 => 0x13, 168 => 0x14 },
	'flashgroupbcontrolmode' => { 166 => 0x10, 167 => '17.1', 168 => '18.1' },
	'flashgroupboutput' => { 166 => 0x12, 167 => 0x13, 168 => 0x14 },
	'flashgroupccompensation' => { 167 => 0x14, 168 => 0x15 },
	'flashgroupccontrolmode' => { 167 => '17.2', 168 => '18.2' },
	'flashgroupcoutput' => { 167 => 0x14, 168 => 0x15 },
	'flashguidenumber' => { 59 => 0xd, 75 => 0x0, 125 => 'GuideNumber' },
	'flashintensity' => { 87 => [0x19,0x5], 227 => 0x405 },
	'flashlevel' => { 218 => 0x9, 316 => 0xb048 },
	'flashmake' => { 125 => 'Make' },
	'flashmanufacturer' => { 142 => 'FlashManufacturer' },
	'flashmetering' => { 144 => 0x3f, 147 => 0x1c },
	'flashmeteringmode' => { 4 => 0x15, 10 => 0x15, 11 => 0x15, 12 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 17 => 0x15, 19 => 0x15, 22 => 0x15 },
	'flashmeteringsegments' => { 277 => 0x20a },
	'flashmode' => { 87 => 0x4, 108 => 0x5c, 125 => 'Mode', 144 => 0x2, 145 => 0x20, 146 => 0x16, 147 => 0xf, 177 => 0x87, 227 => 0x400, 232 => 0x1004, 277 => 0xc, 282 => 0x4, 293 => 0x20, 301 => 0x225, 305 => 0x23, 306 => 0x1f, 307 => 0x20, 317 => 0x10, 346 => [\'Flash','FlashMode'] },
	'flashmodel' => { 125 => 'Model', 142 => 'FlashModel', 228 => 0x1001 },
	'flashoptions' => { 258 => 0x2 },
	'flashoptions2' => { 258 => 0x10 },
	'flashoutput' => { 32 => 0x248, 59 => 0x21, 166 => 0xa, 167 => 0xa, 168 => 0xa },
	'flashpixversion' => { 92 => 0xa000, 346 => 'FlashpixVersion' },
	'flashredeyemode' => { 346 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 227 => 0x403 },
	'flashreturn' => { 346 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 125 => 'SerialNumber', 228 => 0x1003 },
	'flashsetting' => { 177 => 0x8 },
	'flashshutterspeed' => { 217 => '20.2', 222 => '15.2', 223 => '22.2', 224 => '7.2', 225 => '22.2', 226 => '23.1' },
	'flashsource' => { 166 => 0x4, 167 => 0x4, 168 => 0x4 },
	'flashstatus' => { 265 => 0x0, 320 => 0x31 },
	'flashsyncspeed' => { 217 => '20.1', 222 => '15.1', 223 => '22.1', 225 => '22.1' },
	'flashsyncspeedav' => { 63 => 0x3, 65 => 0x10f, 66 => 0x2, 67 => 0x3, 68 => 0x2, 69 => 0x2, 70 => 0x3, 71 => 0x6 },
	'flashthreshold' => { 75 => 0x1 },
	'flashtype' => { 125 => 'Type', 147 => 0x59, 177 => 0x9, 228 => 0x1000 },
	'flashwarning' => { 223 => '30.1', 224 => '7.1', 226 => '31.1', 246 => 0x62 },
	'flexiblespotposition' => { 316 => 0x201d },
	'flickerreduce' => { 301 => 0x218 },
	'fliphorizontal' => { 210 => 0x76a43206 },
	'fnumber' => { 4 => 0x3, 6 => 0x3, 8 => 0x3, 10 => 0x3, 11 => 0x3, 12 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x5, 24 => 0x6, 59 => 0x15, 92 => 0x829d, 105 => 0xfd04, 108 => 0x1e, 110 => 0xfa23, 112 => 0xf103, 115 => 0x13, 117 => 0x3c, 120 => 0xc, 129 => 'FNumber', 144 => 0xa, 145 => 0x36, 146 => 0x47, 147 => 0x9, 150 => 0x49c7, 277 => 0x13, 299 => 0xa019, 302 => [0x31,0x49], 305 => 0x1, 306 => 0x1, 317 => 0x26, 346 => 'FNumber' },
	'focallength' => { 4 => 0x1d, 5 => 0xa, 6 => 0x23, 7 => 0x9, 8 => 0x1d, 9 => 0x9, 10 => 0x1e, 11 => 0x1d, 12 => 0x1d, 13 => 0x1e, 14 => 0x1e, 15 => 0x1e, 16 => 0x28, 17 => 0x1e, 18 => 0x23, 19 => 0x1e, 20 => 0x1e, 21 => 0x20, 22 => 0x1e, 45 => 0x1, 88 => 0x1d, 92 => 0x920a, 115 => 0x1d, 129 => 'FocalLength', 144 => 0x12, 173 => 0xa, 174 => 0xb, 268 => 0x9, 277 => 0x1d, 303 => 0xe, 346 => 'FocalLength' },
	'focallengthin35mmformat' => { 92 => 0xa405, 299 => 0xa01a, 346 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 303 => 0x10 },
	'focalplanediagonal' => { 228 => 0x103, 232 => 0x205 },
	'focalplaneresolutionunit' => { 92 => 0xa210, 346 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 92 => 0xa20e, 346 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 45 => 0x2 },
	'focalplanexunknown' => { 45 => 0x2 },
	'focalplaneyresolution' => { 92 => 0xa20f, 346 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 45 => 0x3 },
	'focalplaneyunknown' => { 45 => 0x3 },
	'focaltype' => { 7 => 0x2d, 45 => 0x0 },
	'focalunits' => { 26 => 0x19 },
	'focus' => { 200 => 0x8 },
	'focusarea' => { 144 => 0x31 },
	'focusareaselection' => { 224 => '15.2' },
	'focuscontinuous' => { 26 => 0x20 },
	'focusdisplayaiservoandmf' => { 65 => 0x515 },
	'focusdistance' => { 129 => 'FocusDistance', 144 => 0x13, 150 => 0x49bb, 173 => 0x9, 174 => 0xa, 230 => 0x305 },
	'focusdistancelower' => { 4 => 0x45, 6 => 0x8e, 8 => 0x45, 10 => 0x56, 11 => 0x45, 12 => 0x45, 13 => 0x52, 14 => 0x52, 15 => 0x56, 17 => 0x52, 18 => 0x8e, 19 => 0x59, 20 => 0x57, 21 => 0x8e, 22 => 0x56, 59 => 0x14 },
	'focusdistanceupper' => { 4 => 0x43, 6 => 0x8c, 8 => 0x43, 10 => 0x54, 11 => 0x43, 12 => 0x43, 13 => 0x50, 14 => 0x50, 15 => 0x54, 17 => 0x50, 18 => 0x8c, 19 => 0x57, 20 => 0x55, 21 => 0x8c, 22 => 0x54, 59 => 0x13 },
	'focusholdbutton' => { 147 => 0x44 },
	'focusinfoversion' => { 230 => 0x0 },
	'focusingscreen' => { 64 => 0x0, 65 => 0x80b, 70 => 0x0 },
	'focuslocked' => { 143 => 0x14 },
	'focusmode' => { 26 => 0x7, 87 => 0x3, 88 => [0x3003,0xd], 97 => 0x1021, 108 => 0x38, 122 => 'FocusMode', 144 => 0x30, 146 => 0xe, 147 => 0xc, 177 => 0x7, 227 => 0x301, 232 => 0x100b, 246 => 0x7, 277 => 0xd, 282 => 0x3, 303 => 0x1d, 305 => 0x4d, 306 => 0x4d, 316 => [0xb042,0xb04e,0x201b], 317 => 0x13, 327 => 0xb },
	'focusmode2' => { 258 => '3.1', 317 => 0x32 },
	'focusmodesetting' => { 218 => '10.1', 305 => 0x10, 306 => 0xf, 307 => 0x6 },
	'focusmodeswitch' => { 147 => 0x58, 305 => 0x2e },
	'focuspixel' => { 97 => 0x1023 },
	'focuspointwrap' => { 217 => '2.2', 222 => '2.2', 223 => '1.2', 226 => '2.5' },
	'focusposition' => { 173 => 0x8, 174 => 0x8, 277 => 0x10, 315 => 0x9bb },
	'focusprocess' => { 227 => 0x302 },
	'focusrange' => { 26 => 0x12, 232 => 0x100a },
	'focussetting' => { 302 => 0x6 },
	'focusstatus' => { 303 => 0x19, 305 => 0x53, 306 => 0x53 },
	'focusstepcount' => { 230 => 0x301, 232 => 0x100e },
	'focusstepinfinity' => { 230 => 0x303, 232 => 0x103b },
	'focusstepnear' => { 230 => 0x304, 232 => 0x103c },
	'focustrackinglockon' => { 217 => ['1.5','4.1'], 222 => '3.1', 223 => '0.4' },
	'focuswarning' => { 97 => 0x1301 },
	'foldername' => { 144 => 0x27 },
	'fontcomposite' => { 369 => [\'Fonts','FontsComposite'] },
	'fontface' => { 369 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 369 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 369 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 369 => [\'Fonts','FontsFontName'] },
	'fonts' => { 369 => 'Fonts' },
	'fonttype' => { 369 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 369 => [\'Fonts','FontsVersionString'] },
	'for' => { 289 => 'For' },
	'format' => { 343 => 'format', 362 => 'Format' },
	'forwardlock' => { 359 => 'forwardlock' },
	'forwardmatrix1' => { 92 => 0xc714 },
	'forwardmatrix2' => { 92 => 0xc715 },
	'framecount' => { 51 => [0x2,0x4] },
	'framenum' => { 284 => 0xd7 },
	'framenumber' => { 97 => 0x8003, 150 => 0x3c, 277 => 0x29 },
	'framerate' => { 51 => [0x1,0x6], 92 => 0xc764 },
	'freebytes' => { 78 => 0x1 },
	'freememorycardimages' => { 145 => [0x37,0x54], 146 => [0x2d,0x4a], 147 => 0x32 },
	'fujiflashmode' => { 97 => 0x1010 },
	'fullimagesize' => { 316 => 0xb02b },
	'fullpanoheightpixels' => { 332 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 332 => 'FullPanoWidthPixels' },
	'fullsizeimage' => { 128 => 'data' },
	'fullsizeimagename' => { 128 => '1Name' },
	'fullsizeimagetype' => { 128 => '0Type' },
	'funcbutton' => { 217 => ['14.1','15.1'], 222 => '28.1', 223 => '13.1', 226 => '14.1' },
	'funcbuttonplusdials' => { 217 => ['14.2','15.2'], 222 => '31.1' },
	'functionbutton' => { 221 => '13.1', 224 => '5.2' },
	'gainbase' => { 231 => 0x610 },
	'gaincontrol' => { 92 => 0xa407, 346 => 'GainControl' },
	'gamma' => { 92 => 0xa500 },
	'gammacompensatedvalue' => { 102 => 0x91 },
	'geimagesize' => { 97 => 0x1304 },
	'gemake' => { 98 => 0x300 },
	'gemodel' => { 98 => 0x207 },
	'genre' => { 355 => 'genre', 364 => 'genre' },
	'geography' => { 356 => 'geography' },
	'geologicalcontext' => { 91 => 'GeologicalContext' },
	'geologicalcontextbed' => { 91 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 91 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 91 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 91 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 91 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 93 => 'Geosync' },
	'geotag' => { 93 => 'Geotag' },
	'geotime' => { 93 => 'Geotime' },
	'globalaltitude' => { 287 => 0x419 },
	'globalangle' => { 287 => 0x40d },
	'good' => { 364 => 'good' },
	'gpsaltitude' => { 99 => 0x6, 126 => 'Altitude', 346 => 'GPSAltitude' },
	'gpsaltituderef' => { 99 => 0x5, 346 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 99 => 0x1c, 346 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 99 => 0x1d },
	'gpsdatetime' => { 126 => 'DateTime', 346 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 99 => 0x18, 126 => 'Bearing', 346 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 99 => 0x17, 346 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 99 => 0x1a, 126 => 'Distance', 346 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 99 => 0x19, 346 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 99 => 0x14, 346 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 99 => 0x13 },
	'gpsdestlongitude' => { 99 => 0x16, 346 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 99 => 0x15 },
	'gpsdifferential' => { 99 => 0x1e, 126 => 'Differential', 346 => 'GPSDifferential' },
	'gpsdop' => { 99 => 0xb, 346 => 'GPSDOP' },
	'gpshpositioningerror' => { 99 => 0x1f },
	'gpsimgdirection' => { 99 => 0x11, 346 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 99 => 0x10, 346 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 99 => 0x2, 126 => 'Latitude', 346 => 'GPSLatitude' },
	'gpslatituderef' => { 99 => 0x1 },
	'gpslongitude' => { 99 => 0x4, 126 => 'Longitude', 346 => 'GPSLongitude' },
	'gpslongituderef' => { 99 => 0x3 },
	'gpsmapdatum' => { 99 => 0x12, 126 => 'Datum', 346 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 99 => 0xa, 126 => 'MeasureMode', 346 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 99 => 0x1b, 346 => 'GPSProcessingMethod' },
	'gpssatellites' => { 99 => 0x8, 126 => 'Satellites', 346 => 'GPSSatellites' },
	'gpsspeed' => { 99 => 0xd, 126 => 'Speed', 346 => 'GPSSpeed' },
	'gpsspeedref' => { 99 => 0xc, 346 => 'GPSSpeedRef' },
	'gpsstatus' => { 99 => 0x9, 346 => 'GPSStatus' },
	'gpstimestamp' => { 99 => 0x7 },
	'gpstrack' => { 99 => 0xf, 126 => 'Heading', 346 => 'GPSTrack' },
	'gpstrackref' => { 99 => 0xe, 346 => 'GPSTrackRef' },
	'gpsversionid' => { 99 => 0x0, 346 => 'GPSVersionID' },
	'gradation' => { 227 => 0x50f },
	'gradientbasedcorractive' => { 342 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 342 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrbrightness' => { 342 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 342 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 342 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 342 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 342 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrdefringe' => { 342 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrections' => { 342 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 342 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 342 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 342 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 342 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrluminancenoise' => { 342 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskcenterweight' => { 342 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 342 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskflow' => { 342 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 342 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 342 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskradius' => { 342 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmasks' => { 342 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmaskvalue' => { 342 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskwhat' => { 342 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskzerox' => { 342 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 342 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 342 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrsaturation' => { 342 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrshadows2012' => { 342 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 342 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 342 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtint' => { 342 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrwhat' => { 342 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'grainamount' => { 342 => 'GrainAmount' },
	'grainfrequency' => { 342 => 'GrainFrequency' },
	'grainsize' => { 342 => 'GrainSize' },
	'graymixeraqua' => { 342 => 'GrayMixerAqua' },
	'graymixerblue' => { 342 => 'GrayMixerBlue' },
	'graymixergreen' => { 342 => 'GrayMixerGreen' },
	'graymixermagenta' => { 342 => 'GrayMixerMagenta' },
	'graymixerorange' => { 342 => 'GrayMixerOrange' },
	'graymixerpurple' => { 342 => 'GrayMixerPurple' },
	'graymixerred' => { 342 => 'GrayMixerRed' },
	'graymixeryellow' => { 342 => 'GrayMixerYellow' },
	'graypoint' => { 328 => 0x8021 },
	'grayresponseunit' => { 92 => 0x122 },
	'greencurvelimits' => { 83 => 0x1c4 },
	'greencurvepoints' => { 83 => 0x19a },
	'greenhue' => { 342 => 'GreenHue' },
	'greensaturation' => { 342 => 'GreenSaturation' },
	'griddisplay' => { 217 => '13.3', 219 => '2.2', 222 => '10.5', 223 => '3.4', 224 => '6.1', 226 => '4.2' },
	'gripbatteryadload' => { 256 => 0x5 },
	'gripbatteryadnoload' => { 256 => 0x4 },
	'gripbatterystate' => { 256 => '1.2' },
	'halftonehints' => { 92 => 0x141 },
	'hasalternative' => { 355 => 'hasAlternative' },
	'hascorrection' => { 355 => 'hasCorrection' },
	'hascrop' => { 342 => 'HasCrop' },
	'hasextendedxmp' => { 366 => 'HasExtendedXMP' },
	'haspreviousversion' => { 355 => 'hasPreviousVersion' },
	'hassettings' => { 342 => 'HasSettings' },
	'hastranslation' => { 355 => 'hasTranslation' },
	'hdr' => { 170 => 0x4, 316 => 0x200a },
	'hdrinfoversion' => { 170 => 0x0 },
	'hdrlevel' => { 170 => 0x5, 307 => 0x2e, 317 => 0x17 },
	'hdrlevel2' => { 170 => 0x7 },
	'hdrsetting' => { 307 => 0x2d, 317 => 0x16 },
	'hdrsmoothing' => { 170 => 0x6 },
	'headline' => { 100 => 0x69, 353 => 'Headline' },
	'hierarchicalkeywords' => { 137 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 137 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 137 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 137 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 137 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 137 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 137 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 137 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 137 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 137 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 137 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 137 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 137 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 137 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 137 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 137 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 137 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 137 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 334 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 91 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highisonoisereduction' => { 13 => 0xbc, 14 => 0xbd, 17 => 0xbd, 22 => 0xc9, 65 => 0x202, 97 => 0x100e, 177 => 0xb1, 277 => 0x71, 305 => 0x2c, 306 => 0x26, 307 => 0x26, 316 => 0x2009, 317 => 0x12 },
	'highisonoisereduction2' => { 316 => 0xb050 },
	'highlight' => { 302 => 0xf },
	'highlightcolordistortreduct' => { 328 => 0x8026 },
	'highlightprotection' => { 209 => 0x6 },
	'highlightrecovery' => { 342 => 'HighlightRecovery' },
	'highlights' => { 336 => 'Highlights' },
	'highlights2012' => { 342 => 'Highlights2012' },
	'highlighttonepriority' => { 10 => 0x7, 13 => 0x7, 14 => 0x7, 15 => 0x7, 17 => 0x7, 19 => 0x7, 22 => 0x7, 65 => 0x203 },
	'highlowkeyadj' => { 277 => 0x6c },
	'highspeedsync' => { 147 => 0x5 },
	'histogramxml' => { 210 => 0x83a1a25 },
	'history' => { 353 => 'History', 365 => 'History' },
	'historyaction' => { 365 => [\'History','HistoryAction'] },
	'historychanged' => { 365 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 365 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 365 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 365 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 365 => [\'History','HistoryWhen'] },
	'hometowncity' => { 88 => 0x3006, 277 => 0x23, 281 => 0x2 },
	'hometowncitycode' => { 282 => 0x1000 },
	'hometowndst' => { 277 => 0x25, 281 => '0.2' },
	'hostcomputer' => { 92 => 0x13c },
	'hue' => { 152 => 0x3b, 277 => 0x67 },
	'hueadj' => { 213 => 0x2f, 328 => 0x8019 },
	'hueadjustment' => { 145 => 0x4a, 146 => 0x40, 177 => 0x92, 179 => 0x36 },
	'hueadjustmentaqua' => { 342 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 342 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 342 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 342 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 342 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 342 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 342 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 342 => 'HueAdjustmentYellow' },
	'huesetting' => { 235 => 0x1011 },
	'icc_profile' => { 93 => 'ICC_Profile' },
	'iccprofilename' => { 353 => 'ICCProfile' },
	'idccreativestyle' => { 328 => 0x8000 },
	'idcpreviewlength' => { 328 => 0x202 },
	'idcpreviewstart' => { 328 => 0x201 },
	'identification' => { 91 => 'Identification' },
	'identificationid' => { 91 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 91 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 91 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 91 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identifiedby' => { 91 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifier' => { 343 => 'identifier', 362 => 'Identifier' },
	'illumination' => { 224 => '0.5' },
	'imageadjustment' => { 177 => 0x80, 200 => 0x5 },
	'imagealterationconstraints' => { 354 => 'ImageAlterationConstraints' },
	'imagearea' => { 187 => 0x10, 190 => 0x10 },
	'imageareaoffset' => { 277 => 0x38 },
	'imageauthentication' => { 177 => 0x20 },
	'imageboundary' => { 177 => 0x16 },
	'imagecount' => { 177 => 0xa5 },
	'imagecreator' => { 354 => 'ImageCreator' },
	'imagecreatorid' => { 354 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 354 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 354 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagedatasize' => { 177 => 0xa2 },
	'imagedescription' => { 92 => 0x10e, 360 => 'ImageDescription' },
	'imageduplicationconstraints' => { 354 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 210 => 0xfe443a45 },
	'imageeditcount' => { 277 => 0x41 },
	'imageediting' => { 277 => 0x32 },
	'imagefileconstraints' => { 354 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 354 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 354 => 'ImageFileSizeAsDelivered' },
	'imageheight' => { 92 => 0x101, 151 => 0xc, 360 => 'ImageLength' },
	'imagehistory' => { 92 => 0x9213 },
	'imageidnumber' => { 242 => 0x340 },
	'imagemaximumtemperature' => { 94 => 0x1 },
	'imageminimumtemperature' => { 94 => 0x2 },
	'imagenumber' => { 92 => 0x9211, 122 => 'ImageNumber', 145 => 0xae, 146 => 0x5e, 305 => 0x9b, 307 => [0x400,0x114,0x314], 339 => 'ImageNumber' },
	'imagenumber2' => { 146 => 0x62 },
	'imageoptimization' => { 177 => 0xa9 },
	'imageorientation' => { 100 => 0x83 },
	'imageprocessing' => { 177 => 0x1a },
	'imageprocessingversion' => { 231 => 0x0 },
	'imagequality' => { 122 => 'ImageQuality', 189 => '723.2', 190 => '732.2', 197 => '708.1', 246 => 0x1 },
	'imagequality2' => { 227 => 0x603 },
	'imageref' => { 349 => 'ImageRef' },
	'imagereview' => { 218 => '0.4', 224 => '0.4' },
	'imagereviewtime' => { 218 => '2.1', 219 => '19.1', 220 => '20.1', 221 => '20.1', 222 => '9.2', 223 => '20.1', 226 => '21.2' },
	'imagesize' => { 128 => 'ImageSize' },
	'imagesizerestriction' => { 357 => 'imageSizeRestriction' },
	'imagesourcedata' => { 92 => 0x935c },
	'imagestabilization' => { 26 => 0x22, 88 => 0x3020, 122 => 'ImageStabilization', 145 => 0xbd, 146 => 0x71, 147 => 0x57, 148 => 0x0, 149 => [0x18,0x107,0x113], 150 => 0x49c2, 177 => 0xac, 227 => 0x604, 230 => 0x1600, 246 => 0x1a, 310 => 0x12, 311 => 0x11, 316 => 0xb026 },
	'imagestabilization2' => { 309 => 0xa },
	'imagestabilizationsetting' => { 150 => 0x14, 305 => 0x3d, 306 => 0x3d, 315 => 0x14 },
	'imagestyle' => { 305 => 0x2d, 306 => 0x27 },
	'imagesupplier' => { 354 => 'ImageSupplier' },
	'imagesupplierid' => { 354 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 354 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 354 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetone' => { 277 => 0x4f },
	'imagetype' => { 100 => 0x82, 354 => 'ImageType' },
	'imageuniqueid' => { 48 => 0x28, 92 => 0xa420, 346 => 'ImageUniqueID' },
	'imagewidth' => { 92 => 0x100, 151 => 0xe, 360 => 'ImageWidth' },
	'incrementaltemperature' => { 342 => 'IncrementalTemperature' },
	'incrementaltint' => { 342 => 'IncrementalTint' },
	'industry' => { 355 => 'industry', 356 => 'industry' },
	'infobuttonwhenshooting' => { 65 => 0x409 },
	'infraredilluminator' => { 290 => 0x28 },
	'ingredients' => { 365 => 'Ingredients' },
	'ingredientsalternatepaths' => { 365 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 365 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 365 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 365 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 365 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 365 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientsmanager' => { 365 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 365 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 365 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 365 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 365 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 365 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 365 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsrenditionclass' => { 365 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 365 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 365 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 365 => [\'Ingredients','IngredientsVersionID'] },
	'initialhorizontalfovdegrees' => { 332 => 'InitialHorizontalFOVDegrees' },
	'initialviewheadingdegrees' => { 332 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 332 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 332 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 217 => '4.4' },
	'initialzoomsetting' => { 217 => '9.3', 222 => '27.3' },
	'inkset' => { 92 => 0x14c },
	'instanceid' => { 365 => 'InstanceID' },
	'instantplaybacksetup' => { 147 => 0x3e },
	'instantplaybacktime' => { 147 => 0x3d },
	'instructions' => { 353 => 'Instructions' },
	'instrument' => { 364 => 'instrument' },
	'intellectualgenre' => { 350 => 'IntellectualGenre' },
	'intelligentauto' => { 316 => 0xb052 },
	'intelligentcontrast' => { 38 => 0x4 },
	'intelligentd-range' => { 246 => 0x79 },
	'intelligentexposure' => { 246 => 0x5d },
	'intelligentresolution' => { 246 => 0x70 },
	'interchangecolorspace' => { 102 => 0x40 },
	'internalflash' => { 144 => 0x2b, 217 => '23.1', 218 => '8.1', 219 => '22.1', 221 => '23.1', 224 => '8.1', 226 => '24.1', 230 => 0x1208 },
	'internalflashae1' => { 232 => 0x1021 },
	'internalflashae1_0' => { 232 => 0x101d },
	'internalflashae2' => { 232 => 0x1022 },
	'internalflashae2_0' => { 232 => 0x101e },
	'internalflashmode' => { 265 => 0x1 },
	'internalflashstrength' => { 265 => 0x3 },
	'internalflashtable' => { 232 => 0x1024 },
	'internalserialnumber' => { 48 => 0x96, 58 => 0x9, 97 => 0x10, 150 => 0x49dc, 228 => 0x102, 246 => 0x25, 257 => 0x4, 294 => 0x5 },
	'interopindex' => { 92 => 0x1 },
	'interopversion' => { 92 => 0x2 },
	'intervallength' => { 144 => 0x10 },
	'intervalmode' => { 144 => 0x26 },
	'intervalnumber' => { 144 => 0x11 },
	'introtime' => { 364 => 'introTime' },
	'introtimescale' => { 364 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 364 => [\'introTime','introTimeValue'] },
	'iptc' => { 93 => 'IPTC' },
	'iptc-naa' => { 92 => 0x83bb, 250 => 0x83bb },
	'iptcbitspersample' => { 102 => 0x56 },
	'iptcdigest' => { 287 => 0x425 },
	'iptcimageheight' => { 102 => 0x1e },
	'iptcimagerotation' => { 102 => 0x66 },
	'iptcimagewidth' => { 102 => 0x14 },
	'iptclastedited' => { 351 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 102 => 0xa },
	'iptcpixelheight' => { 102 => 0x32 },
	'iptcpixelwidth' => { 102 => 0x28 },
	'isbn' => { 355 => 'isbn' },
	'iscorrectionof' => { 355 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 84 => 0x3 },
	'iso' => { 4 => 0x6, 6 => 0x6, 7 => 0x75, 8 => 0x6, 9 => 0x79, 10 => 0x6, 11 => 0x6, 12 => 0x6, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x0, 24 => 0x1, 87 => 0x14, 88 => [0x3014,0x14], 92 => 0x8827, 105 => 0xfd06, 106 => 0x1784, 108 => 0x60, 110 => [0xfa2e,0xfa46], 111 => [0x27,0x28], 112 => 0xf105, 115 => 0x14, 117 => 0x4e, 120 => 0x34, 122 => 'ISO', 144 => 0x8, 150 => 0x49ba, 171 => 0x0, 177 => 0x2, 250 => 0x17, 277 => [0x8b,0x14], 282 => 0x14, 299 => 0xa014, 346 => 'ISOSpeedRatings' },
	'iso2' => { 171 => 0x6, 184 => 0x265, 185 => 0x25c, 186 => 0x265, 187 => 0x221, 188 => 0x25d, 189 => 0x256, 190 => 0x25d, 192 => 0x2b5, 195 => 0x265, 199 => 0x2b5 },
	'isoauto' => { 258 => '14.4' },
	'isoautoparameters' => { 277 => 0x7a },
	'isodisplay' => { 219 => '2.3', 220 => '3.3', 221 => '3.3', 223 => '3.3', 226 => '4.3' },
	'isoexpansion' => { 65 => 0x103, 66 => 0x7, 67 => 0x8, 70 => 0x8, 171 => 0x4 },
	'isoexpansion2' => { 171 => 0xa },
	'isofloor' => { 258 => 0x6 },
	'isoselection' => { 177 => 0xf },
	'isosensitivitystep' => { 223 => '6.2' },
	'isosetting' => { 108 => 0x5e, 122 => 'ISOSetting', 144 => 0x24, 145 => 0x26, 146 => 0x1c, 147 => 0x13, 152 => 0x6, 177 => 0x13, 258 => '17.3', 293 => 0x27, 305 => 0x16, 306 => 0x14, 307 => 0x2 },
	'isospeed' => { 92 => 0x8833 },
	'isospeedexpansion' => { 64 => 0x3 },
	'isospeedincrements' => { 65 => 0x102 },
	'isospeedlatitudeyyy' => { 92 => 0x8834 },
	'isospeedlatitudezzz' => { 92 => 0x8835 },
	'isospeedrange' => { 65 => 0x103 },
	'isostepsize' => { 217 => '6.1', 222 => '4.1' },
	'isovalue' => { 232 => 0x1001 },
	'issn' => { 355 => 'issn' },
	'issueidentifier' => { 355 => 'issueIdentifier' },
	'issuename' => { 355 => 'issueName' },
	'istranslationof' => { 355 => 'isTranslationOf' },
	'jobid' => { 100 => 0xb8 },
	'jobname' => { 347 => 'JobName' },
	'jobref' => { 363 => 'JobRef' },
	'jobrefid' => { 363 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 363 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 363 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 347 => 'JobStatus' },
	'jpegquality' => { 7 => 0x66, 248 => 0x3034, 316 => 0xb047 },
	'jpegsize' => { 248 => 0x303a },
	'jpgfromraw' => { 78 => 0x2007, 89 => 'JpgFromRaw', 250 => 0x2e },
	'jpgfromrawlength' => { 92 => [0x117,0x202] },
	'jpgfromrawstart' => { 92 => [0x111,0x201] },
	'jpgrecordedpixels' => { 258 => '14.1' },
	'jurisdiction' => { 340 => 'jurisdiction' },
	'kelvinwb_01' => { 266 => 0x5 },
	'kelvinwb_02' => { 266 => 0x9 },
	'kelvinwb_03' => { 266 => 0xd },
	'kelvinwb_04' => { 266 => 0x11 },
	'kelvinwb_05' => { 266 => 0x15 },
	'kelvinwb_06' => { 266 => 0x19 },
	'kelvinwb_07' => { 266 => 0x1d },
	'kelvinwb_08' => { 266 => 0x21 },
	'kelvinwb_09' => { 266 => 0x25 },
	'kelvinwb_10' => { 266 => 0x29 },
	'kelvinwb_11' => { 266 => 0x2d },
	'kelvinwb_12' => { 266 => 0x31 },
	'kelvinwb_13' => { 266 => 0x35 },
	'kelvinwb_14' => { 266 => 0x39 },
	'kelvinwb_15' => { 266 => 0x3d },
	'kelvinwb_16' => { 266 => 0x41 },
	'kelvinwb_daylight' => { 266 => 0x1 },
	'key' => { 364 => 'key' },
	'keyword' => { 355 => 'keyword' },
	'keywordinfo' => { 137 => 'Keywords' },
	'keywords' => { 100 => 0x19, 123 => 'Keywords', 236 => 'Keywords', 289 => 'Keywords', 337 => 'keywords', 352 => 'Keywords', 362 => 'Keywords' },
	'killdate' => { 355 => 'killDate' },
	'kodakimageheight' => { 105 => 0xf908, 108 => 0xe, 110 => [0xfa1e,0xfa52], 116 => 0x70 },
	'kodakimagewidth' => { 105 => 0xf907, 108 => 0xc, 110 => [0xfa1d,0xfa51], 116 => 0x6c },
	'kodakinfotype' => { 105 => 0xfa00 },
	'kodakmaker' => { 116 => 0x8 },
	'kodakmodel' => { 108 => 0x0, 116 => 0x28 },
	'label' => { 238 => 'Label', 362 => 'Label' },
	'labelname1' => { 349 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 349 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 349 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 349 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 349 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 349 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 246 => 0x6f },
	'landscapeoutputhighlightpoint' => { 84 => 0x26 },
	'landscapeoutputshadowpoint' => { 84 => 0x27 },
	'landscaperawcolortone' => { 84 => 0x1f },
	'landscaperawcontrast' => { 84 => 0x21 },
	'landscaperawhighlight' => { 84 => 0x77 },
	'landscaperawhighlightpoint' => { 84 => 0x24 },
	'landscaperawlinear' => { 84 => 0x22 },
	'landscaperawsaturation' => { 84 => 0x20 },
	'landscaperawshadow' => { 84 => 0x80 },
	'landscaperawshadowpoint' => { 84 => 0x25 },
	'landscaperawsharpness' => { 84 => 0x23 },
	'landscapeunsharpmaskfineness' => { 84 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 84 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 84 => 0xa2 },
	'language' => { 343 => 'language' },
	'languageidentifier' => { 100 => 0x87 },
	'largestvalidinteriorrectheight' => { 332 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 332 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 332 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 332 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 144 => 0x1b },
	'lastkeywordiptc' => { 142 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 142 => 'LastKeywordXMP' },
	'lastphotodate' => { 332 => 'LastPhotoDate' },
	'lasturl' => { 365 => 'LastURL' },
	'lateralchromaticaberration' => { 316 => 0x2012 },
	'latestageorhigheststage' => { 91 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 91 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 91 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latestperiodorhighestsystem' => { 91 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'lc1' => { 268 => 0x2 },
	'lc10' => { 268 => 0xb },
	'lc11' => { 268 => 0xc },
	'lc12' => { 268 => 0xd },
	'lc14' => { 268 => 0xf },
	'lc15' => { 268 => 0x10 },
	'lc2' => { 268 => 0x3 },
	'lc3' => { 268 => 0x4 },
	'lc4' => { 268 => 0x5 },
	'lc5' => { 268 => 0x6 },
	'lc6' => { 268 => 0x7 },
	'lc7' => { 268 => 0x8 },
	'lcddisplayatpoweron' => { 65 => 0x811, 69 => 0xa },
	'lcddisplayreturntoshoot' => { 70 => 0x12 },
	'lcdillumination' => { 217 => '17.5', 222 => '10.3', 223 => '4.2', 226 => '5.4' },
	'lcdilluminationduringbulb' => { 65 => 0x408 },
	'lcdpanels' => { 64 => 0x8 },
	'lcheditor' => { 210 => 0x8ae85e },
	'legacyiptcdigest' => { 353 => 'LegacyIPTCDigest' },
	'legalcode' => { 340 => 'legalcode' },
	'lens' => { 92 => 0xfdea, 177 => 0x84, 339 => 'Lens' },
	'lensafstopbutton' => { 63 => 0x11, 64 => 0x13, 65 => 0x506, 66 => 0x10, 67 => 0x12, 70 => 0x13, 71 => 0x9 },
	'lensaperturerange' => { 302 => [0x30,0x48] },
	'lensdistortionparams' => { 232 => 0x206 },
	'lensdrivenoaf' => { 65 => 0x505 },
	'lensfirmware' => { 295 => 0x20, 299 => 0xa004 },
	'lensfirmwareversion' => { 228 => 0x204 },
	'lensfocalrange' => { 302 => [0xa,0x2a] },
	'lensfstops' => { 172 => 0x7, 173 => 0xc, 174 => 0xd, 177 => 0x8b, 268 => '0.3' },
	'lensid' => { 339 => 'LensID' },
	'lensidnumber' => { 172 => 0x6, 173 => 0xb, 174 => 0xc },
	'lensinfo' => { 92 => 0xa432, 274 => 0x2a, 339 => 'LensInfo' },
	'lenskind' => { 268 => 0x1 },
	'lensmake' => { 92 => 0xa433, 129 => 'Make' },
	'lensmanualdistortionamount' => { 342 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 142 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 302 => 0x2b },
	'lensmodel' => { 4 => 0x937, 11 => 0x92b, 12 => 0x933, 48 => 0x95, 92 => 0xa434, 129 => 'Model', 142 => 'LensModel', 175 => 0x18a, 228 => 0x203, 274 => 0xc },
	'lensprofilechromaticaberrationscale' => { 342 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 342 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 342 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 342 => 'LensProfileEnable' },
	'lensprofilefilename' => { 342 => 'LensProfileFilename' },
	'lensprofilename' => { 342 => 'LensProfileName' },
	'lensprofilesetup' => { 342 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 342 => 'LensProfileVignettingScale' },
	'lensproperties' => { 228 => 0x20b },
	'lensserialnumber' => { 46 => 0x0, 92 => 0xa435, 129 => 'SerialNumber', 228 => 0x202, 246 => 0x52, 295 => 0x30 },
	'lensshutterlock' => { 147 => 0x4a },
	'lensspec' => { 303 => 0x0, 304 => 0x0, 316 => 0xb02a },
	'lenstemperature' => { 232 => 0x1008 },
	'lenstype' => { 4 => 0xe2, 5 => 0xd, 6 => 0x1a7, 7 => 0xc, 8 => 0x111, 9 => 0xc, 10 => 0x14f, 11 => 0xd6, 12 => 0xde, 13 => 0xf6, 14 => 0xea, 15 => 0xff, 16 => [0xc,0x97], 17 => 0xe6, 18 => 0x153, 19 => 0xea, 20 => 0xe8, 21 => 0x127, 22 => 0x112, 26 => 0x16, 149 => 0x10c, 150 => 0x49bd, 177 => 0x83, 228 => 0x201, 239 => 0x16, 242 => 0x310, 245 => 0x303, 246 => 0x51, 248 => 0x3405, 269 => 0x0, 270 => 0x0, 271 => 0x1, 272 => 0x1, 273 => 0x1, 275 => 0x0, 299 => 0xa003, 302 => 0x27, 316 => 0xb027 },
	'levelgaugepitch' => { 227 => 0x904 },
	'levelgaugeroll' => { 227 => 0x903 },
	'levelorientation' => { 276 => 0x0 },
	'license' => { 340 => 'license' },
	'licensee' => { 354 => 'Licensee' },
	'licenseeid' => { 354 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 354 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 354 => 'LicenseeImageNotes' },
	'licenseename' => { 354 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 354 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 354 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 354 => 'LicenseeTransactionID' },
	'licenseid' => { 354 => 'LicenseID' },
	'licensestartdate' => { 354 => 'LicenseStartDate' },
	'licensetransactiondate' => { 354 => 'LicenseTransactionDate' },
	'licensetype' => { 344 => 'licensetype' },
	'licensor' => { 354 => 'Licensor' },
	'licensorcity' => { 354 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 354 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 354 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 354 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 354 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 354 => 'LicensorImageID' },
	'licensorname' => { 354 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 354 => 'LicensorNotes' },
	'licensorpostalcode' => { 354 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 354 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 354 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 354 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 354 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 354 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 354 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 354 => 'LicensorTransactionID' },
	'licensorurl' => { 354 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 232 => 0x1009 },
	'lightingmode' => { 88 => 0x302a },
	'lightreading' => { 277 => 0x15 },
	'lightsource' => { 92 => 0x9208, 177 => 0x90, 235 => 0x1000, 346 => 'LightSource' },
	'lightsourcespecial' => { 301 => 0x21d },
	'lightswitch' => { 226 => '0.1' },
	'lightvaluecenter' => { 232 => 0x103d },
	'lightvalueperiphery' => { 232 => 0x103e },
	'linearizationtable' => { 92 => 0xc618 },
	'linearresponselimit' => { 92 => 0xc62e },
	'linkaetoafpoint' => { 258 => '14.2' },
	'lithostratigraphicterms' => { 91 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'liveviewaf' => { 219 => '32.1', 226 => '34.1' },
	'liveviewafareamode' => { 223 => '34.1' },
	'liveviewafmethod' => { 317 => 0x20 },
	'liveviewafmode' => { 223 => '34.2' },
	'liveviewafsetting' => { 307 => 0x36 },
	'liveviewexposuresimulation' => { 65 => 0x810 },
	'liveviewfocusmode' => { 307 => 0x8b },
	'liveviewmetering' => { 307 => 0x84 },
	'liveviewmonitorofftime' => { 220 => '20.2', 221 => '20.2', 223 => '20.2' },
	'liveviewshooting' => { 43 => 0x13 },
	'localcaption' => { 100 => 0x79 },
	'localizedcameramodel' => { 92 => 0xc615 },
	'locallocationname' => { 299 => 0x30 },
	'location' => { 176 => 0x9, 246 => 0x67, 335 => 'Location', 350 => 'Location', 355 => 'location' },
	'locationareacode' => { 341 => 'lac' },
	'locationcreated' => { 351 => 'LocationCreated' },
	'locationcreatedcity' => { 351 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 351 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 351 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedprovincestate' => { 351 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 351 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 351 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationinfoversion' => { 176 => 0x0 },
	'locationname' => { 299 => 0x31 },
	'locationshown' => { 351 => 'LocationShown' },
	'locationshowncity' => { 351 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 351 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 351 => [\'LocationShown','LocationShownCountryName'] },
	'locationshownprovincestate' => { 351 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 351 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 351 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 65 => 0x709 },
	'logcomment' => { 364 => 'logComment' },
	'longexposurenoisereduction' => { 65 => 0x201, 66 => 0x1, 67 => 0x2, 68 => 0x1, 69 => 0x1, 70 => 0x2, 71 => 0x1, 305 => 0x2b, 306 => 0x25, 307 => 0x25, 316 => [0xb04e,0x2008], 317 => 0x11 },
	'longexposurenoisereduction2' => { 43 => 0x8 },
	'loop' => { 364 => 'loop' },
	'lowestbiostratigraphiczone' => { 91 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 342 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 342 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 342 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 342 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 342 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 342 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 342 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 342 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 83 => 0x150 },
	'luminancecurvepoints' => { 83 => 0x126 },
	'luminancenoisereduction' => { 84 => 0x5f, 302 => 0x1b },
	'luminancenoisereductioncontrast' => { 342 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 342 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 84 => 0x6d },
	'luminancesmoothing' => { 342 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 65 => 0x40b },
	'm16cversion' => { 242 => 0x333 },
	'macro' => { 97 => 0x1020, 98 => 0x202, 232 => 0x202, 293 => 0x21, 301 => 0x202, 316 => 0xb040 },
	'macroled' => { 230 => 0x120a },
	'macromagnification' => { 4 => 0x1b, 8 => 0x1b, 11 => 0x1b, 12 => 0x1b, 16 => 0x1b, 17 => 0x1b, 43 => 0x10 },
	'macromode' => { 26 => 0x1, 144 => 0xb, 227 => 0x300, 246 => 0x1c },
	'magicfilter' => { 227 => 0x52c },
	'magnifiedview' => { 67 => 0x11, 69 => 0x9 },
	'maindialexposurecomp' => { 224 => '0.6' },
	'make' => { 79 => 0x0, 92 => 0x10f, 122 => 'Make', 238 => 'Make', 250 => 0x10f, 360 => 'Make' },
	'makernote' => { 346 => 'MakerNote' },
	'makernotecanon' => { 90 => 'MakN', 92 => 0x927c },
	'makernotecasio' => { 90 => 'MakN', 92 => 0x927c },
	'makernotecasio2' => { 90 => 'MakN', 92 => 0x927c },
	'makernoteflir' => { 90 => 'MakN', 92 => 0x927c },
	'makernotefujifilm' => { 90 => 'MakN', 92 => 0x927c },
	'makernotege' => { 90 => 'MakN', 92 => 0x927c },
	'makernotege2' => { 90 => 'MakN', 92 => 0x927c },
	'makernotehasselblad' => { 90 => 'MakN', 92 => 0x927c },
	'makernotehp' => { 90 => 'MakN', 92 => 0x927c },
	'makernotehp2' => { 90 => 'MakN', 92 => 0x927c },
	'makernotehp4' => { 90 => 'MakN', 92 => 0x927c },
	'makernotehp6' => { 90 => 'MakN', 92 => 0x927c },
	'makernoteisl' => { 90 => 'MakN', 92 => 0x927c },
	'makernotejvc' => { 90 => 'MakN', 92 => 0x927c },
	'makernotejvctext' => { 90 => 'MakN', 92 => 0x927c },
	'makernotekodak10' => { 90 => 'MakN', 92 => 0x927c },
	'makernotekodak1a' => { 90 => 'MakN', 92 => 0x927c },
	'makernotekodak1b' => { 90 => 'MakN', 92 => 0x927c },
	'makernotekodak2' => { 90 => 'MakN', 92 => 0x927c },
	'makernotekodak3' => { 90 => 'MakN', 92 => 0x927c },
	'makernotekodak4' => { 90 => 'MakN', 92 => 0x927c },
	'makernotekodak5' => { 90 => 'MakN', 92 => 0x927c },
	'makernotekodak6a' => { 90 => 'MakN', 92 => 0x927c },
	'makernotekodak6b' => { 90 => 'MakN', 92 => 0x927c },
	'makernotekodak7' => { 90 => 'MakN', 92 => 0x927c },
	'makernotekodak8a' => { 90 => 'MakN', 92 => 0x927c },
	'makernotekodak8b' => { 90 => 'MakN', 92 => 0x927c },
	'makernotekodak9' => { 90 => 'MakN', 92 => 0x927c },
	'makernotekodakunknown' => { 90 => 'MakN', 92 => 0x927c },
	'makernotekyocera' => { 90 => 'MakN', 92 => 0x927c },
	'makernoteleica' => { 90 => 'MakN', 92 => 0x927c },
	'makernoteleica2' => { 90 => 'MakN', 92 => 0x927c },
	'makernoteleica3' => { 90 => 'MakN', 92 => 0x927c },
	'makernoteleica4' => { 90 => 'MakN', 92 => 0x927c },
	'makernoteleica5' => { 90 => 'MakN', 92 => 0x927c },
	'makernoteleica6' => { 90 => 'MakN', 92 => 0x927c },
	'makernoteminolta' => { 90 => 'MakN', 92 => 0x927c },
	'makernoteminolta2' => { 90 => 'MakN', 92 => 0x927c },
	'makernoteminolta3' => { 90 => 'MakN', 92 => 0x927c },
	'makernotenikon' => { 90 => 'MakN', 92 => 0x927c },
	'makernotenikon2' => { 90 => 'MakN', 92 => 0x927c },
	'makernotenikon3' => { 90 => 'MakN', 92 => 0x927c },
	'makernoteoffset' => { 301 => 0xff },
	'makernoteolympus' => { 90 => 'MakN', 92 => 0x927c },
	'makernoteolympus2' => { 90 => 'MakN', 92 => 0x927c },
	'makernotepanasonic' => { 90 => 'MakN', 92 => 0x927c },
	'makernotepanasonic2' => { 90 => 'MakN', 92 => 0x927c },
	'makernotepentax' => { 90 => 'MakN', 92 => 0x927c },
	'makernotepentax2' => { 90 => 'MakN', 92 => 0x927c },
	'makernotepentax3' => { 90 => 'MakN', 92 => 0x927c },
	'makernotepentax4' => { 90 => 'MakN', 92 => 0x927c },
	'makernotepentax5' => { 90 => 'MakN', 92 => 0x927c },
	'makernotepentax6' => { 90 => 'MakN', 92 => 0x927c },
	'makernotephaseone' => { 90 => 'MakN', 92 => 0x927c },
	'makernotereconyx' => { 90 => 'MakN', 92 => 0x927c },
	'makernotericoh' => { 90 => 'MakN', 92 => 0x927c },
	'makernotericohtext' => { 90 => 'MakN', 92 => 0x927c },
	'makernotesafety' => { 92 => 0xc635 },
	'makernotesamsung1a' => { 90 => 'MakN', 92 => 0x927c },
	'makernotesamsung1b' => { 90 => 'MakN', 92 => 0x927c },
	'makernotesamsung2' => { 90 => 'MakN', 92 => 0x927c },
	'makernotesanyo' => { 90 => 'MakN', 92 => 0x927c },
	'makernotesanyoc4' => { 90 => 'MakN', 92 => 0x927c },
	'makernotesanyopatch' => { 90 => 'MakN', 92 => 0x927c },
	'makernotesigma' => { 90 => 'MakN', 92 => 0x927c },
	'makernotesony' => { 90 => 'MakN', 92 => 0x927c },
	'makernotesony2' => { 90 => 'MakN', 92 => 0x927c },
	'makernotesony3' => { 90 => 'MakN', 92 => 0x927c },
	'makernotesony4' => { 90 => 'MakN', 92 => 0x927c },
	'makernotesonyericsson' => { 90 => 'MakN', 92 => 0x927c },
	'makernotesonysrf' => { 90 => 'MakN', 92 => 0x927c },
	'makernotetype' => { 294 => 0x1 },
	'makernoteunknown' => { 90 => 'MakN', 92 => 0x927c },
	'makernoteunknownbinary' => { 90 => 'MakN', 92 => 0x927c },
	'makernoteunknowntext' => { 90 => 'MakN', 92 => 0x927c },
	'makernoteversion' => { 149 => 0x0, 177 => 0x1, 232 => 0x0, 246 => 0x8000, 298 => 0x0, 299 => 0x1, 302 => [0x1d,0x1f], 308 => 0x2000 },
	'managedfrom' => { 365 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 365 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 365 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 365 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 365 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 365 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 365 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfrommanager' => { 365 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 365 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 365 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 365 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 365 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 365 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 365 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromrenditionclass' => { 365 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 365 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 365 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 365 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 365 => 'Manager' },
	'managervariant' => { 365 => 'ManagerVariant' },
	'manageto' => { 365 => 'ManageTo' },
	'manageui' => { 365 => 'ManageUI' },
	'manifest' => { 365 => 'Manifest' },
	'manifestlinkform' => { 365 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 365 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 365 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 365 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 365 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 365 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 365 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 365 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 365 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 365 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 365 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencemanager' => { 365 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 365 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 365 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 365 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 365 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 365 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 365 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferencerenditionclass' => { 365 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 365 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 365 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 365 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 227 => 0x900, 246 => 0x86 },
	'manometerreading' => { 227 => 0x901 },
	'manualafpointselectpattern' => { 65 => 0x513 },
	'manualflash' => { 230 => 0x1209 },
	'manualflashoutput' => { 26 => 0x29, 218 => '8.2', 219 => '22.2', 220 => '23.1', 221 => '23.2', 222 => '16.2', 223 => '23.2', 224 => '8.2', 225 => '23.2', 226 => '24.2' },
	'manualflashstrength' => { 227 => 0x406 },
	'manualfocusdistance' => { 177 => 0x85, 232 => 0x100c, 301 => 0x223 },
	'manualtv' => { 64 => 0x5, 65 => 0x705 },
	'manufacturedate' => { 257 => 0x1 },
	'manufacturedate1' => { 296 => 0x4 },
	'manufacturedate2' => { 296 => 0x5 },
	'marked' => { 352 => 'Marked', 368 => 'Marked' },
	'markers' => { 364 => 'markers' },
	'markerscomment' => { 364 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 364 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 364 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 364 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 364 => [\'markers','markersCuePointType'] },
	'markersduration' => { 364 => [\'markers','markersDuration'] },
	'markerslocation' => { 364 => [\'markers','markersLocation'] },
	'markersname' => { 364 => [\'markers','markersName'] },
	'markersprobability' => { 364 => [\'markers','markersProbability'] },
	'markersspeaker' => { 364 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 364 => [\'markers','markersStartTime'] },
	'markerstarget' => { 364 => [\'markers','markersTarget'] },
	'markerstype' => { 364 => [\'markers','markersType'] },
	'maskedareas' => { 92 => 0xc68e },
	'masterdocumentid' => { 100 => 0xb9 },
	'mastergain' => { 182 => 0x50 },
	'maxaperture' => { 26 => 0x1a, 112 => 0x6103, 129 => 'MaxAperture', 144 => 0x17, 150 => 0x49c5, 228 => 0x20a, 268 => '14.1', 320 => 0x0 },
	'maxapertureatmaxfocal' => { 97 => 0x1407, 129 => 'MaxApertureAtMaxFocal', 172 => 0xb, 173 => 0x10, 174 => 0x11, 228 => 0x206 },
	'maxapertureatminfocal' => { 97 => 0x1406, 172 => 0xa, 173 => 0xf, 174 => 0x10, 228 => 0x205 },
	'maxaperturevalue' => { 92 => 0x9205, 346 => 'MaxApertureValue' },
	'maxavailheight' => { 351 => 'MaxAvailHeight' },
	'maxavailwidth' => { 351 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 217 => 0xb, 222 => 0xc, 223 => 0xb },
	'maxfaces' => { 231 => 0x1202 },
	'maxfocallength' => { 4 => 0xe6, 5 => 0x10, 6 => 0x1ab, 7 => 0x13, 8 => 0x115, 9 => 0x13, 10 => 0x153, 11 => 0xda, 13 => 0xfa, 14 => 0xee, 15 => 0x103, 16 => 0x95, 17 => 0xea, 18 => 0x157, 19 => 0xee, 20 => 0xec, 21 => 0x12b, 22 => 0x116, 26 => 0x17, 97 => 0x1405, 129 => 'MaxFocalLength', 172 => 0x9, 173 => 0xe, 174 => 0xf, 228 => 0x208 },
	'maximumdensityrange' => { 102 => 0x8c },
	'maxpagesize' => { 369 => 'MaxPageSize' },
	'maxpagesizeh' => { 369 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 369 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 369 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxsamplevalue' => { 92 => 0x119 },
	'maxstorage' => { 359 => 'maxstorage' },
	'mb-d10batteries' => { 217 => '12.6' },
	'mb-d10batterytype' => { 222 => '13.3' },
	'mb-d11batterytype' => { 223 => '2.3' },
	'mb-d80batteries' => { 224 => '6.5' },
	'mb-d80batterytype' => { 226 => '3.2' },
	'mcuversion' => { 172 => 0xc, 173 => 0x11, 174 => 0x12 },
	'md5digest' => { 130 => 'zmd5' },
	'measuredev' => { 22 => 0x9, 59 => 0x3, 78 => 0x1814, 122 => 'MeasuredEV' },
	'measuredev2' => { 10 => 0x8, 22 => 0x8, 59 => 0x17 },
	'measuredev3' => { 10 => 0x9 },
	'measuredlv' => { 150 => 0x690, 242 => 0x312, 248 => 0x3407 },
	'measuredrggb' => { 49 => 0x1 },
	'measuredrggbdata' => { 32 => 0x287 },
	'measurementaccuracy' => { 91 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 91 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 91 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 91 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 91 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 91 => 'MeasurementOrFact' },
	'measurementremarks' => { 91 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 91 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 91 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 91 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'mediaconstraints' => { 354 => 'MediaConstraints' },
	'mediasummarycode' => { 354 => 'MediaSummaryCode' },
	'memorycardconfiguration' => { 311 => 0x16 },
	'menubuttondisplayposition' => { 63 => 0xb, 66 => 0xa, 67 => 0xb, 70 => 0xb },
	'menubuttonreturn' => { 71 => 0xb },
	'menumonitorofftime' => { 222 => '8.2', 223 => '21.1', 226 => '22.1' },
	'metadatadate' => { 362 => 'MetadataDate' },
	'metadatamoddate' => { 364 => 'metadataModDate' },
	'metering' => { 218 => '6.1' },
	'meteringmode' => { 26 => 0x11, 92 => 0x9207, 108 => 0x1c, 144 => 0x7, 145 => 0x25, 147 => 0x12, 227 => 0x202, 277 => 0x17, 302 => 0x9, 305 => 0x15, 306 => 0x13, 307 => 0x7, 317 => 0x3, 346 => 'MeteringMode' },
	'meteringmode2' => { 258 => '2.1' },
	'meteringmode3' => { 258 => '16.1' },
	'meteringoffscaleindicator' => { 147 => 0x53 },
	'meteringtime' => { 217 => '22.2', 218 => '3.2', 219 => '17.1', 220 => '18.1', 222 => '7.3', 223 => '18.1', 224 => '3.2', 226 => '19.1' },
	'mieversion' => { 130 => '0Vers' },
	'minaperture' => { 26 => 0x1b, 129 => 'MinAperture', 268 => '0.2', 320 => 0x1 },
	'minfocallength' => { 4 => 0xe4, 5 => 0xe, 6 => 0x1a9, 7 => 0x11, 8 => 0x113, 9 => 0x11, 10 => 0x151, 11 => 0xd8, 13 => 0xf8, 14 => 0xec, 15 => 0x101, 16 => 0x93, 17 => 0xe8, 18 => 0x155, 19 => 0xec, 20 => 0xea, 21 => 0x129, 22 => 0x114, 26 => 0x18, 97 => 0x1404, 129 => 'MinFocalLength', 172 => 0x8, 173 => 0xd, 174 => 0xe, 228 => 0x207 },
	'minoltadate' => { 144 => 0x15 },
	'minoltaimagesize' => { 144 => 0x4, 145 => 0xc, 146 => 0x2, 149 => 0x103 },
	'minoltamodelid' => { 144 => 0x25 },
	'minoltaquality' => { 144 => 0x5, 145 => 0xd, 146 => 0x3, 149 => [0x102,0x103] },
	'minoltatime' => { 144 => 0x16 },
	'minormodelagedisclosure' => { 354 => 'MinorModelAgeDisclosure' },
	'minsamplevalue' => { 92 => 0x118 },
	'mirrorlockup' => { 63 => 0xc, 64 => 0xc, 65 => 0x60f, 66 => 0xb, 67 => 0xc, 68 => 0x6, 69 => 0x6, 70 => 0xc, 71 => 0x3 },
	'mobilecountrycode' => { 341 => 'mcc' },
	'mobilenetworkcode' => { 341 => 'mnc' },
	'moddate' => { 238 => 'modify-date', 352 => 'ModDate' },
	'modedialposition' => { 311 => 0x14 },
	'model' => { 79 => 0x6, 92 => 0x110, 122 => 'Model', 238 => 'Model', 250 => 0x110, 360 => 'Model' },
	'modelage' => { 351 => 'ModelAge' },
	'modelingflash' => { 217 => '21.4', 222 => '26.4', 223 => '30.2', 224 => '7.4', 225 => '30.1', 226 => '31.3' },
	'modelreleaseid' => { 354 => 'ModelReleaseID' },
	'modelreleasestatus' => { 354 => 'ModelReleaseStatus' },
	'modificationdate' => { 355 => 'modificationDate' },
	'modifiedcolortemp' => { 50 => 0x9 },
	'modifieddigitalgain' => { 50 => 0xb },
	'modifiedparamflag' => { 44 => 0x1 },
	'modifiedpicturestyle' => { 50 => 0xa },
	'modifiedsaturation' => { 227 => 0x504 },
	'modifiedsensorbluelevel' => { 50 => 0x5 },
	'modifiedsensorredlevel' => { 50 => 0x4 },
	'modifiedsharpness' => { 50 => 0x2 },
	'modifiedsharpnessfreq' => { 50 => 0x3 },
	'modifiedtonecurve' => { 50 => 0x1 },
	'modifiedwhitebalance' => { 50 => 0x8 },
	'modifiedwhitebalanceblue' => { 50 => 0x7 },
	'modifiedwhitebalancered' => { 50 => 0x6 },
	'modifydate' => { 92 => 0x132, 123 => 'ModifyDate', 236 => 'ModDate', 237 => 'tIME', 289 => 'ModDate', 362 => 'ModifyDate' },
	'moirefilter' => { 92 => 0xfe58, 342 => 'MoireFilter' },
	'monitordisplayoff' => { 147 => 0x4c },
	'monitorofftime' => { 217 => '18.2', 218 => '3.1', 224 => '3.1' },
	'monochromecontrast' => { 84 => 0x3c },
	'monochromefiltereffect' => { 84 => 0x3a, 277 => 0x73 },
	'monochromelinear' => { 84 => 0x3d },
	'monochromeoutputhighlightpoint' => { 84 => 0x41 },
	'monochromeoutputshadowpoint' => { 84 => 0x42 },
	'monochromerawhighlight' => { 84 => 0x7a },
	'monochromerawhighlightpoint' => { 84 => 0x3f },
	'monochromerawshadow' => { 84 => 0x83 },
	'monochromerawshadowpoint' => { 84 => 0x40 },
	'monochromesharpness' => { 84 => 0x3e },
	'monochrometoning' => { 277 => 0x74 },
	'monochrometoningeffect' => { 84 => 0x3b },
	'monochromeunsharpmaskfineness' => { 84 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 84 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 84 => 0xb4 },
	'monthdaycreated' => { 108 => 0x12, 117 => 0xe },
	'moonphase' => { 290 => 0x12 },
	'morepermissions' => { 340 => 'morePermissions' },
	'motionsensitivity' => { 290 => 0x29 },
	'multiburstimageheight' => { 316 => 0x1002 },
	'multiburstimagewidth' => { 316 => 0x1001 },
	'multiburstmode' => { 316 => 0x1000 },
	'multicontrollerwhilemetering' => { 65 => 0x517 },
	'multiexposureautogain' => { 178 => 0x3 },
	'multiexposuremode' => { 178 => 0x1 },
	'multiexposureshots' => { 178 => 0x2 },
	'multiframenoisereduction' => { 307 => 0x35, 316 => 0x200b, 317 => 0x15 },
	'multifunctionlock' => { 65 => 0x70f },
	'multipleexposuremode' => { 231 => 0x101c },
	'multipleexposureset' => { 258 => '10.1' },
	'multisample' => { 182 => 0x40 },
	'multiselector' => { 217 => '9.4', 222 => '27.4' },
	'multiselectorliveview' => { 217 => '4.3' },
	'multiselectorplaybackmode' => { 217 => ['13.5','9.2'], 222 => '27.2' },
	'multiselectorshootmode' => { 217 => '9.1', 222 => '27.1' },
	'mycolormode' => { 52 => 0x2 },
	'nativedigest' => { 346 => 'NativeDigest', 360 => 'NativeDigest' },
	'ncdfileinfo' => { 106 => 0x414 },
	'ndfilter' => { 59 => 0x1c },
	'nefbitdepth' => { 177 => 0xe22 },
	'nefcompression' => { 177 => 0x93 },
	'neflinearizationtable' => { 177 => 0x96 },
	'neutraldensityfilter' => { 277 => 0x88 },
	'neutraloutputhighlightpoint' => { 84 => 0x2f },
	'neutraloutputshadowpoint' => { 84 => 0x30 },
	'neutralrawcolortone' => { 84 => 0x28 },
	'neutralrawcontrast' => { 84 => 0x2a },
	'neutralrawhighlight' => { 84 => 0x78 },
	'neutralrawhighlightpoint' => { 84 => 0x2d },
	'neutralrawlinear' => { 84 => 0x2b },
	'neutralrawsaturation' => { 84 => 0x29 },
	'neutralrawshadow' => { 84 => 0x81 },
	'neutralrawshadowpoint' => { 84 => 0x2e },
	'neutralrawsharpness' => { 84 => 0x2c },
	'neutralunsharpmaskfineness' => { 84 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 84 => 0xa8 },
	'neutraunsharpmaskstrength' => { 84 => 0xa4 },
	'newrawimagedigest' => { 92 => 0xc7a7 },
	'newsphotoversion' => { 102 => 0x0 },
	'nickname' => { 362 => 'Nickname' },
	'nikoncapturedata' => { 177 => 0xe01 },
	'nikoncaptureeditversions' => { 177 => 0xe13 },
	'nikoncaptureoutput' => { 177 => 0xe1e },
	'nikoncaptureversion' => { 177 => 0xe09 },
	'nikoniccprofile' => { 177 => 0xe1d },
	'nikonimagesize' => { 189 => '723.1', 190 => '732.1', 197 => 0x2c4 },
	'noisefilter' => { 227 => 0x527 },
	'noiseprofile' => { 92 => 0xc761 },
	'noisereduction' => { 97 => 0x100b, 145 => 0xb0, 146 => 0x60, 147 => 0x3f, 177 => 0x95, 210 => 0x753dcbc0, 211 => 0x17, 227 => 0x50a, 232 => 0x103a, 246 => 0x2d, 277 => 0x49, 296 => 0x2a },
	'noisereduction2' => { 231 => 0x1010 },
	'noisereductionapplied' => { 92 => 0xc6f7 },
	'noisereductionintensity' => { 211 => 0x9 },
	'noisereductionmethod' => { 211 => 0x11 },
	'noisereductionmode' => { 328 => 0x801e },
	'noisereductionsharpness' => { 211 => 0xd },
	'noisereductionvalue' => { 328 => 0x8027 },
	'nomemorycard' => { 217 => '22.1', 218 => '0.3', 219 => '2.4', 220 => '3.2', 221 => '3.2', 222 => '33.7', 223 => '3.2', 224 => '0.3', 226 => '4.5' },
	'nominalmaxaperture' => { 268 => 0xa },
	'nominalminaperture' => { 268 => '10.1' },
	'notes' => { 329 => 'Notes', 337 => 'notes' },
	'npages' => { 369 => 'NPages' },
	'nrwdata' => { 177 => 0x14 },
	'nullrecord' => { 78 => 0x0 },
	'number' => { 355 => 'number' },
	'numberofbeats' => { 364 => 'numberOfBeats' },
	'numberoffocuspoints' => { 221 => '0.2', 223 => '0.3' },
	'numfacepositions' => { 240 => 0x0 },
	'numindexentries' => { 102 => 0x54 },
	'object' => { 355 => 'object' },
	'objectattributereference' => { 100 => 0x4 },
	'objectcycle' => { 100 => 0x4b },
	'objectdistance' => { 87 => 0x6, 88 => 0x2022 },
	'objectname' => { 100 => 0x5 },
	'objectpreviewdata' => { 100 => 0xca },
	'objectpreviewfileformat' => { 100 => 0xc8 },
	'objectpreviewfileversion' => { 100 => 0xc9 },
	'objecttypereference' => { 100 => 0x3 },
	'occurrence' => { 91 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 91 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 91 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 91 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 91 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 91 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 91 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 91 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedetails' => { 91 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 91 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 91 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrenceid' => { 91 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 91 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 91 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 91 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceothercatalognumbers' => { 91 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepreparations' => { 91 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 91 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 91 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordnumber' => { 91 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 91 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 91 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 91 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 91 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 346 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 346 => [\'OECF','OECFNames'] },
	'oecfrows' => { 346 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 346 => [\'OECF','OECFValues'] },
	'offsetschema' => { 92 => 0xea1d },
	'okbutton' => { 223 => '15.1', 226 => '16.1' },
	'oldsubfiletype' => { 92 => 0xff },
	'olympusimageheight' => { 232 => 0x102f },
	'olympusimagewidth' => { 232 => 0x102e },
	'onetouchwb' => { 232 => 0x302 },
	'opticalzoom' => { 110 => 0xfa3d, 112 => [0x6006,0xf006], 113 => 0x1000, 114 => 0xf, 117 => 0x1e, 129 => 'OpticalZoom' },
	'opticalzoomcode' => { 59 => 0xa },
	'opticalzoommode' => { 246 => 0x34 },
	'opticalzoomon' => { 301 => 0x219 },
	'optionenddate' => { 357 => 'optionEndDate' },
	'opto-electricconvfactor' => { 346 => 'OECF' },
	'ordernumber' => { 97 => 0x8002 },
	'organisationinimagecode' => { 351 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 351 => 'OrganisationInImageName' },
	'organization' => { 355 => 'organization' },
	'orientation' => { 92 => 0x112, 250 => 0x112, 360 => 'Orientation' },
	'orientation2' => { 317 => 0x2e },
	'orientationlinkedafpoint' => { 65 => 0x516 },
	'originalbestqualitysize' => { 92 => 0xc792 },
	'originaldecisiondata' => { 89 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 48 => 0x83 },
	'originaldefaultcropsize' => { 92 => 0xc793 },
	'originaldefaultfinalsize' => { 92 => 0xc791 },
	'originaldirectory' => { 244 => 0x408 },
	'originaldocumentid' => { 365 => 'OriginalDocumentID' },
	'originalfilename' => { 78 => 0x816, 106 => 0x3e9, 118 => 0x20, 244 => 0x407, 333 => 'OriginalFilename' },
	'originalimageheight' => { 61 => 0xc, 96 => 0x1 },
	'originalimagewidth' => { 61 => 0xb, 96 => 0x0 },
	'originalrawfiledata' => { 92 => 0xc68c },
	'originalrawfiledigest' => { 92 => 0xc71d },
	'originalrawfilename' => { 92 => 0xc68b },
	'originaltransmissionreference' => { 100 => 0x67 },
	'originatingprogram' => { 100 => 0x41 },
	'originplatform' => { 355 => 'originPlatform' },
	'os' => { 344 => 'os' },
	'otherconditions' => { 354 => 'OtherConditions' },
	'otherconstraints' => { 354 => 'OtherConstraints' },
	'otherimage' => { 89 => 'OtherImage' },
	'otherimageinfo' => { 354 => 'OtherImageInfo' },
	'otherimagelength' => { 92 => 0x202 },
	'otherimagestart' => { 92 => 0x201 },
	'otherlicensedocuments' => { 354 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 354 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 354 => 'OtherLicenseRequirements' },
	'outcue' => { 364 => 'outCue' },
	'outcuescale' => { 364 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 364 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 157 => 0x3 },
	'outputimagewidth' => { 157 => 0x2 },
	'outputresolution' => { 157 => 0x4 },
	'owner' => { 368 => 'Owner' },
	'ownerid' => { 100 => 0xbc },
	'ownername' => { 12 => 0x10f, 48 => 0x9, 78 => 0x810, 92 => [0xa430,0xfde8], 122 => 'OwnerName', 339 => 'OwnerName' },
	'padding' => { 92 => 0xea1c },
	'pageimage' => { 362 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 362 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 362 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 362 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 362 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 362 => 'PageInfo' },
	'pagename' => { 92 => 0x11d },
	'pagenumber' => { 92 => 0x129 },
	'pagerange' => { 355 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 342 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 342 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 342 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 342 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionbrightness' => { 342 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 342 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 342 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 342 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 342 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectiondefringe' => { 342 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectionexposure' => { 342 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 342 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 342 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 342 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectionluminancenoise' => { 342 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskcenterweight' => { 342 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 342 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskflow' => { 342 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 342 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 342 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskradius' => { 342 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskvalue' => { 342 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskwhat' => { 342 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskzerox' => { 342 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 342 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 342 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionsaturation' => { 342 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionshadows2012' => { 342 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 342 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 342 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontint' => { 342 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectionwhat' => { 342 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'panasonicexifversion' => { 246 => 0x26 },
	'panasonicimageheight' => { 246 => 0x4c },
	'panasonicimagewidth' => { 246 => 0x4b },
	'panasonicrawversion' => { 250 => 0x1 },
	'panasonictitle' => { 92 => 0xc6d2 },
	'panasonictitle2' => { 92 => 0xc6d3 },
	'panoramacropbottom' => { 318 => 0x7 },
	'panoramacropleft' => { 318 => 0x4 },
	'panoramacropright' => { 318 => 0x6 },
	'panoramacroptop' => { 318 => 0x5 },
	'panoramadirection' => { 55 => 0x5, 318 => 0x3 },
	'panoramaframeheight' => { 318 => 0x9 },
	'panoramaframenumber' => { 55 => 0x2 },
	'panoramaframewidth' => { 318 => 0x8 },
	'panoramafullheight' => { 318 => 0x2 },
	'panoramafullwidth' => { 318 => 0x1 },
	'panoramamode' => { 108 => 0x3c, 227 => 0x601 },
	'panoramasize3d' => { 307 => 0x38 },
	'panoramasourceheight' => { 318 => 0xb },
	'panoramasourcewidth' => { 318 => 0xa },
	'panoramicstitchcameramotion' => { 140 => 'PanoramicStitchCameraMotion', 141 => 0x1 },
	'panoramicstitchmaptype' => { 140 => 'PanoramicStitchMapType', 141 => 0x2 },
	'panoramicstitchphi0' => { 140 => 'PanoramicStitchPhi0', 141 => 0x5 },
	'panoramicstitchphi1' => { 140 => 'PanoramicStitchPhi1', 141 => 0x6 },
	'panoramicstitchtheta0' => { 140 => 'PanoramicStitchTheta0', 141 => 0x3 },
	'panoramicstitchtheta1' => { 140 => 'PanoramicStitchTheta1', 141 => 0x4 },
	'panoramicstitchversion' => { 141 => 0x0 },
	'pantry' => { 365 => 'Pantry' },
	'parallax' => { 97 => 0xb211 },
	'parametricdarks' => { 342 => 'ParametricDarks' },
	'parametrichighlights' => { 342 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 342 => 'ParametricHighlightSplit' },
	'parametriclights' => { 342 => 'ParametricLights' },
	'parametricmidtonesplit' => { 342 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 342 => 'ParametricShadows' },
	'parametricshadowsplit' => { 342 => 'ParametricShadowSplit' },
	'parentmeid' => { 333 => 'ParentMEID' },
	'parentreference1' => { 349 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 349 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 349 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 349 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 349 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 349 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'patientbirthdate' => { 330 => 'PatientDOB' },
	'patientid' => { 330 => 'PatientID' },
	'patientname' => { 330 => 'PatientName' },
	'patientsex' => { 330 => 'PatientSex' },
	'pdfversion' => { 352 => 'PDFVersion' },
	'pentaximagesize' => { 277 => 0x9 },
	'pentaxmodelid' => { 257 => 0x0, 277 => 0x5 },
	'pentaxmodeltype' => { 277 => 0x1 },
	'pentaxversion' => { 277 => 0x0 },
	'people' => { 335 => 'People' },
	'peripheralillumcentralradius' => { 328 => 0x8030 },
	'peripheralillumcentralvalue' => { 328 => 0x8031 },
	'peripheralillumination' => { 84 => 0x68 },
	'peripheralilluminationon' => { 84 => 0x64 },
	'peripheralillumperiphvalue' => { 328 => 0x8032 },
	'peripherallighting' => { 61 => 0x2 },
	'peripherallightingsetting' => { 62 => 0x5 },
	'peripherallightingvalue' => { 61 => 0x6 },
	'permissions' => { 357 => 'permissions' },
	'permits' => { 340 => 'permits' },
	'person' => { 355 => 'person' },
	'personality' => { 333 => 'Personality' },
	'personinimage' => { 351 => 'PersonInImage' },
	'perspectivehorizontal' => { 342 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 342 => 'PerspectiveRotate' },
	'perspectivescale' => { 342 => 'PerspectiveScale' },
	'perspectivevertical' => { 342 => 'PerspectiveVertical' },
	'pf0customfuncregistration' => { 73 => 0x1 },
	'pf10retainprogramshift' => { 73 => 0xb },
	'pf13drivepriority' => { 73 => 0xe },
	'pf14disablefocussearch' => { 73 => 0xf },
	'pf15disableafassistbeam' => { 73 => 0x10 },
	'pf16autofocuspointshoot' => { 73 => 0x11 },
	'pf17disableafpointsel' => { 73 => 0x12 },
	'pf18enableautoafpointsel' => { 73 => 0x13 },
	'pf19continuousshootspeed' => { 73 => 0x14 },
	'pf19shootingspeedhigh' => { 72 => 0xa },
	'pf19shootingspeedlow' => { 72 => 0x9 },
	'pf1disableshootingmodes' => { 73 => 0x2 },
	'pf1value' => { 72 => 0x1 },
	'pf20limitcontinousshots' => { 73 => 0x15 },
	'pf20maxcontinousshots' => { 72 => 0xb },
	'pf21enablequietoperation' => { 73 => 0x16 },
	'pf23felocktime' => { 72 => 0xd },
	'pf23postreleasetime' => { 72 => 0xe },
	'pf23settimerlengths' => { 73 => 0x18 },
	'pf23shutterbuttontime' => { 72 => 0xc },
	'pf24lightlcdduringbulb' => { 73 => 0x19 },
	'pf25aemode' => { 72 => 0xf },
	'pf25afmode' => { 72 => 0x12 },
	'pf25afpointsel' => { 72 => 0x13 },
	'pf25colormatrix' => { 72 => 0x17 },
	'pf25defaultclearsettings' => { 73 => 0x1a },
	'pf25drivemode' => { 72 => 0x11 },
	'pf25imagesize' => { 72 => 0x14 },
	'pf25meteringmode' => { 72 => 0x10 },
	'pf25parameters' => { 72 => 0x16 },
	'pf25wbmode' => { 72 => 0x15 },
	'pf26shortenreleaselag' => { 73 => 0x1b },
	'pf27reversedialrotation' => { 73 => 0x1c },
	'pf27value' => { 72 => 0x18 },
	'pf28noquickdialexpcomp' => { 73 => 0x1d },
	'pf29quickdialswitchoff' => { 73 => 0x1e },
	'pf2disablemeteringmodes' => { 73 => 0x3 },
	'pf2value' => { 72 => 0x2 },
	'pf30enlargementmode' => { 73 => 0x1f },
	'pf31originaldecisiondata' => { 73 => 0x20 },
	'pf3manualexposuremetering' => { 73 => 0x4 },
	'pf3value' => { 72 => 0x3 },
	'pf4exposuretimelimits' => { 73 => 0x5 },
	'pf4exposuretimemax' => { 72 => 0x5 },
	'pf4exposuretimemin' => { 72 => 0x4 },
	'pf5aperturelimits' => { 73 => 0x6 },
	'pf5aperturemax' => { 72 => 0x7 },
	'pf5aperturemin' => { 72 => 0x6 },
	'pf6presetshootingmodes' => { 73 => 0x7 },
	'pf7bracketcontinuousshoot' => { 73 => 0x8 },
	'pf8bracketshots' => { 72 => 0x8 },
	'pf8setbracketshots' => { 73 => 0x9 },
	'pf9changebracketsequence' => { 73 => 0xa },
	'phasedetectaf' => { 155 => 0x6 },
	'phonenumber' => { 123 => 'Phone' },
	'photoeffect' => { 26 => 0x28 },
	'photoeffecthistoryxml' => { 210 => 0xe9651831 },
	'photoeffects' => { 210 => 0xab5eca5e },
	'photoeffectsblue' => { 212 => 0x8 },
	'photoeffectsgreen' => { 212 => 0x6 },
	'photoeffectsred' => { 212 => 0x4 },
	'photoeffectstype' => { 212 => 0x0 },
	'photoinfoplayback' => { 217 => '17.6', 222 => '33.6' },
	'photometricinterpretation' => { 92 => 0x106, 360 => 'PhotometricInterpretation' },
	'photoshopquality' => { 286 => 0x0 },
	'photostyle' => { 246 => 0x89 },
	'picklabel' => { 345 => 'PickLabel' },
	'pictinfo' => { 301 => 0x208 },
	'picturecontrol' => { 210 => 0xe2173c47 },
	'picturecontrolactive' => { 213 => 0x0 },
	'picturecontroladjust' => { 179 => 0x30 },
	'picturecontrolbase' => { 179 => 0x18 },
	'picturecontroldata' => { 177 => [0xbd,0x23] },
	'picturecontrolmode' => { 213 => 0x13 },
	'picturecontrolname' => { 179 => 0x4 },
	'picturecontrolquickadjust' => { 179 => 0x31 },
	'pictureeffect' => { 316 => 0x200e },
	'picturefinish' => { 145 => 0x71 },
	'picturemode' => { 97 => 0x1031, 227 => 0x520, 277 => [0xb,0x33], 302 => 0x3d },
	'picturemode2' => { 258 => 0x0 },
	'picturemodebwfilter' => { 227 => 0x525 },
	'picturemodecontrast' => { 227 => 0x523 },
	'picturemodeeffect' => { 227 => 0x52d },
	'picturemodehue' => { 227 => 0x522 },
	'picturemodesaturation' => { 227 => 0x521 },
	'picturemodesharpness' => { 227 => 0x524 },
	'picturemodetone' => { 227 => 0x526 },
	'picturestyle' => { 5 => [0x4b,0x51], 6 => 0xf4, 7 => 0x6c, 8 => 0x86, 9 => 0x73, 13 => 0xab, 14 => 0xa7, 15 => 0xb0, 16 => 0x6c, 17 => 0xa7, 18 => 0xf4, 19 => 0xb3, 21 => 0xf4, 57 => 0xa, 84 => 0x2 },
	'picturewizard' => { 299 => 0x21 },
	'picturewizardcolor' => { 297 => 0x1 },
	'picturewizardcontrast' => { 297 => 0x4 },
	'picturewizardmode' => { 297 => 0x0 },
	'picturewizardsaturation' => { 297 => 0x2 },
	'picturewizardsharpness' => { 297 => 0x3 },
	'pitchangle' => { 276 => 0x2 },
	'planarconfiguration' => { 92 => 0x11c, 360 => 'PlanarConfiguration' },
	'platenames' => { 369 => 'PlateNames' },
	'playbackmenustime' => { 219 => '20.1', 220 => '21.1', 221 => '21.1' },
	'playbackmonitorofftime' => { 222 => '8.1', 223 => '35.1', 226 => '21.1' },
	'playdisplay' => { 147 => 0x4e },
	'plusversion' => { 354 => 'Version' },
	'pmversion' => { 285 => 'PMVersion' },
	'pngwarning' => { 238 => 'Warning' },
	'portraitoutputhighlightpoint' => { 84 => 0x1d },
	'portraitoutputshadowpoint' => { 84 => 0x1e },
	'portraitrawcolortone' => { 84 => 0x16 },
	'portraitrawcontrast' => { 84 => 0x18 },
	'portraitrawhighlight' => { 84 => 0x76 },
	'portraitrawhighlightpoint' => { 84 => 0x1b },
	'portraitrawlinear' => { 84 => 0x19 },
	'portraitrawsaturation' => { 84 => 0x17 },
	'portraitrawshadow' => { 84 => 0x7f },
	'portraitrawshadowpoint' => { 84 => 0x1c },
	'portraitrawsharpness' => { 84 => 0x1a },
	'portraitrefiner' => { 88 => 0x302b },
	'portraitunsharpmaskfineness' => { 84 => 0x9a },
	'portraitunsharpmaskstrength' => { 84 => 0x98 },
	'portraitunsharpmaskthreshold' => { 84 => 0x9c },
	'poseheadingdegrees' => { 332 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 332 => 'PosePitchDegrees' },
	'poserolldegrees' => { 332 => 'PoseRollDegrees' },
	'postalcode' => { 127 => 'PostalCode' },
	'postcropvignetteamount' => { 342 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 342 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 342 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 342 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 342 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 342 => 'PostCropVignetteStyle' },
	'powersource' => { 256 => '0.1' },
	'poweruptime' => { 177 => 0xb6 },
	'precaptureframes' => { 232 => 0x300 },
	'predictor' => { 92 => 0x13d },
	'preflashreturnstrength' => { 190 => 0x28a },
	'prefs' => { 100 => 0xdd, 285 => 'Prefs' },
	'preservedfilename' => { 365 => 'PreservedFileName' },
	'presetwhitebalance' => { 147 => 0x24, 328 => 0x8002 },
	'presetwhitebalanceadj' => { 328 => 0x8014 },
	'previewapplicationname' => { 92 => 0xc716 },
	'previewapplicationversion' => { 92 => 0xc717 },
	'previewbutton' => { 217 => ['14.1','15.1'], 222 => '29.1', 223 => '14.1' },
	'previewbuttonplusdials' => { 217 => ['14.2','15.2'], 222 => '31.2' },
	'previewcolorspace' => { 92 => 0xc71a },
	'previewcropbottom' => { 284 => 0xef },
	'previewcropleft' => { 284 => 0xec },
	'previewcropright' => { 284 => 0xee },
	'previewcroptop' => { 284 => 0xed },
	'previewdatetime' => { 92 => 0xc71b },
	'previewimage' => { 88 => 0x2000, 89 => 'PreviewImage', 93 => 'PreviewImage', 95 => 0x4, 132 => 'data', 149 => 0x81, 232 => 0x280, 245 => 0x300, 316 => 0x2001 },
	'previewimageborders' => { 277 => 0x3e },
	'previewimageheight' => { 56 => 0x4, 110 => 0xfa58 },
	'previewimagelength' => { 56 => 0x2, 88 => 0x3, 92 => [0x117,0x202], 149 => 0x89, 180 => 0x202, 227 => 0x102, 232 => 0x1037, 277 => 0x3, 293 => 0x1e, 298 => 0x3, 302 => [0x1b,0x1d], 308 => 0x202 },
	'previewimagename' => { 132 => '1Name' },
	'previewimagesize' => { 88 => 0x2, 115 => 0x2, 132 => 'ImageSize', 277 => 0x2, 302 => [0x1c,0x1e], 316 => 0xb02c },
	'previewimagestart' => { 56 => 0x5, 88 => 0x4, 92 => [0x111,0x201], 149 => 0x88, 180 => 0x201, 227 => 0x101, 232 => 0x1036, 277 => 0x4, 293 => 0x1c, 298 => 0x2, 302 => [0x1a,0x1c], 308 => 0x201 },
	'previewimagetype' => { 132 => '0Type' },
	'previewimagevalid' => { 227 => 0x100, 232 => 0x1035 },
	'previewimagewidth' => { 56 => 0x3, 110 => 0xfa57 },
	'previewquality' => { 56 => 0x1 },
	'previewsettingsdigest' => { 92 => 0xc719 },
	'previewsettingsname' => { 92 => 0xc718 },
	'primaryafpoint' => { 155 => 0x7 },
	'primarychromaticities' => { 92 => 0x13f, 360 => 'PrimaryChromaticities' },
	'printim' => { 92 => 0xc4a5 },
	'prioritysetupshutterrelease' => { 147 => 0x1d, 305 => 0x28 },
	'privatertkinfo' => { 334 => 'privateRTKInfo' },
	'processingsoftware' => { 92 => 0xb },
	'processversion' => { 342 => 'ProcessVersion' },
	'producer' => { 236 => 'Producer', 352 => 'Producer' },
	'productid' => { 101 => 0x32 },
	'productioncode' => { 257 => 0x2 },
	'productorserviceconstraints' => { 354 => 'ProductOrServiceConstraints' },
	'profilecalibrationsig' => { 92 => 0xc6f4 },
	'profilecopyright' => { 92 => 0xc6fe },
	'profileembedpolicy' => { 92 => 0xc6fd },
	'profilehuesatmapdata1' => { 92 => 0xc6fa },
	'profilehuesatmapdata2' => { 92 => 0xc6fb },
	'profilehuesatmapdims' => { 92 => 0xc6f9 },
	'profilehuesatmapencoding' => { 92 => 0xc7a3 },
	'profilelooktabledata' => { 92 => 0xc726 },
	'profilelooktabledims' => { 92 => 0xc725 },
	'profilelooktableencoding' => { 92 => 0xc7a4 },
	'profilename' => { 92 => 0xc6f8 },
	'profiletonecurve' => { 92 => 0xc6fc },
	'programiso' => { 246 => 0x3c },
	'programline' => { 258 => '1.1' },
	'programmode' => { 152 => 0x5 },
	'programshift' => { 177 => 0xd },
	'programversion' => { 100 => 0x46 },
	'prohibits' => { 340 => 'prohibits' },
	'projectiontype' => { 332 => 'ProjectionType' },
	'projectname' => { 364 => 'projectName' },
	'projectref' => { 364 => 'projectRef' },
	'projectrefpath' => { 364 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 364 => [\'projectRef','projectRefType'] },
	'propertyreleaseid' => { 354 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 354 => 'PropertyReleaseStatus' },
	'province-state' => { 100 => 0x5f },
	'publicationdate' => { 355 => 'publicationDate' },
	'publicationname' => { 355 => 'publicationName' },
	'publisher' => { 343 => 'publisher' },
	'pulldown' => { 364 => 'pullDown' },
	'quality' => { 0 => 0x1, 26 => 0x3, 87 => 0x2, 88 => 0x3002, 97 => 0x1000, 108 => 0x9, 177 => 0x4, 200 => 0x3, 232 => 0x201, 242 => 0x300, 277 => 0x8, 282 => 0x2, 302 => 0x16, 305 => 0x56, 306 => 0x56, 307 => 0xb, 316 => 0x102 },
	'quality2' => { 321 => 0x29, 322 => 0x25 },
	'qualitymode' => { 88 => 0x8 },
	'quantizationmethod' => { 102 => 0x78 },
	'quickadjust' => { 213 => 0x2a },
	'quickcontroldialinmeter' => { 65 => 0x703 },
	'quickshot' => { 301 => 0x213 },
	'rangefinder' => { 219 => '4.1', 220 => '5.1', 221 => '5.1' },
	'rasterizedcaption' => { 100 => 0x7d },
	'rating' => { 92 => 0x4746, 284 => 0xdf, 316 => 0x2002, 337 => 'rating', 344 => 'rating', 362 => 'Rating' },
	'ratingpercent' => { 92 => 0x4749, 142 => 'Rating' },
	'rawandjpgrecording' => { 63 => 0x8, 149 => 0x109, 258 => 0xd },
	'rawbrightnessadj' => { 83 => 0x38 },
	'rawcoloradj' => { 83 => 0x2e },
	'rawcropbottom' => { 284 => 0xd4 },
	'rawcropleft' => { 284 => 0xd1 },
	'rawcropright' => { 284 => 0xd3 },
	'rawcroptop' => { 284 => 0xd2 },
	'rawcustomsaturation' => { 83 => 0x30 },
	'rawcustomtone' => { 83 => 0x34 },
	'rawdatauniqueid' => { 92 => 0xc65d },
	'rawdepth' => { 151 => 0x10 },
	'rawdevautogradation' => { 234 => 0x119 },
	'rawdevcolorspace' => { 233 => 0x108, 234 => 0x109 },
	'rawdevcontrastvalue' => { 233 => 0x106, 234 => 0x105 },
	'rawdeveditstatus' => { 233 => 0x10b },
	'rawdevelopmentprocess' => { 277 => 0x62 },
	'rawdevengine' => { 233 => 0x109, 234 => 0x10b },
	'rawdevexposurebiasvalue' => { 233 => 0x100, 234 => 0x100 },
	'rawdevgradation' => { 234 => 0x112 },
	'rawdevgraypoint' => { 233 => 0x103, 234 => 0x104 },
	'rawdevmemorycoloremphasis' => { 233 => 0x105, 234 => 0x108 },
	'rawdevnoisereduction' => { 233 => 0x10a, 234 => 0x10a },
	'rawdevpicturemode' => { 234 => 0x10c },
	'rawdevpm_bwfilter' => { 234 => 0x110 },
	'rawdevpmcontrast' => { 234 => 0x10e },
	'rawdevpmnoisefilter' => { 234 => 0x120 },
	'rawdevpmpicturetone' => { 234 => 0x111 },
	'rawdevpmsaturation' => { 234 => 0x10d },
	'rawdevpmsharpness' => { 234 => 0x10f },
	'rawdevsaturation3' => { 234 => 0x113 },
	'rawdevsaturationemphasis' => { 233 => 0x104, 234 => 0x107 },
	'rawdevsettings' => { 233 => 0x10c },
	'rawdevsharpnessvalue' => { 233 => 0x107, 234 => 0x106 },
	'rawdevversion' => { 233 => 0x0, 234 => 0x0 },
	'rawdevwbfineadjustment' => { 233 => 0x102, 234 => 0x103 },
	'rawdevwhitebalance' => { 234 => 0x101 },
	'rawdevwhitebalancevalue' => { 233 => 0x101, 234 => 0x102 },
	'rawfile' => { 92 => 0xfe4c },
	'rawfilename' => { 342 => 'RawFileName' },
	'rawimagecenter' => { 177 => 0x99 },
	'rawimagedigest' => { 92 => 0xc71c },
	'rawimagesize' => { 277 => 0x39 },
	'rawinfoversion' => { 235 => 0x0 },
	'rawjpgheight' => { 80 => 0x4 },
	'rawjpgquality' => { 43 => 0x6, 80 => 0x1 },
	'rawjpgsize' => { 43 => 0x7, 80 => 0x2 },
	'rawjpgwidth' => { 80 => 0x3 },
	'rawmeasuredrggb' => { 31 => 0x26a, 33 => 0x280, 35 => 0x194, 36 => 0x1ad },
	'rawrppused' => { 337 => 'rawrppused' },
	'rawtopreviewgain' => { 92 => 0xc7a8 },
	'reardisplay' => { 217 => '12.3' },
	'recognizedface1age' => { 241 => 0x20 },
	'recognizedface1name' => { 241 => 0x4 },
	'recognizedface1position' => { 241 => 0x18 },
	'recognizedface2age' => { 241 => 0x50 },
	'recognizedface2name' => { 241 => 0x34 },
	'recognizedface2position' => { 241 => 0x48 },
	'recognizedface3age' => { 241 => 0x80 },
	'recognizedface3name' => { 241 => 0x64 },
	'recognizedface3position' => { 241 => 0x78 },
	'recognizedfaceflags' => { 246 => 0x63 },
	'recommendedexposureindex' => { 92 => 0x8832 },
	'record' => { 91 => 'Record' },
	'recordbasisofrecord' => { 91 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 91 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 91 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 91 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 91 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 91 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 147 => 0x4d },
	'recorddynamicproperties' => { 91 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 78 => 0x1804 },
	'recordinformationwithheld' => { 91 => [\'Record','RecordInformationWithheld'] },
	'recordingmode' => { 87 => 0x1, 282 => 0x1 },
	'recordinstitutioncode' => { 91 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 91 => [\'Record','RecordInstitutionID'] },
	'recordmode' => { 26 => 0x9, 88 => 0x3000 },
	'recordownerinstitutioncode' => { 91 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 301 => 0x217 },
	'redbalance' => { 162 => 0x270, 232 => 0x1017, 250 => 0x11, 277 => 0x1c },
	'redcurvelimits' => { 83 => 0x18a },
	'redcurvepoints' => { 83 => 0x160 },
	'redeyecorrection' => { 214 => 0x0 },
	'redeyeinfo' => { 342 => 'RedEyeInfo' },
	'redeyereduction' => { 147 => 0x41, 307 => 0x28 },
	'redhue' => { 342 => 'RedHue' },
	'redsaturation' => { 342 => 'RedSaturation' },
	'reductionmatrix1' => { 92 => 0xc625 },
	'reductionmatrix2' => { 92 => 0xc626 },
	'reelname' => { 92 => 0xc789 },
	'reference1' => { 349 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 349 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 349 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 349 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 349 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 349 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 92 => 0x214, 360 => 'ReferenceBlackWhite' },
	'referencedate' => { 100 => 0x2f },
	'referencenumber' => { 100 => 0x32 },
	'references' => { 123 => 'References' },
	'referenceservice' => { 100 => 0x2d },
	'regionappliedtodimensions' => { 138 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 138 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 138 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 138 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 138 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 138 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 138 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 138 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 138 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 138 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 138 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 138 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 354 => 'RegionConstraints' },
	'regiondescription' => { 138 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 138 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 138 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 138 => 'Regions' },
	'regioninfodateregionsvalid' => { 139 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 139 => 'RegionInfo' },
	'regioninforegions' => { 139 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 138 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 138 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 139 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 139 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 139 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 139 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 139 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionseealso' => { 138 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 138 => [\'Regions','RegionsRegionListType'] },
	'registryid' => { 351 => 'RegistryId' },
	'registryitemid' => { 351 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 351 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 121 => 'data' },
	'relatedaudiofilename' => { 121 => '1Name' },
	'relatedaudiofiletype' => { 121 => '0Type' },
	'relatedimagefileformat' => { 92 => 0x1000 },
	'relatedimageheight' => { 92 => 0x1002 },
	'relatedimagewidth' => { 92 => 0x1001 },
	'relatedresourceid' => { 91 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 92 => 0xa004, 346 => 'RelatedSoundFile' },
	'relatedvideofile' => { 135 => 'data' },
	'relatedvideofilename' => { 135 => '1Name' },
	'relatedvideofiletype' => { 135 => '0Type' },
	'relation' => { 343 => 'relation' },
	'relationshipaccordingto' => { 91 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 91 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 91 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipremarks' => { 91 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativepeakaudiofilepath' => { 364 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 364 => 'relativeTimestamp' },
	'relativetimestampscale' => { 364 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 364 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 217 => '17.8', 222 => '33.8', 223 => '17.6' },
	'releasedate' => { 100 => 0x1e, 364 => 'releaseDate' },
	'releasemode' => { 88 => 0x3001, 316 => 0xb049 },
	'releasemode2' => { 321 => 0x10, 322 => 0x10 },
	'releasesetting' => { 78 => 0x1016 },
	'releasetime' => { 100 => 0x23 },
	'remoteonduration' => { 218 => '3.4', 219 => '17.2', 220 => '18.2', 221 => '18.2', 223 => '18.2', 224 => '4.3', 226 => '19.2' },
	'renditionclass' => { 365 => 'RenditionClass' },
	'renditionof' => { 365 => 'RenditionOf' },
	'renditionofalternatepaths' => { 365 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 365 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 365 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 365 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 365 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 365 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionofmanager' => { 365 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 365 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 365 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 365 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 365 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 365 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 365 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofrenditionclass' => { 365 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 365 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 365 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 365 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 365 => 'RenditionParams' },
	'repeatingflashcount' => { 166 => 0xd, 167 => 0xe, 168 => 0xe, 222 => '17.2', 223 => '24.2', 224 => '9.2', 225 => '24.2', 226 => '25.2' },
	'repeatingflashcountbuilt-in' => { 198 => 0x4db },
	'repeatingflashcountexternal' => { 198 => 0x4c3 },
	'repeatingflashoutput' => { 222 => '17.1', 223 => '24.1', 224 => '9.1', 225 => '24.1', 226 => '25.1' },
	'repeatingflashoutputexternal' => { 198 => 0x4c0 },
	'repeatingflashrate' => { 166 => 0xc, 167 => 0xd, 168 => 0xd, 222 => '18.1', 223 => '25.1', 224 => '10.1', 225 => '25.1', 226 => '26.1' },
	'repeatingflashratebuilt-in' => { 198 => 0x4da },
	'repeatingflashrateexternal' => { 198 => 0x4c2 },
	'requires' => { 340 => 'requires' },
	'resampleparams' => { 364 => 'resampleParams' },
	'resampleparamsquality' => { 364 => [\'resampleParams','resampleParamsQuality'] },
	'resaved' => { 301 => 0x21e },
	'resolution' => { 128 => 'Resolution' },
	'resolutionmode' => { 302 => 0x4 },
	'resolutionunit' => { 92 => 0x128, 103 => 0x2, 360 => 'ResolutionUnit' },
	'resourceid' => { 91 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 91 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 91 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictions' => { 357 => 'restrictions' },
	'retouchhistory' => { 177 => 0x9e },
	'retouchinfo' => { 342 => 'RetouchInfo' },
	'reuse' => { 354 => 'Reuse' },
	'reuseallowed' => { 367 => 'ReuseAllowed' },
	'reuseprohibited' => { 357 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 221 => '5.2' },
	'reverseindicators' => { 217 => '12.1', 219 => '4.3', 220 => '5.2', 221 => '5.4', 222 => '33.5', 223 => '5.1', 226 => '6.2' },
	'reverseshutterspeedaperture' => { 221 => '5.3' },
	'revision' => { 344 => 'revision' },
	'rgbcurvelimits' => { 83 => 0x238 },
	'rgbcurvepoints' => { 83 => 0x20e },
	'richtextcomment' => { 348 => 'RichTextComment' },
	'ricohdate' => { 293 => 0x6 },
	'ricohimageheight' => { 293 => 0x2 },
	'ricohimagewidth' => { 293 => 0x0 },
	'rightascension' => { 131 => 'RightAscension' },
	'rights' => { 343 => 'rights' },
	'rightsagent' => { 355 => 'rightsAgent', 357 => 'rightsAgent' },
	'rightsowner' => { 357 => 'rightsOwner' },
	'rollangle' => { 276 => 0x1 },
	'romoperationmode' => { 78 => 0x80d },
	'rotation' => { 23 => 0x17, 24 => 0x18, 77 => 0x3, 83 => 0x26e, 96 => 0x4, 131 => 'Rotation', 145 => [0x65,0x50], 146 => 0x46, 147 => 0x5a, 150 => 0x10, 197 => '590.1', 210 => 0x76a43207, 246 => 0x30, 258 => '17.2', 284 => 0xd8, 305 => 0x3f, 306 => 0x3f, 315 => 0x10 },
	'routedto' => { 347 => 'RoutedTo' },
	'routing' => { 289 => 'Routing' },
	'routingnotes' => { 347 => 'RoutingNotes' },
	'rowsperstrip' => { 92 => 0x116 },
	'rpp' => { 337 => 'rpp' },
	'safetyshift' => { 65 => 0x108 },
	'safetyshiftinavortv' => { 63 => 0x10, 64 => 0x10, 66 => 0xf, 67 => 0x10, 70 => 0x10 },
	'samplebits' => { 121 => 'SampleBits' },
	'samplerate' => { 121 => 'SampleRate' },
	'samplesperpixel' => { 92 => 0x115, 360 => 'SamplesPerPixel' },
	'samplestructure' => { 102 => 0x5a },
	'sanyoquality' => { 301 => 0x201 },
	'sanyothumbnail' => { 301 => 0x100 },
	'saturation' => { 7 => 0x6e, 9 => 0x76, 26 => 0xe, 37 => 0x1, 87 => 0xd, 88 => [0x3013,0x1f], 92 => [0xa409,0xfe55], 97 => 0x1003, 122 => 'Saturation', 144 => 0x1f, 145 => 0x32, 146 => 0x28, 147 => 0x1a, 152 => 0x1, 177 => [0x94,0xaa], 179 => 0x35, 246 => 0x40, 248 => 0x300d, 277 => 0x1f, 282 => 0xd, 290 => 0x27, 293 => 0x28, 302 => 0x10, 305 => 0x1e, 306 => 0x1b, 316 => 0x2005, 342 => 'Saturation', 346 => 'Saturation' },
	'saturationadj' => { 83 => 0x116, 209 => 0x1, 213 => 0x2e, 328 => 0x8016 },
	'saturationadjustmentaqua' => { 342 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 342 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 342 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 342 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 342 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 342 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 342 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 342 => 'SaturationAdjustmentYellow' },
	'saturationfaithful' => { 16 => 0xfe, 53 => 0x68, 54 => 0x68 },
	'saturationlandscape' => { 16 => 0xfc, 53 => 0x38, 54 => 0x38 },
	'saturationmonochrome' => { 53 => 0x80, 54 => 0x80 },
	'saturationneutral' => { 16 => 0xfd, 53 => 0x50, 54 => 0x50 },
	'saturationportrait' => { 16 => 0xfb, 53 => 0x20, 54 => 0x20 },
	'saturationsetting' => { 235 => 0x1010, 307 => 0x11, 317 => 0x9 },
	'saturationstandard' => { 16 => 0xfa, 53 => 0x8, 54 => 0x8 },
	'saturationunknown' => { 54 => 0x98 },
	'saturationuserdef1' => { 16 => 0x100, 53 => 0x98, 54 => 0xb0 },
	'saturationuserdef2' => { 16 => 0x101, 53 => 0xb0, 54 => 0xc8 },
	'saturationuserdef3' => { 16 => 0x102, 53 => 0xc8, 54 => 0xe0 },
	'saveid' => { 365 => 'SaveID' },
	'scaletype' => { 364 => 'scaleType' },
	'scanimageenhancer' => { 182 => 0x60 },
	'scanningdirection' => { 102 => 0x64 },
	'scene' => { 350 => 'Scene', 364 => 'scene' },
	'scenearea' => { 230 => 0x211, 232 => 0x1031 },
	'sceneassist' => { 177 => 0x9c },
	'scenecapturetype' => { 92 => 0xa406, 346 => 'SceneCaptureType' },
	'scenedetect' => { 230 => 0x210, 232 => 0x1030 },
	'scenedetectdata' => { 230 => 0x212, 232 => 0x1033 },
	'scenemode' => { 110 => 0xfa02, 149 => 0x100, 177 => 0x8f, 227 => 0x509, 232 => 0x403, 246 => 0x8001, 252 => 0xf, 316 => 0xb023 },
	'scenemodeused' => { 112 => [0x6002,0xf002] },
	'sceneselect' => { 301 => 0x21f },
	'scenetype' => { 92 => 0xa301, 346 => 'SceneType' },
	'screentips' => { 217 => '12.7', 222 => '13.1', 223 => '4.4', 226 => '5.1' },
	'section' => { 355 => 'section' },
	'securityclassification' => { 92 => 0x9212 },
	'selectableafpoint' => { 65 => 0x509 },
	'selectafareaselectmode' => { 65 => 0x512 },
	'selftimer' => { 26 => 0x2, 246 => 0x2e, 301 => 0x214 },
	'selftimer2' => { 59 => 0x1d },
	'selftimerinterval' => { 223 => '19.2' },
	'selftimermode' => { 92 => 0x882b },
	'selftimershotcount' => { 219 => '18.2', 220 => '19.2', 221 => '19.2', 223 => '19.3', 226 => '20.2' },
	'selftimertime' => { 78 => 0x1806, 147 => 0x1f, 217 => '18.1', 218 => '3.3', 219 => '18.1', 220 => '19.1', 221 => '19.1', 222 => '7.2', 223 => '19.1', 224 => '3.3', 226 => '20.1' },
	'seminfo' => { 92 => 0x8546 },
	'sensingmethod' => { 92 => 0xa217, 346 => 'SensingMethod' },
	'sensitivityadjust' => { 277 => 0x40 },
	'sensitivitysteps' => { 258 => ['14.3','17.4'], 260 => 0x1 },
	'sensitivitytype' => { 92 => 0x8830 },
	'sensorareas' => { 299 => 0xa010 },
	'sensorbitdepth' => { 248 => 0x312d },
	'sensorbluelevel' => { 57 => 0x5 },
	'sensorcleaning' => { 71 => 0xd },
	'sensorfullheight' => { 105 => 0xf904 },
	'sensorfullwidth' => { 105 => 0xf903 },
	'sensorheight' => { 105 => 0xf901, 110 => 0xfa21, 151 => 0x8, 248 => 0x312c },
	'sensorpixelsize' => { 177 => 0x9a },
	'sensorredlevel' => { 57 => 0x4 },
	'sensorsize' => { 122 => 'SensorSize', 277 => 0x35 },
	'sensortemperature' => { 230 => 0x1500, 232 => 0x1007, 302 => [0x39,0x55] },
	'sensorwidth' => { 105 => 0xf900, 110 => 0xfa20, 151 => 0xa, 248 => 0x312b },
	'sequence' => { 290 => 0x7 },
	'sequencefilenumber' => { 321 => 0xc, 322 => 0xc },
	'sequenceimagenumber' => { 321 => 0x8, 322 => 0x8 },
	'sequencelength' => { 321 => 0x22, 322 => 0x1e },
	'sequencenumber' => { 59 => 0x9, 88 => 0x301c, 97 => 0x1101, 108 => 0x1d, 198 => 0x51c, 246 => 0x2b, 307 => [0x10c,0x30c], 316 => 0xb04a },
	'sequenceshotinterval' => { 301 => 0x224 },
	'sequentialshot' => { 301 => 0x20e },
	'serialnumber' => { 48 => 0xc, 78 => 0x180b, 92 => [0xa431,0xfde9], 105 => 0xfa04, 107 => 0xfa00, 109 => 0xc354, 110 => 0xfa19, 119 => 0x0, 122 => 'SerialNumber', 177 => [0xa0,0x1d], 228 => 0x101, 232 => [0x404,0x101a], 242 => 0x303, 248 => 0x3103, 277 => 0x229, 290 => 0x15, 294 => 0x5, 302 => 0x2, 339 => 'SerialNumber' },
	'serialnumberformat' => { 48 => 0x15, 78 => 0x183b },
	'seriesdatetime' => { 330 => 'SeriesDateTime' },
	'seriesdescription' => { 330 => 'SeriesDescription' },
	'seriesmodality' => { 330 => 'SeriesModality' },
	'seriesnumber' => { 330 => 'SeriesNumber' },
	'serviceidentifier' => { 101 => 0x1e },
	'setbuttoncrosskeysfunc' => { 68 => 0x0, 69 => 0x0 },
	'setbuttonwhenshooting' => { 63 => 0x1, 65 => 0x704, 71 => 0xc },
	'setfunctionwhenshooting' => { 66 => 0x0, 67 => 0x1, 70 => 0x1 },
	'shadingcompensation' => { 227 => 0x50c },
	'shadingcompensation2' => { 231 => 0x1012 },
	'shadow' => { 302 => 0xe },
	'shadowcorrection' => { 277 => 0x79 },
	'shadowprotection' => { 209 => 0x0 },
	'shadows' => { 92 => 0xfe52, 336 => 'Shadows', 342 => 'Shadows' },
	'shadows2012' => { 342 => 'Shadows2012' },
	'shadowscale' => { 92 => 0xc633 },
	'shadowtint' => { 342 => 'ShadowTint' },
	'shakereduction' => { 278 => 0x1 },
	'sharpendetail' => { 342 => 'SharpenDetail' },
	'sharpenedgemasking' => { 342 => 'SharpenEdgeMasking' },
	'sharpening' => { 248 => 0x300b },
	'sharpeningadj' => { 213 => 0x2b },
	'sharpenradius' => { 342 => 'SharpenRadius' },
	'sharpness' => { 5 => [0x42,0x48], 7 => 0x72, 9 => 0x74, 26 => 0xf, 57 => 0x2, 87 => 0xb, 88 => [0x3011,0x21], 92 => [0xa40a,0xfe56], 97 => 0x1001, 108 => 0x6b, 117 => 0x37, 122 => 'Sharpness', 144 => 0x21, 145 => 0x30, 146 => 0x26, 147 => 0x18, 152 => 0x3, 177 => 0x6, 179 => 0x32, 232 => 0x100f, 246 => 0x41, 277 => 0x21, 282 => 0xb, 290 => 0x26, 293 => 0x22, 294 => 0x1003, 302 => 0x11, 305 => 0x1c, 306 => 0x19, 316 => 0x2006, 342 => 'Sharpness', 346 => 'Sharpness' },
	'sharpnessadj' => { 83 => 0x25a, 328 => 0x801a },
	'sharpnessfactor' => { 232 => 0x102a },
	'sharpnessfaithful' => { 16 => 0xf5, 53 => 0x64, 54 => 0x64 },
	'sharpnessfrequency' => { 5 => [0x41,0x47], 57 => 0x3 },
	'sharpnesslandscape' => { 16 => 0xf3, 53 => 0x34, 54 => 0x34 },
	'sharpnessmonochrome' => { 16 => 0xf6, 53 => 0x7c, 54 => 0x7c },
	'sharpnessneutral' => { 16 => 0xf4, 53 => 0x4c, 54 => 0x4c },
	'sharpnessovershoot' => { 328 => 0x801b },
	'sharpnessportrait' => { 16 => 0xf2, 53 => 0x1c, 54 => 0x1c },
	'sharpnesssetting' => { 227 => 0x506, 235 => 0x1013, 307 => 0x12, 317 => 0xa },
	'sharpnessstandard' => { 16 => 0xf1, 53 => 0x4, 54 => 0x4 },
	'sharpnessthreshold' => { 328 => 0x801d },
	'sharpnessundershoot' => { 328 => 0x801c },
	'sharpnessunknown' => { 54 => 0x94 },
	'sharpnessuserdef1' => { 16 => 0xf7, 53 => 0x94, 54 => 0xac },
	'sharpnessuserdef2' => { 16 => 0xf8, 53 => 0xac, 54 => 0xc4 },
	'sharpnessuserdef3' => { 16 => 0xf9, 53 => 0xc4, 54 => 0xdc },
	'shootinginfodisplay' => { 217 => '13.2', 222 => '10.2', 223 => '4.1', 226 => '5.3' },
	'shootinginfomonitorofftime' => { 222 => '9.1', 223 => '21.2', 226 => '22.2' },
	'shootingmode' => { 122 => 'ShootingMode', 177 => 0x89, 246 => 0x1f },
	'shootingmodesetting' => { 218 => '5.1' },
	'shortdescription' => { 344 => 'shortdescription' },
	'shortdocumentid' => { 100 => 0xba },
	'shortownername' => { 16 => 0xac },
	'shortreleasetimelag' => { 65 => 0x80d },
	'shotdate' => { 364 => 'shotDate' },
	'shotday' => { 364 => 'shotDay' },
	'shotlocation' => { 364 => 'shotLocation' },
	'shotname' => { 364 => 'shotName' },
	'shotnumber' => { 364 => 'shotNumber' },
	'shotnumbersincepowerup' => { 321 => 0x1a, 322 => 0x16 },
	'shotsize' => { 364 => 'shotSize' },
	'shutter-aelock' => { 63 => 0x4, 65 => 0x701, 66 => 0x3, 67 => 0x4, 68 => 0x3, 69 => 0x3, 70 => 0x4, 71 => 0x2 },
	'shutteraelbutton' => { 64 => 0x4 },
	'shutterbuttonafonbutton' => { 65 => 0x701 },
	'shuttercount' => { 8 => 0x176, 43 => 0x1, 177 => 0xa7, 183 => [0x6a,0x157,0x24d], 184 => 0x286, 185 => 0x279, 186 => 0x284, 187 => 0x242, 188 => 0x280, 189 => 0x276, 190 => [0x27d,0x27f], 191 => 0x246, 192 => 0x2d6, 193 => 0x321, 194 => 0xbd8, 195 => 0x287, 196 => 0x320, 197 => 0x24a, 198 => 0x5fb, 199 => 0x2d5, 277 => 0x5d },
	'shuttercurtainsync' => { 63 => 0xf, 64 => 0xf, 65 => 0x305, 66 => 0xe, 67 => 0xf, 68 => 0x8, 69 => 0x8, 70 => 0xf, 71 => 0x8 },
	'shuttermode' => { 108 => 0x1b },
	'shutterreleasebuttonae-l' => { 217 => '17.7', 219 => '16.1', 220 => '17.1', 221 => '17.1', 222 => '7.1', 223 => '17.5', 226 => '18.2' },
	'shutterreleasemethod' => { 78 => 0x1010 },
	'shutterreleasenocfcard' => { 63 => 0x2, 64 => 0x2, 71 => 0xf },
	'shutterreleasetiming' => { 78 => 0x1011 },
	'shutterspeedrange' => { 65 => 0x10c },
	'shutterspeedsetting' => { 147 => 0x6, 305 => 0x2f, 306 => 0x28, 307 => 0x0 },
	'shutterspeedvalue' => { 74 => 0x1, 92 => 0x9201, 232 => 0x1000, 346 => 'ShutterSpeedValue' },
	'sidecarforextension' => { 353 => 'SidecarForExtension' },
	'similarityindex' => { 100 => 0xe4 },
	'singleframebracketing' => { 147 => 0x21 },
	'slaveflashmeteringsegments' => { 277 => 0x20b },
	'slowshutter' => { 59 => 0x8 },
	'slowsync' => { 97 => 0x1030 },
	'smartrange' => { 299 => 0xa012 },
	'smileshutter' => { 307 => 0x31 },
	'smileshuttermode' => { 307 => 0x27 },
	'smoothness' => { 92 => 0xfe57, 342 => 'Smoothness' },
	'softskineffect' => { 316 => 0x200f },
	'software' => { 92 => 0x131, 123 => 'Software', 238 => 'Software', 302 => 0x18, 360 => 'Software' },
	'softwareversion' => { 301 => 0x207 },
	'sonydatetime' => { 319 => 0x6 },
	'sonyimageheight' => { 319 => 0x1a },
	'sonyimagesize' => { 147 => 0x3b, 305 => 0x54, 306 => 0x54, 307 => 0x9 },
	'sonyimagewidth' => { 319 => 0x1c },
	'sonymodelid' => { 316 => 0xb001 },
	'sonyquality' => { 147 => 0x3c },
	'source' => { 100 => 0x73, 238 => 'Source', 343 => 'source', 344 => 'source', 353 => 'Source' },
	'sourcedirectoryindex' => { 264 => 0x0 },
	'sourcefileindex' => { 264 => 0x2 },
	'sourcephotoscount' => { 332 => 'SourcePhotosCount' },
	'spatialfrequencyresponse' => { 346 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 346 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 346 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 346 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 346 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 364 => 'speakerPlacement' },
	'specialeffectlevel' => { 88 => 0x3030 },
	'specialeffectmode' => { 88 => 0x2076 },
	'specialeffectsetting' => { 88 => 0x3031 },
	'specialinstructions' => { 100 => 0x28 },
	'specialmode' => { 232 => 0x200, 301 => 0x200 },
	'spectralsensitivity' => { 92 => 0x8824, 346 => 'SpectralSensitivity' },
	'splittoningbalance' => { 342 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 342 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 342 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 342 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 342 => 'SplitToningShadowSaturation' },
	'spotfocuspointx' => { 144 => 0x2d },
	'spotfocuspointy' => { 144 => 0x2e },
	'spotmeteringmode' => { 26 => 0x27 },
	'spotmeterlinktoafpoint' => { 65 => 0x107 },
	'sractive' => { 258 => '17.1' },
	'srawquality' => { 26 => 0x2e },
	'srfocallength' => { 278 => 0x3 },
	'srhalfpresstime' => { 278 => 0x2 },
	'srresult' => { 278 => 0x0 },
	'standardoutputhighlightpoint' => { 84 => 0x14 },
	'standardoutputsensitivity' => { 92 => 0x8831 },
	'standardoutputshadowpoint' => { 84 => 0x15 },
	'standardrawcolortone' => { 84 => 0xd },
	'standardrawcontrast' => { 84 => 0xf },
	'standardrawhighlight' => { 84 => 0x75 },
	'standardrawhighlightpoint' => { 84 => 0x12 },
	'standardrawlinear' => { 84 => 0x10 },
	'standardrawsaturation' => { 84 => 0xe },
	'standardrawshadow' => { 84 => 0x7e },
	'standardrawshadowpoint' => { 84 => 0x13 },
	'standardrawsharpness' => { 84 => 0x11 },
	'standardunsharpmaskfineness' => { 84 => 0x94 },
	'standardunsharpmaskstrength' => { 84 => 0x92 },
	'standardunsharpmaskthreshold' => { 84 => 0x96 },
	'standbytimer' => { 221 => '18.1' },
	'startingpage' => { 355 => 'startingPage' },
	'startmovieshooting' => { 65 => 0x70d },
	'starttimecode' => { 364 => 'startTimecode' },
	'starttimecodetimeformat' => { 364 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 364 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 364 => [\'startTimecode','startTimecodeValue'] },
	'state' => { 127 => 'State', 246 => 0x6b, 353 => 'State' },
	'status' => { 335 => 'Status' },
	'stitchingsoftware' => { 332 => 'StitchingSoftware' },
	'storagemethod' => { 151 => 0x12 },
	'straightenangle' => { 210 => 0x2fc08431 },
	'stretchmode' => { 364 => 'stretchMode' },
	'studydatetime' => { 330 => 'StudyDateTime' },
	'studydescription' => { 330 => 'StudyDescription' },
	'studyid' => { 330 => 'StudyID' },
	'studyphysician' => { 330 => 'StudyPhysician' },
	'sub-location' => { 100 => 0x5c },
	'subfiledata' => { 130 => 'data' },
	'subfiledirectory' => { 130 => '1Directory' },
	'subfilemimetype' => { 130 => '2MIME' },
	'subfilename' => { 130 => '1Name' },
	'subfileresource' => { 130 => 'rsrc' },
	'subfiletype' => { 92 => 0xfe, 130 => '0Type' },
	'subject' => { 236 => 'Subject', 289 => 'Subject', 343 => 'subject', 352 => 'Subject', 365 => 'subject' },
	'subjectarea' => { 92 => 0x9214, 346 => 'SubjectArea' },
	'subjectcode' => { 350 => 'SubjectCode' },
	'subjectdistance' => { 92 => 0x9206, 108 => 0x3e, 346 => 'SubjectDistance' },
	'subjectdistancerange' => { 92 => 0xa40c, 346 => 'SubjectDistanceRange' },
	'subjectlocation' => { 92 => 0xa214, 346 => 'SubjectLocation' },
	'subjectprogram' => { 144 => 0x22 },
	'subjectreference' => { 100 => 0xc },
	'sublabels4' => { 349 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 349 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublables1' => { 349 => [\'TagStructure','TagStructureSubLabels'] },
	'sublables2' => { 349 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublables3' => { 349 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'subsectime' => { 92 => 0x9290 },
	'subsectimedigitized' => { 92 => 0x9292 },
	'subsectimeoriginal' => { 92 => 0x9291 },
	'subsection1' => { 355 => 'subsection1' },
	'subsection2' => { 355 => 'subsection2' },
	'subsection3' => { 355 => 'subsection3' },
	'subsection4' => { 355 => 'subsection4' },
	'subversionfilename' => { 349 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 349 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 349 => 'SubVersions' },
	'superimposeddisplay' => { 63 => 0xa, 65 => 0x510, 66 => 0x9, 67 => 0xa, 70 => 0xa, 71 => 0xe },
	'supermacro' => { 48 => 0x1a },
	'supplementalcategories' => { 100 => 0x14, 353 => 'SupplementalCategories' },
	'supplementaltype' => { 102 => 0x37 },
	'svisosetting' => { 258 => 0x14 },
	'sweeppanoramadirection' => { 307 => 0x33 },
	'sweeppanoramasize' => { 307 => 0x32 },
	'switchtoregisteredafpoint' => { 64 => 0x12, 65 => 0x50a },
	'tagged' => { 284 => 0xdd, 285 => 'Tagged', 337 => 'tagged' },
	'tagslist' => { 345 => 'TagsList' },
	'tagstructure' => { 349 => 'TagStructure' },
	'takenumber' => { 364 => 'takeNumber' },
	'tapename' => { 364 => 'tapeName' },
	'targetaperture' => { 59 => 0x4 },
	'targetcompressionratio' => { 76 => 0x1 },
	'targetdistancesetting' => { 78 => 0x1807 },
	'targetexposuretime' => { 59 => 0x5 },
	'targetimagetype' => { 78 => 0x100a },
	'taxon' => { 91 => 'Taxon' },
	'taxonacceptednameusage' => { 91 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 91 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 91 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 91 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxonfamily' => { 91 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 91 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 91 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 91 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 91 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 91 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 91 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 91 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 91 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 91 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnomenclaturalcode' => { 91 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 91 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 91 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 91 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonparentnameusage' => { 91 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 91 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 91 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 91 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 91 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 91 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 91 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 91 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 91 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 91 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 91 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 91 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 91 => [\'Taxon','TaxonVernacularName'] },
	'teaser' => { 355 => 'teaser' },
	'teleconverter' => { 149 => 0x105, 316 => 0x105 },
	'tempo' => { 364 => 'tempo' },
	'termsandconditionstext' => { 354 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 354 => 'TermsAndConditionsURL' },
	'textencoding' => { 176 => 0x4 },
	'textlayername' => { 353 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 353 => 'TextLayers' },
	'textlayertext' => { 353 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 246 => [0x8008,0x8009,0x3b,0x3e] },
	'thresholding' => { 92 => 0x107 },
	'thumbnailfilename' => { 78 => 0x817 },
	'thumbnailformat' => { 362 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 110 => 0xfa55, 362 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 78 => 0x2008, 89 => 'ThumbnailImage', 95 => 0x3, 133 => 'data', 232 => 0x100, 362 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 133 => '1Name' },
	'thumbnailimagesize' => { 133 => 'ImageSize' },
	'thumbnailimagetype' => { 133 => '0Type' },
	'thumbnailimagevalidarea' => { 48 => 0x13 },
	'thumbnaillength' => { 92 => 0x202 },
	'thumbnailoffset' => { 92 => 0x201 },
	'thumbnails' => { 362 => 'Thumbnails' },
	'thumbnailwidth' => { 110 => 0xfa54, 362 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 355 => 'ticker' },
	'tilelength' => { 92 => 0x143 },
	'tilewidth' => { 92 => 0x142 },
	'time' => { 106 => 0x401, 277 => 0x7 },
	'timecodes' => { 92 => 0xc763 },
	'timecreated' => { 100 => 0x3c, 108 => 0x14, 117 => 0x10, 285 => 'TimeCreated' },
	'timeperiod' => { 355 => 'timePeriod' },
	'timerfunctionbutton' => { 218 => '5.2', 219 => '12.1', 220 => '13.1' },
	'timerlength' => { 65 => 0x80c },
	'timescaleparams' => { 364 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 364 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 364 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 364 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 101 => 0x50 },
	'timesignature' => { 364 => 'timeSignature' },
	'timesincepoweron' => { 246 => 0x29 },
	'timestamp' => { 8 => 0x45e, 16 => 0x11c, 238 => 'TimeStamp', 338 => 'Timestamp' },
	'timestamp1' => { 8 => 0x45a },
	'timezone' => { 60 => 0x1, 202 => 0x0 },
	'timezonecity' => { 60 => 0x2 },
	'timezonecode' => { 81 => 0x1 },
	'timezoneinfo' => { 81 => 0x2 },
	'timezoneoffset' => { 92 => 0x882a },
	'tint' => { 342 => 'Tint' },
	'title' => { 123 => 'Title', 236 => 'Title', 238 => 'Title', 246 => 0x65, 289 => 'Title', 343 => 'title', 352 => 'Title', 362 => 'Title' },
	'tonecomp' => { 177 => 0x81 },
	'tonecurve' => { 57 => 0x1, 277 => 0x402, 342 => 'ToneCurve' },
	'tonecurve1' => { 299 => 0xa040 },
	'tonecurve2' => { 299 => 0xa041 },
	'tonecurve3' => { 299 => 0xa042 },
	'tonecurve4' => { 299 => 0xa043 },
	'tonecurveactive' => { 83 => 0x110 },
	'tonecurveblue' => { 342 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 328 => 0x9003 },
	'tonecurvebluey' => { 328 => 0x9007 },
	'tonecurvebrightnessx' => { 328 => 0x9000 },
	'tonecurvebrightnessy' => { 328 => 0x9004 },
	'tonecurvefilename' => { 106 => 0x1391 },
	'tonecurvegreen' => { 342 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 328 => 0x9002 },
	'tonecurvegreeny' => { 328 => 0x9006 },
	'tonecurveinterpolation' => { 83 => 0x159 },
	'tonecurvemode' => { 83 => 0x113 },
	'tonecurvename' => { 342 => 'ToneCurveName' },
	'tonecurvename2012' => { 342 => 'ToneCurveName2012' },
	'tonecurveproperty' => { 83 => 0x3c },
	'tonecurvepv2012' => { 342 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 342 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 342 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 342 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 342 => 'ToneCurveRed' },
	'tonecurveredx' => { 328 => 0x9001 },
	'tonecurveredy' => { 328 => 0x9005 },
	'tonecurves' => { 277 => 0x403 },
	'toningeffect' => { 43 => 0xf, 177 => 0xb3, 179 => 0x38 },
	'toningeffectfaithful' => { 53 => 0x74, 54 => 0x74 },
	'toningeffectlandscape' => { 53 => 0x44, 54 => 0x44 },
	'toningeffectmonochrome' => { 16 => 0x108, 53 => 0x8c, 54 => 0x8c },
	'toningeffectneutral' => { 53 => 0x5c, 54 => 0x5c },
	'toningeffectportrait' => { 53 => 0x2c, 54 => 0x2c },
	'toningeffectstandard' => { 53 => 0x14, 54 => 0x14 },
	'toningeffectunknown' => { 54 => 0xa4 },
	'toningeffectuserdef1' => { 53 => 0xa4, 54 => 0xbc },
	'toningeffectuserdef2' => { 53 => 0xbc, 54 => 0xd4 },
	'toningeffectuserdef3' => { 53 => 0xd4, 54 => 0xec },
	'toningsaturation' => { 179 => 0x39 },
	'totalzoom' => { 108 => 0x62 },
	'tracknumber' => { 364 => 'trackNumber' },
	'tracks' => { 364 => 'Tracks' },
	'tracksframerate' => { 364 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 364 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 364 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 364 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 364 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 364 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 364 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 364 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 364 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 364 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 364 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 364 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 364 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 364 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 364 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 364 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 364 => [\'Tracks','TracksTrackType'] },
	'trailersignature' => { 130 => 'zmie' },
	'transferfunction' => { 92 => 0x12d, 360 => 'TransferFunction' },
	'transform' => { 246 => [0x8012,0x59] },
	'transmissionreference' => { 353 => 'TransmissionReference' },
	'trapped' => { 236 => 'Trapped', 352 => 'Trapped' },
	'travelday' => { 246 => 0x36 },
	'triggermode' => { 290 => 0x6 },
	'tstop' => { 92 => 0xc772 },
	'ttl_da_adown' => { 265 => 0x5 },
	'ttl_da_aup' => { 265 => 0x4 },
	'ttl_da_bdown' => { 265 => 0x7 },
	'ttl_da_bup' => { 265 => 0x6 },
	'tungstenawb' => { 255 => 0x1 },
	'tvexposuretimesetting' => { 258 => 0x12 },
	'type' => { 343 => 'type', 359 => 'type' },
	'typestatus' => { 91 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 92 => 0xc614 },
	'uniquedocumentid' => { 100 => 0xbb },
	'uniqueobjectname' => { 101 => 0x64 },
	'unknownblock' => { 277 => 0x405 },
	'unknownblock1' => { 231 => 0x635 },
	'unknownblock2' => { 231 => 0x636 },
	'unknownblock3' => { 231 => 0x1103 },
	'unknownblock4' => { 231 => 0x1104 },
	'unknowncontrast' => { 84 => 0x45 },
	'unknownev' => { 106 => 0x1 },
	'unknownlinear' => { 84 => 0x46 },
	'unknownmaximumtemperature' => { 94 => 0x5 },
	'unknownminimumtemperature' => { 94 => 0x6 },
	'unknownnumber' => { 78 => 0x180b },
	'unknownoutputhighlightpoint' => { 84 => 0x4a },
	'unknownoutputshadowpoint' => { 84 => 0x4b },
	'unknownrawhighlight' => { 84 => 0x7b },
	'unknownrawhighlightpoint' => { 84 => 0x48 },
	'unknownrawshadow' => { 84 => 0x84 },
	'unknownrawshadowpoint' => { 84 => 0x49 },
	'unknownsharpness' => { 84 => 0x47 },
	'unknowntemperature' => { 94 => 0x4 },
	'unsharp1color' => { 215 => 0x13 },
	'unsharp1halowidth' => { 215 => 0x19 },
	'unsharp1intensity' => { 215 => 0x17 },
	'unsharp1threshold' => { 215 => 0x1b },
	'unsharp2color' => { 215 => 0x2e },
	'unsharp2halowidth' => { 215 => 0x34 },
	'unsharp2intensity' => { 215 => 0x32 },
	'unsharp2threshold' => { 215 => 0x36 },
	'unsharp3color' => { 215 => 0x49 },
	'unsharp3halowidth' => { 215 => 0x4f },
	'unsharp3intensity' => { 215 => 0x4d },
	'unsharp3threshold' => { 215 => 0x51 },
	'unsharp4color' => { 215 => 0x64 },
	'unsharp4halowidth' => { 215 => 0x6a },
	'unsharp4intensity' => { 215 => 0x68 },
	'unsharp4threshold' => { 215 => 0x6c },
	'unsharpcount' => { 215 => 0x0 },
	'unsharpmask' => { 84 => 0x90, 210 => 0x76a43200 },
	'urgency' => { 100 => 0xa, 353 => 'Urgency' },
	'url' => { 123 => 'URL', 238 => 'URL', 287 => 0x40b, 355 => 'url' },
	'usablemeteringmodes' => { 65 => 0x10a },
	'usableshootingmodes' => { 65 => 0x109 },
	'usage' => { 356 => 'usage' },
	'usagefee' => { 357 => 'usageFee' },
	'usageterms' => { 368 => 'UsageTerms' },
	'useguidelines' => { 340 => 'useGuidelines' },
	'usepanoramaviewer' => { 332 => 'UsePanoramaViewer' },
	'usercomment' => { 78 => 0x805, 92 => 0x9286, 346 => 'UserComment' },
	'userdef1picturestyle' => { 16 => 0x10c, 53 => 0xd8, 54 => 0xf0 },
	'userdef2picturestyle' => { 16 => 0x10e, 53 => 0xda, 54 => 0xf2 },
	'userdef3picturestyle' => { 16 => 0x110, 53 => 0xdc, 54 => 0xf4 },
	'userfields' => { 335 => 'UserFields' },
	'userlabel' => { 290 => 0x2b },
	'userprofile' => { 242 => 0x302, 248 => 0x3038 },
	'usmlenselectronicmf' => { 64 => 0x7, 65 => 0x501 },
	'utmeasting' => { 134 => 'Easting' },
	'utmmapdatum' => { 134 => 'Datum' },
	'utmnorthing' => { 134 => 'Northing' },
	'utmzone' => { 134 => 'Zone' },
	'uv-irfiltercorrection' => { 242 => 0x325 },
	'validbits' => { 231 => 0x611, 232 => 0x102c },
	'validpixeldepth' => { 235 => 0x611 },
	'variousmodes' => { 108 => 0x26 },
	'variousmodes2' => { 108 => 0x3a },
	'variprogram' => { 177 => 0xab },
	'version' => { 97 => 0x0, 289 => 'Version', 342 => 'Version' },
	'versioncreatedate' => { 328 => 0xd100 },
	'versionid' => { 365 => 'VersionID' },
	'versionidentifier' => { 355 => 'versionIdentifier' },
	'versionmodifydate' => { 328 => 0xd101 },
	'versions' => { 365 => 'Versions' },
	'versionscomments' => { 365 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 365 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 365 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 365 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 365 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 365 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 365 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 365 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 365 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 365 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 365 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 217 => '3.2' },
	'vfdisplayillumination' => { 65 => 0x510 },
	'vibrance' => { 336 => 'Vibrance', 342 => 'Vibrance' },
	'vibrationreduction' => { 183 => [0x75,0x82,0x1ae], 191 => '586.1', 197 => '590.2', 201 => 0x4 },
	'videoalphamode' => { 364 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 364 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 364 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 364 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 364 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 364 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 364 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgreen' => { 364 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 364 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 364 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 364 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 364 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 364 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 364 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 364 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 364 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 364 => 'videoAlphaUnityIsTransparent' },
	'videocodec' => { 51 => 0x74 },
	'videocolorspace' => { 364 => 'videoColorSpace' },
	'videocompressor' => { 364 => 'videoCompressor' },
	'videofieldorder' => { 364 => 'videoFieldOrder' },
	'videoframerate' => { 364 => 'videoFrameRate' },
	'videoframesize' => { 364 => 'videoFrameSize' },
	'videoframesizeh' => { 364 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 364 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 364 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 364 => 'videoModDate' },
	'videopixelaspectratio' => { 364 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 364 => 'videoPixelDepth' },
	'videoquality' => { 88 => 0x4003 },
	'viewfinderdisplay' => { 217 => '12.4' },
	'viewfinderwarning' => { 217 => '13.4', 223 => '3.5', 224 => '6.2', 226 => '4.4' },
	'viewfinderwarnings' => { 65 => 0x40a },
	'viewinfoduringexposure' => { 65 => 0x407 },
	'viewingmode' => { 307 => 0x2f, 317 => 0x18 },
	'viewingmode2' => { 307 => 0x85 },
	'vignetteamount' => { 342 => 'VignetteAmount' },
	'vignettecontrol' => { 177 => 0x2a, 210 => 0x76a43205 },
	'vignettecontrolintensity' => { 210 => 0xac6bd5c0 },
	'vignettemidpoint' => { 342 => 'VignetteMidpoint' },
	'vignettingcorrection' => { 316 => 0x2011 },
	'voicememo' => { 301 => 0x216 },
	'volume' => { 355 => 'volume' },
	'vr_0x66' => { 183 => 0x66 },
	'vrdoffset' => { 48 => 0xd0 },
	'vrmode' => { 201 => 0x6 },
	'wb_bluelevel3500k' => { 150 => 0x19a },
	'wb_bluelevel6500k' => { 150 => 0x18a },
	'wb_bluelevelcustom' => { 150 => 0x18e },
	'wb_bluelevelscloudy' => { 150 => 0x106 },
	'wb_bluelevelsdaylight' => { 150 => 0xea },
	'wb_bluelevelsflash' => { 150 => 0x122 },
	'wb_bluelevelsfluorescent' => { 150 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 150 => 0x254 },
	'wb_bluelevelsshade' => { 150 => 0x176 },
	'wb_bluelevelstungsten' => { 150 => 0xce },
	'wb_gbrglevels' => { 150 => 0xae, 153 => 0x4 },
	'wb_glevel' => { 231 => 0x11f },
	'wb_glevel3000k' => { 231 => 0x113 },
	'wb_glevel3300k' => { 231 => 0x114 },
	'wb_glevel3600k' => { 231 => 0x115 },
	'wb_glevel3900k' => { 231 => 0x116 },
	'wb_glevel4000k' => { 231 => 0x117 },
	'wb_glevel4300k' => { 231 => 0x118 },
	'wb_glevel4500k' => { 231 => 0x119 },
	'wb_glevel4800k' => { 231 => 0x11a },
	'wb_glevel5300k' => { 231 => 0x11b },
	'wb_glevel6000k' => { 231 => 0x11c },
	'wb_glevel6600k' => { 231 => 0x11d },
	'wb_glevel7500k' => { 231 => 0x11e },
	'wb_grbglevels' => { 161 => 0x0 },
	'wb_rbgglevels' => { 158 => 0x0 },
	'wb_rblevels' => { 177 => 0xc, 231 => 0x100 },
	'wb_rblevels3000k' => { 231 => 0x102 },
	'wb_rblevels3300k' => { 231 => 0x103 },
	'wb_rblevels3500k' => { 150 => 0x430 },
	'wb_rblevels3600k' => { 231 => 0x104 },
	'wb_rblevels3900k' => { 231 => 0x105 },
	'wb_rblevels4000k' => { 231 => 0x106 },
	'wb_rblevels4300k' => { 231 => 0x107 },
	'wb_rblevels4500k' => { 231 => 0x108 },
	'wb_rblevels4800k' => { 231 => 0x109 },
	'wb_rblevels5300k' => { 231 => 0x10a },
	'wb_rblevels6000k' => { 231 => 0x10b },
	'wb_rblevels6500k' => { 150 => 0x420 },
	'wb_rblevels6600k' => { 231 => 0x10c },
	'wb_rblevels7500k' => { 231 => 0x10d },
	'wb_rblevelsauto' => { 235 => 0x110 },
	'wb_rblevelscloudy' => { 150 => 0x3f0, 152 => 0x10, 235 => 0x121 },
	'wb_rblevelscoolwhitef' => { 150 => 0x308, 152 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 235 => 0x132 },
	'wb_rblevelscustom' => { 150 => 0x424 },
	'wb_rblevelscwb1' => { 231 => 0x10e },
	'wb_rblevelscwb2' => { 231 => 0x10f },
	'wb_rblevelscwb3' => { 231 => 0x110 },
	'wb_rblevelscwb4' => { 231 => 0x111 },
	'wb_rblevelsdaylight' => { 150 => [0x3ec,0x528], 152 => 0xc },
	'wb_rblevelsdaylightf' => { 152 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 235 => 0x130 },
	'wb_rblevelsdaywhitef' => { 152 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 235 => 0x131 },
	'wb_rblevelseveningsunlight' => { 235 => 0x124 },
	'wb_rblevelsfineweather' => { 235 => 0x122 },
	'wb_rblevelsflash' => { 150 => [0x3f4,0x304], 152 => 0x18 },
	'wb_rblevelsshade' => { 150 => 0x418, 152 => 0x20, 235 => 0x120 },
	'wb_rblevelstungsten' => { 150 => 0x3e8, 152 => 0x8, 235 => 0x123 },
	'wb_rblevelsunknown' => { 152 => 0x1c },
	'wb_rblevelsused' => { 235 => 0x100 },
	'wb_rblevelswhitef' => { 152 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 235 => 0x133 },
	'wb_redlevel3500k' => { 150 => 0x198 },
	'wb_redlevel6500k' => { 150 => 0x188 },
	'wb_redlevelcustom' => { 150 => 0x18c },
	'wb_redlevelscloudy' => { 150 => 0xf8 },
	'wb_redlevelsdaylight' => { 150 => 0xdc },
	'wb_redlevelsflash' => { 150 => 0x114 },
	'wb_redlevelsfluorescent' => { 150 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 150 => 0x1be },
	'wb_redlevelsshade' => { 150 => 0x168 },
	'wb_redlevelstungsten' => { 150 => 0xc0 },
	'wb_rgbglevels' => { 160 => 0x0 },
	'wb_rgblevels' => { 150 => [0x546,0x96], 243 => 0xd, 244 => 0x413, 248 => 0x3036 },
	'wb_rggblevels' => { 153 => 0x4, 159 => 0x0 },
	'wb_rggblevelsasshot' => { 29 => 0x0, 30 => 0x19, 31 => 0x22, 32 => 0x3f, 35 => 0x3f, 36 => 0x3f },
	'wb_rggblevelsauto' => { 27 => 0x0, 29 => 0x5, 30 => 0x1e, 31 => 0x18, 32 => 0x44, 35 => 0x44, 36 => 0x44, 299 => 0xa022 },
	'wb_rggblevelsblack' => { 299 => 0xa028 },
	'wb_rggblevelscloudy' => { 27 => 0xc, 29 => 0x1e, 30 => 0x2d, 31 => 0x31, 32 => 0x58, 35 => 0x71, 36 => 0x71, 277 => 0x20f, 283 => 0x14 },
	'wb_rggblevelscustom' => { 27 => 0x1c, 32 => 0x80 },
	'wb_rggblevelscustom1' => { 30 => 0x41 },
	'wb_rggblevelscustom2' => { 30 => 0x46 },
	'wb_rggblevelsdaylight' => { 27 => 0x4, 29 => 0x14, 30 => 0x23, 31 => 0x27, 32 => 0x4e, 35 => 0x67, 36 => 0x67, 277 => 0x20d, 283 => 0x2 },
	'wb_rggblevelsflash' => { 27 => 0x18, 29 => 0x32, 30 => 0x3c, 31 => 0x45, 32 => 0x6c, 35 => 0x85, 36 => 0x85, 277 => 0x214, 283 => 0x41 },
	'wb_rggblevelsfluorescent' => { 27 => 0x14, 29 => 0x28, 30 => 0x37, 31 => 0x3b, 32 => 0x62, 35 => 0x7b, 36 => 0x7b },
	'wb_rggblevelsfluorescentd' => { 277 => 0x211, 283 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 283 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 277 => 0x212, 283 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 277 => 0x213, 283 => 0x38 },
	'wb_rggblevelsilluminator1' => { 299 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 299 => 0xa024 },
	'wb_rggblevelskelvin' => { 27 => 0x20, 29 => 0x2d, 31 => 0x40, 32 => 0x67, 35 => 0x80, 36 => 0x80 },
	'wb_rggblevelsmeasured' => { 29 => 0xa, 32 => 0x49, 35 => 0x49, 36 => 0x49 },
	'wb_rggblevelspc1' => { 31 => 0x90, 32 => 0x71 },
	'wb_rggblevelspc2' => { 31 => 0x95, 32 => 0x76 },
	'wb_rggblevelspc3' => { 31 => 0x9a, 32 => 0x7b },
	'wb_rggblevelsshade' => { 27 => 0x8, 29 => 0x19, 30 => 0x28, 31 => 0x2c, 32 => 0x53, 35 => 0x6c, 36 => 0x6c, 277 => 0x20e, 283 => 0xb },
	'wb_rggblevelstungsten' => { 27 => 0x10, 29 => 0x23, 30 => 0x32, 31 => 0x36, 32 => 0x5d, 35 => 0x76, 36 => 0x76, 277 => 0x210, 283 => 0x1d },
	'wb_rggblevelsuncorrected' => { 299 => 0xa021 },
	'wb_rggblevelsunknown' => { 29 => 0xf, 31 => 0x1d, 35 => 0x4e, 36 => 0x4e, 283 => 0x53 },
	'wb_rggblevelsunknown10' => { 29 => 0x5f, 31 => 0x72, 35 => 0x9e, 36 => 0x9e },
	'wb_rggblevelsunknown11' => { 29 => 0x64, 31 => 0x77, 35 => 0xa3, 36 => 0xa3 },
	'wb_rggblevelsunknown12' => { 29 => 0x69, 31 => 0x7c, 35 => 0xa8, 36 => 0xa8 },
	'wb_rggblevelsunknown13' => { 29 => 0x6e, 31 => 0x81, 35 => 0xad, 36 => 0xad },
	'wb_rggblevelsunknown14' => { 31 => 0x86, 35 => 0xb2, 36 => 0xb2 },
	'wb_rggblevelsunknown15' => { 31 => 0x8b, 35 => 0xb7, 36 => 0xb7 },
	'wb_rggblevelsunknown16' => { 31 => 0x9f, 36 => 0xbc },
	'wb_rggblevelsunknown17' => { 36 => 0xc1 },
	'wb_rggblevelsunknown18' => { 36 => 0xc6 },
	'wb_rggblevelsunknown19' => { 36 => 0xcb },
	'wb_rggblevelsunknown2' => { 29 => 0x37, 31 => 0x4a, 35 => 0x53, 36 => 0x53 },
	'wb_rggblevelsunknown20' => { 36 => 0xd0 },
	'wb_rggblevelsunknown3' => { 29 => 0x3c, 31 => 0x4f, 35 => 0x58, 36 => 0x58 },
	'wb_rggblevelsunknown4' => { 29 => 0x41, 31 => 0x54, 35 => 0x5d, 36 => 0x5d },
	'wb_rggblevelsunknown5' => { 29 => 0x46, 31 => 0x59, 35 => 0x62, 36 => 0x62 },
	'wb_rggblevelsunknown6' => { 29 => 0x4b, 31 => 0x5e, 35 => 0x8a, 36 => 0x8a },
	'wb_rggblevelsunknown7' => { 29 => 0x50, 31 => 0x63, 35 => 0x8f, 36 => 0x8f },
	'wb_rggblevelsunknown8' => { 29 => 0x55, 31 => 0x68, 35 => 0x94, 36 => 0x94 },
	'wb_rggblevelsunknown9' => { 29 => 0x5a, 31 => 0x6d, 35 => 0x99, 36 => 0x99 },
	'wb_rggblevelsuserselected' => { 283 => 0x5c },
	'wbadjbluebalance' => { 216 => 0x8 },
	'wbadjcolortemp' => { 83 => 0x1a },
	'wbadjlighting' => { 216 => 0x15 },
	'wbadjlightingsubtype' => { 216 => 0x14 },
	'wbadjmode' => { 216 => 0x10 },
	'wbadjredbalance' => { 216 => 0x0 },
	'wbadjrggblevels' => { 83 => 0x6 },
	'wbadjtemperature' => { 216 => 0x18 },
	'wbadjtint' => { 216 => 0x25 },
	'wbbluelevel' => { 242 => 0x324, 246 => 0x8006, 250 => 0x26 },
	'wbbracketmode' => { 43 => 0x9 },
	'wbbracketshotnumber' => { 150 => 0x2b },
	'wbbracketvalueab' => { 43 => 0xc },
	'wbbracketvaluegm' => { 43 => 0xd },
	'wbfinetuneactive' => { 83 => 0x24 },
	'wbfinetunesaturation' => { 83 => 0x28 },
	'wbfinetunetone' => { 83 => 0x2c },
	'wbgreenlevel' => { 242 => 0x323, 246 => 0x8005, 250 => 0x25 },
	'wbmediaimagesizesetting' => { 65 => 0x708 },
	'wbmode' => { 152 => 0x4, 232 => 0x1015 },
	'wbredlevel' => { 242 => 0x322, 246 => 0x8004, 250 => 0x24 },
	'wbscale' => { 153 => 0x0 },
	'wbshiftab' => { 57 => 0xc, 246 => 0x46, 259 => 0x10 },
	'wbshiftab_gm' => { 316 => 0x2014 },
	'wbshiftgm' => { 57 => 0xd, 246 => 0x47, 259 => 0x11 },
	'webstatement' => { 368 => 'WebStatement' },
	'whitebalance' => { 4 => 0x6f, 5 => [0x44,0x4a], 6 => 0xbc, 7 => 0x36, 8 => 0x5e, 9 => 0x36, 10 => 0x78, 11 => 0x6f, 12 => 0x6f, 13 => 0x73, 14 => 0x6f, 15 => 0x78, 16 => 0x54, 17 => 0x6f, 18 => 0xbc, 19 => 0x7b, 21 => 0xbc, 22 => 0x77, 57 => 0x8, 59 => 0x7, 87 => 0x7, 88 => [0x19,0x2012], 92 => [0xa403,0xfe4e], 97 => 0x1002, 106 => 0x3fc, 107 => 0xfa0d, 108 => 0x40, 144 => 0x3, 145 => 0xe, 146 => 0x4, 147 => 0xb, 149 => 0x115, 177 => 0x5, 200 => 0x7, 242 => 0x304, 246 => 0x3, 248 => 0x3033, 277 => 0x19, 282 => 0x7, 293 => 0x26, 302 => [0x3c,0x7,0x58], 316 => [0x115,0xb054], 342 => 'WhiteBalance', 346 => 'WhiteBalance' },
	'whitebalance2' => { 227 => 0x500 },
	'whitebalanceadj' => { 83 => 0x18, 210 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 255 => 0x0 },
	'whitebalancebias' => { 88 => 0x2011, 232 => 0x304, 246 => 0x23 },
	'whitebalanceblue' => { 57 => 0x7 },
	'whitebalancebracket' => { 227 => 0x502, 232 => 0x303 },
	'whitebalancebracketing' => { 147 => 0x22, 150 => 0x2c, 315 => 0x2c },
	'whitebalancecomp' => { 235 => 0x1001 },
	'whitebalancefinetune' => { 97 => 0x100a, 147 => 0x38, 149 => 0x112, 177 => 0xb, 305 => 0x6, 316 => 0x112 },
	'whitebalancemode' => { 277 => 0x1a },
	'whitebalancered' => { 57 => 0x6 },
	'whitebalanceset' => { 258 => 0xa },
	'whitebalancesetting' => { 147 => 0x23, 307 => 0x16, 317 => 0xd },
	'whitebalancetemperature' => { 227 => 0x501 },
	'whiteboard' => { 232 => 0x301 },
	'whitelevel' => { 92 => 0xc61d },
	'whitepoint' => { 92 => 0x13e, 277 => 0x201, 360 => 'WhitePoint' },
	'whites2012' => { 342 => 'Whites2012' },
	'widefocuszone' => { 144 => 0x2f },
	'widerange' => { 301 => 0x20f },
	'wordcount' => { 355 => 'wordCount' },
	'workcolorspace' => { 83 => 0x270 },
	'worktodo' => { 347 => 'WorkToDo' },
	'worldtimelocation' => { 246 => 0x3a, 277 => 0x22, 281 => '0.1' },
	'writer-editor' => { 100 => 0x7a },
	'x3filllight' => { 302 => 0x12 },
	'xml' => { 104 => 'xml ' },
	'xmp' => { 82 => 0xffff00f6, 93 => 'XMP' },
	'xmptoolkit' => { 361 => 'xmptk' },
	'xpauthor' => { 92 => 0x9c9d },
	'xpcomment' => { 92 => 0x9c9c },
	'xpkeywords' => { 92 => 0x9c9e },
	'xposition' => { 92 => 0x11e },
	'xpsubject' => { 92 => 0x9c9f },
	'xptitle' => { 92 => 0x9c9b },
	'xresolution' => { 92 => 0x11a, 103 => 0x3, 288 => 0x0, 360 => 'XResolution' },
	'xyresolution' => { 96 => 0x3 },
	'ycbcrcoefficients' => { 92 => 0x211, 360 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 92 => 0x213, 360 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 92 => 0x212, 360 => 'YCbCrSubSampling' },
	'yearcreated' => { 108 => 0x10, 117 => 0xc },
	'yposition' => { 92 => 0x11f },
	'yresolution' => { 92 => 0x11b, 103 => 0x5, 288 => 0x4, 360 => 'YResolution' },
	'zonematching' => { 149 => 0x10a, 152 => [0x3a,0x4a], 316 => 0xb024 },
	'zonematchingmode' => { 147 => 0x14 },
	'zonematchingon' => { 146 => 0x75 },
	'zonematchingvalue' => { 305 => 0x1f },
	'zoomedpreviewlength' => { 232 => 0xf05 },
	'zoomedpreviewsize' => { 232 => 0xf06 },
	'zoomedpreviewstart' => { 232 => 0xf04 },
	'zoomsourcewidth' => { 26 => 0x24 },
	'zoomstepcount' => { 230 => 0x300, 232 => 0x100d },
	'zoomtargetwidth' => { 26 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'accessdate' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeflags' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'aeunknown' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointsinfocus1d' => 1,
	'aftune' => 1,
	'aimetadata' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'album2' => 1,
	'albumartist' => 1,
	'albumartistsortorder' => 1,
	'albumcoverurl' => 1,
	'albumid' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'albumtitleid' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'ambienceinfo' => 1,
	'animationiterations' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'applestoreaccount' => 1,
	'applestoreaccounttype' => 1,
	'applestorecatalogid' => 1,
	'applestorecountry' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationversion' => 1,
	'appversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'arranger' => 1,
	'arrangerkeywords' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'artwork' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'aspectinfo' => 1,
	'aspectratiotype' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atmospherictemperature' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'attachedfile' => 1,
	'attachedfiledata' => 1,
	'attachedfiledescription' => 1,
	'attachedfilemimetype' => 1,
	'attachedfilename' => 1,
	'attachedfilereferral' => 1,
	'attachedfileuid' => 1,
	'attachments' => 1,
	'attributes' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobitspersample' => 1,
	'audiobytes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'authorurl' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'balance' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'batteryinfo' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats-per-minute' => 1,
	'beatsperminute' => 1,
	'belowcolor' => 1,
	'billinginformation' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'birthday' => 1,
	'bitrate' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackleveldata' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'block' => 1,
	'blockaddid' => 1,
	'blockadditional' => 1,
	'blockadditionalid' => 1,
	'blockadditions' => 1,
	'blockduration' => 1,
	'blockgroup' => 1,
	'blocklocation' => 1,
	'blockmore' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blockvirtual' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'booktitle' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'breakchar' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calibrationdatetime' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'camera' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameradirection' => 1,
	'cameraidentifier' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfoa100' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameramaximumtemperature' => 1,
	'cameraminimumtemperature' => 1,
	'cameramotion' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelpositions' => 1,
	'chapter' => 1,
	'chapteratom' => 1,
	'chaptercountry' => 1,
	'chapterdisplay' => 1,
	'chapterflagenabled' => 1,
	'chapterflaghidden' => 1,
	'chapterlanguage' => 1,
	'chapterlist' => 1,
	'chapternum' => 1,
	'chapterphysicalequivalent' => 1,
	'chapterprocess' => 1,
	'chapterprocesscodecid' => 1,
	'chapterprocesscommand' => 1,
	'chapterprocessdata' => 1,
	'chapterprocessprivate' => 1,
	'chapterprocesstime' => 1,
	'chapters' => 1,
	'chaptersegmenteditionuid' => 1,
	'chaptersegmentuid' => 1,
	'chapterstring' => 1,
	'chaptertimeend' => 1,
	'chaptertimestart' => 1,
	'chaptertrack' => 1,
	'chaptertracknumber' => 1,
	'chaptertranslate' => 1,
	'chaptertranslatecodec' => 1,
	'chaptertranslateeditionuid' => 1,
	'chaptertranslateid' => 1,
	'chapteruid' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'checkedby' => 1,
	'children' => 1,
	'chmversion' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanaperturedimensions' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cluster' => 1,
	'clusterduration' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'codecdecodeall' => 1,
	'codecdownloadurl' => 1,
	'codecflavorid' => 1,
	'codecid' => 1,
	'codecinfourl' => 1,
	'codeclist' => 1,
	'codecname' => 1,
	'codecprivate' => 1,
	'codecsettings' => 1,
	'codecstate' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'color' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorprimaries' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecapproximation' => 1,
	'colorspecdata' => 1,
	'colorspecification' => 1,
	'colorspecmethod' => 1,
	'colorspecprecedence' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'compilation' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'composerkeywords' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'compressorversion' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerformat' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentcompression' => 1,
	'contentcompressionalgorithm' => 1,
	'contentcompressionsettings' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentdistributorduration' => 1,
	'contentdistributorid' => 1,
	'contentdistributortype' => 1,
	'contentencoding' => 1,
	'contentencodingorder' => 1,
	'contentencodings' => 1,
	'contentencodingscope' => 1,
	'contentencodingtype' => 1,
	'contentencryption' => 1,
	'contentencryptionalgorithm' => 1,
	'contentencryptionkeyid' => 1,
	'contentgroupdescription' => 1,
	'contentid' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentsignature' => 1,
	'contentsignaturealgorithm' => 1,
	'contentsignaturehashalgorithm' => 1,
	'contentsignaturekeyid' => 1,
	'contentstyletype' => 1,
	'contenttype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'country-region' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'coveruri' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'crc-32' => 1,
	'crcdevelparams' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorappid' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatorinfo' => 1,
	'creatorversion' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs1' => 1,
	'cueblocknumber' => 1,
	'cueclusterposition' => 1,
	'cuecodecstate' => 1,
	'cuepoint' => 1,
	'cuerefcluster' => 1,
	'cuerefcodecstate' => 1,
	'cuereference' => 1,
	'cuerefnumber' => 1,
	'cuereftime' => 1,
	'cues' => 1,
	'cuesheet' => 1,
	'cuetime' => 1,
	'cuetrack' => 1,
	'cuetrackpositions' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'custompicturestyledata' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd40' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd90' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datainformation' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasize' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultduration' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directors' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayartist' => 1,
	'displayheight' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunit' => 1,
	'displayunits' => 1,
	'displaywidth' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'division' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dngadobedata' => 1,
	'dngprivatedata' => 1,
	'docclass' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'doctypereadversion' => 1,
	'doctypeversion' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotsperinch' => 1,
	'driveserialnumber' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'ebmlheader' => 1,
	'ebmlmaxidlength' => 1,
	'ebmlmaxsizelength' => 1,
	'ebmlreadversion' => 1,
	'ebmlversion' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editionentry' => 1,
	'editionflagdefault' => 1,
	'editionflaghidden' => 1,
	'editionflagordered' => 1,
	'editionuid' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'eighthlanguage' => 1,
	'embeddedaudiofile' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagewidth' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encodedwith' => 1,
	'encoder' => 1,
	'encodersettings' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encrypt' => 1,
	'encryptedblock' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'episodeglobaluniqueid' => 1,
	'episodename' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escchar' => 1,
	'evalstate' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureinfo' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extenderstatus' => 1,
	'extensionanimation' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionicc' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensionxmp' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'facepos' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fieldmdp' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepermissions' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'finalframeblocks' => 1,
	'firmwareinfo' => 1,
	'firmwareversions' => 1,
	'firstchar' => 1,
	'firstlanguage' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flir' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspos' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'frameheight' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framereadouttime' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'framewidth' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'gain' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geotiffasciiparams' => 1,
	'geotiffdirectory' => 1,
	'geotiffdoubleparams' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'givenname' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'goprotype' => 1,
	'gpano' => 1,
	'gps' => 1,
	'gpscoordinates' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'group' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdrinfo' => 1,
	'hdrl' => 1,
	'hdvideo' => 1,
	'header' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hiddenslides' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hintversion' => 1,
	'historybuffersize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huffmantable' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'iconuri' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedepth' => 1,
	'imagefields' => 1,
	'imageformat' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imageoffset' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imageresolution' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imageworkstationmake' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'information' => 1,
	'infourl' => 1,
	'ingrreserved' => 1,
	'initialdisplayeffect' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputprofile' => 1,
	'insertmode' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrccode' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemprotection' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesu' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtables' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'kelvinwb' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keys' => 1,
	'kids' => 1,
	'kinds' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'lacenumber' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastauthor' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lasttimestamp' => 1,
	'layercomps' => 1,
	'layersgroupinfo' => 1,
	'layerstateinfo' => 1,
	'layout' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkerversion' => 1,
	'linkinfo' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'lit' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'locationbody' => 1,
	'locationdate' => 1,
	'locationinfo' => 1,
	'locationinformation' => 1,
	'locationnote' => 1,
	'locationrole' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'longdescription' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'lslv' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics' => 1,
	'lyrics_synchronised' => 1,
	'lyricsuri' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotes' => 1,
	'makerurl' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturer' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'matrixstructure' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxblockadditionid' => 1,
	'maxcache' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mcdi' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementobserver' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacreatedate' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'medialanguagecode' => 1,
	'mediamodifydate' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediatype' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'mie' => 1,
	'mileage' => 1,
	'mimetype' => 1,
	'minaperturevalue' => 1,
	'mincache' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minorversion' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'modeextension' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'moreinfo' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviedata' => 1,
	'moviedatasize' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'multiexposure' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'muxingapp' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'nextfilename' => 1,
	'nexttrackid' => 1,
	'nextuid' => 1,
	'nikon' => 1,
	'nikoncaptureoffsets' => 1,
	'nikondata' => 1,
	'nikonncdt' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numafpoints' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'objecttype' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offsetorigin' => 1,
	'offsetxy' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'opacity' => 1,
	'opcodelist1' => 1,
	'opcodelist2' => 1,
	'opcodelist3' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputaudiosamplerate' => 1,
	'outputdataobjectlist' => 1,
	'outputprofile' => 1,
	'outputresponse' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pagecount' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'paraminfo' => 1,
	'parasites' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'part' => 1,
	'partialpalette' => 1,
	'participants' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'patternangle' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'performer' => 1,
	'performerkeywords' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'performerurl' => 1,
	'period' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshopbgrthumbnail' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'photoshopthumbnail' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturestyleinfo2' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'pitchandfamily' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelscale' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixelsperunitx' => 1,
	'pixelsperunity' => 1,
	'pixelunits' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playlistid' => 1,
	'playlistindex' => 1,
	'playmode' => 1,
	'playselection' => 1,
	'plus' => 1,
	'pobox' => 1,
	'podcast' => 1,
	'podcasturl' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'prevfilename' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewdate' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'prevsize' => 1,
	'prevuid' => 1,
	'primarye-mail' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producerkeywords' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversion' => 1,
	'productversionnumber' => 1,
	'profession' => 1,
	'profile' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasedate' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'rawcodecversion' => 1,
	'rawdata' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawformat' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readerrequirements' => 1,
	'readstatus' => 1,
	'realtimestreamingprotocol' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingcopyright' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'recordlabelname' => 1,
	'recordlabelurl' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reference' => 1,
	'referenceblock' => 1,
	'referencepriority' => 1,
	'referencevirtual' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'relatedimagefile' => 1,
	'relativehumidity' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'remindertime' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'requirements' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'resolutioninfo' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohrdc2' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rotationangle' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'runwindow' => 1,
	'sampledegradationpriority' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungtags' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'scriptcommand' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'seek' => 1,
	'seekable' => 1,
	'seekhead' => 1,
	'seekid' => 1,
	'seekpoint' => 1,
	'seekposition' => 1,
	'seektable' => 1,
	'segmentfamily' => 1,
	'segmentfilename' => 1,
	'segmentheader' => 1,
	'segmentuid' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensorbottomborder' => 1,
	'sensorcalibration' => 1,
	'sensordefects' => 1,
	'sensorid' => 1,
	'sensorimageheight' => 1,
	'sensorimagewidth' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorleftmargin' => 1,
	'sensorrightborder' => 1,
	'sensortemperature2' => 1,
	'sensortopborder' => 1,
	'sensortopmargin' => 1,
	'serialinfo' => 1,
	'series' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharedwith' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod40' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutter' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signaturealgo' => 1,
	'signatureelementlist' => 1,
	'signatureelements' => 1,
	'signaturehash' => 1,
	'signaturepublickey' => 1,
	'signatureslot' => 1,
	'signatureusagerights' => 1,
	'signedelement' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'silenttracknumber' => 1,
	'silenttracks' => 1,
	'simpleblock' => 1,
	'simpleindex' => 1,
	'simpletag' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slices' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarerelease' => 1,
	'songwriter' => 1,
	'songwriterkeywords' => 1,
	'sony' => 1,
	'sortalbum' => 1,
	'sortalbumartist' => 1,
	'sortartist' => 1,
	'sortcomposer' => 1,
	'sortname' => 1,
	'sortshow' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecredits' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'speed' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'splitcolumn' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'srgbrendering' => 1,
	'stamptoolcount' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startofframe' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereo3dmode' => 1,
	'stereoimage' => 1,
	'stereomode' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchinfo' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtype' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subseccreatedate' => 1,
	'subsecdatetimeoriginal' => 1,
	'subsecmodifydate' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitle' => 1,
	'subtitledescription' => 1,
	'subtitlekeywords' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'system' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag' => 1,
	'tag9050' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9406' => 1,
	'tag940a' => 1,
	'tag940e' => 1,
	'tagattachmentuid' => 1,
	'tagbinary' => 1,
	'tagchapteruid' => 1,
	'tagdefault' => 1,
	'tageditionuid' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'taglanguage' => 1,
	'tagname' => 1,
	'tags' => 1,
	'tagstring' => 1,
	'tagtrackuid' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetprinter' => 1,
	'targets' => 1,
	'targettype' => 1,
	'targettypevalue' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfok5' => 1,
	'template' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailclip' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimage' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timecodescale' => 1,
	'timeinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timeslice' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'track' => 1,
	'trackaperture' => 1,
	'trackattachmentuid' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackcreatedate' => 1,
	'trackdefault' => 1,
	'trackduration' => 1,
	'trackentry' => 1,
	'trackerdata' => 1,
	'trackforced' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklacing' => 1,
	'tracklanguage' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackmodifydate' => 1,
	'trackname' => 1,
	'trackoffset' => 1,
	'trackoverlay' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'tracktimecodescale' => 1,
	'tracktranslate' => 1,
	'tracktranslatecodec' => 1,
	'tracktranslateeditionuid' => 1,
	'tracktranslatetrackid' => 1,
	'tracktype' => 1,
	'trackuid' => 1,
	'trackused' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transferrange' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trebel' => 1,
	'tty-ttdphone' => 1,
	'tvepisode' => 1,
	'tvepisodeid' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'tvshow' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknown_cndb' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowndate' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknowntags' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unknowntemperature3' => 1,
	'unknowntemperature4' => 1,
	'unknowntemperature5' => 1,
	'unknowntemperature6' => 1,
	'unsharpdata' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'ur3' => 1,
	'url_list' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userlastplayedtime' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userrating' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videocompression' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'void' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumenormalization' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8version' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wb_grblevels' => 1,
	'wb_grgblevels' => 1,
	'wb_rgbcoeffs0' => 1,
	'wb_rgbcoeffs1' => 1,
	'wb_rgbcoeffs2' => 1,
	'wb_rgbcoeffs3' => 1,
	'wb_rgblevelsauto' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelsdaylight' => 1,
	'wb_rgblevelsflash' => 1,
	'wb_rgblevelsfluorescent' => 1,
	'wb_rgblevelsshade' => 1,
	'wb_rgblevelstungsten' => 1,
	'wb_rgbmul0' => 1,
	'wb_rgbmul1' => 1,
	'wb_rgbmul2' => 1,
	'wb_rgbmul3' => 1,
	'wbadjdata' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wcsprofiles' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wrapmodes' => 1,
	'writer' => 1,
	'writers' => 1,
	'writingapp' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yawangle' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level stucture
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '$strName'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $lc = $$tagTablePtr{$id} ? lc $$tagTablePtr{$id}{Name} : $lcTag . lc($field);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        my $fieldInfo = $$strTable{$field};
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = ucfirst($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                AddFields($tagTablePtr, $tagID, $lcTag, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2013, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
