# Before "make install", this script should be runnable with "make test".
# After "make install" it should work as "perl t/FLAC.t".

BEGIN { $| = 1; print "1..3\n"; $Image::ExifTool::configFile = ''; }
END {print "not ok 1\n" unless $loaded;}

# test 1: Load the module(s)
use Image::ExifTool 'ImageInfo';
use Image::ExifTool::FLAC;
$loaded = 1;
print "ok 1\n";

use t::TestLib;

my $testname = 'FLAC';
my $testnum = 1;

# test 2: Extract information from FLAC test file
{
    ++$testnum;
    my $exifTool = new Image::ExifTool;
    my $info = $exifTool->ImageInfo('t/images/FLAC.flac');
    print 'not ' unless check($exifTool, $info, $testname, $testnum);
    print "ok $testnum\n";
}

# test 3: Extract information from Ogg test file
{
    ++$testnum;
    my $exifTool = new Image::ExifTool;
    my $info = $exifTool->ImageInfo('t/images/FLAC.ogg');
    print 'not ' unless check($exifTool, $info, $testname, $testnum);
    print "ok $testnum\n";
}


# end
