use 5.008;
use Module::Build::Tiny 0.030;
check_conflicts();
Build_PL();

sub check_conflicts {
    if ( eval { require 'lib/Dist/Zilla/Plugin/Test/Compile/Conflicts.pm'; 1; } ) {
        if ( eval { Dist::Zilla::Plugin::Test::Compile::Conflicts->check_conflicts; 1 } ) {
            return;
        }
        else {
            my $err = $@;
            $err =~ s/^/    /mg;
            warn "***\n$err***\n";
        }
    }
    else {
        print <<'EOF';
***
    Your toolchain doesn't support configure_requires, so Dist::CheckConflicts
    hasn't been installed yet. You should check for conflicting modules
    manually by examining the list of conflicts in Dist::Zilla::Plugin::Test::Compile::Conflicts once the installation
    finishes.
***
EOF
    }

    return if $ENV{AUTOMATED_TESTING} || $ENV{NONINTERACTIVE_TESTING};

    # More or less copied from Module::Build
    return if $ENV{PERL_MM_USE_DEFAULT};
    return unless -t STDIN && ( -t STDOUT || !( -f STDOUT || -c STDOUT ) );

    sleep 4;
}
