# NAME

Dist::Zilla::Plugin::MungeFile::WithConfigFile - Modify files in the build, with templates and config data from a file

# VERSION

version 0.002

# SYNOPSIS

In your `dist.ini`:

    [MungeFile::WithConfigFile]
    file = lib/My/Module.pm
    house = maison
    configfile = data.json

And during the build, `lib/My/Module.pm`:

    my $some_string = '{{ expensive_build_time_sub($config_data{some_field}) }}';
    my ${{ $house }} = 'my castle';
    __DATA__
    alpha
    beta
    gamma

Is transformed to:

    my $some_string = 'something derived from data in config file';
    my $maison = 'my castle';

# DESCRIPTION

This is a [FileMunger](https://metacpan.org/pod/Dist::Zilla::Role::FileMunger) plugin for
[Dist::Zilla](https://metacpan.org/pod/Dist::Zilla) that passes a file(s)
through a [Text::Template](https://metacpan.org/pod/Text::Template), with a variable provided that contains data
read from the provided config file.

[Text::Template](https://metacpan.org/pod/Text::Template) is used to transform the file by making the `$config_data`
variable available to all code blocks within `{{ }}` sections.

This data is extracted from the provided `configfile` using [Config::Any](https://metacpan.org/pod/Config::Any),
so a variety of file formats are supported, including `JSON`, `YAML` and
`INI`.

The [Dist::Zilla](https://metacpan.org/pod/Dist::Zilla) object (as `$dist`) and this plugin (as `$plugin`) are
also made available to the template, for extracting other information about
the build.

Additionally, any extra keys and values you pass to the plugin are passed
along in variables named for each key.

# OPTIONS

- `finder`

    This is the name of a [FileFinder](https://metacpan.org/pod/Dist::Zilla::Role::FileFinder) for finding
    files to modify.

    Other pre-defined finders are listed in
    ["default\_finders" in Dist::Zilla::Role::FileFinderUser](https://metacpan.org/pod/Dist::Zilla::Role::FileFinderUser#default_finders).
    You can define your own with the
    [\[FileFinder::ByName\]](https://metacpan.org/pod/Dist::Zilla::Plugin::FileFinder::ByName) plugin.

    There is no default.

- `file`

    Indicates the filename in the dist to be operated upon; this file can exist on
    disk, or have been generated by some other plugin.  Can be included more than once.

    __At least one of the `finder` or `file` options is required.__

- `arbitrary option`

    All other keys/values provided will be passed to the template as is.

# SUPPORT

Bugs may be submitted through [the RT bug tracker](https://rt.cpan.org/Public/Dist/Display.html?Name=Dist-Zilla-Plugin-MungeFile-WithConfigFile)
(or [bug-Dist-Zilla-Plugin-MungeFile-WithConfigFile@rt.cpan.org](mailto:bug-Dist-Zilla-Plugin-MungeFile-WithConfigFile@rt.cpan.org)).
I am also usually active on irc, as 'ether' at `irc.perl.org`.

# SEE ALSO

- [Dist::Zilla::Plugin::Substitute](https://metacpan.org/pod/Dist::Zilla::Plugin::Substitute)
- [Dist::Zilla::Plugin::GatherDir::Template](https://metacpan.org/pod/Dist::Zilla::Plugin::GatherDir::Template)
- [Dist::Zilla::Plugin::MungeFile::WithDataSection](https://metacpan.org/pod/Dist::Zilla::Plugin::MungeFile::WithDataSection)

# AUTHOR

Karen Etheridge <ether@cpan.org>

# COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Karen Etheridge.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.
