package Net::SSLLabs::Chain;

use strict;
use warnings;
use Net::SSLLabs::ChainCert();

sub new {
    my ( $class, $json ) = @_;
    my $self = $json;
    bless $self, $class;
    my @certs = @{ $self->{certs} };
    $self->{certs} = [];
    foreach my $cert (@certs) {
        push @{ $self->{certs} }, Net::SSLLabs::ChainCert->new($cert);
    }
    return $self;
}

sub certs {
    my ($self) = @_;
    return @{ $self->{certs} };
}

sub issues {
    my ($self) = @_;
    return $self->{issues};
}

1;
__END__

=head1 NAME

Net::SSLLabs::Chain - Chain object

=head1 METHODS

=head2 new

a new I<Net::SSLLabs::Chain> object, accepts a JSON object as it's parameter.

=head2 certs

a list of I<Net::SSLLabs::ChainCert> objects, representing the chain certificates in the order in which they were retrieved from the server

=head2 issues

a number of flags that describe the chain and the problems it has:

=over 2

=item bit 0 (1) - unused

=item bit 1 (2) - incomplete chain (set only when we were able to build a chain by adding missing intermediate certificates from external sources)

=item bit 2 (4) - chain contains unrelated or duplicate certificates (i.e., certificates that are not part of the same chain)

=item bit 3 (8) - the certificates form a chain (trusted or not), but the order is incorrect

=item bit 4 (16) - contains a self-signed root certificate (not set for self-signed leafs)

=item bit 5 (32) - the certificates form a chain (if we added external certificates, bit 1 will be set), but we could not validate it. If the leaf was trusted, that means that we built a different chain we trusted.

=back
