package OpenInteract::Handler::Error;

# $Id: Error.pm,v 1.13 2001/11/28 05:37:29 lachoy Exp $

use strict;
use OpenInteract::CommonHandler;
use OpenInteract::Handler::GenericDispatcher qw( DEFAULT_SECURITY_KEY );
use SPOPS::Secure qw( :level );
use Text::Wrap    qw();

@OpenInteract::Handler::Error::ISA     = qw(  OpenInteract::CommonHandler SPOPS::Secure );
$OpenInteract::Handler::Error::VERSION = sprintf("%d.%02d", q$Revision: 1.13 $ =~ /(\d+)\.(\d+)/);

$OpenInteract::Handler::Error::author            = 'chris@cwinters.com';
$OpenInteract::Handler::Error::default_method    = 'search_form';
@OpenInteract::Handler::Error::forbidden_methods = ();
%OpenInteract::Handler::Error::security          = (
 DEFAULT_SECURITY_KEY() => SEC_LEVEL_READ, remove => SEC_LEVEL_WRITE );


sub MY_PACKAGE                 { return 'base_error' }
sub MY_HANDLER_PATH            { return '/Error' }
sub MY_OBJECT_TYPE             { return 'error' }
sub MY_OBJECT_CLASS            { return OpenInteract::Request->instance->error }
sub MY_SEARCH_FIELDS           { return qw( code type) }
sub MY_SEARCH_FORM_TITLE       { return 'Search for Errors' }
sub MY_SEARCH_FORM_TEMPLATE    { return 'error_search_form' }
sub MY_SEARCH_RESULTS_TITLE    { return 'Error Search Results' }
sub MY_SEARCH_RESULTS_TEMPLATE { return 'error_search_results' }
sub MY_OBJECT_FORM_TITLE       { return 'Error Detail' }
sub MY_OBJECT_FORM_TEMPLATE    { return 'error_detail' }
sub MY_ALLOW_SEARCH_FORM       { return 1 }
sub MY_ALLOW_SEARCH            { return 1 }
sub MY_ALLOW_SHOW              { return 1 }
sub MY_ALLOW_REMOVE            { return 1 }
sub MY_ALLOW_NOTIFY            { return 1 }

sub MY_SEARCH_RESULTS_ORDER {
    my $R = OpenInteract::Request->instance;
    my $apr = $R->apache;
    my $order = $apr->param( 'sort' ) || 'error_time';
    return ( $order eq 'error_time' ) ? 'error_time DESC' : $order;
}

sub _search_build_where_customize {
    my ( $class, $from, $where, $value ) = @_;
    my $R = OpenInteract::Request->instance;
    my $apr = $R->apache;

    if ( my $from_date = $class->_read_field_date( $apr, 'filter_date_from' ) ) {
        push @{ $where }, 'error_time >= ?';
        push @{ $value }, $from_date;
    }
    if ( my $to_date = $class->_read_field_date( $apr, 'filter_date_to' ) ) {
        push @{ $where }, 'error_time <= ?';
        push @{ $value }, $to_date;
    }

}


sub _search_customize {
    my ( $class, $params ) = @_;
    my $apr = OpenInteract::Request->instance->apache;
    my %filter = (
         sort      => $apr->param( 'filter_sort' ),
         code      => $apr->param( 'filter_code' ),
         type      => $apr->param( 'filter_type' ),
         date_from => $class->_read_field_date_object( $apr, 'filter_date_from' ),
         date_to   => $class->_read_field_date_object( $apr, 'filter_date_to' ),
    );
    $params->{filterby} = \%filter;
}



# Grab the user here since sometimes the user might be 'superuser'
# who cannot be seen by mere mortals. This throws an error if you
# do in the template [% error_user = err.user %] and rather than a
# TRY/CATCH block we'll just do it here.

sub _show_customize {
    my ( $class, $params ) = @_;
    $params->{error_user} = eval { $params->{error}->user };
}


# Override 'remove()' so we can delete multiple objects at once

sub remove {
    my ( $class, $p ) = @_;
    my $R = OpenInteract::Request->instance;
    unless ( $class->MY_ALLOW_REMOVE ) {
        $R->scrib( 0, "User tried to remove error object - not allowed." );
        return '<h2>Error</h2><p>Removal of error objects has been disallowed.</p>';
    }

    my @error_id = $R->apache->param( 'error_id' );
    my ( @error_items );
    my $success = 0;
    foreach my $eid ( @error_id ) {
        $R->DEBUG && $R->scrib( 1, "Removing error: $eid" );
        my $error = eval { $R->error_object->fetch( $eid ); };
        if ( $@ or ! $error ) {
            push @error_items, "Could not retrieve error ($eid) to remove: $SPOPS::Error::system_msg" if ( $@ );
            push @error_items, "Error ($eid) apparently does not exist, so it was not removed."       if ( ! $@ );;
            next;
        }
        eval { $error->remove };
        if ( $@ ) { push @error_items, SPOPS::Error->get }
        else      { $success++ }
    }
    $p->{error_msg}  = join "\n\n", map { $_->{system_msg} } @error_items if ( scalar @error_items );
    $p->{status_msg} = "$success objects removed successfully";
    return $class->search_form( $p );
}

1;
