#!/usr/bin/perl

# $Id: save_with_directory.pl,v 1.1 2001/09/14 10:46:06 lachoy Exp $

# save_with_directory.pl
#
#  Scroll through the static_page objects in the database, set the
#  'is_file' property of each to 'no' and save it. This has the
#  benefit of triggering the 'pre_save_action' rule which sets the
#  'directory' property for each object.

# Author: Chris Winters <chris@cwinters.com>

use strict;
use Getopt::Long   qw( GetOptions );
use OpenInteract::Startup;

# Note, you must have modified the basic_page table to have the new
# properties before running this script.

{
    my $R = OpenInteract::Startup->setup_static_environment_options( $usage );

    # Find all the pages

    my $iter = $R->static_page->fetch_iterator({ skip_security => 1 });

    my $count = 0;
    while ( my $page = $iter->get_next ) {
        $page->{is_file} = 'no';
        $page->save({ skip_security => 1, skip_log => 1, skip_cache => 1 });
        print "Done: $page->{location}\n";
        $count++;
    }
    print "Records modified: $count\n";
    $R->db->disconnect;
}
