package OpenInteract::SQLInstall::Classified;

# $Id: Classified.pm,v 1.1.1.1 2001/02/02 06:20:24 lachoy Exp $

# Do installation of SQL for this package

use strict;
use vars qw( %HANDLERS );

@OpenInteract::SQLInstall::Classified::ISA = qw( OpenInteract::SQLInstall );

my %files = (
 tables   => [ 'classified.sql' ],
 security => [ 'install_security.dat' ],
);

%HANDLERS = (
 create_structure => { '_default_' => [ 'create_structure', 
                                        { table_file_list => $files{tables} } ] },
 install_security => { '_default_' => [ 'install_data',
                                        { data_file_list => $files{security} } ] },
);

1;

__END__

=pod

=head1 NAME

OpenInteract::SQLInstall::Classified - SQL installer for the classified package

=head1 SYNOPSIS

=head1 DESCRIPTION

=head1 BUGS 

=head1 TO DO

=head1 SEE ALSO

=head1 COPYRIGHT

Copyright (c) 2001 intes.net, inc.. All rights reserved.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 AUTHORS

Chris Winters <chris@cwinters.com>

=cut
