#!/usr/bin/perl

# $Id$

# save_with_directory.pl
#
#  Scroll through the static_page objects in the database, set the
#  'is_file' property of each to 'no' and save it. This has the
#  benefit of triggering the 'pre_save_action' rule which sets the
#  'directory' property for each object.

# Author: Chris Winters <chris@cwinters.com>

use strict;
use Getopt::Long   qw( GetOptions );
use OpenInteract::Startup;

# Note, you must have modified the basic_page table to have the new
# properties before running this script.

{
    my $usage = "Usage: $0 --website_dir=/path/to/my_site";

    # Get the options

    my ( $OPT_website_dir );
    GetOptions( 'website_dir=s' => \$OPT_website_dir );

    if ( ! $OPT_website_dir and $ENV{OIWEBSITE} ) {
        print "[db_to_files]: Using ($ENV{OIWEBSITE}) for 'website_dir'.\n";
        $OPT_website_dir = $ENV{OIWEBSITE};
    }

    unless ( -d $OPT_website_dir ) {
        die "$usage\n Parameter 'website_dir' must refer to an OpenInteract website directory!\n";
    }

    # Setup the OI environment

    my $R = OpenInteract::Startup->setup_static_environment( $OPT_website_dir );

    # Find all the pages

    my $iter = $R->static_page->fetch_iterator({ skip_security => 1 });

    my $count = 0;
    while ( my $page = $iter->get_next ) {
        $page->{is_file} = 'no';
        $page->save({ skip_security => 1, skip_log => 1, skip_cache => 1 });
        print "Done: $page->{location}\n";
        $count++;
    }
    print "Records modified: $count\n";
    $R->db->disconnect;
}
