## no critic(ErrorHandling::RequireCarping, Documentation::RequirePodAtEnd, Editor::RequireEmacsFileVariables)

#######################################################################
#      $URL: svn+ssh://equilibrious@equilibrious.net/home/equilibrious/svnrepos/chrisdolan/Fuse-PDF/lib/Fuse/PDF/ImageTemplate.pm $
#     $Date: 2007-11-27 23:43:19 -0600 (Tue, 27 Nov 2007) $
#   $Author: equilibrious $
# $Revision: 724 $
########################################################################

package Fuse::PDF::ImageTemplate;

use warnings;
use strict;
use English qw(-no_match_vars);
use MIME::Base64 qw();
use CAM::PDF;

our $VERSION = '0.07';

my $content;  # cache
sub get_template_pdf {
   my ($pkg) = @_;

   if (!$content) {
      $content = MIME::Base64::decode(do { local $RS = undef; <DATA>});
   }
   return CAM::PDF->new($content);
}

sub _selfupdate {
   my ($pkg, $source_file) = @_;

   my $pdf = CAM::PDF->new($source_file) or die $CAM::PDF::errstr; ## no critic(PackageVar)
   my $pdfsrc = MIME::Base64::encode($pdf->{content});

   open my $ifh, '<', __FILE__ or die $OS_ERROR;
   my $code = do {local $RS = undef; <$ifh> };
   close $ifh or die $OS_ERROR;
   $code =~ s/(^__DATA__\s*).* \z/$1$pdfsrc/xms;
   
   open my $ofh, '>', __FILE__ or die $OS_ERROR;
   print {$ofh} $code;
   close $ofh or die $OS_ERROR;

   return;
}

1;

=pod

=head1 NAME

Fuse::PDF::ImageTemplate - Carrier for the template PDF for images

=head1 SYNOPSIS

  use Fuse::PDF::ImageTemplate;
  my $pdf = Fuse::PDF::ImageTemplate->get_template_pdf();

=head1 LICENSE

Copyright 2007 Chris Dolan, I<cdolan@cpan.org>

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 DESCRIPTION

A binary PDF is embedded in this source code.

=head1 METHODS

=over

=item Fuse::PDF::ImageTemplate->get_template_pdf()

Returns a new L<CAM::PDF> instance of the template PDF.

=back

=head1 SEE ALSO

L<Fuse::PDF::ContentFS>

=head1 AUTHOR

Chris Dolan, I<cdolan@cpan.org>

=cut

# The data below is generated by "perl image_template_update.PL" which
# invokes the _selfupdate() function above with the image_template.pdf
# as an argument.  One could recreate the image_template.pdf by
# calling get_template_pdf()->output($filename)

__DATA__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==
