#########################
# TODO: Come up with some 
# good tests!

use strict;
use Test::More qw(no_plan);

BEGIN{ use_ok( 'Geo::Distance' ); }

my $geo = eval{ return Geo::Distance->new() };
ok(!$@,'Create a Geo::Distance object.');

my $units = {
	barleycorn => 752526278.492973,
	fathom => 11652455.232,
	'nautical mile' => 3440.41036717063,
	kilometre => 6371.64,
	foot => 20904330.7086614,
	kilometer => 6371.64,
	rod => 1266929.13385827,
	'light second' => 0.0212535033152835,
	mile => 3959.15354330709,
	perch => 1266929.13385827,
	centimetre => 637164000,
	pole => 1266929.13385827,
	yard => 6968110.23622047,
	centimeter => 637164000,
	millimetre => 6371640000,
	chain => 316732.283464567,
	millimeter => 6371640000,
	furlong => 31673.2283464567,
	meter => 6371640,
	inch => 250851968.503937,
	'poppy seed' => 3019734597.1564,
	league => 1319.71784776903,
	metre => 6371640
};
ok(eq_hash($units,$geo->{units}),'Live units data matches test data.');

__END__

my($zips_db,$zips);

#-----#
$zips_db = load_zips();
eval{ $zips = find_closest(array=>$zips_db, lon=>'-80.7881', lat=>'35.22', unit=>'mile', distance=>'50') };
ok(($@?0:1));
#-----#
ok((@$zips!=@$zips_db?0:1));
#-----#
$zips = find_closest(count=>5, array=>$zips_db, lon=>'-80.7881', lat=>'35.22', unit=>'mile', distance=>'50');
ok((@$zips==5?1:0));
#-----#
$zips = find_closest(count=>0, array=>$zips_db, lon=>'-80.7881', lat=>'35.22', unit=>'kilometer', distance=>'20');
ok((@$zips==27?1:0));
#-----#

# This is a start, but still need more tests.

#########################

sub load_zips {
	# lon, lat, id, state
	return [
		['-81.044','35.244','28012','37'],
		['-81.0306','35.3119','28120','37'],
		['-81.0079','35.0972','28217','37'],
		['-80.9604','35.1467','28278','37'],
		['-80.9586','35.026','29715','45'],
		['-80.9571','35.2731','28214','37'],
		['-80.8967','35.1596','28273','37'],
		['-80.8964','35.2358','28208','37'],
		['-80.8858','35.0709','28134','37'],
		['-80.8702','35.2834','28216','37'],
		['-80.8647','35.422','28078','37'],
		['-80.8583','35.2081','28203','37'],
		['-80.8577','35.1316','28210','37'],
		['-80.8559','35.1796','28209','37'],
		['-80.8419','35.229','28202','37'],
		['-80.8272','35.1935','28207','37'],
		['-80.8265','35.2522','28206','37'],
		['-80.8232','35.2132','28204','37'],
		['-80.8209','35.2886','28269','37'],
		['-80.8167','35.0869','28226','37'],
		['-80.8002','35.1345','28277','37'],
		['-80.7932','35.1677','28211','37'],
		['-80.7881','35.22','28205','37'],
		['-80.776','35.2725','28262','37'],
		['-80.7669','35.1355','28270','37'],
		['-80.7501','35.3179','28213','37'],
		['-80.7448','35.1908','28212','37'],
		['-80.7387','35.244','28215','37'],
		['-80.7279','34.9553','28173','37'],
		['-80.7136','35.1219','28105','37'],
		['-80.6846','35.1936','28227','37'],
		['-80.6597','35.0831','28079','37'],
		['-80.6594','35.3247','28075','37'],
		['-80.6162','35.4141','28027','37'],
		['-80.5319','35.2477','28107','37'],
		['-80.53','35.3716','28025','37']
	];
}
