use Test::Simple tests => 29;

use Chess::Game::MoveList;
use Chess::Piece::Pawn;

$movelist = Chess::Game::MoveList->new("white", "black");
$wpawn = Chess::Piece::Pawn->new("e2", "white");
ok( $movelist->add_move($wpawn, "e2", "e4") );
$bpawn = Chess::Piece::Pawn->new("d7", "black");
ok( $movelist->add_move($bpawn, "d7", "d6") );
ok( $movelist->add_move($wpawn, "e4", "e5") );
$move_num = $movelist->get_move_num();
$last_moved = $movelist->get_last_moved();
ok( $move_num == 2 );
ok( $last_moved eq "white" );
$del_entry = $movelist->delete_move();
ok( $del_entry->get_piece() eq $wpawn );
ok( $del_entry->get_move_num() == $move_num );
ok( $del_entry->get_start_square() eq "e4" );
ok( $del_entry->get_dest_square() eq "e5" );
ok( $movelist->get_move_num() == 1 );
ok( $movelist->get_last_moved() eq "black" );
ok( $movelist->add_move($wpawn, "e4", "e5") );
ok( $movelist->add_move($bpawn, "d6", "e5") );
$entry = $movelist->get_move(2, "white");
ok( $entry->get_piece() eq $wpawn );
ok( $entry->get_dest_square() eq "e5" );
$entry = $movelist->get_move(1, "black");
ok( $entry->get_piece() eq $bpawn );
ok( $entry->get_dest_square() eq "d6" );
@wmoves = $movelist->get_all_moves("white");
@bmoves = $movelist->get_all_moves("black");
ok( $wmoves[1]->get_piece() eq $wpawn );
ok( $wmoves[1]->get_dest_square() eq "e5" );
ok( $bmoves[0]->get_piece() eq $bpawn );
ok( $bmoves[0]->get_dest_square() eq "d6" );
($wmove_ref, $bmove_ref) = $movelist->get_all_moves();
$wmove = $wmove_ref->[0];
$bmove = $bmove_ref->[1];
ok( $wmove->get_piece() eq $wpawn );
ok( $wmove->get_dest_square() eq "e4" );
ok( $bmove->get_piece() eq $bpawn );
ok( $bmove->get_dest_square() eq "e5" );
$clone = $movelist->clone();
ok( $clone );
ok( $clone->add_move($bpawn, "f7", "f5") );
$move_num = $clone->get_move_num();
$last_moved = $clone->get_last_moved();
$entry = $clone->get_move($move_num, $last_moved);
ok( $entry->get_piece() eq $bpawn );
ok( $entry->get_dest_square() eq "f5" );
